/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.pip;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.pip.PIPResponse;
import org.apache.openaz.xacml.std.StdStatus;

public class StdMutablePIPResponse
implements PIPResponse {
    private static final List<Attribute> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    private List<Attribute> attributes = EMPTY_LIST;
    private Status status;
    private boolean simple;

    public StdMutablePIPResponse(Status statusIn) {
        this.status = statusIn;
        this.simple = true;
    }

    public StdMutablePIPResponse(Attribute attribute) {
        this(StdStatus.STATUS_OK);
        if (attribute != null) {
            this.addAttribute(attribute);
        }
    }

    public StdMutablePIPResponse(Collection<Attribute> attributesIn) {
        this(StdStatus.STATUS_OK);
        if (attributesIn != null) {
            this.addAttributes(attributesIn);
        }
    }

    public StdMutablePIPResponse() {
        this(StdStatus.STATUS_OK);
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status statusIn) {
        this.status = statusIn;
    }

    @Override
    public boolean isSimple() {
        return this.simple;
    }

    @Override
    public Collection<Attribute> getAttributes() {
        return this.attributes == EMPTY_LIST ? this.attributes : Collections.unmodifiableCollection(this.attributes);
    }

    public void addAttribute(Attribute attributeIn) {
        if (this.attributes == EMPTY_LIST) {
            this.attributes = new ArrayList<Attribute>();
        }
        if (this.simple && this.attributes.size() > 0) {
            this.simple = false;
        }
        this.attributes.add(attributeIn);
    }

    public void addAttributes(Collection<Attribute> attributesIn) {
        if (attributesIn != null && attributesIn.size() > 0) {
            if (this.attributes == EMPTY_LIST) {
                this.attributes = new ArrayList<Attribute>();
            }
            if (this.simple && (this.attributes.size() > 0 || attributesIn.size() > 1)) {
                this.simple = false;
            }
            this.attributes.addAll(attributesIn);
        }
    }

    public void setAttributes(Collection<Attribute> attributesIn) {
        this.attributes = EMPTY_LIST;
        this.simple = true;
        this.addAttributes(attributesIn);
    }
}

