/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.pip.engines;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Request;
import org.apache.openaz.xacml.api.RequestAttributes;
import org.apache.openaz.xacml.api.pip.PIPEngine;
import org.apache.openaz.xacml.api.pip.PIPException;
import org.apache.openaz.xacml.api.pip.PIPFinder;
import org.apache.openaz.xacml.api.pip.PIPRequest;
import org.apache.openaz.xacml.api.pip.PIPResponse;
import org.apache.openaz.xacml.std.StdMutableAttribute;
import org.apache.openaz.xacml.std.pip.StdMutablePIPResponse;
import org.apache.openaz.xacml.std.pip.StdPIPRequest;
import org.apache.openaz.xacml.std.pip.StdPIPResponse;

public class RequestEngine
implements PIPEngine {
    private Request request;

    protected Request getRequest() {
        return this.request;
    }

    public RequestEngine(Request requestIn) {
        this.request = requestIn;
    }

    @Override
    public String getName() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public String getDescription() {
        return "PIPEngine for retrieving Attributes from the Request";
    }

    @Override
    public PIPResponse getAttributes(PIPRequest pipRequest, PIPFinder pipFinder) throws PIPException {
        Request thisRequest = this.getRequest();
        if (thisRequest == null) {
            return StdPIPResponse.PIP_RESPONSE_EMPTY;
        }
        Iterator<RequestAttributes> iterRequestAttributes = thisRequest.getRequestAttributes(pipRequest.getCategory());
        if (iterRequestAttributes == null || !iterRequestAttributes.hasNext()) {
            return StdPIPResponse.PIP_RESPONSE_EMPTY;
        }
        StdMutablePIPResponse pipResponse = null;
        while (iterRequestAttributes.hasNext()) {
            RequestAttributes requestAttributes = iterRequestAttributes.next();
            Iterator<Attribute> iterAttributes = requestAttributes.getAttributes(pipRequest.getAttributeId());
            while (iterAttributes.hasNext()) {
                Attribute attribute = iterAttributes.next();
                if (attribute.getValues().size() <= 0 || pipRequest.getIssuer() != null && !pipRequest.getIssuer().equals(attribute.getIssuer())) continue;
                boolean bAllMatch = true;
                for (AttributeValue<?> attributeValue : attribute.getValues()) {
                    if (pipRequest.getDataTypeId().equals(attributeValue.getDataTypeId())) continue;
                    bAllMatch = false;
                    break;
                }
                if (bAllMatch) {
                    if (pipResponse == null) {
                        pipResponse = new StdMutablePIPResponse(attribute);
                        continue;
                    }
                    pipResponse.addAttribute(attribute);
                    continue;
                }
                ArrayList listAttributeValues = null;
                for (AttributeValue<?> attributeValue : attribute.getValues()) {
                    if (!pipRequest.getDataTypeId().equals(attributeValue.getDataTypeId())) continue;
                    if (listAttributeValues == null) {
                        listAttributeValues = new ArrayList();
                    }
                    listAttributeValues.add(attributeValue);
                }
                if (listAttributeValues == null) continue;
                if (pipResponse == null) {
                    pipResponse = new StdMutablePIPResponse();
                }
                pipResponse.addAttribute(new StdMutableAttribute(attribute.getCategory(), attribute.getAttributeId(), listAttributeValues, attribute.getIssuer(), attribute.getIncludeInResults()));
            }
        }
        if (pipResponse == null) {
            return StdPIPResponse.PIP_RESPONSE_EMPTY;
        }
        return pipResponse;
    }

    @Override
    public Collection<PIPRequest> attributesRequired() {
        return Collections.emptyList();
    }

    @Override
    public Collection<PIPRequest> attributesProvided() {
        HashSet<PIPRequest> providedAttributes = new HashSet<PIPRequest>();
        for (RequestAttributes attributes : this.request.getRequestAttributes()) {
            for (Attribute attribute : attributes.getAttributes()) {
                HashSet<Identifier> datatypes = new HashSet<Identifier>();
                for (AttributeValue<?> value : attribute.getValues()) {
                    datatypes.add(value.getDataTypeId());
                }
                for (Identifier dt : datatypes) {
                    providedAttributes.add(new StdPIPRequest(attribute.getCategory(), attribute.getAttributeId(), dt, attribute.getIssuer()));
                }
            }
        }
        return providedAttributes;
    }
}

