/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.pip.engines.ldap;

import com.google.common.base.Splitter;
import com.google.common.cache.Cache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.pip.PIPException;
import org.apache.openaz.xacml.api.pip.PIPFinder;
import org.apache.openaz.xacml.api.pip.PIPRequest;
import org.apache.openaz.xacml.api.pip.PIPResponse;
import org.apache.openaz.xacml.std.pip.StdMutablePIPResponse;
import org.apache.openaz.xacml.std.pip.StdPIPResponse;
import org.apache.openaz.xacml.std.pip.engines.StdConfigurableEngine;
import org.apache.openaz.xacml.std.pip.engines.ldap.LDAPResolver;

public class LDAPEngine
extends StdConfigurableEngine {
    public static final String PROP_RESOLVERS = "resolvers";
    public static final String PROP_RESOLVER = "resolver";
    public static final String PROP_LDAP_SCOPE = "scope";
    private static final String LDAP_SCOPE_SUBTREE = "subtree";
    private static final String LDAP_SCOPE_OBJECT = "object";
    private static final String LDAP_SCOPE_ONELEVEL = "onelevel";
    private static final String DEFAULT_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String DEFAULT_SCOPE = "subtree";
    private Log logger = LogFactory.getLog(this.getClass());
    private Hashtable<Object, Object> ldapEnvironment = new Hashtable();
    private List<LDAPResolver> ldapResolvers = new ArrayList<LDAPResolver>();
    private int ldapScope;

    private boolean configureStringProperty(String propertyPrefix, String property, Properties properties, String defaultValue) {
        String propertyValue = properties.getProperty(propertyPrefix + property, defaultValue);
        if (propertyValue != null) {
            this.ldapEnvironment.put(property, propertyValue);
            return true;
        }
        return false;
    }

    private boolean configureIntegerProperty(String propertyPrefix, String property, Properties properties, Integer defaultValue) {
        String propertyValue = properties.getProperty(propertyPrefix + property);
        if (propertyValue == null) {
            if (defaultValue != null) {
                this.ldapEnvironment.put(property, defaultValue);
                return true;
            }
            return false;
        }
        try {
            this.ldapEnvironment.put(property, Integer.parseInt(propertyValue));
            return true;
        }
        catch (NumberFormatException ex) {
            this.logger.error((Object)("Invalid Integer '" + propertyValue + "' for '" + property + "' property"));
            return false;
        }
    }

    @Override
    public void configure(String id, Properties properties) throws PIPException {
        super.configure(id, properties);
        String propertyPrefix = id + ".";
        if (!this.configureStringProperty(propertyPrefix, "java.naming.provider.url", properties, null)) {
            throw new PIPException("Invalid configuration for " + this.getClass().getName() + ": No " + propertyPrefix + "java.naming.provider.url");
        }
        this.configureStringProperty(propertyPrefix, "java.naming.authoritative", properties, null);
        this.configureIntegerProperty(propertyPrefix, "java.naming.batchsize", properties, null);
        this.configureStringProperty(propertyPrefix, "java.naming.dns.url", properties, null);
        this.configureStringProperty(propertyPrefix, "java.naming.factory.initial", properties, DEFAULT_CONTEXT_FACTORY);
        this.configureStringProperty(propertyPrefix, "java.naming.language", properties, null);
        this.configureStringProperty(propertyPrefix, "java.naming.factory.object", properties, null);
        this.configureStringProperty(propertyPrefix, "java.naming.referral", properties, null);
        this.configureStringProperty(propertyPrefix, "java.naming.security.authentication", properties, null);
        this.configureStringProperty(propertyPrefix, "java.naming.security.credentials", properties, null);
        this.configureStringProperty(propertyPrefix, "java.naming.security.principal", properties, null);
        this.configureStringProperty(propertyPrefix, "java.naming.security.protocol", properties, null);
        this.configureStringProperty(propertyPrefix, "java.naming.factory.state", properties, null);
        this.configureStringProperty(propertyPrefix, "java.naming.factory.url.pkgs", properties, null);
        String ldapScopeValue = properties.getProperty(propertyPrefix + PROP_LDAP_SCOPE, "subtree");
        if ("subtree".equals(ldapScopeValue)) {
            this.ldapScope = 2;
        } else if (LDAP_SCOPE_OBJECT.equals(ldapScopeValue)) {
            this.ldapScope = 0;
        } else if (LDAP_SCOPE_ONELEVEL.equals(ldapScopeValue)) {
            this.ldapScope = 1;
        } else {
            this.logger.warn((Object)("Invalid LDAP Scope value '" + ldapScopeValue + "'; using " + "subtree"));
            this.ldapScope = 2;
        }
        String resolversList = properties.getProperty(propertyPrefix + PROP_RESOLVERS);
        if (resolversList == null || resolversList.isEmpty()) {
            throw new PIPException("Invalid configuration for " + this.getClass().getName() + ": No " + propertyPrefix + PROP_RESOLVERS);
        }
        for (String resolver : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)resolversList)) {
            String resolverClassName = properties.getProperty(propertyPrefix + PROP_RESOLVER + "." + resolver + ".classname");
            if (resolverClassName == null) {
                throw new PIPException("Invalid configuration for " + this.getClass().getName() + ": No " + propertyPrefix + PROP_RESOLVER + "." + resolver + ".classname");
            }
            LDAPResolver ldapResolverNew = null;
            try {
                Class<?> classResolver = Class.forName(resolverClassName);
                if (!LDAPResolver.class.isAssignableFrom(classResolver)) {
                    this.logger.error((Object)("LDAPResolver class " + resolverClassName + " does not implement " + LDAPResolver.class.getCanonicalName()));
                    throw new PIPException("LDAPResolver class " + resolverClassName + " does not implement " + LDAPResolver.class.getCanonicalName());
                }
                ldapResolverNew = (LDAPResolver)LDAPResolver.class.cast(classResolver.newInstance());
            }
            catch (Exception ex) {
                this.logger.error((Object)("Exception instantiating LDAPResolver for class '" + resolverClassName + "': " + ex.getMessage()), (Throwable)ex);
                throw new PIPException("Exception instantiating LDAPResolver for class '" + resolverClassName + "'", ex);
            }
            assert (ldapResolverNew != null);
            ldapResolverNew.configure(propertyPrefix + PROP_RESOLVER + "." + resolver, properties, this.getIssuer());
            this.ldapResolvers.add(ldapResolverNew);
        }
    }

    @Override
    public PIPResponse getAttributes(PIPRequest pipRequest, PIPFinder pipFinder) throws PIPException {
        if (this.ldapResolvers.size() == 0) {
            throw new IllegalStateException(this.getClass().getCanonicalName() + " is not configured");
        }
        StdMutablePIPResponse mutablePIPResponse = new StdMutablePIPResponse();
        for (LDAPResolver ldapResolver : this.ldapResolvers) {
            this.getAttributes(pipRequest, pipFinder, mutablePIPResponse, ldapResolver);
        }
        if (mutablePIPResponse.getAttributes().size() == 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"returning empty response");
            }
            return StdPIPResponse.PIP_RESPONSE_EMPTY;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Returning " + mutablePIPResponse.getAttributes().size() + " attributes"));
            this.logger.debug(mutablePIPResponse.getAttributes());
        }
        return new StdPIPResponse(mutablePIPResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAttributes(PIPRequest pipRequest, PIPFinder pipFinder, StdMutablePIPResponse mutablePIPResponse, LDAPResolver ldapResolver) throws PIPException {
        PIPResponse pipResponse;
        String stringBase = ldapResolver.getBase(this, pipRequest, pipFinder);
        if (stringBase == null) {
            this.logger.warn((Object)(this.getName() + " does not handle " + pipRequest.toString()));
            return;
        }
        String stringFilter = ldapResolver.getFilterString(this, pipRequest, pipFinder);
        Cache<String, PIPResponse> cache = this.getCache();
        String cacheKey = stringBase + "::" + (stringFilter == null ? "" : stringFilter);
        if (cache != null && (pipResponse = (PIPResponse)cache.getIfPresent((Object)cacheKey)) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Returning cached response: " + pipResponse));
            }
            mutablePIPResponse.addAttributes(pipResponse.getAttributes());
            return;
        }
        InitialDirContext dirContext = null;
        Object pipResponse2 = null;
        try {
            dirContext = new InitialDirContext(this.ldapEnvironment);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(this.ldapScope);
            NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(stringBase, stringFilter, searchControls);
            if (namingEnumeration != null && namingEnumeration.hasMore()) {
                while (namingEnumeration.hasMore()) {
                    List<Attribute> listAttributes = ldapResolver.decodeResult(namingEnumeration.next());
                    if (listAttributes == null || listAttributes.size() <= 0) continue;
                    mutablePIPResponse.addAttributes(listAttributes);
                }
            }
            if (cache != null) {
                cache.put((Object)cacheKey, pipResponse2);
            }
        }
        catch (NamingException ex) {
            this.logger.error((Object)("NamingException creating the DirContext: " + ex.getMessage()), (Throwable)ex);
        }
        finally {
            if (dirContext != null) {
                try {
                    dirContext.close();
                }
                catch (Exception ex) {
                    this.logger.warn((Object)("Exception closing DirContext: " + ex.getMessage()), (Throwable)ex);
                }
            }
        }
    }

    @Override
    public Collection<PIPRequest> attributesRequired() {
        HashSet<PIPRequest> requiredAttributes = new HashSet<PIPRequest>();
        for (LDAPResolver resolver : this.ldapResolvers) {
            resolver.attributesRequired(requiredAttributes);
        }
        return requiredAttributes;
    }

    @Override
    public Collection<PIPRequest> attributesProvided() {
        HashSet<PIPRequest> providedAttributes = new HashSet<PIPRequest>();
        for (LDAPResolver resolver : this.ldapResolvers) {
            resolver.attributesProvided(providedAttributes);
        }
        return providedAttributes;
    }
}

