/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.failover;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import javassist.util.proxy.ProxyObjectInputStream;
import javassist.util.proxy.ProxyObjectOutputStream;
import javax.servlet.http.HttpSession;
import org.apache.webbeans.corespi.ServiceLoader;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.spi.FailOverService;
import org.apache.webbeans.web.failover.FailOverBag;

public class FailOverBagWrapper
implements Serializable,
Externalizable {
    private final WebBeansLogger logger = WebBeansLogger.getLogger(FailOverBagWrapper.class);
    private transient FailOverService failoverService;
    FailOverBag bag;
    String sessionId;
    boolean isSessionInUse;

    public FailOverBagWrapper() {
        this.failoverService = (FailOverService)ServiceLoader.getService(FailOverService.class);
    }

    public FailOverBagWrapper(HttpSession session, FailOverService service) {
        this.isSessionInUse = false;
        this.sessionId = session.getId();
        this.bag = new FailOverBag(session, service);
    }

    public void updateOwbFailOverBag(HttpSession session, FailOverService service) {
        this.isSessionInUse = false;
        this.bag.updateOwbFailOverBag(session, service);
    }

    public void restore() {
        if (!this.isSessionInUse) {
            this.bag.restore();
            if (this.logger.wblWillLogDebug()) {
                this.logger.debug(this.sessionId + " from " + this.bag.getJVMId() + "is restored successfully.");
            }
        } else if (this.logger.wblWillLogDebug()) {
            this.logger.debug("restore is skipped because isSessionInUse is true for session " + this.sessionId);
        }
    }

    public synchronized void sessionIsInUse() {
        this.isSessionInUse = true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.isSessionInUse = in.readBoolean();
        this.sessionId = (String)in.readObject();
        if (!this.isSessionInUse) {
            byte[] buf = (byte[])in.readObject();
            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
            OwbProxyObjectInputStream ois = new OwbProxyObjectInputStream(bais);
            this.bag = (FailOverBag)((ObjectInputStream)((Object)ois)).readObject();
            ((ObjectInputStream)((Object)ois)).close();
        }
    }

    @Override
    public synchronized void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.isSessionInUse);
        out.writeObject(this.sessionId);
        if (this.isSessionInUse) {
            if (this.logger.wblWillLogDebug()) {
                this.logger.debug("writeExternal skip writing because session is in use for sessionid" + this.sessionId);
            }
            return;
        }
        ByteArrayOutputStream baos = null;
        ProxyObjectOutputStream oos = null;
        byte[] buf = null;
        try {
            baos = new ByteArrayOutputStream();
            oos = new ProxyObjectOutputStream((OutputStream)baos);
            oos.writeObject(this.bag);
            oos.flush();
            buf = baos.toByteArray();
            oos.close();
            baos.close();
            out.writeObject(buf);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static class OwbProxyObjectInputStream
    extends ProxyObjectInputStream {
        public OwbProxyObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String name = desc.getName();
            try {
                return Class.forName(name, false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException ex) {
                return super.resolveClass(desc);
            }
        }
    }
}

