/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.avro;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.schema.ConversionPatterns;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.NullNode;

public class AvroSchemaConverter {
    public static final String ADD_LIST_ELEMENT_RECORDS = "parquet.avro.add-list-element-records";
    private static final boolean ADD_LIST_ELEMENT_RECORDS_DEFAULT = true;
    private final boolean assumeRepeatedIsListElement;
    private final boolean writeOldListStructure;

    public AvroSchemaConverter() {
        this.assumeRepeatedIsListElement = true;
        this.writeOldListStructure = true;
    }

    public AvroSchemaConverter(Configuration conf) {
        this.assumeRepeatedIsListElement = conf.getBoolean(ADD_LIST_ELEMENT_RECORDS, true);
        this.writeOldListStructure = conf.getBoolean("parquet.avro.write-old-list-structure", true);
    }

    public static Schema getNonNull(Schema schema) {
        if (schema.getType().equals((Object)Schema.Type.UNION)) {
            List schemas = schema.getTypes();
            if (schemas.size() == 2) {
                if (((Schema)schemas.get(0)).getType().equals((Object)Schema.Type.NULL)) {
                    return (Schema)schemas.get(1);
                }
                if (((Schema)schemas.get(1)).getType().equals((Object)Schema.Type.NULL)) {
                    return (Schema)schemas.get(0);
                }
                return schema;
            }
            return schema;
        }
        return schema;
    }

    public MessageType convert(Schema avroSchema) {
        if (!avroSchema.getType().equals((Object)Schema.Type.RECORD)) {
            throw new IllegalArgumentException("Avro schema must be a record.");
        }
        return new MessageType(avroSchema.getFullName(), this.convertFields(avroSchema.getFields()));
    }

    private List<Type> convertFields(List<Schema.Field> fields) {
        ArrayList<Type> types = new ArrayList<Type>();
        for (Schema.Field field : fields) {
            if (field.schema().getType().equals((Object)Schema.Type.NULL)) continue;
            types.add(this.convertField(field));
        }
        return types;
    }

    private Type convertField(String fieldName, Schema schema) {
        return this.convertField(fieldName, schema, Type.Repetition.REQUIRED);
    }

    private Type convertField(String fieldName, Schema schema, Type.Repetition repetition) {
        Schema.Type type = schema.getType();
        if (type.equals((Object)Schema.Type.BOOLEAN)) {
            return this.primitive(fieldName, PrimitiveType.PrimitiveTypeName.BOOLEAN, repetition);
        }
        if (type.equals((Object)Schema.Type.INT)) {
            return this.primitive(fieldName, PrimitiveType.PrimitiveTypeName.INT32, repetition);
        }
        if (type.equals((Object)Schema.Type.LONG)) {
            return this.primitive(fieldName, PrimitiveType.PrimitiveTypeName.INT64, repetition);
        }
        if (type.equals((Object)Schema.Type.FLOAT)) {
            return this.primitive(fieldName, PrimitiveType.PrimitiveTypeName.FLOAT, repetition);
        }
        if (type.equals((Object)Schema.Type.DOUBLE)) {
            return this.primitive(fieldName, PrimitiveType.PrimitiveTypeName.DOUBLE, repetition);
        }
        if (type.equals((Object)Schema.Type.BYTES)) {
            return this.primitive(fieldName, PrimitiveType.PrimitiveTypeName.BINARY, repetition);
        }
        if (type.equals((Object)Schema.Type.STRING)) {
            return this.primitive(fieldName, PrimitiveType.PrimitiveTypeName.BINARY, repetition, OriginalType.UTF8);
        }
        if (type.equals((Object)Schema.Type.RECORD)) {
            return new GroupType(repetition, fieldName, this.convertFields(schema.getFields()));
        }
        if (type.equals((Object)Schema.Type.ENUM)) {
            return this.primitive(fieldName, PrimitiveType.PrimitiveTypeName.BINARY, repetition, OriginalType.ENUM);
        }
        if (type.equals((Object)Schema.Type.ARRAY)) {
            if (this.writeOldListStructure) {
                return ConversionPatterns.listType((Type.Repetition)repetition, (String)fieldName, (Type)this.convertField("array", schema.getElementType(), Type.Repetition.REPEATED));
            }
            return ConversionPatterns.listOfElements((Type.Repetition)repetition, (String)fieldName, (Type)this.convertField("element", schema.getElementType()));
        }
        if (type.equals((Object)Schema.Type.MAP)) {
            Type valType = this.convertField("value", schema.getValueType());
            return ConversionPatterns.stringKeyMapType((Type.Repetition)repetition, (String)fieldName, (Type)valType);
        }
        if (type.equals((Object)Schema.Type.FIXED)) {
            return this.primitive(fieldName, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, repetition, schema.getFixedSize(), null);
        }
        if (type.equals((Object)Schema.Type.UNION)) {
            return this.convertUnion(fieldName, schema, repetition);
        }
        throw new UnsupportedOperationException("Cannot convert Avro type " + type);
    }

    private Type convertUnion(String fieldName, Schema schema, Type.Repetition repetition) {
        ArrayList<Schema> nonNullSchemas = new ArrayList<Schema>(schema.getTypes().size());
        for (Schema childSchema : schema.getTypes()) {
            if (childSchema.getType().equals((Object)Schema.Type.NULL)) {
                if (Type.Repetition.REQUIRED != repetition) continue;
                repetition = Type.Repetition.OPTIONAL;
                continue;
            }
            nonNullSchemas.add(childSchema);
        }
        switch (nonNullSchemas.size()) {
            case 0: {
                throw new UnsupportedOperationException("Cannot convert Avro union of only nulls");
            }
            case 1: {
                return this.convertField(fieldName, (Schema)nonNullSchemas.get(0), repetition);
            }
        }
        ArrayList<Type> unionTypes = new ArrayList<Type>(nonNullSchemas.size());
        int index = 0;
        for (Schema childSchema : nonNullSchemas) {
            unionTypes.add(this.convertField("member" + index++, childSchema, Type.Repetition.OPTIONAL));
        }
        return new GroupType(repetition, fieldName, unionTypes);
    }

    private Type convertField(Schema.Field field) {
        return this.convertField(field.name(), field.schema());
    }

    private PrimitiveType primitive(String name, PrimitiveType.PrimitiveTypeName primitive, Type.Repetition repetition, int typeLength, OriginalType originalType) {
        return new PrimitiveType(repetition, primitive, typeLength, name, originalType);
    }

    private PrimitiveType primitive(String name, PrimitiveType.PrimitiveTypeName primitive, Type.Repetition repetition, OriginalType originalType) {
        return new PrimitiveType(repetition, primitive, name, originalType);
    }

    private PrimitiveType primitive(String name, PrimitiveType.PrimitiveTypeName primitive, Type.Repetition repetition) {
        return new PrimitiveType(repetition, primitive, name, null);
    }

    public Schema convert(MessageType parquetSchema) {
        return this.convertFields(parquetSchema.getName(), parquetSchema.getFields());
    }

    private Schema convertFields(String name, List<Type> parquetFields) {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        for (Type parquetType : parquetFields) {
            Schema fieldSchema = this.convertField(parquetType);
            if (parquetType.isRepetition(Type.Repetition.REPEATED)) {
                throw new UnsupportedOperationException("REPEATED not supported outside LIST or MAP. Type: " + parquetType);
            }
            if (parquetType.isRepetition(Type.Repetition.OPTIONAL)) {
                fields.add(new Schema.Field(parquetType.getName(), AvroSchemaConverter.optional(fieldSchema), null, (JsonNode)NullNode.getInstance()));
                continue;
            }
            fields.add(new Schema.Field(parquetType.getName(), fieldSchema, null, null));
        }
        Schema schema = Schema.createRecord((String)name, null, null, (boolean)false);
        schema.setFields(fields);
        return schema;
    }

    private Schema convertField(final Type parquetType) {
        if (parquetType.isPrimitive()) {
            PrimitiveType.PrimitiveTypeName parquetPrimitiveTypeName = parquetType.asPrimitiveType().getPrimitiveTypeName();
            final OriginalType originalType = parquetType.getOriginalType();
            return (Schema)parquetPrimitiveTypeName.convert((PrimitiveType.PrimitiveTypeNameConverter)new PrimitiveType.PrimitiveTypeNameConverter<Schema, RuntimeException>(){

                public Schema convertBOOLEAN(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                    return Schema.create((Schema.Type)Schema.Type.BOOLEAN);
                }

                public Schema convertINT32(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                    return Schema.create((Schema.Type)Schema.Type.INT);
                }

                public Schema convertINT64(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                    return Schema.create((Schema.Type)Schema.Type.LONG);
                }

                public Schema convertINT96(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                    throw new IllegalArgumentException("INT96 not yet implemented.");
                }

                public Schema convertFLOAT(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                    return Schema.create((Schema.Type)Schema.Type.FLOAT);
                }

                public Schema convertDOUBLE(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                    return Schema.create((Schema.Type)Schema.Type.DOUBLE);
                }

                public Schema convertFIXED_LEN_BYTE_ARRAY(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                    int size = parquetType.asPrimitiveType().getTypeLength();
                    return Schema.createFixed((String)parquetType.getName(), null, null, (int)size);
                }

                public Schema convertBINARY(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                    if (originalType == OriginalType.UTF8 || originalType == OriginalType.ENUM) {
                        return Schema.create((Schema.Type)Schema.Type.STRING);
                    }
                    return Schema.create((Schema.Type)Schema.Type.BYTES);
                }
            });
        }
        GroupType parquetGroupType = parquetType.asGroupType();
        OriginalType originalType = parquetGroupType.getOriginalType();
        if (originalType != null) {
            switch (originalType) {
                case LIST: {
                    if (parquetGroupType.getFieldCount() != 1) {
                        throw new UnsupportedOperationException("Invalid list type " + parquetGroupType);
                    }
                    Type repeatedType = parquetGroupType.getType(0);
                    if (!repeatedType.isRepetition(Type.Repetition.REPEATED)) {
                        throw new UnsupportedOperationException("Invalid list type " + parquetGroupType);
                    }
                    if (this.isElementType(repeatedType, parquetGroupType.getName())) {
                        return Schema.createArray((Schema)this.convertField(repeatedType));
                    }
                    Type elementType = repeatedType.asGroupType().getType(0);
                    if (elementType.isRepetition(Type.Repetition.OPTIONAL)) {
                        return Schema.createArray((Schema)AvroSchemaConverter.optional(this.convertField(elementType)));
                    }
                    return Schema.createArray((Schema)this.convertField(elementType));
                }
                case MAP_KEY_VALUE: 
                case MAP: {
                    if (parquetGroupType.getFieldCount() != 1 || parquetGroupType.getType(0).isPrimitive()) {
                        throw new UnsupportedOperationException("Invalid map type " + parquetGroupType);
                    }
                    GroupType mapKeyValType = parquetGroupType.getType(0).asGroupType();
                    if (!mapKeyValType.isRepetition(Type.Repetition.REPEATED) || !mapKeyValType.getOriginalType().equals((Object)OriginalType.MAP_KEY_VALUE) || mapKeyValType.getFieldCount() != 2) {
                        throw new UnsupportedOperationException("Invalid map type " + parquetGroupType);
                    }
                    Type keyType = mapKeyValType.getType(0);
                    if (!(keyType.isPrimitive() && keyType.asPrimitiveType().getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.BINARY) && keyType.getOriginalType().equals((Object)OriginalType.UTF8))) {
                        throw new IllegalArgumentException("Map key type must be binary (UTF8): " + keyType);
                    }
                    Type valueType = mapKeyValType.getType(1);
                    if (valueType.isRepetition(Type.Repetition.OPTIONAL)) {
                        return Schema.createMap((Schema)AvroSchemaConverter.optional(this.convertField(valueType)));
                    }
                    return Schema.createMap((Schema)this.convertField(valueType));
                }
                case ENUM: {
                    return Schema.create((Schema.Type)Schema.Type.STRING);
                }
            }
            throw new UnsupportedOperationException("Cannot convert Parquet type " + parquetType);
        }
        return this.convertFields(parquetGroupType.getName(), parquetGroupType.getFields());
    }

    private boolean isElementType(Type repeatedType, String parentName) {
        return repeatedType.isPrimitive() || repeatedType.asGroupType().getFieldCount() > 1 || repeatedType.getName().equals("array") || repeatedType.getName().equals(parentName + "_tuple") || this.assumeRepeatedIsListElement;
    }

    private static Schema optional(Schema original) {
        return Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), original));
    }
}

