/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.pig.summary;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.parquet.pig.summary.SummaryData;
import org.apache.parquet.pig.summary.TupleSummaryData;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.parser.ParserException;

public class Summary
extends EvalFunc<String>
implements Algebraic {
    private static final TupleFactory TF = TupleFactory.getInstance();
    private Schema inputSchema;
    private String signature;

    private static Properties getProperties(String signature) {
        return UDFContext.getUDFContext().getUDFProperties(Summary.class, new String[]{signature});
    }

    private static Schema getInputSchema(String signature) {
        try {
            return Utils.getSchemaFromString((String)Summary.getProperties(signature).getProperty("inputSchema"));
        }
        catch (ParserException e) {
            throw new RuntimeException(e);
        }
    }

    private static TupleSummaryData getData(Tuple tuple) throws ExecException {
        if (tuple instanceof JSONTuple) {
            return ((JSONTuple)tuple).data;
        }
        return SummaryData.fromJSON((String)tuple.get(0), TupleSummaryData.class);
    }

    private static TupleSummaryData merge(Tuple t) throws IOException {
        TupleSummaryData summaryData = new TupleSummaryData();
        DataBag bag = (DataBag)t.get(0);
        for (Tuple tuple : bag) {
            summaryData.merge(Summary.getData(tuple));
        }
        return summaryData;
    }

    private static TupleSummaryData sumUp(Schema schema, Tuple t) throws ExecException {
        TupleSummaryData summaryData = new TupleSummaryData();
        DataBag bag = (DataBag)t.get(0);
        for (Tuple tuple : bag) {
            summaryData.addTuple(schema, tuple);
        }
        return summaryData;
    }

    public String exec(Tuple t) throws IOException {
        return SummaryData.toPrettyJSON(Summary.sumUp(this.inputSchema, t));
    }

    public String getInitial() {
        return Initial.class.getName();
    }

    public String getIntermed() {
        return Intermediate.class.getName();
    }

    public String getFinal() {
        return Final.class.getName();
    }

    public void setInputSchema(Schema input) {
        try {
            this.inputSchema = input.getField((int)0).schema.getField((int)0).schema;
            this.saveSchemaToUDFContext();
        }
        catch (FrontendException e) {
            throw new RuntimeException("Usage: B = FOREACH (GROUP A ALL) GENERATE Summary(A); Can not get schema from " + input, e);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Usage: B = FOREACH (GROUP A ALL) GENERATE Summary(A); Can not get schema from " + input, e);
        }
    }

    public void setUDFContextSignature(String signature) {
        this.signature = signature;
        this.saveSchemaToUDFContext();
    }

    private void saveSchemaToUDFContext() {
        if (this.signature != null && this.inputSchema != null) {
            String schemaString = this.inputSchema.toString();
            Summary.getProperties(this.signature).put("inputSchema", schemaString.substring(1, schemaString.length() - 1));
        }
    }

    private static final class JSONTuple
    implements Tuple {
        private static final long serialVersionUID = 1L;
        private TupleSummaryData data;

        public JSONTuple(TupleSummaryData data) {
            this.data = data;
        }

        public void readFields(DataInput dataInput) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void write(DataOutput dataOutput) throws IOException {
            Tuple t = TF.newTuple((Object)this.json());
            t.write(dataOutput);
        }

        public int compareTo(Object o) {
            throw new UnsupportedOperationException();
        }

        public void append(Object o) {
            throw new UnsupportedOperationException();
        }

        public Object get(int i) throws ExecException {
            if (i == 0) {
                return this.json();
            }
            throw new ExecException();
        }

        private String json() {
            return SummaryData.toJSON(this.data);
        }

        public List<Object> getAll() {
            return new ArrayList<Object>(Arrays.asList(this.json()));
        }

        public long getMemorySize() {
            return 100L;
        }

        public byte getType(int i) throws ExecException {
            if (i == 0) {
                return 55;
            }
            throw new ExecException("size is 1");
        }

        public boolean isNull(int i) throws ExecException {
            if (i == 0) {
                return false;
            }
            throw new ExecException("size is 1");
        }

        public void reference(Tuple t) {
            throw new UnsupportedOperationException();
        }

        public void set(int i, Object o) throws ExecException {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return 1;
        }

        public String toDelimitedString(String delim) throws ExecException {
            return this.json();
        }

        public Iterator<Object> iterator() {
            return this.getAll().iterator();
        }
    }

    public static class Final
    extends EvalFunc<String> {
        public String exec(Tuple t) throws IOException {
            return SummaryData.toPrettyJSON(Summary.merge(t));
        }
    }

    public static class Intermediate
    extends EvalFunc<Tuple> {
        public Tuple exec(Tuple t) throws IOException {
            return new JSONTuple(Summary.merge(t));
        }
    }

    public static class Initial
    extends EvalFunc<Tuple> {
        private Schema inputSchema;

        public void setUDFContextSignature(String signature) {
            this.inputSchema = Summary.getInputSchema(signature);
        }

        public Tuple exec(Tuple t) throws IOException {
            return new JSONTuple(Summary.sumUp(this.inputSchema, t));
        }
    }
}

