/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.proto;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.twitter.elephantbird.util.Protobufs;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.io.InvalidRecordException;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.IncompatibleSchemaModificationException;
import org.apache.parquet.schema.Type;

class ProtoMessageConverter
extends GroupConverter {
    private final Converter[] converters;
    private final ParentValueContainer parent;
    private final Message.Builder myBuilder;

    ProtoMessageConverter(ParentValueContainer pvc, Class<? extends Message> protoClass, GroupType parquetSchema) {
        this(pvc, Protobufs.getMessageBuilder(protoClass), parquetSchema);
    }

    ProtoMessageConverter(ParentValueContainer pvc, Message.Builder builder, GroupType parquetSchema) {
        int schemaSize = parquetSchema.getFieldCount();
        this.converters = new Converter[schemaSize];
        this.parent = pvc;
        int parquetFieldIndex = 1;
        if (pvc == null) {
            throw new IllegalStateException("Missing parent value container");
        }
        this.myBuilder = builder;
        Descriptors.Descriptor protoDescriptor = builder.getDescriptorForType();
        for (Type parquetField : parquetSchema.getFields()) {
            Descriptors.FieldDescriptor protoField = protoDescriptor.findFieldByName(parquetField.getName());
            if (protoField == null) {
                String description = "Scheme mismatch \n\"" + parquetField + "\"" + "\n proto descriptor:\n" + protoDescriptor.toProto();
                throw new IncompatibleSchemaModificationException("Cant find \"" + parquetField.getName() + "\" " + description);
            }
            this.converters[parquetFieldIndex - 1] = this.newMessageConverter(this.myBuilder, protoField, parquetField);
            ++parquetFieldIndex;
        }
    }

    public Converter getConverter(int fieldIndex) {
        return this.converters[fieldIndex];
    }

    public void start() {
    }

    public void end() {
        this.parent.add(this.myBuilder.build());
        this.myBuilder.clear();
    }

    private Converter newMessageConverter(final Message.Builder parentBuilder, final Descriptors.FieldDescriptor fieldDescriptor, Type parquetType) {
        boolean isRepeated = fieldDescriptor.isRepeated();
        ParentValueContainer parent = isRepeated ? new ParentValueContainer(){

            @Override
            public void add(Object value) {
                parentBuilder.addRepeatedField(fieldDescriptor, value);
            }
        } : new ParentValueContainer(){

            @Override
            public void add(Object value) {
                parentBuilder.setField(fieldDescriptor, value);
            }
        };
        return this.newScalarConverter(parent, parentBuilder, fieldDescriptor, parquetType);
    }

    private Converter newScalarConverter(ParentValueContainer pvc, Message.Builder parentBuilder, Descriptors.FieldDescriptor fieldDescriptor, Type parquetType) {
        Descriptors.FieldDescriptor.JavaType javaType = fieldDescriptor.getJavaType();
        switch (javaType) {
            case STRING: {
                return new ProtoStringConverter(pvc);
            }
            case FLOAT: {
                return new ProtoFloatConverter(pvc);
            }
            case DOUBLE: {
                return new ProtoDoubleConverter(pvc);
            }
            case BOOLEAN: {
                return new ProtoBooleanConverter(pvc);
            }
            case BYTE_STRING: {
                return new ProtoBinaryConverter(pvc);
            }
            case ENUM: {
                return new ProtoEnumConverter(pvc, fieldDescriptor);
            }
            case INT: {
                return new ProtoIntConverter(pvc);
            }
            case LONG: {
                return new ProtoLongConverter(pvc);
            }
            case MESSAGE: {
                Message.Builder subBuilder = parentBuilder.newBuilderForField(fieldDescriptor);
                return new ProtoMessageConverter(pvc, subBuilder, parquetType.asGroupType());
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot convert type: %s (Parquet type: %s) ", javaType, parquetType));
    }

    public Message.Builder getBuilder() {
        return this.myBuilder;
    }

    final class ProtoStringConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoStringConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addBinary(Binary binary) {
            String str = binary.toStringUsingUTF8();
            this.parent.add(str);
        }
    }

    final class ProtoLongConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoLongConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addLong(long value) {
            this.parent.add(value);
        }
    }

    final class ProtoIntConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoIntConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addInt(int value) {
            this.parent.add(value);
        }
    }

    final class ProtoFloatConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoFloatConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addFloat(float value) {
            this.parent.add(Float.valueOf(value));
        }
    }

    final class ProtoDoubleConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoDoubleConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addDouble(double value) {
            this.parent.add(value);
        }
    }

    final class ProtoBooleanConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoBooleanConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public final void addBoolean(boolean value) {
            this.parent.add(value);
        }
    }

    final class ProtoBinaryConverter
    extends PrimitiveConverter {
        final ParentValueContainer parent;

        public ProtoBinaryConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public void addBinary(Binary binary) {
            ByteString byteString = ByteString.copyFrom((ByteBuffer)binary.toByteBuffer());
            this.parent.add(byteString);
        }
    }

    final class ProtoEnumConverter
    extends PrimitiveConverter {
        private final Descriptors.FieldDescriptor fieldType;
        private final Map<Binary, Descriptors.EnumValueDescriptor> enumLookup;
        private Descriptors.EnumValueDescriptor[] dict;
        private final ParentValueContainer parent;

        public ProtoEnumConverter(ParentValueContainer parent, Descriptors.FieldDescriptor fieldType) {
            this.parent = parent;
            this.fieldType = fieldType;
            this.enumLookup = this.makeLookupStructure(fieldType);
        }

        private Map<Binary, Descriptors.EnumValueDescriptor> makeLookupStructure(Descriptors.FieldDescriptor enumFieldType) {
            Descriptors.EnumDescriptor enumType = enumFieldType.getEnumType();
            HashMap<Binary, Descriptors.EnumValueDescriptor> lookupStructure = new HashMap<Binary, Descriptors.EnumValueDescriptor>();
            List enumValues = enumType.getValues();
            for (Descriptors.EnumValueDescriptor value : enumValues) {
                String name = value.getName();
                lookupStructure.put(Binary.fromString((String)name), enumType.findValueByName(name));
            }
            return lookupStructure;
        }

        private Descriptors.EnumValueDescriptor translateEnumValue(Binary binaryValue) {
            Descriptors.EnumValueDescriptor protoValue = this.enumLookup.get(binaryValue);
            if (protoValue == null) {
                Set<Binary> knownValues = this.enumLookup.keySet();
                String msg = "Illegal enum value \"" + binaryValue + "\"" + " in protocol buffer \"" + this.fieldType.getFullName() + "\"" + " legal values are: \"" + knownValues + "\"";
                throw new InvalidRecordException(msg);
            }
            return protoValue;
        }

        public final void addBinary(Binary binaryValue) {
            Descriptors.EnumValueDescriptor protoValue = this.translateEnumValue(binaryValue);
            this.parent.add(protoValue);
        }

        public void addValueFromDictionary(int dictionaryId) {
            this.parent.add(this.dict[dictionaryId]);
        }

        public boolean hasDictionarySupport() {
            return true;
        }

        public void setDictionary(Dictionary dictionary) {
            this.dict = new Descriptors.EnumValueDescriptor[dictionary.getMaxId() + 1];
            for (int i = 0; i <= dictionary.getMaxId(); ++i) {
                Binary binaryValue = dictionary.decodeToBinary(i);
                this.dict[i] = this.translateEnumValue(binaryValue);
            }
        }
    }

    static abstract class ParentValueContainer {
        ParentValueContainer() {
        }

        public abstract void add(Object var1);
    }
}

