/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.apache.parquet.ShouldNeverHappenException;
import org.apache.parquet.thrift.DecodingSchemaMismatchException;
import org.apache.parquet.thrift.FieldIgnoredHandler;
import org.apache.parquet.thrift.ProtocolPipe;
import org.apache.parquet.thrift.ProtocolReadToWrite;
import org.apache.parquet.thrift.SkippableException;
import org.apache.parquet.thrift.struct.ThriftField;
import org.apache.parquet.thrift.struct.ThriftType;
import org.apache.parquet.thrift.struct.ThriftTypeID;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;

public class BufferedProtocolReadToWrite
implements ProtocolPipe {
    private static final Action STRUCT_END = new Action(){

        @Override
        public void write(TProtocol out) throws TException {
            out.writeFieldStop();
            out.writeStructEnd();
        }

        @Override
        public String toDebugString() {
            return ")";
        }
    };
    private static final Action FIELD_END = new Action(){

        @Override
        public void write(TProtocol out) throws TException {
            out.writeFieldEnd();
        }

        @Override
        public String toDebugString() {
            return ";";
        }
    };
    private static final Action MAP_END = new Action(){

        @Override
        public void write(TProtocol out) throws TException {
            out.writeMapEnd();
        }

        @Override
        public String toDebugString() {
            return "]";
        }
    };
    private static final Action LIST_END = new Action(){

        @Override
        public void write(TProtocol out) throws TException {
            out.writeListEnd();
        }

        @Override
        public String toDebugString() {
            return "}";
        }
    };
    private static final Action SET_END = new Action(){

        @Override
        public void write(TProtocol out) throws TException {
            out.writeSetEnd();
        }

        @Override
        public String toDebugString() {
            return "*}";
        }
    };
    private final FieldIgnoredHandler errorHandler;
    private final ThriftType.StructType thriftType;

    public BufferedProtocolReadToWrite(ThriftType.StructType thriftType) {
        this(thriftType, null);
    }

    public BufferedProtocolReadToWrite(ThriftType.StructType thriftType, FieldIgnoredHandler errorHandler) {
        this.thriftType = thriftType;
        this.errorHandler = errorHandler;
    }

    @Override
    public void readOne(TProtocol in, TProtocol out) throws TException {
        LinkedList<Action> buffer = new LinkedList<Action>();
        try {
            boolean hasFieldsIgnored = this.readOneStruct(in, buffer, this.thriftType);
            if (hasFieldsIgnored) {
                this.notifyRecordHasFieldIgnored();
            }
        }
        catch (Exception e) {
            throw new SkippableException(this.error("Error while reading", buffer), e);
        }
        try {
            for (Action a : buffer) {
                a.write(out);
            }
        }
        catch (Exception e) {
            throw new TException(this.error("Can not write record", buffer), (Throwable)e);
        }
    }

    private void notifyRecordHasFieldIgnored() {
        if (this.errorHandler != null) {
            this.errorHandler.handleRecordHasFieldIgnored();
        }
    }

    private void notifyIgnoredFieldsOfRecord(TField field) {
        if (this.errorHandler != null) {
            this.errorHandler.handleFieldIgnored(field);
        }
    }

    private String error(String message, List<Action> buffer) {
        StringBuilder sb = new StringBuilder(message).append(": ");
        for (Action action : buffer) {
            sb.append(action.toDebugString());
        }
        return sb.toString();
    }

    private boolean readOneValue(TProtocol in, byte type, List<Action> buffer, ThriftType expectedType) throws TException {
        if (expectedType != null && expectedType.getType().getSerializedThriftType() != type) {
            throw new DecodingSchemaMismatchException("the data type does not match the expected thrift structure: expected " + expectedType + " got " + this.typeName(type));
        }
        boolean hasFieldsIgnored = false;
        switch (type) {
            case 15: {
                hasFieldsIgnored = this.readOneList(in, buffer, (ThriftType.ListType)expectedType);
                break;
            }
            case 13: {
                hasFieldsIgnored = this.readOneMap(in, buffer, (ThriftType.MapType)expectedType);
                break;
            }
            case 14: {
                hasFieldsIgnored = this.readOneSet(in, buffer, (ThriftType.SetType)expectedType);
                break;
            }
            case 12: {
                hasFieldsIgnored = this.readOneStruct(in, buffer, (ThriftType.StructType)expectedType);
                break;
            }
            case 0: {
                break;
            }
            case 2: {
                boolean bool = in.readBool();
                this.writeBoolAction(buffer, bool);
                break;
            }
            case 3: {
                byte b = in.readByte();
                this.writeByteAction(buffer, b);
                break;
            }
            case 4: {
                double d = in.readDouble();
                this.writeDoubleAction(buffer, d);
                break;
            }
            case 6: {
                short s = in.readI16();
                this.writeShortAction(buffer, s);
                break;
            }
            case 8: 
            case 16: {
                int i = in.readI32();
                this.checkEnum(expectedType, i);
                this.writeIntAction(buffer, i);
                break;
            }
            case 10: {
                long l = in.readI64();
                this.writeLongAction(buffer, l);
                break;
            }
            case 11: {
                ByteBuffer bin = in.readBinary();
                this.writeStringAction(buffer, bin);
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new TException("Unknown type: " + type);
            }
        }
        return hasFieldsIgnored;
    }

    private void writeStringAction(List<Action> buffer, final ByteBuffer bin) {
        buffer.add(new Action(){

            @Override
            public void write(TProtocol out) throws TException {
                out.writeBinary(bin);
            }

            @Override
            public String toDebugString() {
                return String.valueOf(bin);
            }
        });
    }

    private void writeLongAction(List<Action> buffer, final long l) {
        buffer.add(new Action(){

            @Override
            public void write(TProtocol out) throws TException {
                out.writeI64(l);
            }

            @Override
            public String toDebugString() {
                return String.valueOf(l);
            }
        });
    }

    private void writeIntAction(List<Action> buffer, final int i) {
        buffer.add(new Action(){

            @Override
            public void write(TProtocol out) throws TException {
                out.writeI32(i);
            }

            @Override
            public String toDebugString() {
                return String.valueOf(i);
            }
        });
    }

    private void writeShortAction(List<Action> buffer, final short s) {
        buffer.add(new Action(){

            @Override
            public void write(TProtocol out) throws TException {
                out.writeI16(s);
            }

            @Override
            public String toDebugString() {
                return String.valueOf(s);
            }
        });
    }

    private void writeDoubleAction(List<Action> buffer, final double d) {
        buffer.add(new Action(){

            @Override
            public void write(TProtocol out) throws TException {
                out.writeDouble(d);
            }

            @Override
            public String toDebugString() {
                return String.valueOf(d);
            }
        });
    }

    private void writeByteAction(List<Action> buffer, final byte b) {
        buffer.add(new Action(){

            @Override
            public void write(TProtocol out) throws TException {
                out.writeByte(b);
            }

            @Override
            public String toDebugString() {
                return String.valueOf(b);
            }
        });
    }

    private void writeBoolAction(List<Action> buffer, final boolean bool) {
        buffer.add(new Action(){

            @Override
            public void write(TProtocol out) throws TException {
                out.writeBool(bool);
            }

            @Override
            public String toDebugString() {
                return String.valueOf(bool);
            }
        });
    }

    private String typeName(byte type) {
        try {
            return ThriftTypeID.fromByte(type).name();
        }
        catch (RuntimeException e) {
            return String.valueOf(type);
        }
    }

    private boolean readOneStruct(TProtocol in, List<Action> buffer, ThriftType.StructType type) throws TException {
        final TStruct struct = in.readStructBegin();
        buffer.add(new Action(){

            @Override
            public void write(TProtocol out) throws TException {
                out.writeStructBegin(struct);
            }

            @Override
            public String toDebugString() {
                return "(";
            }
        });
        boolean hasFieldsIgnored = false;
        int childFieldsPresent = 0;
        while (true) {
            TField field = in.readFieldBegin();
            if (field.type == 0) break;
            final TField currentField = field;
            ThriftField expectedField = type.getChildById(field.id);
            if (expectedField == null) {
                this.handleUnrecognizedField(field, type, in);
                hasFieldsIgnored |= true;
                continue;
            }
            ++childFieldsPresent;
            buffer.add(new Action(){

                @Override
                public void write(TProtocol out) throws TException {
                    out.writeFieldBegin(currentField);
                }

                @Override
                public String toDebugString() {
                    return "f=" + currentField.id + "<t=" + BufferedProtocolReadToWrite.this.typeName(currentField.type) + ">: ";
                }
            });
            hasFieldsIgnored |= this.readOneValue(in, field.type, buffer, expectedField.getType());
            in.readFieldEnd();
            buffer.add(FIELD_END);
        }
        this.assertUnionHasExactlyOneChild(type, childFieldsPresent);
        in.readStructEnd();
        buffer.add(STRUCT_END);
        return hasFieldsIgnored;
    }

    private void handleUnrecognizedField(TField field, ThriftType.StructType type, TProtocol in) throws TException {
        switch (type.getStructOrUnionType()) {
            case STRUCT: {
                this.notifyIgnoredFieldsOfRecord(field);
                new ProtocolReadToWrite().readOneValue(in, new NullProtocol(), field.type);
                break;
            }
            case UNION: {
                throw new DecodingSchemaMismatchException("Unrecognized union member with id: " + field.id + " for struct:\n" + type);
            }
            case UNKNOWN: {
                throw BufferedProtocolReadToWrite.unknownStructOrUnion(type);
            }
            default: {
                throw BufferedProtocolReadToWrite.unrecognizedStructOrUnion(type.getStructOrUnionType());
            }
        }
    }

    private void assertUnionHasExactlyOneChild(ThriftType.StructType type, int childFieldsPresent) {
        switch (type.getStructOrUnionType()) {
            case STRUCT: {
                break;
            }
            case UNION: {
                if (childFieldsPresent == 1) break;
                if (childFieldsPresent == 0) {
                    throw new DecodingSchemaMismatchException("Cannot write a TUnion with no set value in :\n" + type);
                }
                throw new DecodingSchemaMismatchException("Cannot write a TUnion with more than 1 set value in :\n" + type);
            }
            case UNKNOWN: {
                throw BufferedProtocolReadToWrite.unknownStructOrUnion(type);
            }
            default: {
                throw BufferedProtocolReadToWrite.unrecognizedStructOrUnion(type.getStructOrUnionType());
            }
        }
    }

    private static ShouldNeverHappenException unrecognizedStructOrUnion(ThriftType.StructType.StructOrUnionType type) {
        return new ShouldNeverHappenException("Unrecognized StructOrUnionType: " + (Object)((Object)type));
    }

    private static ShouldNeverHappenException unknownStructOrUnion(ThriftType.StructType type) {
        return new ShouldNeverHappenException("This should never happen! Don't know if this field is a union, was the deprecated constructor of StructType used?\n" + type);
    }

    private boolean readOneMap(TProtocol in, List<Action> buffer, ThriftType.MapType mapType) throws TException {
        final TMap map = in.readMapBegin();
        buffer.add(new Action(){

            @Override
            public void write(TProtocol out) throws TException {
                out.writeMapBegin(map);
            }

            @Override
            public String toDebugString() {
                return "<k=" + map.keyType + ", v=" + map.valueType + ", s=" + map.size + ">[";
            }
        });
        boolean hasFieldIgnored = false;
        for (int i = 0; i < map.size; ++i) {
            hasFieldIgnored |= this.readOneValue(in, map.keyType, buffer, mapType.getKey().getType());
            hasFieldIgnored |= this.readOneValue(in, map.valueType, buffer, mapType.getValue().getType());
        }
        in.readMapEnd();
        buffer.add(MAP_END);
        return hasFieldIgnored;
    }

    private boolean readOneSet(TProtocol in, List<Action> buffer, ThriftType.SetType expectedType) throws TException {
        final TSet set = in.readSetBegin();
        buffer.add(new Action(){

            @Override
            public void write(TProtocol out) throws TException {
                out.writeSetBegin(set);
            }

            @Override
            public String toDebugString() {
                return "<e=" + set.elemType + ", s=" + set.size + ">{*";
            }
        });
        boolean hasFieldsIgnored = this.readCollectionElements(in, set.size, set.elemType, buffer, expectedType.getValues().getType());
        in.readSetEnd();
        buffer.add(SET_END);
        return hasFieldsIgnored;
    }

    private boolean readOneList(TProtocol in, List<Action> buffer, ThriftType.ListType expectedType) throws TException {
        final TList list = in.readListBegin();
        buffer.add(new Action(){

            @Override
            public void write(TProtocol out) throws TException {
                out.writeListBegin(list);
            }

            @Override
            public String toDebugString() {
                return "<e=" + list.elemType + ", s=" + list.size + ">{";
            }
        });
        boolean hasFieldsIgnored = this.readCollectionElements(in, list.size, list.elemType, buffer, expectedType.getValues().getType());
        in.readListEnd();
        buffer.add(LIST_END);
        return hasFieldsIgnored;
    }

    private boolean readCollectionElements(TProtocol in, int size, byte elemType, List<Action> buffer, ThriftType expectedType) throws TException {
        boolean hasFieldIgnored = false;
        for (int i = 0; i < size; ++i) {
            hasFieldIgnored |= this.readOneValue(in, elemType, buffer, expectedType);
        }
        return hasFieldIgnored;
    }

    private void checkEnum(ThriftType expectedType, int i) {
        ThriftType.EnumType expectedEnumType;
        if (expectedType.getType() == ThriftTypeID.ENUM && (expectedEnumType = (ThriftType.EnumType)expectedType).getEnumValueById(i) == null) {
            throw new DecodingSchemaMismatchException("can not find index " + i + " in enum " + expectedType);
        }
    }

    class NullProtocol
    extends TProtocol {
        public NullProtocol() {
            super(null);
        }

        public void writeMessageBegin(TMessage tMessage) throws TException {
        }

        public void writeMessageEnd() throws TException {
        }

        public void writeStructBegin(TStruct tStruct) throws TException {
        }

        public void writeStructEnd() throws TException {
        }

        public void writeFieldBegin(TField tField) throws TException {
        }

        public void writeFieldEnd() throws TException {
        }

        public void writeFieldStop() throws TException {
        }

        public void writeMapBegin(TMap tMap) throws TException {
        }

        public void writeMapEnd() throws TException {
        }

        public void writeListBegin(TList tList) throws TException {
        }

        public void writeListEnd() throws TException {
        }

        public void writeSetBegin(TSet tSet) throws TException {
        }

        public void writeSetEnd() throws TException {
        }

        public void writeBool(boolean b) throws TException {
        }

        public void writeByte(byte b) throws TException {
        }

        public void writeI16(short i) throws TException {
        }

        public void writeI32(int i) throws TException {
        }

        public void writeI64(long l) throws TException {
        }

        public void writeDouble(double v) throws TException {
        }

        public void writeString(String s) throws TException {
        }

        public void writeBinary(ByteBuffer byteBuffer) throws TException {
        }

        public TMessage readMessageBegin() throws TException {
            return null;
        }

        public void readMessageEnd() throws TException {
        }

        public TStruct readStructBegin() throws TException {
            return null;
        }

        public void readStructEnd() throws TException {
        }

        public TField readFieldBegin() throws TException {
            return null;
        }

        public void readFieldEnd() throws TException {
        }

        public TMap readMapBegin() throws TException {
            return null;
        }

        public void readMapEnd() throws TException {
        }

        public TList readListBegin() throws TException {
            return null;
        }

        public void readListEnd() throws TException {
        }

        public TSet readSetBegin() throws TException {
            return null;
        }

        public void readSetEnd() throws TException {
        }

        public boolean readBool() throws TException {
            return false;
        }

        public byte readByte() throws TException {
            return 0;
        }

        public short readI16() throws TException {
            return 0;
        }

        public int readI32() throws TException {
            return 0;
        }

        public long readI64() throws TException {
            return 0L;
        }

        public double readDouble() throws TException {
            return 0.0;
        }

        public String readString() throws TException {
            return null;
        }

        public ByteBuffer readBinary() throws TException {
            return null;
        }
    }

    private static interface Action {
        public void write(TProtocol var1) throws TException;

        public String toDebugString();
    }
}

