/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift.projection.amend;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.parquet.thrift.projection.amend.DefaultProtocolEventsGenerator;
import org.apache.parquet.thrift.struct.ThriftField;
import org.apache.parquet.thrift.struct.ThriftType;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;

public class ProtocolEventsAmender {
    List<TProtocol> rootEvents;
    List<TProtocol> fixedEvents = new ArrayList<TProtocol>();

    public ProtocolEventsAmender(List<TProtocol> rootEvents) {
        this.rootEvents = rootEvents;
    }

    public List<TProtocol> amendMissingRequiredFields(ThriftType.StructType recordThriftType) throws TException {
        Iterator<TProtocol> protocolIter = this.rootEvents.iterator();
        this.checkStruct(protocolIter, recordThriftType);
        return this.fixedEvents;
    }

    private TProtocol acceptProtocol(TProtocol p) {
        this.fixedEvents.add(p);
        return p;
    }

    private void checkStruct(Iterator<TProtocol> eventIter, ThriftType.StructType thriftStructType) throws TException {
        TProtocol next;
        TField field;
        TStruct tStruct = this.acceptProtocol(eventIter.next()).readStructBegin();
        List<ThriftField> childrenFields = thriftStructType.getChildren();
        HashSet<Short> includedFieldsIds = new HashSet<Short>();
        while (!this.isStopField(field = (next = eventIter.next()).readFieldBegin())) {
            this.acceptProtocol(next);
            includedFieldsIds.add(field.id);
            ThriftField fieldDefinition = thriftStructType.getChildById(field.id);
            this.checkField(field.type, eventIter, fieldDefinition);
            this.acceptProtocol(eventIter.next()).readFieldEnd();
        }
        for (ThriftField requiredField : childrenFields) {
            if (!this.isRequired(requiredField) || includedFieldsIds.contains(requiredField.getFieldId())) continue;
            this.fixedEvents.addAll(new DefaultProtocolEventsGenerator().createProtocolEventsForField(requiredField));
        }
        this.acceptProtocol(DefaultProtocolEventsGenerator.READ_FIELD_STOP);
        this.acceptProtocol(eventIter.next()).readStructEnd();
    }

    private void checkField(byte type, Iterator<TProtocol> eventIter, ThriftField fieldDefinition) throws TException {
        switch (type) {
            case 12: {
                this.checkStruct(eventIter, (ThriftType.StructType)fieldDefinition.getType());
                return;
            }
            case 15: {
                this.checkList(eventIter, fieldDefinition);
                return;
            }
            case 13: {
                this.checkMap(eventIter, fieldDefinition);
                return;
            }
            case 14: {
                this.checkSet(eventIter, fieldDefinition);
                return;
            }
        }
        this.checkPrimitiveField(type, eventIter);
    }

    private void checkSet(Iterator<TProtocol> eventIter, ThriftField setFieldDefinition) throws TException {
        TSet thriftSet = this.acceptProtocol(eventIter.next()).readSetBegin();
        ThriftField elementFieldDefinition = ((ThriftType.SetType)setFieldDefinition.getType()).getValues();
        int setSize = thriftSet.size;
        for (int i = 0; i < setSize; ++i) {
            this.checkField(thriftSet.elemType, eventIter, elementFieldDefinition);
        }
        this.acceptProtocol(eventIter.next()).readSetEnd();
    }

    private void checkMap(Iterator<TProtocol> eventIter, ThriftField mapFieldForWriting) throws TException {
        TMap thriftMap = this.acceptProtocol(eventIter.next()).readMapBegin();
        ThriftField keyFieldForWriting = ((ThriftType.MapType)mapFieldForWriting.getType()).getKey();
        ThriftField valueFieldForWriting = ((ThriftType.MapType)mapFieldForWriting.getType()).getValue();
        int mapSize = thriftMap.size;
        for (int i = 0; i < mapSize; ++i) {
            this.checkField(thriftMap.keyType, eventIter, keyFieldForWriting);
            this.checkField(thriftMap.valueType, eventIter, valueFieldForWriting);
        }
        this.acceptProtocol(eventIter.next()).readMapEnd();
    }

    private void checkList(Iterator<TProtocol> eventIter, ThriftField listFieldUsedForWriting) throws TException {
        ThriftField valueFieldForWriting = ((ThriftType.ListType)listFieldUsedForWriting.getType()).getValues();
        TList thriftList = this.acceptProtocol(eventIter.next()).readListBegin();
        int listSize = thriftList.size;
        for (int i = 0; i < listSize; ++i) {
            this.checkField(thriftList.elemType, eventIter, valueFieldForWriting);
        }
        this.acceptProtocol(eventIter.next()).readListEnd();
    }

    private void checkPrimitiveField(byte type, Iterator<TProtocol> eventIter) throws TException {
        this.acceptProtocol(eventIter.next());
    }

    private boolean isStopField(TField field) {
        return field.type == 0;
    }

    private boolean isRequired(ThriftField requiredField) {
        return requiredField.getRequirement() == ThriftField.Requirement.REQUIRED;
    }
}

