/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift.struct;

import org.apache.parquet.thrift.projection.FieldsPath;
import org.apache.parquet.thrift.struct.CompatibilityReport;
import org.apache.parquet.thrift.struct.State;
import org.apache.parquet.thrift.struct.ThriftField;
import org.apache.parquet.thrift.struct.ThriftType;

class CompatibleCheckerVisitor
implements ThriftType.StateVisitor<Void, State> {
    CompatibilityReport report = new CompatibilityReport();

    CompatibleCheckerVisitor() {
    }

    public CompatibilityReport getReport() {
        return this.report;
    }

    @Override
    public Void visit(ThriftType.MapType mapType, State state) {
        ThriftType.MapType oldMapType = (ThriftType.MapType)state.oldType;
        ThriftField oldKeyField = oldMapType.getKey();
        ThriftField newKeyField = mapType.getKey();
        ThriftField newValueField = mapType.getValue();
        ThriftField oldValueField = oldMapType.getValue();
        this.checkField(oldKeyField, newKeyField, state.path);
        this.checkField(oldValueField, newValueField, state.path);
        return null;
    }

    @Override
    public Void visit(ThriftType.SetType setType, State state) {
        ThriftType.SetType oldSetType = (ThriftType.SetType)state.oldType;
        ThriftField oldField = oldSetType.getValues();
        ThriftField newField = setType.getValues();
        this.checkField(oldField, newField, state.path);
        return null;
    }

    @Override
    public Void visit(ThriftType.ListType listType, State state) {
        ThriftType.ListType currentOldType = (ThriftType.ListType)state.oldType;
        ThriftField oldField = currentOldType.getValues();
        ThriftField newField = listType.getValues();
        this.checkField(oldField, newField, state.path);
        return null;
    }

    public void incompatible(String message, FieldsPath path) {
        this.report.fail("at " + path + ":" + message);
    }

    private void checkField(ThriftField oldField, ThriftField newField, FieldsPath path) {
        if (!newField.getType().getType().equals((Object)oldField.getType().getType())) {
            this.incompatible("type is not compatible: " + (Object)((Object)oldField.getType().getType()) + " vs " + (Object)((Object)newField.getType().getType()), path);
            return;
        }
        if (!newField.getName().equals(oldField.getName())) {
            this.incompatible("field names are different: " + oldField.getName() + " vs " + newField.getName(), path);
            return;
        }
        if (this.firstIsMoreRestirctive(newField.getRequirement(), oldField.getRequirement())) {
            this.incompatible("new field is more restrictive: " + newField.getName(), path);
            return;
        }
        newField.getType().accept(this, new State(oldField.getType(), path.push(newField)));
    }

    private boolean firstIsMoreRestirctive(ThriftField.Requirement firstReq, ThriftField.Requirement secReq) {
        return firstReq == ThriftField.Requirement.REQUIRED && secReq != ThriftField.Requirement.REQUIRED;
    }

    @Override
    public Void visit(ThriftType.StructType newStruct, State state) {
        ThriftType.StructType oldStructType = (ThriftType.StructType)state.oldType;
        short oldMaxId = 0;
        if (newStruct.getChildren().isEmpty()) {
            this.report.emptyStruct("encountered an empty struct: " + state.path);
        }
        for (ThriftField oldField : oldStructType.getChildren()) {
            ThriftField newField;
            short fieldId = oldField.getFieldId();
            if (fieldId > oldMaxId) {
                oldMaxId = fieldId;
            }
            if ((newField = newStruct.getChildById(fieldId)) == null) {
                this.incompatible("can not find index in new Struct: " + fieldId + " in " + newStruct, state.path);
                return null;
            }
            this.checkField(oldField, newField, state.path);
        }
        for (ThriftField newField : newStruct.getChildren()) {
            if (newField.getRequirement() != ThriftField.Requirement.REQUIRED) continue;
            short newFieldId = newField.getFieldId();
            if (newFieldId > oldMaxId) {
                this.incompatible("new required field " + newField.getName() + " is added", state.path);
                return null;
            }
            if (newFieldId >= oldMaxId || oldStructType.getChildById(newFieldId) != null) continue;
            this.incompatible("new required field " + newField.getName() + " is added", state.path);
            return null;
        }
        return null;
    }

    @Override
    public Void visit(ThriftType.EnumType enumType, State state) {
        return null;
    }

    @Override
    public Void visit(ThriftType.BoolType boolType, State state) {
        return null;
    }

    @Override
    public Void visit(ThriftType.ByteType byteType, State state) {
        return null;
    }

    @Override
    public Void visit(ThriftType.DoubleType doubleType, State state) {
        return null;
    }

    @Override
    public Void visit(ThriftType.I16Type i16Type, State state) {
        return null;
    }

    @Override
    public Void visit(ThriftType.I32Type i32Type, State state) {
        return null;
    }

    @Override
    public Void visit(ThriftType.I64Type i64Type, State state) {
        return null;
    }

    @Override
    public Void visit(ThriftType.StringType stringType, State state) {
        return null;
    }
}

