/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.metrics;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.phoenix.metrics.MetricsManager;

public class Metrics {
    private static final Log LOG = LogFactory.getLog(Metrics.class);
    private static volatile MetricsManager manager;
    private static boolean initialized;
    public static final String METRICS_SYSTEM_NAME = "phoenix";
    private static volatile boolean sinkInitialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetricsManager initialize() {
        MetricsManager manager = Metrics.getManager();
        if (manager == null) {
            LOG.warn((Object)"Phoenix metrics could not be initialized - no MetricsManager found!");
            return null;
        }
        Class<Metrics> clazz = Metrics.class;
        synchronized (Metrics.class) {
            if (!initialized) {
                LOG.info((Object)"Initializing metrics system: phoenix");
                manager.initialize(METRICS_SYSTEM_NAME);
                initialized = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return manager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MetricsManager getManager() {
        if (manager != null) return manager;
        Class<Metrics> clazz = Metrics.class;
        synchronized (Metrics.class) {
            if (manager != null) return manager;
            manager = (MetricsManager)CompatibilitySingletonFactory.getInstance(MetricsManager.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    public static void markSinkInitialized() {
        sinkInitialized = true;
    }

    public static void ensureConfigured() {
        if (!sinkInitialized) {
            LOG.warn((Object)"Phoenix metrics2/tracing sink was not started. Should be it be?");
        }
    }

    static {
        sinkInitialized = false;
    }
}

