/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.trace;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.metrics.MetricsWriter;
import org.apache.phoenix.trace.PhoenixSpanReceiver;
import org.cloudera.htrace.Span;
import org.cloudera.htrace.SpanReceiver;

public class TracingCompat {
    private static final Log LOG = LogFactory.getLog(TracingCompat.class);
    public static final String METRIC_SOURCE_KEY = "phoenix.";
    public static final String METRICS_CONTEXT = "tracing";
    public static final String METRICS_MARKER_CONTEXT = "marker";

    public static SpanReceiver newTraceMetricSource() {
        return (SpanReceiver)CompatibilityFactory.getInstance(PhoenixSpanReceiver.class);
    }

    public static void addAnnotation(Span span, String message, int value) {
        span.addKVAnnotation(message.getBytes(), Bytes.toBytes((int)value));
    }

    public static Pair<String, String> readAnnotation(byte[] key, byte[] value) {
        return new Pair((Object)new String(key), (Object)Integer.toString(Bytes.toInt((byte[])value)));
    }

    public static MetricsWriter initializeWriter(String clazz) {
        try {
            MetricsWriter writer = Class.forName(clazz).asSubclass(MetricsWriter.class).newInstance();
            writer.initialize();
            return writer;
        }
        catch (InstantiationException e) {
            LOG.error((Object)("Failed to create metrics writer: " + clazz), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)("Failed to create metrics writer: " + clazz), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("Failed to create metrics writer: " + clazz), (Throwable)e);
        }
        return null;
    }

    public static final String getTraceMetricName(long traceId) {
        return TracingCompat.getTraceMetricName(Long.toString(traceId));
    }

    public static final String getTraceMetricName(String traceId) {
        return METRIC_SOURCE_KEY + traceId;
    }
}

