/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.qpid.amqp_1_0.client;

import org.apache.qpid.amqp_1_0.type.Binary;

public class Transaction
{
    private TransactionController _transactionController;
    private Binary _txnId;

    Transaction(final TransactionController transactionController, Binary txnId)
    {
        _transactionController = transactionController;
        _txnId = txnId;
    }

    public void commit() throws LinkDetachedException
    {
        _transactionController.commit(this);
    }

    public void rollback() throws LinkDetachedException
    {
        _transactionController.rollback(this);
    }

    public Binary getTxnId()
    {
        return _txnId;
    }
}
