/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authz.handler.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.util.CertificateUtil;
import org.apache.ranger.authz.handler.RangerAuthHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RangerJwtAuthHandler
implements RangerAuthHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RangerJwtAuthHandler.class);
    private JWSVerifier verifier = null;
    private String jwksProviderUrl = null;
    public static final String TYPE = "ranger-jwt";
    public static final String KEY_PROVIDER_URL = "jwks.provider-url";
    public static final String KEY_JWT_PUBLIC_KEY = "jwt.public-key";
    public static final String KEY_JWT_COOKIE_NAME = "jwt.cookie-name";
    public static final String KEY_JWT_AUDIENCES = "jwt.audiences";
    public static final String JWT_AUTHZ_PREFIX = "Bearer ";
    protected List<String> audiences = null;
    protected JWKSource<SecurityContext> keySource = null;
    protected static String cookieName = "hadoop-jwt";

    @Override
    public void initialize(Properties config) throws Exception {
        String audiencesStr;
        String pemPublicKey;
        if (LOG.isDebugEnabled()) {
            LOG.debug("===>>> RangerJwtAuthHandler.initialize()");
        }
        this.jwksProviderUrl = config.getProperty(KEY_PROVIDER_URL);
        if (!StringUtils.isBlank((String)this.jwksProviderUrl)) {
            this.keySource = new RemoteJWKSet(new URL(this.jwksProviderUrl));
        }
        if (StringUtils.isNotBlank((String)(pemPublicKey = config.getProperty(KEY_JWT_PUBLIC_KEY)))) {
            this.verifier = new RSASSAVerifier(CertificateUtil.parseRSAPublicKey((String)pemPublicKey));
        } else if (StringUtils.isBlank((String)this.jwksProviderUrl)) {
            throw new Exception("RangerJwtAuthHandler: Mandatory configs ('jwks.provider-url' & 'jwt.public-key') are missing, must provide atleast one.");
        }
        String customCookieName = config.getProperty(KEY_JWT_COOKIE_NAME);
        if (customCookieName != null) {
            cookieName = customCookieName;
        }
        if (StringUtils.isNotBlank((String)(audiencesStr = config.getProperty(KEY_JWT_AUDIENCES)))) {
            this.audiences = Arrays.asList(audiencesStr.split(","));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<<<=== RangerJwtAuthHandler.initialize()");
        }
    }

    protected AuthenticationToken authenticate(String jwtAuthHeader, String jwtCookie) {
        AuthenticationToken token;
        block8: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("===>>> RangerJwtAuthHandler.authenticate()");
            }
            token = null;
            if (RangerJwtAuthHandler.shouldProceedAuth(jwtAuthHeader, jwtCookie)) {
                String serializedJWT = this.getJWT(jwtAuthHeader, jwtCookie);
                if (StringUtils.isNotBlank((String)serializedJWT)) {
                    try {
                        SignedJWT jwtToken = SignedJWT.parse((String)serializedJWT);
                        boolean valid = this.validateToken(jwtToken);
                        if (valid) {
                            String userName = jwtToken.getJWTClaimsSet().getSubject();
                            LOG.info("Issuing AuthenticationToken for user: [{}]", (Object)userName);
                            token = new AuthenticationToken(userName, userName, TYPE);
                            break block8;
                        }
                        LOG.warn("Validation failed for JWT token: [{}] ", (Object)jwtToken.serialize());
                    }
                    catch (ParseException pe) {
                        LOG.warn("Unable to parse the JWT token", (Throwable)pe);
                    }
                } else {
                    LOG.warn("JWT token not found.");
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<<<=== RangerJwtAuthHandler.authenticate()");
        }
        return token;
    }

    protected String getJWT(String jwtAuthHeader, String jwtCookie) {
        String[] cookie;
        String serializedJWT = null;
        if (StringUtils.isNotBlank((String)jwtAuthHeader) && jwtAuthHeader.startsWith(JWT_AUTHZ_PREFIX)) {
            serializedJWT = jwtAuthHeader.substring(JWT_AUTHZ_PREFIX.length());
        }
        if (StringUtils.isBlank(serializedJWT) && StringUtils.isNotBlank((String)jwtCookie) && cookieName.equals((cookie = jwtCookie.split("="))[0])) {
            serializedJWT = cookie[1];
        }
        return serializedJWT;
    }

    protected boolean validateToken(SignedJWT jwtToken) {
        boolean expValid = this.validateExpiration(jwtToken);
        boolean sigValid = false;
        boolean audValid = false;
        if (expValid && (sigValid = this.validateSignature(jwtToken))) {
            audValid = this.validateAudiences(jwtToken);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("expValid={}, sigValid={}, audValid={}", new Object[]{expValid, sigValid, audValid});
        }
        return sigValid && audValid && expValid;
    }

    protected boolean validateSignature(SignedJWT jwtToken) {
        boolean valid = false;
        if (JWSObject.State.SIGNED == jwtToken.getState()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("JWT token is in a SIGNED state");
            }
            if (jwtToken.getSignature() != null) {
                try {
                    if (StringUtils.isNotBlank((String)this.jwksProviderUrl)) {
                        JWSVerificationKeySelector keySelector = new JWSVerificationKeySelector(jwtToken.getHeader().getAlgorithm(), this.keySource);
                        ConfigurableJWTProcessor<SecurityContext> jwtProcessor = this.getJwtProcessor((JWSKeySelector<SecurityContext>)keySelector);
                        jwtProcessor.process(jwtToken, null);
                        valid = true;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("JWT token has been successfully verified.");
                        }
                    } else if (this.verifier != null) {
                        if (jwtToken.verify(this.verifier)) {
                            valid = true;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("JWT token has been successfully verified.");
                            }
                        } else {
                            LOG.warn("JWT signature verification failed.");
                        }
                    } else {
                        LOG.warn("Cannot authenticate JWT token as neither JWKS provider URL nor public key provided.");
                    }
                }
                catch (JOSEException | BadJOSEException e) {
                    LOG.error("Error while validating signature.", e);
                }
            }
        }
        if (!valid) {
            LOG.warn("Signature could not be verified.");
        }
        return valid;
    }

    public abstract ConfigurableJWTProcessor<SecurityContext> getJwtProcessor(JWSKeySelector<SecurityContext> var1);

    protected boolean validateAudiences(SignedJWT jwtToken) {
        boolean valid = false;
        try {
            List tokenAudienceList = jwtToken.getJWTClaimsSet().getAudience();
            if (this.audiences == null) {
                valid = true;
            } else {
                for (String aud : tokenAudienceList) {
                    if (!this.audiences.contains(aud)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("JWT token audience has been successfully validated.");
                    }
                    valid = true;
                    break;
                }
                if (!valid) {
                    LOG.warn("JWT audience validation failed.");
                }
            }
        }
        catch (ParseException pe) {
            LOG.warn("Unable to parse the JWT token.", (Throwable)pe);
        }
        return valid;
    }

    protected boolean validateExpiration(SignedJWT jwtToken) {
        boolean valid = false;
        try {
            Date expires = jwtToken.getJWTClaimsSet().getExpirationTime();
            if (expires == null || new Date().before(expires)) {
                valid = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("JWT token expiration date has been successfully validated.");
                }
            } else {
                LOG.warn("JWT token provided is expired.");
            }
        }
        catch (ParseException pe) {
            LOG.warn("Failed to validate JWT expiry.", (Throwable)pe);
        }
        return valid;
    }

    public static boolean shouldProceedAuth(String authHeader, String jwtCookie) {
        return StringUtils.isNotBlank((String)authHeader) && authHeader.startsWith(JWT_AUTHZ_PREFIX) || StringUtils.isNotBlank((String)jwtCookie) && jwtCookie.startsWith(cookieName);
    }
}

