/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.elasticsearch.plugin;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import org.apache.ranger.authorization.elasticsearch.plugin.action.filter.RangerSecurityActionFilter;
import org.apache.ranger.authorization.elasticsearch.plugin.rest.filter.RangerSecurityRestFilter;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerElasticsearchPlugin
extends Plugin
implements ActionPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(RangerElasticsearchPlugin.class);
    private static final String RANGER_ELASTICSEARCH_PLUGIN_CONF_NAME = "ranger-elasticsearch-plugin";
    private final Settings settings;
    private RangerSecurityActionFilter rangerSecurityActionFilter;

    public RangerElasticsearchPlugin(Settings settings) {
        this.settings = settings;
        LOG.debug("settings:" + this.settings);
    }

    public List<ActionFilter> getActionFilters() {
        return Collections.singletonList(this.rangerSecurityActionFilter);
    }

    public UnaryOperator<RestHandler> getRestHandlerWrapper(ThreadContext threadContext) {
        return handler -> new RangerSecurityRestFilter(threadContext, (RestHandler)handler);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry) {
        this.addPluginConfig2Classpath(environment);
        this.rangerSecurityActionFilter = new RangerSecurityActionFilter(threadPool.getThreadContext());
        return Collections.singletonList(this.rangerSecurityActionFilter);
    }

    private void addPluginConfig2Classpath(Environment environment) {
        Path configPath = environment.configFile().resolve(RANGER_ELASTICSEARCH_PLUGIN_CONF_NAME);
        if (configPath == null) {
            LOG.error("Failed to add ranger elasticsearch plugin config directory [ranger-elasticsearch-plugin] to classpath.");
            return;
        }
        File configFile = configPath.toFile();
        try {
            ClassLoader classLoader;
            if (configFile.exists() && (classLoader = ((Object)((Object)this)).getClass().getClassLoader()) instanceof URLClassLoader) {
                URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
                Class<?> urlClass = urlClassLoader.getClass();
                Method method = urlClass.getSuperclass().getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)urlClassLoader, configFile.toURI().toURL());
                LOG.info("Success to add ranger elasticsearch plugin config directory [{}] to classpath.", (Object)configFile.getCanonicalPath());
            }
        }
        catch (Exception e) {
            LOG.error("Failed to add ranger elasticsearch plugin config directory [ranger-elasticsearch-plugin] to classpath.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

