/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.metrics;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.ranger.metrics.sink.RangerMetricsJsonSink;
import org.apache.ranger.metrics.sink.RangerMetricsPrometheusSink;
import org.apache.ranger.metrics.source.RangerMetricsJvmSource;
import org.apache.ranger.metrics.wrapper.RangerMetricsSinkWrapper;
import org.apache.ranger.metrics.wrapper.RangerMetricsSourceWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerMetricsSystemWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(RangerMetricsSystemWrapper.class);
    private RangerMetricsPrometheusSink rangerMetricsPrometheusSink;
    private RangerMetricsJsonSink rangerMetricsJsonSink;

    public void init(String serviceName, List<RangerMetricsSourceWrapper> sourceWrappers, List<RangerMetricsSinkWrapper> sinkWrappers) {
        MetricsSystem metricsSystem = DefaultMetricsSystem.initialize((String)serviceName);
        HashSet<String> sourceContexts = new HashSet<String>();
        sourceContexts.add(serviceName);
        if (Objects.isNull(sourceWrappers) || sourceWrappers.isEmpty()) {
            sourceWrappers = new ArrayList<RangerMetricsSourceWrapper>();
        }
        sourceWrappers.add(new RangerMetricsSourceWrapper("RangerJVM", "Ranger common metric source (RangerMetricsJvmSource)", serviceName, new RangerMetricsJvmSource(serviceName)));
        for (RangerMetricsSourceWrapper sourceWrapper : sourceWrappers) {
            metricsSystem.register(sourceWrapper.getName(), sourceWrapper.getDescription(), (Object)sourceWrapper.getSource());
            sourceContexts.add(sourceWrapper.getContext());
        }
        if (Objects.isNull(sinkWrappers) || sinkWrappers.isEmpty()) {
            sinkWrappers = new ArrayList<RangerMetricsSinkWrapper>();
        }
        this.rangerMetricsPrometheusSink = new RangerMetricsPrometheusSink(sourceContexts);
        sinkWrappers.add(new RangerMetricsSinkWrapper("Prometheus", "Ranger common metric sink (RangerMetricsPrometheusSink)", this.rangerMetricsPrometheusSink));
        this.rangerMetricsJsonSink = new RangerMetricsJsonSink(sourceContexts);
        sinkWrappers.add(new RangerMetricsSinkWrapper("Json", "Ranger common metric sink (RangerMetricsJsonSink)", this.rangerMetricsJsonSink));
        for (RangerMetricsSinkWrapper sinkWrapper : sinkWrappers) {
            metricsSystem.register(sinkWrapper.getName(), sinkWrapper.getDescription(), sinkWrapper.getSink());
        }
        LOG.info("===>> Ranger Metric system initialized successfully.");
    }

    public String getRangerMetricsInPrometheusFormat() throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.rangerMetricsPrometheusSink.writeMetrics(stringWriter);
        return stringWriter.toString();
    }

    public Map<String, Map<String, Object>> getRangerMetrics() {
        return this.rangerMetricsJsonSink.getMetrics();
    }
}

