/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.admin.client;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.admin.client.AbstractRangerAdminClient;
import org.apache.ranger.admin.client.datatype.RESTResponse;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.model.RangerRole;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.GrantRevokeRoleRequest;
import org.apache.ranger.plugin.util.RangerPluginCapability;
import org.apache.ranger.plugin.util.RangerRESTClient;
import org.apache.ranger.plugin.util.RangerRESTUtils;
import org.apache.ranger.plugin.util.RangerRoles;
import org.apache.ranger.plugin.util.RangerServiceNotFoundException;
import org.apache.ranger.plugin.util.RangerUserStore;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.apache.ranger.plugin.util.ServiceTags;
import org.apache.ranger.plugin.util.URLEncoderUtil;

public class RangerAdminRESTClient
extends AbstractRangerAdminClient {
    private static final Log LOG = LogFactory.getLog(RangerAdminRESTClient.class);
    private String serviceName;
    private String serviceNameUrlParam;
    private String pluginId;
    private String clusterName;
    private RangerRESTClient restClient;
    private RangerRESTUtils restUtils = new RangerRESTUtils();
    private boolean supportsPolicyDeltas;
    private boolean supportsTagDeltas;
    private final String pluginCapabilities = Long.toHexString(new RangerPluginCapability().getPluginCapabilities());

    public static <T> GenericType<List<T>> getGenericType(final T clazz) {
        ParameterizedType parameterizedGenericType = new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{clazz.getClass()};
            }

            @Override
            public Type getRawType() {
                return List.class;
            }

            @Override
            public Type getOwnerType() {
                return List.class;
            }
        };
        return new GenericType<List<T>>(parameterizedGenericType){};
    }

    @Override
    public void init(String serviceName, String appId, String propertyPrefix, Configuration config) {
        super.init(serviceName, appId, propertyPrefix, config);
        this.serviceName = serviceName;
        this.pluginId = this.restUtils.getPluginId(serviceName, appId);
        String url = "";
        String tmpUrl = config.get(propertyPrefix + ".policy.rest.url");
        String sslConfigFileName = config.get(propertyPrefix + ".policy.rest.ssl.config.file");
        this.clusterName = config.get(propertyPrefix + ".access.cluster.name", "");
        if (StringUtil.isEmpty(this.clusterName)) {
            this.clusterName = config.get(propertyPrefix + ".ambari.cluster.name", "");
            if (StringUtil.isEmpty(this.clusterName) && config instanceof RangerPluginConfig) {
                this.clusterName = ((RangerPluginConfig)config).getClusterName();
            }
        }
        int restClientConnTimeOutMs = config.getInt(propertyPrefix + ".policy.rest.client.connection.timeoutMs", 120000);
        int restClientReadTimeOutMs = config.getInt(propertyPrefix + ".policy.rest.client.read.timeoutMs", 30000);
        this.supportsPolicyDeltas = config.getBoolean(propertyPrefix + ".supports.policy.deltas", false);
        this.supportsTagDeltas = config.getBoolean(propertyPrefix + ".supports.tag.deltas", false);
        if (!StringUtil.isEmpty(tmpUrl)) {
            url = tmpUrl.trim();
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        this.init(url, sslConfigFileName, restClientConnTimeOutMs, restClientReadTimeOutMs, config);
        try {
            this.serviceNameUrlParam = URLEncoderUtil.encodeURIParam(serviceName);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)("Unsupported encoding, serviceName=" + serviceName));
            this.serviceNameUrlParam = serviceName;
        }
    }

    @Override
    public ServicePolicies getServicePoliciesIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        ServicePolicies ret;
        RESTResponse resp;
        ClientResponse response;
        UserGroupInformation user;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.getServicePoliciesIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + ")"));
        }
        boolean isSecureMode = (user = MiscUtil.getUGILoginUser()) != null && UserGroupInformation.isSecurityEnabled();
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("lastKnownVersion", Long.toString(lastKnownVersion));
        queryParams.put("lastActivationTime", Long.toString(lastActivationTimeInMillis));
        queryParams.put("pluginId", this.pluginId);
        queryParams.put("clusterName", this.clusterName);
        queryParams.put("supportsPolicyDeltas", Boolean.toString(this.supportsPolicyDeltas));
        queryParams.put("pluginCapabilities", this.pluginCapabilities);
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Checking Service policy if updated as user : " + user));
            }
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    ClientResponse clientRes = null;
                    String relativeURL = "/service/plugins/secure/policies/download/" + RangerAdminRESTClient.this.serviceNameUrlParam;
                    try {
                        clientRes = RangerAdminRESTClient.this.restClient.get(relativeURL, queryParams);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to get response, Error is : " + e.getMessage()));
                    }
                    return clientRes;
                }
            };
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Checking Service policy if updated with old api call");
            }
            String relativeURL = "/service/plugins/policies/download/" + this.serviceNameUrlParam;
            response = this.restClient.get(relativeURL, queryParams);
        }
        if (response == null || response.getStatus() == 304) {
            if (response == null) {
                LOG.error((Object)("Error getting policies; Received NULL response!!. secureMode=" + isSecureMode + ", user=" + user + ", serviceName=" + this.serviceName));
            } else {
                resp = RESTResponse.fromClientResponse(response);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("No change in policies. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName));
                }
            }
            ret = null;
        } else if (response.getStatus() == 200) {
            ret = (ServicePolicies)response.getEntity(ServicePolicies.class);
        } else if (response.getStatus() == 404) {
            LOG.error((Object)("Error getting policies; service not found. secureMode=" + isSecureMode + ", user=" + user + ", response=" + response.getStatus() + ", serviceName=" + this.serviceName + ", lastKnownVersion=" + lastKnownVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis));
            ret = null;
            String exceptionMsg = response.hasEntity() ? (String)response.getEntity(String.class) : null;
            RangerServiceNotFoundException.throwExceptionIfServiceNotFound(this.serviceName, exceptionMsg);
            LOG.warn((Object)("Received 404 error code with body:[" + exceptionMsg + "], Ignoring"));
        } else {
            resp = RESTResponse.fromClientResponse(response);
            LOG.warn((Object)("Error getting policies. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName));
            ret = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.getServicePoliciesIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): " + ret));
        }
        return ret;
    }

    @Override
    public RangerRoles getRolesIfUpdated(long lastKnownRoleVersion, long lastActivationTimeInMillis) throws Exception {
        RangerRoles ret;
        RESTResponse resp;
        ClientResponse response;
        UserGroupInformation user;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.getRolesIfUpdated(" + lastKnownRoleVersion + ", " + lastActivationTimeInMillis + ")"));
        }
        boolean isSecureMode = (user = MiscUtil.getUGILoginUser()) != null && UserGroupInformation.isSecurityEnabled();
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("lastKnownRoleVersion", Long.toString(lastKnownRoleVersion));
        queryParams.put("lastActivationTime", Long.toString(lastActivationTimeInMillis));
        queryParams.put("pluginId", this.pluginId);
        queryParams.put("clusterName", this.clusterName);
        queryParams.put("pluginCapabilities", this.pluginCapabilities);
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Checking Roles updated as user : " + user));
            }
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    ClientResponse clientRes = null;
                    String relativeURL = "/service/roles/secure/download/" + RangerAdminRESTClient.this.serviceNameUrlParam;
                    try {
                        clientRes = RangerAdminRESTClient.this.restClient.get(relativeURL, queryParams);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to get response, Error is : " + e.getMessage()));
                    }
                    return clientRes;
                }
            };
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Checking Roles updated as user : " + user));
            }
            String relativeURL = "/service/roles/download/" + this.serviceNameUrlParam;
            response = this.restClient.get(relativeURL, queryParams);
        }
        if (response == null || response.getStatus() == 304) {
            if (response == null) {
                LOG.error((Object)("Error getting Roles; Received NULL response!!. secureMode=" + isSecureMode + ", user=" + user + ", serviceName=" + this.serviceName));
            } else {
                resp = RESTResponse.fromClientResponse(response);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("No change in Roles. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName + ", lastKnownRoleVersion=" + lastKnownRoleVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis));
                }
            }
            ret = null;
        } else if (response.getStatus() == 200) {
            ret = (RangerRoles)response.getEntity(RangerRoles.class);
        } else if (response.getStatus() == 404) {
            ret = null;
            LOG.error((Object)("Error getting Roles; service not found. secureMode=" + isSecureMode + ", user=" + user + ", response=" + response.getStatus() + ", serviceName=" + this.serviceName + ", lastKnownRoleVersion=" + lastKnownRoleVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis));
            String exceptionMsg = response.hasEntity() ? (String)response.getEntity(String.class) : null;
            RangerServiceNotFoundException.throwExceptionIfServiceNotFound(this.serviceName, exceptionMsg);
            LOG.warn((Object)("Received 404 error code with body:[" + exceptionMsg + "], Ignoring"));
        } else {
            resp = RESTResponse.fromClientResponse(response);
            LOG.warn((Object)("Error getting Roles. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName));
            ret = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.getRolesIfUpdated(" + lastKnownRoleVersion + ", " + lastActivationTimeInMillis + "): "));
        }
        return ret;
    }

    @Override
    public RangerRole createRole(final RangerRole request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.createRole(" + request + ")"));
        }
        RangerRole ret = null;
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        final String relativeURL = "/service/public/v2/api/roles/";
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("serviceName", this.serviceNameUrlParam);
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    ClientResponse clientRes = null;
                    try {
                        clientRes = RangerAdminRESTClient.this.restClient.post(relativeURL, queryParams, request);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to get response, Error is : " + e.getMessage()));
                    }
                    return clientRes;
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("create role as user " + user));
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            response = this.restClient.post(relativeURL, queryParams, request);
        }
        if (response != null && response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error((Object)("createRole() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : "")));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (response == null) {
            throw new Exception("unknown error during createRole. roleName=" + request.getName());
        }
        ret = (RangerRole)response.getEntity(RangerRole.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.createRole(" + request + ")"));
        }
        return ret;
    }

    @Override
    public void dropRole(String execUser, String roleName) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.dropRole(" + roleName + ")"));
        }
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("serviceName", this.serviceNameUrlParam);
        queryParams.put("execUser", execUser);
        final String relativeURL = "/service/public/v2/api/roles/name/" + roleName;
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    ClientResponse clientRes = null;
                    try {
                        clientRes = RangerAdminRESTClient.this.restClient.delete(relativeURL, queryParams);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to get response, Error is : " + e.getMessage()));
                    }
                    return clientRes;
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("drop role as user " + user));
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            response = this.restClient.delete(relativeURL, queryParams);
        }
        if (response == null) {
            throw new Exception("unknown error during deleteRole. roleName=" + roleName);
        }
        if (response.getStatus() != 200 && response.getStatus() != 204) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error((Object)("createRole() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : "")));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.deleteRole(" + roleName + ")"));
        }
    }

    @Override
    public List<String> getUserRoles(String execUser) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.getUserRoles(" + execUser + ")"));
        }
        List ret = null;
        String emptyString = "";
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        final String relativeURL = "/service/public/v2/api/roles/user/" + execUser;
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    ClientResponse clientRes = null;
                    try {
                        clientRes = RangerAdminRESTClient.this.restClient.get(relativeURL, null);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to get response, Error is : " + e.getMessage()));
                    }
                    return clientRes;
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("get roles as user " + user));
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            response = this.restClient.get(relativeURL, null);
        }
        if (response != null) {
            if (response.getStatus() != 200) {
                RESTResponse resp = RESTResponse.fromClientResponse(response);
                LOG.error((Object)("getUserRoles() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : "")));
                if (response.getStatus() == 401) {
                    throw new AccessControlException();
                }
                throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
            }
        } else {
            throw new Exception("unknown error during getUserRoles. execUser=" + execUser);
        }
        ret = (List)response.getEntity(RangerAdminRESTClient.getGenericType(emptyString));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.getUserRoles(" + execUser + ")"));
        }
        return ret;
    }

    @Override
    public List<String> getAllRoles(String execUser) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAdminRESTClient.getAllRoles()");
        }
        List ret = null;
        String emptyString = "";
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        final String relativeURL = "/service/public/v2/api/roles/names/";
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("serviceName", this.serviceNameUrlParam);
        queryParams.put("execUser", execUser);
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    ClientResponse clientRes = null;
                    try {
                        clientRes = RangerAdminRESTClient.this.restClient.get(relativeURL, queryParams);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to get response, Error is : " + e.getMessage()));
                    }
                    return clientRes;
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("get roles as user " + user));
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            response = this.restClient.get(relativeURL, queryParams);
        }
        if (response != null) {
            if (response.getStatus() != 200) {
                RESTResponse resp = RESTResponse.fromClientResponse(response);
                LOG.error((Object)("getAllRoles() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : "")));
                if (response.getStatus() == 401) {
                    throw new AccessControlException();
                }
                throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
            }
        } else {
            throw new Exception("unknown error during getAllRoles.");
        }
        ret = (List)response.getEntity(RangerAdminRESTClient.getGenericType(emptyString));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAdminRESTClient.getAllRoles()");
        }
        return ret;
    }

    @Override
    public RangerRole getRole(String execUser, String roleName) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.getPrincipalsForRole(" + roleName + ")"));
        }
        RangerRole ret = null;
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        final String relativeURL = "/service/public/v2/api/roles/name/" + roleName;
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("serviceName", this.serviceNameUrlParam);
        queryParams.put("execUser", execUser);
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    ClientResponse clientResp = null;
                    try {
                        clientResp = RangerAdminRESTClient.this.restClient.get(relativeURL, queryParams);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to get response, Error is : " + e.getMessage()));
                    }
                    return clientResp;
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("get role info as user " + user));
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            response = this.restClient.get(relativeURL, queryParams);
        }
        if (response != null) {
            if (response.getStatus() != 200) {
                RESTResponse resp = RESTResponse.fromClientResponse(response);
                LOG.error((Object)("getPrincipalsForRole() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : "")));
                if (response.getStatus() == 401) {
                    throw new AccessControlException();
                }
                throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
            }
        } else {
            throw new Exception("unknown error during getPrincipalsForRole. roleName=" + roleName);
        }
        ret = (RangerRole)response.getEntity(RangerRole.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.getPrincipalsForRole(" + roleName + ")"));
        }
        return ret;
    }

    @Override
    public void grantRole(final GrantRevokeRoleRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.grantRole(" + request + ")"));
        }
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        final String relativeURL = "/service/public/v2/api/roles/grant/" + this.serviceNameUrlParam;
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    ClientResponse clientResp = null;
                    try {
                        clientResp = RangerAdminRESTClient.this.restClient.put(relativeURL, null, request);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to get response, Error is : " + e.getMessage()));
                    }
                    return clientResp;
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("grant role as user " + user));
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            response = this.restClient.put(relativeURL, null, request);
        }
        if (response != null && response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error((Object)("grantRole() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : "")));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (response == null) {
            throw new Exception("unknown error during grantRole. serviceName=" + this.serviceName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.grantRole(" + request + ")"));
        }
    }

    @Override
    public void revokeRole(final GrantRevokeRoleRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.revokeRole(" + request + ")"));
        }
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        final String relativeURL = "/service/public/v2/api/roles/revoke/" + this.serviceNameUrlParam;
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    ClientResponse clientResp = null;
                    try {
                        clientResp = RangerAdminRESTClient.this.restClient.put(relativeURL, null, request);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to get response, Error is : " + e.getMessage()));
                    }
                    return clientResp;
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("revoke role as user " + user));
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            response = this.restClient.put(relativeURL, null, request);
        }
        if (response != null && response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error((Object)("revokeRole() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : "")));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (response == null) {
            throw new Exception("unknown error during revokeRole. serviceName=" + this.serviceName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.revokeRole(" + request + ")"));
        }
    }

    @Override
    public void grantAccess(final GrantRevokeRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.grantAccess(" + request + ")"));
        }
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("pluginId", this.pluginId);
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    String relativeURL = "/service/plugins/secure/services/grant/" + RangerAdminRESTClient.this.serviceNameUrlParam;
                    ClientResponse clientResp = null;
                    try {
                        clientResp = RangerAdminRESTClient.this.restClient.post(relativeURL, queryParams, request);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to get response, Error is : " + e.getMessage()));
                    }
                    return clientResp;
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("grantAccess as user " + user));
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            String relativeURL = "/service/plugins/services/grant/" + this.serviceNameUrlParam;
            response = this.restClient.post(relativeURL, queryParams, request);
        }
        if (response != null && response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error((Object)("grantAccess() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : "")));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (response == null) {
            throw new Exception("unknown error during grantAccess. serviceName=" + this.serviceName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.grantAccess(" + request + ")"));
        }
    }

    @Override
    public void revokeAccess(final GrantRevokeRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.revokeAccess(" + request + ")"));
        }
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("pluginId", this.pluginId);
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    String relativeURL = "/service/plugins/secure/services/revoke/" + RangerAdminRESTClient.this.serviceNameUrlParam;
                    ClientResponse clientResp = null;
                    try {
                        clientResp = RangerAdminRESTClient.this.restClient.post(relativeURL, queryParams, request);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to get response, Error is : " + e.getMessage()));
                    }
                    return clientResp;
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("revokeAccess as user " + user));
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            String relativeURL = "/service/plugins/services/revoke/" + this.serviceNameUrlParam;
            response = this.restClient.post(relativeURL, queryParams, request);
        }
        if (response != null && response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error((Object)("revokeAccess() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : "")));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (response == null) {
            throw new Exception("unknown error. revokeAccess(). serviceName=" + this.serviceName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.revokeAccess(" + request + ")"));
        }
    }

    private void init(String url, String sslConfigFileName, int restClientConnTimeOutMs, int restClientReadTimeOutMs, Configuration config) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.init(" + url + ", " + sslConfigFileName + ")"));
        }
        this.restClient = new RangerRESTClient(url, sslConfigFileName, config);
        this.restClient.setRestClientConnTimeOutMs(restClientConnTimeOutMs);
        this.restClient.setRestClientReadTimeOutMs(restClientReadTimeOutMs);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.init(" + url + ", " + sslConfigFileName + ")"));
        }
    }

    @Override
    public ServiceTags getServiceTagsIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        RESTResponse resp;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.getServiceTagsIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): "));
        }
        ServiceTags ret = null;
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("lastKnownVersion", Long.toString(lastKnownVersion));
        queryParams.put("lastActivationTime", Long.toString(lastActivationTimeInMillis));
        queryParams.put("pluginId", this.pluginId);
        queryParams.put("supportsTagDeltas", Boolean.toString(this.supportsTagDeltas));
        queryParams.put("pluginCapabilities", this.pluginCapabilities);
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    String relativeURL = "/service/tags/secure/download/" + RangerAdminRESTClient.this.serviceNameUrlParam;
                    ClientResponse clientResp = null;
                    try {
                        clientResp = RangerAdminRESTClient.this.restClient.get(relativeURL, queryParams);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to get response, Error is : " + e.getMessage()));
                    }
                    return clientResp;
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getServiceTagsIfUpdated as user " + user));
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            String relativeURL = "/service/tags/download/" + this.serviceNameUrlParam;
            response = this.restClient.get(relativeURL, queryParams);
        }
        if (response == null || response.getStatus() == 304) {
            if (response == null) {
                LOG.error((Object)("Error getting tags; Received NULL response!!. secureMode=" + isSecureMode + ", user=" + user + ", serviceName=" + this.serviceName));
            } else {
                resp = RESTResponse.fromClientResponse(response);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("No change in tags. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName + ", lastKnownVersion=" + lastKnownVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis));
                }
            }
            ret = null;
        } else if (response.getStatus() == 200) {
            ret = (ServiceTags)response.getEntity(ServiceTags.class);
        } else if (response.getStatus() == 404) {
            LOG.error((Object)("Error getting tags; service not found. secureMode=" + isSecureMode + ", user=" + user + ", response=" + response.getStatus() + ", serviceName=" + this.serviceName + ", lastKnownVersion=" + lastKnownVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis));
            String exceptionMsg = response.hasEntity() ? (String)response.getEntity(String.class) : null;
            RangerServiceNotFoundException.throwExceptionIfServiceNotFound(this.serviceName, exceptionMsg);
            LOG.warn((Object)("Received 404 error code with body:[" + exceptionMsg + "], Ignoring"));
        } else {
            resp = RESTResponse.fromClientResponse(response);
            LOG.warn((Object)("Error getting tags. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName));
            ret = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.getServiceTagsIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): "));
        }
        return ret;
    }

    @Override
    public List<String> getTagTypes(String pattern) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.getTagTypes(" + pattern + "): "));
        }
        List ret = null;
        String emptyString = "";
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("serviceName", this.serviceNameUrlParam);
        queryParams.put("pattern", pattern);
        final String relativeURL = "/service/tags/lookup";
        ClientResponse response = null;
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    ClientResponse clientResp = null;
                    try {
                        clientResp = RangerAdminRESTClient.this.restClient.get(relativeURL, queryParams);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to get response, Error is : " + e.getMessage()));
                    }
                    return clientResp;
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getTagTypes as user " + user));
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            response = this.restClient.get(relativeURL, queryParams);
        }
        if (response == null || response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error((Object)("Error getting tags. response=" + resp + ", serviceName=" + this.serviceName + ", pattern=" + pattern));
            throw new Exception(resp.getMessage());
        }
        ret = (List)response.getEntity(RangerAdminRESTClient.getGenericType(emptyString));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.getTagTypes(" + pattern + "): " + ret));
        }
        return ret;
    }

    @Override
    public RangerUserStore getUserStoreIfUpdated(long lastKnownUserStoreVersion, long lastActivationTimeInMillis) throws Exception {
        RangerUserStore ret;
        RESTResponse resp;
        ClientResponse response;
        UserGroupInformation user;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.getUserStoreIfUpdated(" + lastKnownUserStoreVersion + ", " + lastActivationTimeInMillis + ")"));
        }
        boolean isSecureMode = (user = MiscUtil.getUGILoginUser()) != null && UserGroupInformation.isSecurityEnabled();
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("lastKnownUserStoreVersion", Long.toString(lastKnownUserStoreVersion));
        queryParams.put("lastActivationTime", Long.toString(lastActivationTimeInMillis));
        queryParams.put("pluginId", this.pluginId);
        queryParams.put("clusterName", this.clusterName);
        queryParams.put("pluginCapabilities", this.pluginCapabilities);
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Checking UserStore updated as user : " + user));
            }
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    ClientResponse clientRes = null;
                    String relativeURL = "/service/xusers/secure/download/" + RangerAdminRESTClient.this.serviceNameUrlParam;
                    try {
                        clientRes = RangerAdminRESTClient.this.restClient.get(relativeURL, queryParams);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to get response, Error is : " + e.getMessage()));
                    }
                    return clientRes;
                }
            };
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Checking UserStore updated as user : " + user));
            }
            String relativeURL = "/service/xusers/secure/download/" + this.serviceNameUrlParam;
            response = this.restClient.get(relativeURL, queryParams);
        }
        if (response == null || response.getStatus() == 304) {
            if (response == null) {
                LOG.error((Object)("Error getting UserStore; Received NULL response!!. secureMode=" + isSecureMode + ", user=" + user + ", serviceName=" + this.serviceName));
            } else {
                resp = RESTResponse.fromClientResponse(response);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("No change in UserStore. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName + ", lastKnownUserStoreVersion=" + lastKnownUserStoreVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis));
                }
            }
            ret = null;
        } else if (response.getStatus() == 200) {
            ret = (RangerUserStore)response.getEntity(RangerUserStore.class);
        } else if (response.getStatus() == 404) {
            ret = null;
            LOG.error((Object)("Error getting UserStore; service not found. secureMode=" + isSecureMode + ", user=" + user + ", response=" + response.getStatus() + ", serviceName=" + this.serviceName + ", lastKnownUserStoreVersion=" + lastKnownUserStoreVersion + ", lastActivationTimeInMillis=" + lastActivationTimeInMillis));
            String exceptionMsg = response.hasEntity() ? (String)response.getEntity(String.class) : null;
            RangerServiceNotFoundException.throwExceptionIfServiceNotFound(this.serviceName, exceptionMsg);
            LOG.warn((Object)("Received 404 error code with body:[" + exceptionMsg + "], Ignoring"));
        } else {
            resp = RESTResponse.fromClientResponse(response);
            LOG.warn((Object)("Error getting UserStore. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp + ", serviceName=" + this.serviceName));
            ret = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.getUserStoreIfUpdated(" + lastKnownUserStoreVersion + ", " + lastActivationTimeInMillis + "): "));
        }
        return ret;
    }
}

