/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.plugin.contextenricher.RangerAbstractContextEnricher;
import org.apache.ranger.plugin.contextenricher.RangerServiceResourceMatcher;
import org.apache.ranger.plugin.contextenricher.RangerTagForEval;
import org.apache.ranger.plugin.contextenricher.RangerTagRetriever;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.plugin.model.RangerTag;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerResourceTrie;
import org.apache.ranger.plugin.policyresourcematcher.RangerDefaultPolicyResourceMatcher;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.service.RangerAuthContext;
import org.apache.ranger.plugin.util.DownloadTrigger;
import org.apache.ranger.plugin.util.DownloaderTask;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerReadWriteLock;
import org.apache.ranger.plugin.util.RangerServiceNotFoundException;
import org.apache.ranger.plugin.util.RangerServiceTagsDeltaUtil;
import org.apache.ranger.plugin.util.ServiceTags;

public class RangerTagEnricher
extends RangerAbstractContextEnricher {
    private static final Log LOG = LogFactory.getLog(RangerTagEnricher.class);
    private static final Log PERF_CONTEXTENRICHER_INIT_LOG = RangerPerfTracer.getPerfLogger("contextenricher.init");
    private static final Log PERF_TRIE_OP_LOG = RangerPerfTracer.getPerfLogger("resourcetrie.retrieval");
    private static final Log PERF_SET_SERVICETAGS_LOG = RangerPerfTracer.getPerfLogger("tagenricher.setservicetags");
    private static final String TAG_REFRESHER_POLLINGINTERVAL_OPTION = "tagRefresherPollingInterval";
    public static final String TAG_RETRIEVER_CLASSNAME_OPTION = "tagRetrieverClassName";
    private static final String TAG_DISABLE_TRIE_PREFILTER_OPTION = "disableTrieLookupPrefilter";
    private RangerTagRefresher tagRefresher;
    private RangerTagRetriever tagRetriever;
    private boolean disableTrieLookupPrefilter;
    private EnrichedServiceTags enrichedServiceTags;
    private boolean disableCacheIfServiceNotFound = true;
    private final BlockingQueue<DownloadTrigger> tagDownloadQueue = new LinkedBlockingQueue<DownloadTrigger>();
    private Timer tagDownloadTimer;
    private RangerServiceDefHelper serviceDefHelper;
    private RangerReadWriteLock lock = new RangerReadWriteLock(false);

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerTagEnricher.init()");
        }
        super.init();
        String tagRetrieverClassName = this.getOption(TAG_RETRIEVER_CLASSNAME_OPTION);
        long pollingIntervalMs = this.getLongOption(TAG_REFRESHER_POLLINGINTERVAL_OPTION, 60000L);
        this.disableTrieLookupPrefilter = this.getBooleanOption(TAG_DISABLE_TRIE_PREFILTER_OPTION, false);
        this.serviceDefHelper = new RangerServiceDefHelper(this.serviceDef, false);
        if (StringUtils.isNotBlank((String)tagRetrieverClassName)) {
            try {
                Class<?> tagRetriverClass = Class.forName(tagRetrieverClassName);
                this.tagRetriever = (RangerTagRetriever)tagRetriverClass.newInstance();
            }
            catch (ClassNotFoundException exception) {
                LOG.error((Object)("Class " + tagRetrieverClassName + " not found, exception=" + exception));
            }
            catch (ClassCastException exception) {
                LOG.error((Object)("Class " + tagRetrieverClassName + " is not a type of RangerTagRetriever, exception=" + exception));
            }
            catch (IllegalAccessException exception) {
                LOG.error((Object)("Class " + tagRetrieverClassName + " illegally accessed, exception=" + exception));
            }
            catch (InstantiationException exception) {
                LOG.error((Object)("Class " + tagRetrieverClassName + " could not be instantiated, exception=" + exception));
            }
            if (this.tagRetriever != null) {
                String propertyPrefix = "ranger.plugin." + this.serviceDef.getName();
                this.disableCacheIfServiceNotFound = this.getBooleanConfig(propertyPrefix + ".disable.cache.if.servicenotfound", true);
                String cacheDir = this.getConfig(propertyPrefix + ".policy.cache.dir", null);
                String cacheFilename = String.format("%s_%s_tag.json", this.appId, this.serviceName);
                cacheFilename = cacheFilename.replace(File.separatorChar, '_');
                cacheFilename = cacheFilename.replace(File.pathSeparatorChar, '_');
                String cacheFile = cacheDir == null ? null : cacheDir + File.separator + cacheFilename;
                this.createLock();
                this.tagRetriever.setServiceName(this.serviceName);
                this.tagRetriever.setServiceDef(this.serviceDef);
                this.tagRetriever.setAppId(this.appId);
                this.tagRetriever.setPluginConfig(this.getPluginConfig());
                this.tagRetriever.init(this.enricherDef.getEnricherOptions());
                this.tagRefresher = new RangerTagRefresher(this.tagRetriever, this, -1L, this.tagDownloadQueue, cacheFile);
                LOG.info((Object)("Created RangerTagRefresher Thread(" + this.tagRefresher.getName() + ")"));
                try {
                    this.tagRefresher.populateTags();
                }
                catch (Throwable exception) {
                    LOG.error((Object)"Exception when retrieving tag for the first time for this enricher", exception);
                }
                this.tagRefresher.setDaemon(true);
                this.tagRefresher.startRefresher();
                this.tagDownloadTimer = new Timer("policyDownloadTimer", true);
                try {
                    this.tagDownloadTimer.schedule((TimerTask)new DownloaderTask(this.tagDownloadQueue), pollingIntervalMs, pollingIntervalMs);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Scheduled tagDownloadRefresher to download tags every " + pollingIntervalMs + " milliseconds"));
                    }
                }
                catch (IllegalStateException exception) {
                    LOG.error((Object)"Error scheduling tagDownloadTimer:", (Throwable)exception);
                    LOG.error((Object)("*** Tags will NOT be downloaded every " + pollingIntervalMs + " milliseconds ***"));
                    this.tagDownloadTimer = null;
                }
            }
        } else {
            LOG.error((Object)"No value specified for tagRetrieverClassName in the RangerTagEnricher options");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerTagEnricher.init()");
        }
    }

    @Override
    public void enrich(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerTagEnricher.enrich(" + request + ")"));
        }
        this.enrich(request, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerTagEnricher.enrich(" + request + ")"));
        }
    }

    @Override
    public void enrich(RangerAccessRequest request, Object dataStore) {
        Set<RangerTagForEval> matchedTags;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerTagEnricher.enrich(" + request + ") with dataStore:[" + dataStore + "]"));
        }
        try (RangerReadWriteLock.RangerLock readLock = this.lock.getReadLock();){
            EnrichedServiceTags enrichedServiceTags;
            if (LOG.isDebugEnabled() && readLock.isLockingEnabled()) {
                LOG.debug((Object)("Acquired lock - " + readLock));
            }
            if (dataStore instanceof EnrichedServiceTags) {
                enrichedServiceTags = (EnrichedServiceTags)dataStore;
            } else {
                enrichedServiceTags = this.enrichedServiceTags;
                if (dataStore != null) {
                    LOG.warn((Object)("Incorrect type of dataStore :[" + dataStore.getClass().getName() + "], falling back to original enrich"));
                }
            }
            matchedTags = enrichedServiceTags == null ? null : this.findMatchingTags(request, enrichedServiceTags);
            RangerAccessRequestUtil.setRequestTagsInContext(request.getContext(), matchedTags);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerTagEnricher.enrich(" + request + ") with dataStore:[" + dataStore + "]): tags count=" + (matchedTags == null ? 0 : matchedTags.size())));
        }
    }

    public void setServiceTags(ServiceTags serviceTags) {
        boolean rebuildOnlyIndex = false;
        this.setServiceTags(serviceTags, rebuildOnlyIndex);
    }

    protected void setServiceTags(ServiceTags serviceTags, boolean rebuildOnlyIndex) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerTagEnricher.setServiceTags(serviceTags=" + serviceTags + ", rebuildOnlyIndex=" + rebuildOnlyIndex + ")"));
        }
        try (RangerReadWriteLock.RangerLock writeLock = this.lock.getWriteLock();){
            if (LOG.isDebugEnabled() && writeLock.isLockingEnabled()) {
                LOG.debug((Object)("Acquired lock - " + writeLock));
            }
            RangerPerfTracer perf = null;
            if (RangerPerfTracer.isPerfTraceEnabled(PERF_SET_SERVICETAGS_LOG)) {
                perf = RangerPerfTracer.getPerfTracer(PERF_SET_SERVICETAGS_LOG, "RangerTagEnricher.setServiceTags(newTagVersion=" + serviceTags.getTagVersion() + ",isDelta=" + serviceTags.getIsDelta() + ")");
            }
            if (serviceTags == null) {
                LOG.info((Object)("ServiceTags is null for service " + this.serviceName));
                this.enrichedServiceTags = null;
            } else if (!serviceTags.getIsDelta().booleanValue()) {
                this.processServiceTags(serviceTags);
            } else {
                ServiceTags allServiceTags;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Received service-tag deltas:" + serviceTags));
                }
                ServiceTags oldServiceTags = this.enrichedServiceTags != null ? this.enrichedServiceTags.getServiceTags() : new ServiceTags();
                ServiceTags serviceTags2 = allServiceTags = rebuildOnlyIndex ? oldServiceTags : RangerServiceTagsDeltaUtil.applyDelta(oldServiceTags, serviceTags);
                if (serviceTags.getTagsChangeExtent() == ServiceTags.TagsChangeExtent.NONE) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"No change to service-tags other than version change");
                    }
                } else if (serviceTags.getTagsChangeExtent() != ServiceTags.TagsChangeExtent.TAGS) {
                    Map<Object, Object> trieMap = this.enrichedServiceTags == null ? new HashMap() : (writeLock.isLockingEnabled() ? this.enrichedServiceTags.getServiceResourceTrie() : this.copyServiceResourceTrie());
                    this.processServiceTagDeltas(serviceTags, allServiceTags, trieMap);
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Delta contains only tag attribute changes");
                    }
                    ArrayList<RangerServiceResourceMatcher> resourceMatchers = this.enrichedServiceTags != null ? this.enrichedServiceTags.getServiceResourceMatchers() : new ArrayList();
                    HashMap<String, RangerResourceTrie<RangerServiceResourceMatcher>> serviceResourceTrie = this.enrichedServiceTags != null ? this.enrichedServiceTags.getServiceResourceTrie() : new HashMap();
                    this.enrichedServiceTags = new EnrichedServiceTags(allServiceTags, resourceMatchers, serviceResourceTrie);
                }
            }
            this.setEnrichedServiceTagsInPlugin();
            RangerPerfTracer.logAlways(perf);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerTagEnricher.setServiceTags(serviceTags=" + serviceTags + ", rebuildOnlyIndex=" + rebuildOnlyIndex + ")"));
        }
    }

    public Long getServiceTagsVersion() {
        EnrichedServiceTags localEnrichedServiceTags = this.enrichedServiceTags;
        return localEnrichedServiceTags != null ? localEnrichedServiceTags.getServiceTags().getTagVersion() : -1L;
    }

    protected Long getResourceTrieVersion() {
        EnrichedServiceTags localEnrichedServiceTags = this.enrichedServiceTags;
        return localEnrichedServiceTags != null ? localEnrichedServiceTags.getResourceTrieVersion() : -1L;
    }

    @Override
    public boolean preCleanup() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerTagEnricher.preCleanup()");
        }
        super.preCleanup();
        Timer tagDownloadTimer = this.tagDownloadTimer;
        this.tagDownloadTimer = null;
        if (tagDownloadTimer != null) {
            tagDownloadTimer.cancel();
        }
        RangerTagRefresher tagRefresher = this.tagRefresher;
        this.tagRefresher = null;
        if (tagRefresher != null) {
            tagRefresher.cleanup();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerTagEnricher.preCleanup() : result=true");
        }
        return true;
    }

    public void syncTagsWithAdmin(DownloadTrigger token) throws InterruptedException {
        this.tagDownloadQueue.put(token);
        token.waitForCompletion();
    }

    public EnrichedServiceTags getEnrichedServiceTags() {
        return this.enrichedServiceTags;
    }

    protected RangerReadWriteLock createLock() {
        String propertyPrefix = "ranger.plugin." + this.serviceDef.getName();
        RangerPluginConfig config = this.getPluginConfig();
        boolean deltasEnabled = config != null && config.getBoolean(propertyPrefix + ".supports.tag.deltas", false);
        boolean inPlaceUpdatesEnabled = config != null && config.getBoolean(propertyPrefix + ".supports.in.place.tag.updates", false);
        boolean useReadWriteLock = deltasEnabled && inPlaceUpdatesEnabled;
        LOG.info((Object)("Policy-Engine will" + (useReadWriteLock ? " " : " not ") + "use read-write locking to update tags in place when tag-deltas are provided"));
        return new RangerReadWriteLock(useReadWriteLock);
    }

    private void processServiceTags(ServiceTags serviceTags) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Processing all service-tags");
        }
        boolean isInError = false;
        if (CollectionUtils.isEmpty(serviceTags.getServiceResources())) {
            LOG.info((Object)("There are no tagged resources for service " + this.serviceName));
            this.enrichedServiceTags = null;
        } else {
            ResourceHierarchies hierarchies = new ResourceHierarchies();
            ArrayList<RangerServiceResourceMatcher> resourceMatchers = new ArrayList<RangerServiceResourceMatcher>();
            List<RangerServiceResource> serviceResources = serviceTags.getServiceResources();
            for (RangerServiceResource serviceResource : serviceResources) {
                RangerServiceResourceMatcher serviceResourceMatcher = RangerTagEnricher.createRangerServiceResourceMatcher(serviceResource, this.serviceDefHelper, hierarchies);
                if (serviceResourceMatcher != null) {
                    resourceMatchers.add(serviceResourceMatcher);
                    continue;
                }
                LOG.error((Object)("Could not create service-resource-matcher for service-resource:[" + serviceResource + "]"));
                isInError = true;
                break;
            }
            if (isInError) {
                serviceTags.setTagVersion(-1L);
                LOG.error((Object)"Error in processing tag-deltas. Will continue to use old tags");
            } else {
                HashMap<String, RangerResourceTrie<RangerServiceResourceMatcher>> serviceResourceTrie = null;
                if (!this.disableTrieLookupPrefilter) {
                    serviceResourceTrie = new HashMap<String, RangerResourceTrie<RangerServiceResourceMatcher>>();
                    for (RangerServiceDef.RangerResourceDef resourceDef : this.serviceDef.getResources()) {
                        serviceResourceTrie.put(resourceDef.getName(), new RangerResourceTrie<RangerServiceResourceMatcher>(resourceDef, resourceMatchers, this.getPolicyEngineOptions().optimizeTrieForRetrieval, null));
                    }
                }
                this.enrichedServiceTags = new EnrichedServiceTags(serviceTags, resourceMatchers, serviceResourceTrie);
            }
        }
    }

    private void processServiceTagDeltas(ServiceTags deltas, ServiceTags allServiceTags, Map<String, RangerResourceTrie<RangerServiceResourceMatcher>> serviceResourceTrie) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Delta contains changes other than tag attribute changes, [" + (Object)((Object)deltas.getTagsChangeExtent()) + "]"));
        }
        boolean isInError = false;
        ResourceHierarchies hierarchies = new ResourceHierarchies();
        ArrayList<RangerServiceResourceMatcher> resourceMatchers = new ArrayList<RangerServiceResourceMatcher>();
        if (this.enrichedServiceTags != null) {
            resourceMatchers.addAll(this.enrichedServiceTags.getServiceResourceMatchers());
        }
        List<RangerServiceResource> changedServiceResources = deltas.getServiceResources();
        for (RangerServiceResource rangerServiceResource : changedServiceResources) {
            boolean removedOldServiceResource;
            boolean bl = removedOldServiceResource = MapUtils.isEmpty(rangerServiceResource.getResourceElements()) || this.removeOldServiceResource(rangerServiceResource, resourceMatchers, serviceResourceTrie);
            if (removedOldServiceResource) {
                if (!StringUtils.isEmpty((String)rangerServiceResource.getResourceSignature())) {
                    RangerServiceResourceMatcher resourceMatcher = RangerTagEnricher.createRangerServiceResourceMatcher(rangerServiceResource, this.serviceDefHelper, hierarchies);
                    if (resourceMatcher != null) {
                        for (RangerServiceDef.RangerResourceDef resourceDef : this.serviceDef.getResources()) {
                            RangerResourceTrie<RangerServiceResourceMatcher> trie = serviceResourceTrie.get(resourceDef.getName());
                            if (trie != null) {
                                trie.add(rangerServiceResource.getResourceElements().get(resourceDef.getName()), resourceMatcher);
                                if (!LOG.isDebugEnabled()) continue;
                                LOG.debug((Object)("Added resource-matcher for service-resource:[" + rangerServiceResource + "]"));
                                continue;
                            }
                            trie = new RangerResourceTrie<RangerServiceResourceMatcher>(resourceDef, Collections.singletonList(resourceMatcher));
                            serviceResourceTrie.put(resourceDef.getName(), trie);
                        }
                        resourceMatchers.add(resourceMatcher);
                    } else {
                        LOG.error((Object)("Could not create resource-matcher for resource: [" + rangerServiceResource + "]. Should NOT happen!!"));
                        LOG.error((Object)"Setting tagVersion to -1 to ensure that in the next download all tags are downloaded");
                        isInError = true;
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Service-resource:[id=" + rangerServiceResource.getId() + "] is deleted as its resource-signature is empty. No need to create it!"));
                }
            } else {
                isInError = true;
            }
            if (!isInError) continue;
            break;
        }
        if (isInError) {
            LOG.error((Object)"Error in processing tag-deltas. Will continue to use old tags");
            deltas.setTagVersion(-1L);
        } else {
            for (Map.Entry entry : serviceResourceTrie.entrySet()) {
                ((RangerResourceTrie)entry.getValue()).wrapUpUpdate();
            }
            this.enrichedServiceTags = new EnrichedServiceTags(allServiceTags, resourceMatchers, serviceResourceTrie);
        }
    }

    private boolean removeOldServiceResource(RangerServiceResource serviceResource, List<RangerServiceResourceMatcher> resourceMatchers, Map<String, RangerResourceTrie<RangerServiceResourceMatcher>> resourceTries) {
        boolean ret = true;
        if (this.enrichedServiceTags != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing service-resource:[" + serviceResource + "] from trie-map"));
            }
            RangerAccessResourceImpl accessResource = new RangerAccessResourceImpl();
            for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry : serviceResource.getResourceElements().entrySet()) {
                accessResource.setValue(entry.getKey(), entry.getValue());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RangerAccessResource:[" + accessResource + "] created to represent service-resource[" + serviceResource + "] to find evaluators from trie-map"));
            }
            RangerAccessRequestImpl request = new RangerAccessRequestImpl();
            request.setResource(accessResource);
            List<RangerServiceResourceMatcher> oldMatchers = this.getEvaluators(request, this.enrichedServiceTags);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found [" + oldMatchers.size() + "] matchers for service-resource[" + serviceResource + "]"));
            }
            block1: for (RangerServiceResourceMatcher matcher : oldMatchers) {
                for (RangerServiceDef.RangerResourceDef resourceDef : this.serviceDef.getResources()) {
                    String resourceDefName = resourceDef.getName();
                    RangerResourceTrie<RangerServiceResourceMatcher> trie = resourceTries.get(resourceDefName);
                    if (trie != null) {
                        trie.delete(serviceResource.getResourceElements().get(resourceDefName), matcher);
                        continue;
                    }
                    LOG.error((Object)("Cannot find resourceDef with name:[" + resourceDefName + "]. Should NOT happen!!"));
                    LOG.error((Object)"Setting tagVersion to -1 to ensure that in the next download all tags are downloaded");
                    ret = false;
                    continue block1;
                }
            }
            if (ret) {
                resourceMatchers.removeAll(oldMatchers);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Found and removed [" + oldMatchers.size() + "] matchers for service-resource[" + serviceResource + "] from trie-map"));
                }
            }
        }
        return ret;
    }

    public static RangerServiceResourceMatcher createRangerServiceResourceMatcher(RangerServiceResource serviceResource, RangerServiceDefHelper serviceDefHelper, ResourceHierarchies hierarchies) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> createRangerServiceResourceMatcher(serviceResource=" + serviceResource + ")"));
        }
        RangerServiceResourceMatcher ret = null;
        Set<String> resourceKeys = serviceResource.getResourceElements().keySet();
        for (int policyType : RangerPolicy.POLICY_TYPES) {
            Boolean isValidHierarchy = hierarchies.isValidHierarchy(policyType, resourceKeys);
            if (isValidHierarchy == null) {
                isValidHierarchy = Boolean.FALSE;
                for (List<RangerServiceDef.RangerResourceDef> hierarchy : serviceDefHelper.getResourceHierarchies(policyType)) {
                    if (!serviceDefHelper.hierarchyHasAllResources(hierarchy, resourceKeys)) continue;
                    isValidHierarchy = Boolean.TRUE;
                    break;
                }
                hierarchies.addHierarchy(policyType, resourceKeys, isValidHierarchy);
            }
            if (!isValidHierarchy.booleanValue()) continue;
            RangerDefaultPolicyResourceMatcher matcher = new RangerDefaultPolicyResourceMatcher();
            matcher.setServiceDef(serviceDefHelper.getServiceDef());
            matcher.setPolicyResources(serviceResource.getResourceElements(), policyType);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RangerTagEnricher.setServiceTags() - Initializing matcher with (resource=" + serviceResource + ", serviceDef=" + serviceDefHelper.getServiceDef() + ")"));
            }
            matcher.setServiceDefHelper(serviceDefHelper);
            matcher.init();
            ret = new RangerServiceResourceMatcher(serviceResource, matcher);
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== createRangerServiceResourceMatcher(serviceResource=" + serviceResource + ") : [" + ret + "]"));
        }
        return ret;
    }

    private void setEnrichedServiceTagsInPlugin() {
        RangerAuthContext authContext;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> setEnrichedServiceTagsInPlugin()");
        }
        if ((authContext = this.getAuthContext()) != null) {
            authContext.addOrReplaceRequestContextEnricher(this, this.enrichedServiceTags);
            this.notifyAuthContextChanged();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== setEnrichedServiceTagsInPlugin()");
        }
    }

    private Set<RangerTagForEval> findMatchingTags(RangerAccessRequest request, EnrichedServiceTags dataStore) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerTagEnricher.findMatchingTags(" + request + ")"));
        }
        EnrichedServiceTags enrichedServiceTags = dataStore != null ? dataStore : this.enrichedServiceTags;
        Set<RangerTagForEval> ret = null;
        RangerAccessResource resource = request.getResource();
        if ((resource == null || resource.getKeys() == null || resource.getKeys().isEmpty()) && request.isAccessTypeAny()) {
            ret = enrichedServiceTags.getTagsForEmptyResourceAndAnyAccess();
        } else {
            List<RangerServiceResourceMatcher> serviceResourceMatchers = this.getEvaluators(request, enrichedServiceTags);
            if (CollectionUtils.isNotEmpty(serviceResourceMatchers)) {
                for (RangerServiceResourceMatcher resourceMatcher : serviceResourceMatchers) {
                    boolean isMatched;
                    RangerPolicyResourceMatcher.MatchType matchType = resourceMatcher.getMatchType(resource, request.getContext());
                    if (request.isAccessTypeAny()) {
                        isMatched = matchType != RangerPolicyResourceMatcher.MatchType.NONE;
                    } else if (request.getResourceMatchingScope() == RangerAccessRequest.ResourceMatchingScope.SELF_OR_DESCENDANTS) {
                        isMatched = matchType != RangerPolicyResourceMatcher.MatchType.NONE;
                    } else {
                        boolean bl = isMatched = matchType == RangerPolicyResourceMatcher.MatchType.SELF || matchType == RangerPolicyResourceMatcher.MatchType.ANCESTOR;
                    }
                    if (!isMatched) continue;
                    if (ret == null) {
                        ret = new HashSet<RangerTagForEval>();
                    }
                    ret.addAll(RangerTagEnricher.getTagsForServiceResource(request.getAccessTime(), enrichedServiceTags.getServiceTags(), resourceMatcher.getServiceResource(), matchType));
                }
            }
        }
        if (CollectionUtils.isEmpty(ret)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RangerTagEnricher.findMatchingTags(" + resource + ") - No tags Found "));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RangerTagEnricher.findMatchingTags(" + resource + ") - " + ret.size() + " tags Found "));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerTagEnricher.findMatchingTags(" + request + ")"));
        }
        return ret;
    }

    private List<RangerServiceResourceMatcher> getEvaluators(RangerAccessRequest request, EnrichedServiceTags enrichedServiceTags) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerTagEnricher.getEvaluators(request=" + request + ")"));
        }
        List<RangerServiceResourceMatcher> ret = Collections.EMPTY_LIST;
        RangerAccessResource resource = request.getResource();
        Map<String, RangerResourceTrie<RangerServiceResourceMatcher>> serviceResourceTrie = enrichedServiceTags.getServiceResourceTrie();
        if (resource == null || resource.getKeys() == null || resource.getKeys().isEmpty() || serviceResourceTrie == null) {
            ret = enrichedServiceTags.getServiceResourceMatchers();
        } else {
            RangerPerfTracer perf = null;
            if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_OP_LOG)) {
                perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_OP_LOG, "RangerTagEnricher.getEvaluators(resource=" + resource.getAsString() + ")");
            }
            List<String> resourceKeys = this.serviceDefHelper.getOrderedResourceNames(resource.getKeys());
            HashSet<RangerServiceResourceMatcher> smallestList = null;
            if (CollectionUtils.isNotEmpty(resourceKeys)) {
                for (String resourceName : resourceKeys) {
                    RangerResourceTrie<RangerServiceResourceMatcher> trie = serviceResourceTrie.get(resourceName);
                    if (trie == null) continue;
                    HashSet serviceResourceMatchersForResource = trie.getEvaluatorsForResource(resource.getValue(resourceName), request.getResourceMatchingScope());
                    HashSet inheritedResourceMatchers = trie.getInheritedEvaluators();
                    if (smallestList != null) {
                        if (CollectionUtils.isEmpty(inheritedResourceMatchers) && CollectionUtils.isEmpty(serviceResourceMatchersForResource)) {
                            smallestList = null;
                        } else if (CollectionUtils.isEmpty(inheritedResourceMatchers)) {
                            smallestList.retainAll(serviceResourceMatchersForResource);
                        } else if (CollectionUtils.isEmpty(serviceResourceMatchersForResource)) {
                            smallestList.retainAll(inheritedResourceMatchers);
                        } else {
                            HashSet bigger;
                            HashSet smaller;
                            if (serviceResourceMatchersForResource.size() < inheritedResourceMatchers.size()) {
                                smaller = serviceResourceMatchersForResource;
                                bigger = inheritedResourceMatchers;
                            } else {
                                smaller = inheritedResourceMatchers;
                                bigger = serviceResourceMatchersForResource;
                            }
                            HashSet tmp = new HashSet();
                            if (smallestList.size() < smaller.size()) {
                                smallestList.stream().filter(smaller::contains).forEach(tmp::add);
                                smallestList.stream().filter(bigger::contains).forEach(tmp::add);
                            } else {
                                smaller.stream().filter(smallestList::contains).forEach(tmp::add);
                                if (smallestList.size() < bigger.size()) {
                                    smallestList.stream().filter(bigger::contains).forEach(tmp::add);
                                } else {
                                    bigger.stream().filter(smallestList::contains).forEach(tmp::add);
                                }
                            }
                            smallestList = tmp;
                        }
                    } else if (CollectionUtils.isEmpty(inheritedResourceMatchers) || CollectionUtils.isEmpty(serviceResourceMatchersForResource)) {
                        HashSet tmp = CollectionUtils.isEmpty(inheritedResourceMatchers) ? serviceResourceMatchersForResource : inheritedResourceMatchers;
                        smallestList = resourceKeys.size() == 1 || CollectionUtils.isEmpty(tmp) ? tmp : new HashSet(tmp);
                    } else {
                        smallestList = new HashSet<RangerServiceResourceMatcher>(serviceResourceMatchersForResource);
                        smallestList.addAll(inheritedResourceMatchers);
                    }
                    if (!CollectionUtils.isEmpty((Collection)smallestList)) continue;
                    smallestList = null;
                    break;
                }
            }
            if (smallestList != null) {
                ret = new ArrayList<RangerServiceResourceMatcher>(smallestList);
            }
            RangerPerfTracer.logAlways(perf);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerTagEnricher.getEvaluators(request=" + request + "): evaluatorCount=" + ret.size()));
        }
        return ret;
    }

    private static Set<RangerTagForEval> getTagsForServiceResource(Date accessTime, ServiceTags serviceTags, RangerServiceResource serviceResource, RangerPolicyResourceMatcher.MatchType matchType) {
        HashSet<RangerTagForEval> ret = new HashSet<RangerTagForEval>();
        Long resourceId = serviceResource.getId();
        Map<Long, List<Long>> resourceToTagIds = serviceTags.getResourceToTagIds();
        Map<Long, RangerTag> tags = serviceTags.getTags();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Looking for tags for resource-id:[" + resourceId + "] in serviceTags:[" + serviceTags + "]"));
        }
        if (resourceId != null && MapUtils.isNotEmpty(resourceToTagIds) && MapUtils.isNotEmpty(tags)) {
            List<Long> tagIds = resourceToTagIds.get(resourceId);
            if (CollectionUtils.isNotEmpty(tagIds)) {
                accessTime = accessTime == null ? new Date() : accessTime;
                for (Long tagId : tagIds) {
                    RangerTagForEval tagForEval;
                    RangerTag tag = tags.get(tagId);
                    if (tag == null || !(tagForEval = new RangerTagForEval(tag, matchType)).isApplicable(accessTime)) continue;
                    ret.add(tagForEval);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No tags mapping found for resource:[" + resourceId + "]"));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"resourceId is null or resourceToTagTds mapping is null or tags mapping is null!");
        }
        return ret;
    }

    private Map<String, RangerResourceTrie<RangerServiceResourceMatcher>> copyServiceResourceTrie() {
        HashMap<String, RangerResourceTrie<RangerServiceResourceMatcher>> ret = new HashMap<String, RangerResourceTrie<RangerServiceResourceMatcher>>();
        if (this.enrichedServiceTags != null) {
            for (Map.Entry<String, RangerResourceTrie<RangerServiceResourceMatcher>> entry : this.enrichedServiceTags.getServiceResourceTrie().entrySet()) {
                RangerResourceTrie<RangerServiceResourceMatcher> resourceTrie = new RangerResourceTrie<RangerServiceResourceMatcher>(entry.getValue());
                ret.put(entry.getKey(), resourceTrie);
            }
        }
        return ret;
    }

    static class RangerTagRefresher
    extends Thread {
        private static final Log LOG = LogFactory.getLog(RangerTagRefresher.class);
        private final RangerTagRetriever tagRetriever;
        private final RangerTagEnricher tagEnricher;
        private long lastKnownVersion;
        private final BlockingQueue<DownloadTrigger> tagDownloadQueue;
        private long lastActivationTimeInMillis;
        private final String cacheFile;
        private boolean hasProvidedTagsToReceiver;
        private Gson gson;

        RangerTagRefresher(RangerTagRetriever tagRetriever, RangerTagEnricher tagEnricher, long lastKnownVersion, BlockingQueue<DownloadTrigger> tagDownloadQueue, String cacheFile) {
            this.tagRetriever = tagRetriever;
            this.tagEnricher = tagEnricher;
            this.lastKnownVersion = lastKnownVersion;
            this.tagDownloadQueue = tagDownloadQueue;
            this.cacheFile = cacheFile;
            try {
                this.gson = new GsonBuilder().setDateFormat("yyyyMMdd-HH:mm:ss.SSS-Z").create();
            }
            catch (Throwable excp) {
                LOG.fatal((Object)"failed to create GsonBuilder object", excp);
            }
            this.setName("RangerTagRefresher(serviceName=" + tagRetriever.getServiceName() + ")-" + this.getId());
        }

        public long getLastActivationTimeInMillis() {
            return this.lastActivationTimeInMillis;
        }

        public void setLastActivationTimeInMillis(long lastActivationTimeInMillis) {
            this.lastActivationTimeInMillis = lastActivationTimeInMillis;
        }

        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"==> RangerTagRefresher().run()");
            }
            while (true) {
                DownloadTrigger trigger = null;
                try {
                    RangerPerfTracer perf = null;
                    if (RangerPerfTracer.isPerfTraceEnabled(PERF_CONTEXTENRICHER_INIT_LOG)) {
                        perf = RangerPerfTracer.getPerfTracer(PERF_CONTEXTENRICHER_INIT_LOG, "RangerTagRefresher(" + this.getName() + ").populateTags(lastKnownVersion=" + this.lastKnownVersion + ")");
                    }
                    trigger = this.tagDownloadQueue.take();
                    this.populateTags();
                    RangerPerfTracer.log(perf);
                    continue;
                }
                catch (InterruptedException excp) {
                    LOG.info((Object)("RangerTagRefresher(" + this.getName() + ").run(): Interrupted! Exiting thread"), (Throwable)excp);
                }
                finally {
                    if (trigger == null) continue;
                    trigger.signalCompletion();
                    continue;
                }
                break;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"<== RangerTagRefresher().run()");
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void populateTags() throws InterruptedException {
            if (this.tagEnricher != null) {
                try {
                    ServiceTags serviceTags = this.tagRetriever.retrieveTags(this.lastKnownVersion, this.lastActivationTimeInMillis);
                    if (serviceTags == null) {
                        if (!this.hasProvidedTagsToReceiver) {
                            serviceTags = this.loadFromCache();
                        }
                    } else if (!serviceTags.getIsDelta().booleanValue()) {
                        this.saveToCache(serviceTags);
                    }
                    if (serviceTags != null) {
                        this.tagEnricher.setServiceTags(serviceTags);
                        if (serviceTags.getIsDelta().booleanValue() && serviceTags.getTagVersion() != -1L) {
                            this.saveToCache(this.tagEnricher.enrichedServiceTags.serviceTags);
                        }
                        LOG.info((Object)("RangerTagRefresher(serviceName=" + this.tagRetriever.getServiceName() + ").populateTags() - Updated tags-cache to new version of tags, lastKnownVersion=" + this.lastKnownVersion + "; newVersion=" + (serviceTags.getTagVersion() == null ? -1L : serviceTags.getTagVersion())));
                        this.hasProvidedTagsToReceiver = true;
                        this.lastKnownVersion = serviceTags.getTagVersion() == null ? -1L : serviceTags.getTagVersion();
                        this.setLastActivationTimeInMillis(System.currentTimeMillis());
                        return;
                    }
                    if (!LOG.isDebugEnabled()) return;
                    LOG.debug((Object)("RangerTagRefresher(serviceName=" + this.tagRetriever.getServiceName() + ").populateTags() - No need to update tags-cache. lastKnownVersion=" + this.lastKnownVersion));
                    return;
                }
                catch (RangerServiceNotFoundException snfe) {
                    LOG.error((Object)"Caught ServiceNotFound exception :", (Throwable)snfe);
                    if (!this.tagEnricher.disableCacheIfServiceNotFound) return;
                    this.disableCache();
                    this.tagEnricher.setServiceTags(null);
                    this.setLastActivationTimeInMillis(System.currentTimeMillis());
                    this.lastKnownVersion = -1L;
                    return;
                }
                catch (InterruptedException interruptedException) {
                    throw interruptedException;
                }
                catch (Exception e) {
                    LOG.error((Object)("RangerTagRefresher(serviceName=" + this.tagRetriever.getServiceName() + ").populateTags(): Encountered unexpected exception. Ignoring"), (Throwable)e);
                    return;
                }
            } else {
                LOG.error((Object)("RangerTagRefresher(serviceName=" + this.tagRetriever.getServiceName() + ".populateTags() - no tag receiver to update tag-cache"));
            }
        }

        void cleanup() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"==> RangerTagRefresher.cleanup()");
            }
            this.stopRefresher();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"<== RangerTagRefresher.cleanup()");
            }
        }

        final void startRefresher() {
            try {
                super.start();
            }
            catch (Exception excp) {
                LOG.error((Object)("RangerTagRefresher(" + this.getName() + ").startRetriever(): Failed to start, exception=" + excp));
            }
        }

        private void stopRefresher() {
            if (super.isAlive()) {
                super.interrupt();
                boolean setInterrupted = false;
                boolean isJoined = false;
                while (!isJoined) {
                    try {
                        super.join();
                        isJoined = true;
                    }
                    catch (InterruptedException excp) {
                        LOG.warn((Object)("RangerTagRefresher(" + this.getName() + ").stopRefresher(): Error while waiting for thread to exit"), (Throwable)excp);
                        LOG.warn((Object)"Retrying Thread.join(). Current thread will be marked as 'interrupted' after Thread.join() returns");
                        setInterrupted = true;
                    }
                }
                if (setInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        final ServiceTags loadFromCache() {
            serviceTags = null;
            if (RangerTagRefresher.LOG.isDebugEnabled()) {
                RangerTagRefresher.LOG.debug((Object)("==> RangerTagRetriever(serviceName=" + this.tagEnricher.getServiceName() + ").loadFromCache()"));
            }
            v0 = cacheFile = StringUtils.isEmpty((String)this.cacheFile) != false ? null : new File(this.cacheFile);
            if (cacheFile != null && cacheFile.isFile() && cacheFile.canRead()) {
                reader = null;
                try {
                    reader = new FileReader(cacheFile);
                    serviceTags = (ServiceTags)this.gson.fromJson((Reader)reader, ServiceTags.class);
                    if (serviceTags == null || StringUtils.equals((String)this.tagEnricher.getServiceName(), (String)serviceTags.getServiceName())) ** GOTO lbl26
                    RangerTagRefresher.LOG.warn((Object)("ignoring unexpected serviceName '" + serviceTags.getServiceName() + "' in cache file '" + cacheFile.getAbsolutePath() + "'"));
                    serviceTags.setServiceName(this.tagEnricher.getServiceName());
                }
                catch (Exception excp) {
                    RangerTagRefresher.LOG.error((Object)("failed to load service-tags from cache file " + cacheFile.getAbsolutePath()), (Throwable)excp);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception excp) {
                            RangerTagRefresher.LOG.error((Object)("error while closing opened cache file " + cacheFile.getAbsolutePath()), (Throwable)excp);
                        }
                    }
                }
            } else {
                RangerTagRefresher.LOG.warn((Object)("cache file does not exist or not readable '" + (cacheFile == null ? null : cacheFile.getAbsolutePath()) + "'"));
            }
lbl26:
            // 4 sources

            if (RangerTagRefresher.LOG.isDebugEnabled()) {
                RangerTagRefresher.LOG.debug((Object)("<== RangerTagRetriever(serviceName=" + this.tagEnricher.getServiceName() + ").loadFromCache()"));
            }
            return serviceTags;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void saveToCache(ServiceTags serviceTags) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("==> RangerTagRetriever(serviceName=" + this.tagEnricher.getServiceName() + ").saveToCache()"));
            }
            if (serviceTags != null) {
                File cacheFile;
                File file = cacheFile = StringUtils.isEmpty((String)this.cacheFile) ? null : new File(this.cacheFile);
                if (cacheFile != null) {
                    FileWriter writer = null;
                    try {
                        writer = new FileWriter(cacheFile);
                        this.gson.toJson((Object)serviceTags, (Appendable)writer);
                    }
                    catch (Exception excp) {
                        LOG.error((Object)("failed to save service-tags to cache file '" + cacheFile.getAbsolutePath() + "'"), (Throwable)excp);
                    }
                    finally {
                        if (writer != null) {
                            try {
                                ((Writer)writer).close();
                            }
                            catch (Exception excp) {
                                LOG.error((Object)("error while closing opened cache file '" + cacheFile.getAbsolutePath() + "'"), (Throwable)excp);
                            }
                        }
                    }
                }
            } else {
                LOG.info((Object)("service-tags is null for service=" + this.tagRetriever.getServiceName() + ". Nothing to save in cache"));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("<== RangerTagRetriever(serviceName=" + this.tagEnricher.getServiceName() + ").saveToCache()"));
            }
        }

        final void disableCache() {
            File cacheFile;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("==> RangerTagRetriever.disableCache(serviceName=" + this.tagEnricher.getServiceName() + ")"));
            }
            File file = cacheFile = StringUtils.isEmpty((String)this.cacheFile) ? null : new File(this.cacheFile);
            if (cacheFile != null && cacheFile.isFile() && cacheFile.canRead()) {
                LOG.warn((Object)"Cleaning up local tags cache");
                String renamedCacheFile = cacheFile.getAbsolutePath() + "_" + System.currentTimeMillis();
                if (!cacheFile.renameTo(new File(renamedCacheFile))) {
                    LOG.error((Object)("Failed to move " + cacheFile.getAbsolutePath() + " to " + renamedCacheFile));
                } else {
                    LOG.warn((Object)("moved " + cacheFile.getAbsolutePath() + " to " + renamedCacheFile));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No local TAGS cache found. No need to disable it!");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("<== RangerTagRetriever.disableCache(serviceName=" + this.tagEnricher.getServiceName() + ")"));
            }
        }
    }

    public static final class EnrichedServiceTags {
        private final ServiceTags serviceTags;
        private final List<RangerServiceResourceMatcher> serviceResourceMatchers;
        private final Map<String, RangerResourceTrie<RangerServiceResourceMatcher>> serviceResourceTrie;
        private final Set<RangerTagForEval> tagsForEmptyResourceAndAnyAccess;
        private final Long resourceTrieVersion;

        EnrichedServiceTags(ServiceTags serviceTags, List<RangerServiceResourceMatcher> serviceResourceMatchers, Map<String, RangerResourceTrie<RangerServiceResourceMatcher>> serviceResourceTrie) {
            this.serviceTags = serviceTags;
            this.serviceResourceMatchers = serviceResourceMatchers;
            this.serviceResourceTrie = serviceResourceTrie;
            this.tagsForEmptyResourceAndAnyAccess = this.createTagsForEmptyResourceAndAnyAccess();
            this.resourceTrieVersion = serviceTags.getTagVersion();
        }

        public ServiceTags getServiceTags() {
            return this.serviceTags;
        }

        public List<RangerServiceResourceMatcher> getServiceResourceMatchers() {
            return this.serviceResourceMatchers;
        }

        public Map<String, RangerResourceTrie<RangerServiceResourceMatcher>> getServiceResourceTrie() {
            return this.serviceResourceTrie;
        }

        public Long getResourceTrieVersion() {
            return this.resourceTrieVersion;
        }

        public Set<RangerTagForEval> getTagsForEmptyResourceAndAnyAccess() {
            return this.tagsForEmptyResourceAndAnyAccess;
        }

        private Set<RangerTagForEval> createTagsForEmptyResourceAndAnyAccess() {
            HashSet<RangerTagForEval> tagsForEmptyResourceAndAnyAccess = new HashSet<RangerTagForEval>();
            for (Map.Entry<Long, RangerTag> entry : this.serviceTags.getTags().entrySet()) {
                tagsForEmptyResourceAndAnyAccess.add(new RangerTagForEval(entry.getValue(), RangerPolicyResourceMatcher.MatchType.DESCENDANT));
            }
            return tagsForEmptyResourceAndAnyAccess;
        }
    }

    public static class ResourceHierarchies {
        private final Map<Collection<String>, Boolean> accessHierarchies = new HashMap<Collection<String>, Boolean>();
        private final Map<Collection<String>, Boolean> dataMaskHierarchies = new HashMap<Collection<String>, Boolean>();
        private final Map<Collection<String>, Boolean> rowFilterHierarchies = new HashMap<Collection<String>, Boolean>();

        Boolean isValidHierarchy(int policyType, Collection<String> resourceKeys) {
            switch (policyType) {
                case 0: {
                    return this.accessHierarchies.get(resourceKeys);
                }
                case 1: {
                    return this.dataMaskHierarchies.get(resourceKeys);
                }
                case 2: {
                    return this.rowFilterHierarchies.get(resourceKeys);
                }
            }
            return null;
        }

        void addHierarchy(int policyType, Collection<String> resourceKeys, Boolean isValid) {
            switch (policyType) {
                case 0: {
                    this.accessHierarchies.put(resourceKeys, isValid);
                    break;
                }
                case 1: {
                    this.dataMaskHierarchies.put(resourceKeys, isValid);
                    break;
                }
                case 2: {
                    this.rowFilterHierarchies.put(resourceKeys, isValid);
                    break;
                }
                default: {
                    LOG.error((Object)("unknown policy-type " + policyType));
                }
            }
        }
    }
}

