/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model.validation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.errors.ValidationErrorCode;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerPolicyResourceSignature;
import org.apache.ranger.plugin.model.RangerSecurityZone;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.RangerValiditySchedule;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.model.validation.RangerValidator;
import org.apache.ranger.plugin.model.validation.RangerValidityScheduleValidator;
import org.apache.ranger.plugin.model.validation.ValidationFailureDetails;
import org.apache.ranger.plugin.model.validation.ValidationFailureDetailsBuilder;
import org.apache.ranger.plugin.store.ServiceStore;

public class RangerPolicyValidator
extends RangerValidator {
    private static final Log LOG = LogFactory.getLog(RangerPolicyValidator.class);

    public RangerPolicyValidator(ServiceStore store) {
        super(store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(RangerPolicy policy, RangerValidator.Action action, boolean isAdmin) throws Exception {
        String message;
        boolean valid;
        block5: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("==> RangerPolicyValidator.validate(%s, %s, %s)", new Object[]{policy, action, isAdmin}));
            }
            ArrayList<ValidationFailureDetails> failures = new ArrayList<ValidationFailureDetails>();
            valid = this.isValid(policy, action, isAdmin, failures);
            message = "";
            try {
                if (valid) break block5;
                message = RangerPolicyValidator.serializeFailures(failures);
                throw new Exception(message);
            }
            catch (Throwable throwable) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("<== RangerPolicyValidator.validate(%s, %s, %s): %s, reason[%s]", new Object[]{policy, action, isAdmin, valid, message}));
                }
                throw throwable;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.validate(%s, %s, %s): %s, reason[%s]", new Object[]{policy, action, isAdmin, valid, message}));
        }
    }

    @Override
    boolean isValid(Long id, RangerValidator.Action action, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isValid(%s, %s, %s)", new Object[]{id, action, failures}));
        }
        boolean valid = true;
        if (action != RangerValidator.Action.DELETE) {
            ValidationErrorCode error = ValidationErrorCode.POLICY_VALIDATION_ERR_UNSUPPORTED_ACTION;
            failures.add(new ValidationFailureDetailsBuilder().isAnInternalError().becauseOf(error.getMessage(new Object[0])).errorCode(error.getErrorCode()).build());
            valid = false;
        } else if (id == null) {
            ValidationErrorCode error = ValidationErrorCode.POLICY_VALIDATION_ERR_MISSING_FIELD;
            failures.add(new ValidationFailureDetailsBuilder().becauseOf("policy id was null/missing").field("id").isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage("id")).build());
            valid = false;
        } else if (this.policyExists(id) && LOG.isDebugEnabled()) {
            LOG.debug((Object)("No policy found for id[" + id + "]! ok!"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isValid(%s, %s, %s): %s", new Object[]{id, action, failures, valid}));
        }
        return valid;
    }

    boolean isValid(RangerPolicy policy, RangerValidator.Action action, boolean isAdmin, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isValid(%s, %s, %s, %s)", new Object[]{policy, action, isAdmin, failures}));
        }
        if (action != RangerValidator.Action.CREATE && action != RangerValidator.Action.UPDATE) {
            throw new IllegalArgumentException("isValid(RangerPolicy, ...) is only supported for create/update");
        }
        boolean valid = true;
        if (policy == null) {
            ValidationErrorCode error = ValidationErrorCode.POLICY_VALIDATION_ERR_NULL_POLICY_OBJECT;
            failures.add(new ValidationFailureDetailsBuilder().field("policy").isMissing().becauseOf(error.getMessage(new Object[0])).errorCode(error.getErrorCode()).build());
            valid = false;
        } else {
            ValidationErrorCode error;
            ValidationErrorCode error2;
            Integer priority = policy.getPolicyPriority();
            if (priority != null && (priority < 0 || priority > 1)) {
                ValidationErrorCode error3 = ValidationErrorCode.POLICY_VALIDATION_ERR_POLICY_INVALID_PRIORITY;
                failures.add(new ValidationFailureDetailsBuilder().field("policyPriority").isSemanticallyIncorrect().becauseOf(error3.getMessage("out of range")).errorCode(error3.getErrorCode()).build());
                valid = false;
            }
            Long id = policy.getId();
            RangerPolicy existingPolicy = null;
            if (action == RangerValidator.Action.UPDATE) {
                ValidationErrorCode error4;
                if (id == null) {
                    error4 = ValidationErrorCode.POLICY_VALIDATION_ERR_MISSING_FIELD;
                    failures.add(new ValidationFailureDetailsBuilder().field("id").isMissing().becauseOf(error4.getMessage("id")).errorCode(error4.getErrorCode()).build());
                    valid = false;
                }
                if ((existingPolicy = this.getPolicy(id)) == null) {
                    error4 = ValidationErrorCode.POLICY_VALIDATION_ERR_INVALID_POLICY_ID;
                    failures.add(new ValidationFailureDetailsBuilder().field("id").isSemanticallyIncorrect().becauseOf(error4.getMessage(id)).errorCode(error4.getErrorCode()).build());
                    valid = false;
                }
            }
            String policyName = policy.getName();
            String serviceName = policy.getService();
            String policyServicetype = policy.getServiceType();
            String zoneName = policy.getZoneName();
            RangerService service = null;
            RangerSecurityZone zone = null;
            boolean serviceNameValid = false;
            if (StringUtils.isBlank((String)serviceName)) {
                error2 = ValidationErrorCode.POLICY_VALIDATION_ERR_MISSING_FIELD;
                failures.add(new ValidationFailureDetailsBuilder().field("service name").isMissing().becauseOf(error2.getMessage("service name")).errorCode(error2.getErrorCode()).build());
                valid = false;
            } else {
                service = this.getService(serviceName);
                if (service == null) {
                    error2 = ValidationErrorCode.POLICY_VALIDATION_ERR_INVALID_SERVICE_NAME;
                    failures.add(new ValidationFailureDetailsBuilder().field("service name").isSemanticallyIncorrect().becauseOf(error2.getMessage(serviceName)).errorCode(error2.getErrorCode()).build());
                    valid = false;
                } else {
                    serviceNameValid = true;
                    String serviceType = service.getType();
                    if (StringUtils.isNotEmpty((String)serviceType) && StringUtils.isNotEmpty((String)policyServicetype) && !serviceType.equalsIgnoreCase(policyServicetype)) {
                        ValidationErrorCode error5 = ValidationErrorCode.POLICY_VALIDATION_ERR_INVALID_SERVICE_TYPE;
                        failures.add(new ValidationFailureDetailsBuilder().field("service type").isSemanticallyIncorrect().becauseOf(error5.getMessage(policyServicetype, serviceName)).errorCode(error5.getErrorCode()).build());
                        valid = false;
                    }
                }
            }
            if (StringUtils.isNotEmpty((String)zoneName)) {
                zone = this.getSecurityZone(zoneName);
                if (zone == null) {
                    error2 = ValidationErrorCode.POLICY_VALIDATION_ERR_NONEXISTANT_ZONE_NAME;
                    failures.add(new ValidationFailureDetailsBuilder().field("zoneName").isSemanticallyIncorrect().becauseOf(error2.getMessage(id, zoneName)).errorCode(error2.getErrorCode()).build());
                    valid = false;
                }
                List<String> tagSvcList = zone.getTagServices();
                Set<String> svcNameSet = zone.getServices().keySet();
                if (!svcNameSet.contains(serviceName) && !tagSvcList.contains(serviceName)) {
                    error = ValidationErrorCode.POLICY_VALIDATION_ERR_SERVICE_NOT_ASSOCIATED_TO_ZONE;
                    failures.add(new ValidationFailureDetailsBuilder().field("zoneName").isSemanticallyIncorrect().becauseOf(error.getMessage(serviceName, zoneName)).errorCode(error.getErrorCode()).build());
                    valid = false;
                }
            }
            if (StringUtils.isBlank((String)policyName)) {
                error2 = ValidationErrorCode.POLICY_VALIDATION_ERR_MISSING_FIELD;
                failures.add(new ValidationFailureDetailsBuilder().field("name").isMissing().becauseOf(error2.getMessage("name")).errorCode(error2.getErrorCode()).build());
                valid = false;
            } else if (service != null && (StringUtils.isEmpty((String)zoneName) || zone != null)) {
                Long zoneId = zone != null ? zone.getId() : 1L;
                Long policyId = this.getPolicyId(service.getId(), policyName, zoneId);
                if (policyId != null) {
                    if (action == RangerValidator.Action.CREATE) {
                        error = ValidationErrorCode.POLICY_VALIDATION_ERR_POLICY_NAME_CONFLICT;
                        failures.add(new ValidationFailureDetailsBuilder().field("policy name").isSemanticallyIncorrect().becauseOf(error.getMessage(policyId, serviceName)).errorCode(error.getErrorCode()).build());
                        valid = false;
                    } else if (!policyId.equals(id)) {
                        error = ValidationErrorCode.POLICY_VALIDATION_ERR_POLICY_NAME_CONFLICT;
                        failures.add(new ValidationFailureDetailsBuilder().field("id/name").isSemanticallyIncorrect().becauseOf(error.getMessage(policyId, serviceName)).errorCode(error.getErrorCode()).build());
                        valid = false;
                    }
                }
            }
            if (existingPolicy != null) {
                int policyType;
                if (!StringUtils.equalsIgnoreCase((String)existingPolicy.getService(), (String)policy.getService())) {
                    error2 = ValidationErrorCode.POLICY_VALIDATION_ERR_POLICY_UPDATE_MOVE_SERVICE_NOT_ALLOWED;
                    failures.add(new ValidationFailureDetailsBuilder().field("service name").isSemanticallyIncorrect().becauseOf(error2.getMessage(policy.getId(), existingPolicy.getService(), policy.getService())).errorCode(error2.getErrorCode()).build());
                    valid = false;
                }
                int existingPolicyType = existingPolicy.getPolicyType() == null ? 0 : existingPolicy.getPolicyType();
                int n = policyType = policy.getPolicyType() == null ? 0 : policy.getPolicyType();
                if (existingPolicyType != policyType) {
                    error = ValidationErrorCode.POLICY_VALIDATION_ERR_POLICY_TYPE_CHANGE_NOT_ALLOWED;
                    failures.add(new ValidationFailureDetailsBuilder().field("policy type").isSemanticallyIncorrect().becauseOf(error.getMessage(policy.getId(), existingPolicyType, policyType)).errorCode(error.getErrorCode()).build());
                    valid = false;
                }
                String existingZoneName = existingPolicy.getZoneName();
                if ((StringUtils.isNotEmpty((String)zoneName) || StringUtils.isNotEmpty((String)existingZoneName)) && !StringUtils.equals((String)existingZoneName, (String)zoneName)) {
                    ValidationErrorCode error6 = ValidationErrorCode.POLICY_VALIDATION_ERR_UPDATE_ZONE_NAME_NOT_ALLOWED;
                    failures.add(new ValidationFailureDetailsBuilder().field("zoneName").isSemanticallyIncorrect().becauseOf(error6.getMessage(existingZoneName, zoneName)).errorCode(error6.getErrorCode()).build());
                    valid = false;
                }
            }
            boolean isAuditEnabled = this.getIsAuditEnabled(policy);
            String serviceDefName = null;
            RangerServiceDef serviceDef = null;
            int policyItemsCount = 0;
            int policyType = policy.getPolicyType() == null ? 0 : policy.getPolicyType();
            switch (policyType) {
                case 1: {
                    if (!CollectionUtils.isNotEmpty(policy.getDataMaskPolicyItems())) break;
                    policyItemsCount += policy.getDataMaskPolicyItems().size();
                    break;
                }
                case 2: {
                    if (!CollectionUtils.isNotEmpty(policy.getRowFilterPolicyItems())) break;
                    policyItemsCount += policy.getRowFilterPolicyItems().size();
                    break;
                }
                default: {
                    if (CollectionUtils.isNotEmpty(policy.getPolicyItems())) {
                        policyItemsCount += policy.getPolicyItems().size();
                    }
                    if (!CollectionUtils.isNotEmpty(policy.getDenyPolicyItems())) break;
                    policyItemsCount += policy.getDenyPolicyItems().size();
                }
            }
            if (policyItemsCount == 0 && !isAuditEnabled) {
                ValidationErrorCode error7 = ValidationErrorCode.POLICY_VALIDATION_ERR_MISSING_POLICY_ITEMS;
                failures.add(new ValidationFailureDetailsBuilder().field("policy items").isMissing().becauseOf(error7.getMessage(new Object[0])).errorCode(error7.getErrorCode()).build());
                valid = false;
            } else if (service != null) {
                serviceDefName = service.getType();
                serviceDef = this.getServiceDef(serviceDefName);
                if (serviceDef == null) {
                    ValidationErrorCode error8 = ValidationErrorCode.POLICY_VALIDATION_ERR_MISSING_SERVICE_DEF;
                    failures.add(new ValidationFailureDetailsBuilder().field("policy service def").isAnInternalError().becauseOf(error8.getMessage(serviceDefName, serviceName)).errorCode(error8.getErrorCode()).build());
                    valid = false;
                } else {
                    if (Boolean.TRUE.equals(policy.getIsDenyAllElse()) && (CollectionUtils.isNotEmpty(policy.getDenyPolicyItems()) || CollectionUtils.isNotEmpty(policy.getDenyExceptions()))) {
                        ValidationErrorCode error9 = ValidationErrorCode.POLICY_VALIDATION_ERR_UNSUPPORTED_POLICY_ITEM_TYPE;
                        failures.add(new ValidationFailureDetailsBuilder().field("policy items").becauseOf(error9.getMessage(new Object[0])).errorCode(error9.getErrorCode()).build());
                        valid = false;
                    }
                    valid = this.isValidPolicyItems(policy.getPolicyItems(), failures, serviceDef) && valid;
                    valid = this.isValidPolicyItems(policy.getDenyPolicyItems(), failures, serviceDef) && valid;
                    valid = this.isValidPolicyItems(policy.getAllowExceptions(), failures, serviceDef) && valid;
                    boolean bl = valid = this.isValidPolicyItems(policy.getDenyExceptions(), failures, serviceDef) && valid;
                }
            }
            if (serviceNameValid) {
                valid = this.isValidValiditySchedule(policy, failures, action) && valid;
                valid = this.isValidResources(policy, failures, action, isAdmin, serviceDef) && valid;
                boolean bl = valid = this.isValidAccessTypeDef(policy, failures, action, isAdmin, serviceDef) && valid;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isValid(%s, %s, %s, %s): %s", new Object[]{policy, action, isAdmin, failures, valid}));
        }
        return valid;
    }

    boolean isValidAccessTypeDef(RangerPolicy policy, List<ValidationFailureDetails> failures, RangerValidator.Action action, boolean isAdmin, RangerServiceDef serviceDef) {
        ValidationErrorCode error;
        int policyType;
        boolean valid = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isValidAccessTypeDef(%s, %s, %s,%s,%s)", new Object[]{policy, failures, action, isAdmin, serviceDef}));
        }
        int n = policyType = policy.getPolicyType() == null ? 0 : policy.getPolicyType();
        if (policyType == 2) {
            ArrayList<String> rowFilterAccessTypeDefNames = new ArrayList<String>();
            if (serviceDef != null && serviceDef.getRowFilterDef() != null && !CollectionUtils.isEmpty(serviceDef.getRowFilterDef().getAccessTypes())) {
                for (RangerServiceDef.RangerAccessTypeDef rangerAccessTypeDef : serviceDef.getRowFilterDef().getAccessTypes()) {
                    rowFilterAccessTypeDefNames.add(rangerAccessTypeDef.getName().toLowerCase());
                }
            }
            if (!CollectionUtils.isEmpty(policy.getRowFilterPolicyItems())) {
                for (RangerPolicy.RangerRowFilterPolicyItem rangerRowFilterPolicyItem : policy.getRowFilterPolicyItems()) {
                    if (CollectionUtils.isEmpty(rangerRowFilterPolicyItem.getAccesses())) continue;
                    for (RangerPolicy.RangerPolicyItemAccess rangerPolicyItemAccess : rangerRowFilterPolicyItem.getAccesses()) {
                        if (rowFilterAccessTypeDefNames.contains(rangerPolicyItemAccess.getType().toLowerCase())) continue;
                        error = ValidationErrorCode.POLICY_VALIDATION_ERR_POLICY_ITEM_ACCESS_TYPE_INVALID;
                        failures.add(new ValidationFailureDetailsBuilder().field("row filter policy item access type").isSemanticallyIncorrect().becauseOf(error.getMessage(rangerPolicyItemAccess.getType(), rowFilterAccessTypeDefNames)).errorCode(error.getErrorCode()).build());
                        valid = false;
                    }
                }
            }
        }
        if (policyType == 1) {
            ArrayList<String> dataMaskAccessTypeDefNames = new ArrayList<String>();
            if (serviceDef != null && serviceDef.getDataMaskDef() != null && !CollectionUtils.isEmpty(serviceDef.getDataMaskDef().getAccessTypes())) {
                for (RangerServiceDef.RangerAccessTypeDef rangerAccessTypeDef : serviceDef.getDataMaskDef().getAccessTypes()) {
                    dataMaskAccessTypeDefNames.add(rangerAccessTypeDef.getName().toLowerCase());
                }
            }
            if (!CollectionUtils.isEmpty(policy.getDataMaskPolicyItems())) {
                for (RangerPolicy.RangerDataMaskPolicyItem rangerDataMaskPolicyItem : policy.getDataMaskPolicyItems()) {
                    if (CollectionUtils.isEmpty(rangerDataMaskPolicyItem.getAccesses())) continue;
                    for (RangerPolicy.RangerPolicyItemAccess rangerPolicyItemAccess : rangerDataMaskPolicyItem.getAccesses()) {
                        if (dataMaskAccessTypeDefNames.contains(rangerPolicyItemAccess.getType().toLowerCase())) continue;
                        error = ValidationErrorCode.POLICY_VALIDATION_ERR_POLICY_ITEM_ACCESS_TYPE_INVALID;
                        failures.add(new ValidationFailureDetailsBuilder().field("data masking policy item access type").isSemanticallyIncorrect().becauseOf(error.getMessage(rangerPolicyItemAccess.getType(), dataMaskAccessTypeDefNames)).errorCode(error.getErrorCode()).build());
                        valid = false;
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isValidAccessTypeDef(%s, %s, %s,%s,%s)", new Object[]{policy, failures, action, isAdmin, serviceDef}));
        }
        return valid;
    }

    boolean isValidResources(RangerPolicy policy, List<ValidationFailureDetails> failures, RangerValidator.Action action, boolean isAdmin, RangerServiceDef serviceDef) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isValidResources(%s, %s, %s, %s, %s)", new Object[]{policy, failures, action, isAdmin, serviceDef}));
        }
        boolean valid = true;
        Map<String, RangerPolicy.RangerPolicyResource> resourceMap = policy.getResources();
        if (resourceMap != null) {
            boolean bl = valid = this.isPolicyResourceUnique(policy, failures, action) && valid;
            if (serviceDef != null) {
                valid = this.isValidResourceNames(policy, failures, serviceDef) && valid;
                valid = this.isValidResourceValues(resourceMap, failures, serviceDef) && valid;
                boolean bl2 = valid = this.isValidResourceFlags(resourceMap, failures, serviceDef.getResources(), serviceDef.getName(), policy.getName(), isAdmin) && valid;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isValidResources(%s, %s, %s, %s, %s): %s", new Object[]{policy, failures, action, isAdmin, serviceDef, valid}));
        }
        return valid;
    }

    boolean isValidValiditySchedule(RangerPolicy policy, List<ValidationFailureDetails> failures, RangerValidator.Action action) {
        boolean valid = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isValidValiditySchedule(%s, %s, %s)", new Object[]{policy, failures, action}));
        }
        List<RangerValiditySchedule> validitySchedules = policy.getValiditySchedules();
        ArrayList<RangerValiditySchedule> normalizedValiditySchedules = null;
        for (RangerValiditySchedule entry : validitySchedules) {
            RangerValidityScheduleValidator validator = new RangerValidityScheduleValidator(entry);
            RangerValiditySchedule normalizedValiditySchedule = validator.validate(failures);
            if (normalizedValiditySchedule == null) {
                valid = false;
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Invalid Validity-Schedule:[" + entry + "]"));
                continue;
            }
            if (normalizedValiditySchedules == null) {
                normalizedValiditySchedules = new ArrayList<RangerValiditySchedule>();
            }
            normalizedValiditySchedules.add(normalizedValiditySchedule);
        }
        if (valid && CollectionUtils.isNotEmpty(normalizedValiditySchedules)) {
            policy.setValiditySchedules(normalizedValiditySchedules);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isValidValiditySchedule(%s, %s, %s): %s", new Object[]{policy, failures, action, valid}));
        }
        return valid;
    }

    boolean isPolicyResourceUnique(RangerPolicy policy, List<ValidationFailureDetails> failures, RangerValidator.Action action) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isPolicyResourceUnique(%s, %s, %s)", new Object[]{policy, failures, action}));
        }
        boolean valid = true;
        if (!Boolean.TRUE.equals(policy.getIsEnabled())) {
            LOG.debug((Object)"Policy is disabled. Skipping resource uniqueness validation.");
        } else {
            RangerPolicyResourceSignature policySignature = this._factory.createPolicyResourceSignature(policy);
            String signature = policySignature.getSignature();
            List<RangerPolicy> policies = this.getPoliciesForResourceSignature(policy.getService(), signature);
            if (CollectionUtils.isNotEmpty(policies)) {
                ValidationErrorCode error = ValidationErrorCode.POLICY_VALIDATION_ERR_DUPLICATE_POLICY_RESOURCE;
                RangerPolicy matchedPolicy = policies.iterator().next();
                if (action == RangerValidator.Action.CREATE || action == RangerValidator.Action.UPDATE && (policies.size() > 1 || !matchedPolicy.getId().equals(policy.getId()))) {
                    failures.add(new ValidationFailureDetailsBuilder().field("resources").isSemanticallyIncorrect().becauseOf(error.getMessage(matchedPolicy.getName(), policy.getService())).errorCode(error.getErrorCode()).build());
                    valid = false;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isPolicyResourceUnique(%s, %s, %s): %s", new Object[]{policy, failures, action, valid}));
        }
        return valid;
    }

    boolean isValidResourceNames(RangerPolicy policy, List<ValidationFailureDetails> failures, RangerServiceDef serviceDef) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isValidResourceNames(%s, %s, %s)", policy, failures, serviceDef));
        }
        boolean valid = true;
        this.convertPolicyResourceNamesToLower(policy);
        Set<String> policyResources = policy.getResources().keySet();
        RangerServiceDefHelper defHelper = new RangerServiceDefHelper(serviceDef);
        Set<List<RangerServiceDef.RangerResourceDef>> hierarchies = defHelper.getResourceHierarchies(policy.getPolicyType());
        if (hierarchies.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"RangerPolicyValidator.isValidResourceNames: serviceDef does not have any resource hierarchies, possibly due to invalid service def!!");
            }
            ValidationErrorCode error = ValidationErrorCode.POLICY_VALIDATION_ERR_INVALID_RESOURCE_NO_COMPATIBLE_HIERARCHY;
            failures.add(new ValidationFailureDetailsBuilder().field("service def resource hierarchies").subField("incompatible").isSemanticallyIncorrect().becauseOf(error.getMessage(serviceDef.getName(), " does not have any resource hierarchies")).errorCode(error.getErrorCode()).build());
            valid = false;
        } else {
            Set<List<RangerServiceDef.RangerResourceDef>> candidateHierarchies = this.filterHierarchies_hierarchyHasAllPolicyResources(policyResources, hierarchies, defHelper);
            if (candidateHierarchies.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("No compatible resource hierarchies found: resource[%s], service-def[%s], valid-resource-hierarchies[%s]", policyResources.toString(), serviceDef.getName(), this.toStringHierarchies_all(hierarchies, defHelper)));
                }
                ValidationErrorCode error = hierarchies.size() == 1 ? ValidationErrorCode.POLICY_VALIDATION_ERR_INVALID_RESOURCE_NO_COMPATIBLE_HIERARCHY_SINGLE : ValidationErrorCode.POLICY_VALIDATION_ERR_INVALID_RESOURCE_NO_COMPATIBLE_HIERARCHY;
                failures.add(new ValidationFailureDetailsBuilder().field("policy resources").subField("incompatible").isSemanticallyIncorrect().becauseOf(error.getMessage(serviceDef.getName(), this.toStringHierarchies_all(hierarchies, defHelper))).errorCode(error.getErrorCode()).build());
                valid = false;
            } else {
                Set<List<RangerServiceDef.RangerResourceDef>> validHierarchies;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("isValidResourceNames: Found [" + candidateHierarchies.size() + "] compatible hierarchies: " + this.toStringHierarchies_all(candidateHierarchies, defHelper)));
                }
                if ((validHierarchies = this.filterHierarchies_mandatoryResourcesSpecifiedInPolicy(policyResources, candidateHierarchies, defHelper)).isEmpty()) {
                    ValidationErrorCode error = candidateHierarchies.size() == 1 ? ValidationErrorCode.POLICY_VALIDATION_ERR_INVALID_RESOURCE_MISSING_MANDATORY_SINGLE : ValidationErrorCode.POLICY_VALIDATION_ERR_INVALID_RESOURCE_MISSING_MANDATORY;
                    failures.add(new ValidationFailureDetailsBuilder().field("policy resources").subField("missing mandatory").isSemanticallyIncorrect().becauseOf(error.getMessage(serviceDef.getName(), this.toStringHierarchies_mandatory(candidateHierarchies, defHelper))).errorCode(error.getErrorCode()).build());
                    valid = false;
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("isValidResourceNames: Found hierarchies with all mandatory fields specified: " + this.toStringHierarchies_mandatory(validHierarchies, defHelper)));
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isValidResourceNames(%s, %s, %s): %s", policy, failures, serviceDef, valid));
        }
        return valid;
    }

    String toStringHierarchies_mandatory(Set<List<RangerServiceDef.RangerResourceDef>> hierarchies, RangerServiceDefHelper defHelper) {
        StringBuilder builder = new StringBuilder();
        for (List<RangerServiceDef.RangerResourceDef> aHierarchy : hierarchies) {
            builder.append(defHelper.getMandatoryResourceNames(aHierarchy));
            builder.append(" ");
        }
        return builder.toString();
    }

    String toStringHierarchies_all(Set<List<RangerServiceDef.RangerResourceDef>> hierarchies, RangerServiceDefHelper defHelper) {
        StringBuilder builder = new StringBuilder();
        for (List<RangerServiceDef.RangerResourceDef> aHierarchy : hierarchies) {
            builder.append(defHelper.getAllResourceNamesOrdered(aHierarchy));
            builder.append(" ");
        }
        return builder.toString();
    }

    Set<List<RangerServiceDef.RangerResourceDef>> filterHierarchies_hierarchyHasAllPolicyResources(Set<String> policyResources, Set<List<RangerServiceDef.RangerResourceDef>> hierarchies, RangerServiceDefHelper defHelper) {
        HashSet<List<RangerServiceDef.RangerResourceDef>> result = new HashSet<List<RangerServiceDef.RangerResourceDef>>(hierarchies.size());
        for (List<RangerServiceDef.RangerResourceDef> aHierarchy : hierarchies) {
            if (!defHelper.hierarchyHasAllResources(aHierarchy, policyResources)) continue;
            result.add(aHierarchy);
        }
        return result;
    }

    Set<List<RangerServiceDef.RangerResourceDef>> filterHierarchies_mandatoryResourcesSpecifiedInPolicy(Set<String> policyResources, Set<List<RangerServiceDef.RangerResourceDef>> hierarchies, RangerServiceDefHelper defHelper) {
        HashSet<List<RangerServiceDef.RangerResourceDef>> result = new HashSet<List<RangerServiceDef.RangerResourceDef>>(hierarchies.size());
        for (List<RangerServiceDef.RangerResourceDef> aHierarchy : hierarchies) {
            Set<String> mandatoryResources = defHelper.getMandatoryResourceNames(aHierarchy);
            if (!policyResources.containsAll(mandatoryResources)) continue;
            result.add(aHierarchy);
        }
        return result;
    }

    boolean isValidResourceFlags(Map<String, RangerPolicy.RangerPolicyResource> inputPolicyResources, List<ValidationFailureDetails> failures, List<RangerServiceDef.RangerResourceDef> resourceDefs, String serviceDefName, String policyName, boolean isAdmin) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isValidResourceFlags(%s, %s, %s, %s, %s, %s)", inputPolicyResources, failures, resourceDefs, serviceDefName, policyName, isAdmin));
        }
        boolean valid = true;
        if (resourceDefs == null) {
            LOG.debug((Object)"isValidResourceFlags: service Def is null");
        } else {
            Map<String, RangerPolicy.RangerPolicyResource> policyResources = this.getPolicyResourceWithLowerCaseKeys(inputPolicyResources);
            for (RangerServiceDef.RangerResourceDef resourceDef : resourceDefs) {
                ValidationErrorCode error;
                ValidationErrorCode error2;
                if (resourceDef == null) {
                    error2 = ValidationErrorCode.POLICY_VALIDATION_ERR_NULL_RESOURCE_DEF;
                    failures.add(new ValidationFailureDetailsBuilder().field("resource-def").isAnInternalError().becauseOf(error2.getMessage(serviceDefName)).errorCode(error2.getErrorCode()).build());
                    valid = false;
                    continue;
                }
                if (StringUtils.isBlank((String)resourceDef.getName())) {
                    error2 = ValidationErrorCode.POLICY_VALIDATION_ERR_MISSING_RESOURCE_DEF_NAME;
                    failures.add(new ValidationFailureDetailsBuilder().field("resource-def-name").isAnInternalError().becauseOf(error2.getMessage(serviceDefName)).errorCode(error2.getErrorCode()).build());
                    valid = false;
                    continue;
                }
                String resourceName = resourceDef.getName().toLowerCase();
                RangerPolicy.RangerPolicyResource policyResource = policyResources.get(resourceName);
                if (policyResource == null) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("a policy-resource object for resource[" + resourceName + "] on policy [" + policyName + "] was null"));
                    continue;
                }
                boolean excludesSupported = Boolean.TRUE.equals(resourceDef.getExcludesSupported());
                boolean policyResourceIsExcludes = Boolean.TRUE.equals(policyResource.getIsExcludes());
                if (policyResourceIsExcludes && !excludesSupported) {
                    error = ValidationErrorCode.POLICY_VALIDATION_ERR_EXCLUDES_NOT_SUPPORTED;
                    failures.add(new ValidationFailureDetailsBuilder().field("isExcludes").subField(resourceName).isSemanticallyIncorrect().becauseOf(error.getMessage(resourceName)).errorCode(error.getErrorCode()).build());
                    valid = false;
                }
                if (policyResourceIsExcludes && !isAdmin) {
                    error = ValidationErrorCode.POLICY_VALIDATION_ERR_EXCLUDES_REQUIRES_ADMIN;
                    failures.add(new ValidationFailureDetailsBuilder().field("isExcludes").subField("isAdmin").isSemanticallyIncorrect().becauseOf(error.getMessage(new Object[0])).errorCode(error.getErrorCode()).build());
                    valid = false;
                }
                boolean recursiveSupported = Boolean.TRUE.equals(resourceDef.getRecursiveSupported());
                boolean policyIsRecursive = Boolean.TRUE.equals(policyResource.getIsRecursive());
                if (!policyIsRecursive || recursiveSupported) continue;
                ValidationErrorCode error3 = ValidationErrorCode.POLICY_VALIDATION_ERR_RECURSIVE_NOT_SUPPORTED;
                failures.add(new ValidationFailureDetailsBuilder().field("isRecursive").subField(resourceName).isSemanticallyIncorrect().becauseOf(error3.getMessage(resourceName)).errorCode(error3.getErrorCode()).build());
                valid = false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isValidResourceFlags(%s, %s, %s, %s, %s, %s): %s", inputPolicyResources, failures, resourceDefs, serviceDefName, policyName, isAdmin, valid));
        }
        return valid;
    }

    boolean isValidResourceValues(Map<String, RangerPolicy.RangerPolicyResource> resourceMap, List<ValidationFailureDetails> failures, RangerServiceDef serviceDef) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isValidResourceValues(%s, %s, %s)", resourceMap, failures, serviceDef));
        }
        boolean valid = true;
        Map<String, String> validationRegExMap = this.getValidationRegExes(serviceDef);
        for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry : resourceMap.entrySet()) {
            String name = entry.getKey();
            RangerPolicy.RangerPolicyResource policyResource = entry.getValue();
            if (policyResource == null) continue;
            if (CollectionUtils.isNotEmpty(policyResource.getValues())) {
                HashSet<String> resources = new HashSet<String>(policyResource.getValues());
                for (String aValue : resources) {
                    if (!StringUtils.isBlank((String)aValue)) continue;
                    policyResource.getValues().remove(aValue);
                }
            }
            if (CollectionUtils.isEmpty(policyResource.getValues())) {
                ValidationErrorCode error = ValidationErrorCode.POLICY_VALIDATION_ERR_MISSING_RESOURCE_LIST;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Resource list was empty or contains null: value[%s], resource-name[%s], service-def-name[%s]", policyResource.getValues(), name, serviceDef.getName()));
                }
                failures.add(new ValidationFailureDetailsBuilder().field("resource-values").subField(name).isMissing().becauseOf(error.getMessage(name)).errorCode(error.getErrorCode()).build());
                valid = false;
            }
            if (!validationRegExMap.containsKey(name) || !CollectionUtils.isNotEmpty(policyResource.getValues())) continue;
            String regEx = validationRegExMap.get(name);
            for (String aValue : policyResource.getValues()) {
                if (aValue.matches(regEx)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Resource failed regex check: value[%s], resource-name[%s], regEx[%s], service-def-name[%s]", aValue, name, regEx, serviceDef.getName()));
                }
                ValidationErrorCode error = ValidationErrorCode.POLICY_VALIDATION_ERR_INVALID_RESOURCE_VALUE_REGEX;
                failures.add(new ValidationFailureDetailsBuilder().field("resource-values").subField(name).isSemanticallyIncorrect().becauseOf(error.getMessage(aValue, name)).errorCode(error.getErrorCode()).build());
                valid = false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isValidResourceValues(%s, %s, %s): %s", resourceMap, failures, serviceDef, valid));
        }
        return valid;
    }

    boolean isValidPolicyItems(List<RangerPolicy.RangerPolicyItem> policyItems, List<ValidationFailureDetails> failures, RangerServiceDef serviceDef) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isValid(%s, %s, %s)", policyItems, failures, serviceDef));
        }
        boolean valid = true;
        if (CollectionUtils.isEmpty(policyItems)) {
            LOG.debug((Object)"policy items collection was null/empty");
        } else {
            for (RangerPolicy.RangerPolicyItem policyItem : policyItems) {
                if (policyItem == null) {
                    ValidationErrorCode error = ValidationErrorCode.POLICY_VALIDATION_ERR_NULL_POLICY_ITEM;
                    failures.add(new ValidationFailureDetailsBuilder().field("policy item").isMissing().becauseOf(error.getMessage(new Object[0])).errorCode(error.getErrorCode()).build());
                    valid = false;
                    continue;
                }
                valid = this.isValidPolicyItem(policyItem, failures, serviceDef) && valid;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isValid(%s, %s, %s): %s", policyItems, failures, serviceDef, valid));
        }
        return valid;
    }

    boolean isValidPolicyItem(RangerPolicy.RangerPolicyItem policyItem, List<ValidationFailureDetails> failures, RangerServiceDef serviceDef) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isValid(%s, %s, %s)", policyItem, failures, serviceDef));
        }
        boolean valid = true;
        if (policyItem == null) {
            LOG.debug((Object)"policy item was null!");
        } else {
            ValidationErrorCode error;
            if (CollectionUtils.isEmpty(policyItem.getAccesses())) {
                if (!Boolean.TRUE.equals(policyItem.getDelegateAdmin())) {
                    error = ValidationErrorCode.POLICY_VALIDATION_ERR_MISSING_FIELD;
                    failures.add(new ValidationFailureDetailsBuilder().field("policy item accesses").isMissing().becauseOf(error.getMessage("policy item accesses")).errorCode(error.getErrorCode()).build());
                    valid = false;
                } else {
                    LOG.debug((Object)"policy item collection was null but delegated admin is true. Ok");
                }
            } else {
                boolean bl = valid = this.isValidItemAccesses(policyItem.getAccesses(), failures, serviceDef) && valid;
            }
            if (CollectionUtils.isEmpty(policyItem.getUsers()) && CollectionUtils.isEmpty(policyItem.getGroups()) && CollectionUtils.isEmpty(policyItem.getRoles())) {
                error = ValidationErrorCode.POLICY_VALIDATION_ERR_MISSING_USER_AND_GROUPS;
                failures.add(new ValidationFailureDetailsBuilder().field("policy item users/user-groups/roles").isMissing().becauseOf(error.getMessage(new Object[0])).errorCode(error.getErrorCode()).build());
                valid = false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isValid(%s, %s, %s): %s", policyItem, failures, serviceDef, valid));
        }
        return valid;
    }

    boolean isValidItemAccesses(List<RangerPolicy.RangerPolicyItemAccess> accesses, List<ValidationFailureDetails> failures, RangerServiceDef serviceDef) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isValid(%s, %s, %s)", accesses, failures, serviceDef));
        }
        boolean valid = true;
        if (CollectionUtils.isEmpty(accesses)) {
            LOG.debug((Object)"policy item accesses collection was null/empty!");
        } else {
            Set<String> accessTypes = this.getAccessTypes(serviceDef);
            for (RangerPolicy.RangerPolicyItemAccess access : accesses) {
                if (access == null) {
                    ValidationErrorCode error = ValidationErrorCode.POLICY_VALIDATION_ERR_NULL_POLICY_ITEM_ACCESS;
                    failures.add(new ValidationFailureDetailsBuilder().field("policy item access").isMissing().becauseOf(error.getMessage(new Object[0])).errorCode(error.getErrorCode()).build());
                    valid = false;
                    continue;
                }
                valid = this.isValidPolicyItemAccess(access, failures, accessTypes) && valid;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isValid(%s, %s, %s): %b", accesses, failures, serviceDef, valid));
        }
        return valid;
    }

    boolean isValidPolicyItemAccess(RangerPolicy.RangerPolicyItemAccess access, List<ValidationFailureDetails> failures, Set<String> accessTypes) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isValidPolicyItemAccess(%s, %s, %s)", access, failures, accessTypes));
        }
        boolean valid = true;
        if (CollectionUtils.isEmpty(accessTypes)) {
            LOG.debug((Object)"isValidPolicyItemAccess: accessTypes was null!");
        } else if (access == null) {
            LOG.debug((Object)"isValidPolicyItemAccess: policy item access was null!");
        } else {
            ValidationErrorCode error;
            String accessType = access.getType();
            if (StringUtils.isBlank((String)accessType)) {
                ValidationErrorCode error2 = ValidationErrorCode.POLICY_VALIDATION_ERR_MISSING_FIELD;
                failures.add(new ValidationFailureDetailsBuilder().field("policy item access type").isMissing().becauseOf(error2.getMessage("policy item access type")).errorCode(error2.getErrorCode()).build());
                valid = false;
            } else {
                String matchedAccessType = this.getMatchedAccessType(accessType, accessTypes);
                if (StringUtils.isEmpty((String)matchedAccessType)) {
                    error = ValidationErrorCode.POLICY_VALIDATION_ERR_POLICY_ITEM_ACCESS_TYPE_INVALID;
                    failures.add(new ValidationFailureDetailsBuilder().field("policy item access type").isSemanticallyIncorrect().becauseOf(error.getMessage(accessType, accessTypes)).errorCode(error.getErrorCode()).build());
                    valid = false;
                } else {
                    access.setType(matchedAccessType);
                }
            }
            Boolean isAllowed = access.getIsAllowed();
            if (isAllowed != null && !isAllowed.booleanValue()) {
                error = ValidationErrorCode.POLICY_VALIDATION_ERR_POLICY_ITEM_ACCESS_TYPE_DENY;
                failures.add(new ValidationFailureDetailsBuilder().field("policy item access type allowed").isSemanticallyIncorrect().becauseOf(error.getMessage(new Object[0])).errorCode(error.getErrorCode()).build());
                valid = false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isValidPolicyItemAccess(%s, %s, %s): %s", access, failures, accessTypes, valid));
        }
        return valid;
    }

    String getMatchedAccessType(String accessType, Set<String> validAccessTypes) {
        String ret = null;
        for (String validType : validAccessTypes) {
            if (!StringUtils.equalsIgnoreCase((String)accessType, (String)validType)) continue;
            ret = validType;
            break;
        }
        return ret;
    }
}

