/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;

public class RangerPolicyEngineOptions {
    public String evaluatorType = "auto";
    public boolean disableContextEnrichers = false;
    public boolean disableCustomConditions = false;
    public boolean disableTagPolicyEvaluation = false;
    public boolean disableTrieLookupPrefilter = false;
    public boolean disablePolicyRefresher = false;
    public boolean disableTagRetriever = false;
    public boolean cacheAuditResults = true;
    public boolean evaluateDelegateAdminOnly = false;
    public boolean enableTagEnricherWithLocalRefresher = false;
    public boolean disableAccessEvaluationWithPolicyACLSummary = true;
    public boolean optimizeTrieForRetrieval = false;
    private RangerServiceDefHelper serviceDefHelper;

    public RangerPolicyEngineOptions() {
    }

    public RangerPolicyEngineOptions(RangerPolicyEngineOptions other) {
        this.disableContextEnrichers = other.disableContextEnrichers;
        this.disableCustomConditions = other.disableCustomConditions;
        this.disableTagPolicyEvaluation = other.disableTagPolicyEvaluation;
        this.disableTrieLookupPrefilter = other.disableTrieLookupPrefilter;
        this.disablePolicyRefresher = other.disablePolicyRefresher;
        this.disableTagRetriever = other.disableTagRetriever;
        this.cacheAuditResults = other.cacheAuditResults;
        this.evaluateDelegateAdminOnly = other.evaluateDelegateAdminOnly;
        this.enableTagEnricherWithLocalRefresher = other.enableTagEnricherWithLocalRefresher;
        this.disableAccessEvaluationWithPolicyACLSummary = other.disableAccessEvaluationWithPolicyACLSummary;
        this.optimizeTrieForRetrieval = other.optimizeTrieForRetrieval;
        this.serviceDefHelper = null;
    }

    public void configureForPlugin(Configuration conf, String propertyPrefix) {
        this.disableContextEnrichers = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.context.enrichers", false);
        this.disableCustomConditions = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.custom.conditions", false);
        this.disableTagPolicyEvaluation = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.tagpolicy.evaluation", false);
        this.disableTrieLookupPrefilter = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.trie.lookup.prefilter", false);
        this.disablePolicyRefresher = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.policy.refresher", false);
        this.disableTagRetriever = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.tag.retriever", false);
        this.cacheAuditResults = conf.getBoolean(propertyPrefix + ".policyengine.option.cache.audit.results", true);
        if (!this.disableTrieLookupPrefilter) {
            this.cacheAuditResults = false;
        }
        this.evaluateDelegateAdminOnly = false;
        this.enableTagEnricherWithLocalRefresher = false;
        this.disableAccessEvaluationWithPolicyACLSummary = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.access.evaluation.with.policy.acl.summary", true);
        this.optimizeTrieForRetrieval = conf.getBoolean(propertyPrefix + ".policyengine.option.optimize.trie.for.retrieval", false);
    }

    public void configureDefaultRangerAdmin(Configuration conf, String propertyPrefix) {
        this.disableContextEnrichers = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.context.enrichers", true);
        this.disableCustomConditions = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.custom.conditions", true);
        this.disableTagPolicyEvaluation = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.tagpolicy.evaluation", true);
        this.disableTrieLookupPrefilter = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.trie.lookup.prefilter", false);
        this.disablePolicyRefresher = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.policy.refresher", true);
        this.disableTagRetriever = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.tag.retriever", true);
        this.cacheAuditResults = false;
        this.evaluateDelegateAdminOnly = false;
        this.enableTagEnricherWithLocalRefresher = false;
        this.disableAccessEvaluationWithPolicyACLSummary = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.access.evaluation.with.policy.acl.summary", true);
        this.optimizeTrieForRetrieval = conf.getBoolean(propertyPrefix + ".policyengine.option.optimize.trie.for.retrieval", false);
    }

    public void configureDelegateAdmin(Configuration conf, String propertyPrefix) {
        this.disableContextEnrichers = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.context.enrichers", true);
        this.disableCustomConditions = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.custom.conditions", true);
        this.disableTagPolicyEvaluation = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.tagpolicy.evaluation", true);
        this.disableTrieLookupPrefilter = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.trie.lookup.prefilter", false);
        this.disablePolicyRefresher = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.policy.refresher", true);
        this.disableTagRetriever = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.tag.retriever", true);
        this.optimizeTrieForRetrieval = conf.getBoolean(propertyPrefix + ".policyengine.option.optimize.trie.for.retrieval", false);
        this.cacheAuditResults = false;
        this.evaluateDelegateAdminOnly = true;
        this.enableTagEnricherWithLocalRefresher = false;
    }

    public void configureRangerAdminForPolicySearch(Configuration conf, String propertyPrefix) {
        this.disableContextEnrichers = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.context.enrichers", true);
        this.disableCustomConditions = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.custom.conditions", true);
        this.disableTagPolicyEvaluation = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.tagpolicy.evaluation", false);
        this.disableTrieLookupPrefilter = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.trie.lookup.prefilter", false);
        this.disablePolicyRefresher = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.policy.refresher", true);
        this.disableTagRetriever = conf.getBoolean(propertyPrefix + ".policyengine.option.disable.tag.retriever", false);
        this.optimizeTrieForRetrieval = conf.getBoolean(propertyPrefix + ".policyengine.option.optimize.trie.for.retrieval", false);
        this.cacheAuditResults = false;
        this.evaluateDelegateAdminOnly = false;
        this.enableTagEnricherWithLocalRefresher = true;
    }

    public RangerServiceDefHelper getServiceDefHelper() {
        return this.serviceDefHelper;
    }

    void setServiceDefHelper(RangerServiceDefHelper serviceDefHelper) {
        this.serviceDefHelper = serviceDefHelper;
    }

    public boolean equals(Object other) {
        boolean ret = false;
        if (other instanceof RangerPolicyEngineOptions) {
            RangerPolicyEngineOptions that = (RangerPolicyEngineOptions)other;
            ret = this.disableContextEnrichers == that.disableContextEnrichers && this.disableCustomConditions == that.disableCustomConditions && this.disableTagPolicyEvaluation == that.disableTagPolicyEvaluation && this.disableTrieLookupPrefilter == that.disableTrieLookupPrefilter && this.disablePolicyRefresher == that.disablePolicyRefresher && this.disableTagRetriever == that.disableTagRetriever && this.cacheAuditResults == that.cacheAuditResults && this.evaluateDelegateAdminOnly == that.evaluateDelegateAdminOnly && this.enableTagEnricherWithLocalRefresher == that.enableTagEnricherWithLocalRefresher && this.optimizeTrieForRetrieval == that.optimizeTrieForRetrieval;
        }
        return ret;
    }

    public int hashCode() {
        int ret = 0;
        ret += this.disableContextEnrichers ? 1 : 0;
        ret *= 2;
        ret += this.disableCustomConditions ? 1 : 0;
        ret *= 2;
        ret += this.disableTagPolicyEvaluation ? 1 : 0;
        ret *= 2;
        ret += this.disableTrieLookupPrefilter ? 1 : 0;
        ret *= 2;
        ret += this.disablePolicyRefresher ? 1 : 0;
        ret *= 2;
        ret += this.disableTagRetriever ? 1 : 0;
        ret *= 2;
        ret += this.cacheAuditResults ? 1 : 0;
        ret *= 2;
        ret += this.evaluateDelegateAdminOnly ? 1 : 0;
        ret *= 2;
        ret += this.enableTagEnricherWithLocalRefresher ? 1 : 0;
        ret *= 2;
        ret += this.optimizeTrieForRetrieval ? 1 : 0;
        return ret *= 2;
    }

    public String toString() {
        return "PolicyEngineOptions: { evaluatorType: " + this.evaluatorType + ", evaluateDelegateAdminOnly: " + this.evaluateDelegateAdminOnly + ", disableContextEnrichers: " + this.disableContextEnrichers + ", disableCustomConditions: " + this.disableContextEnrichers + ", disableTagPolicyEvaluation: " + this.disableTagPolicyEvaluation + ", disablePolicyRefresher: " + this.disablePolicyRefresher + ", disableTagRetriever: " + this.disableTagRetriever + ", enableTagEnricherWithLocalRefresher: " + this.enableTagEnricherWithLocalRefresher + ", disableTrieLookupPrefilter: " + this.disableTrieLookupPrefilter + ", optimizeTrieForRetrieval: " + this.optimizeTrieForRetrieval + ", cacheAuditResult: " + this.cacheAuditResults + " }";
    }
}

