/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyevaluator;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.util.ServiceDefUtil;

public abstract class RangerAbstractPolicyEvaluator
implements RangerPolicyEvaluator {
    private static final Log LOG = LogFactory.getLog(RangerAbstractPolicyEvaluator.class);
    private RangerPolicy policy;
    private RangerServiceDef serviceDef;
    private RangerServiceDef.RangerResourceDef leafResourceDef;
    private int evalOrder;
    protected RangerPluginContext pluginContext = null;

    public void setPluginContext(RangerPluginContext pluginContext) {
        this.pluginContext = pluginContext;
    }

    public RangerPluginContext getPluginContext() {
        return this.pluginContext;
    }

    @Override
    public void init(RangerPolicy policy, RangerServiceDef serviceDef, RangerPolicyEngineOptions options) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAbstractPolicyEvaluator.init(" + policy + ", " + serviceDef + ")"));
        }
        this.policy = this.getPrunedPolicy(policy);
        this.serviceDef = serviceDef;
        this.leafResourceDef = ServiceDefUtil.getLeafResourceDef(serviceDef, this.getPolicyResource());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAbstractPolicyEvaluator.init(" + this.policy + ", " + serviceDef + ")"));
        }
    }

    @Override
    public long getId() {
        return this.policy != null ? this.policy.getId() : -1L;
    }

    @Override
    public Map<String, RangerPolicy.RangerPolicyResource> getPolicyResource() {
        return this.policy != null ? this.policy.getResources() : null;
    }

    @Override
    public RangerPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public int getPolicyPriority() {
        return this.policy != null && this.policy.getPolicyPriority() != null ? this.policy.getPolicyPriority() : 0;
    }

    @Override
    public RangerServiceDef getServiceDef() {
        return this.serviceDef;
    }

    @Override
    public boolean isAncestorOf(RangerServiceDef.RangerResourceDef resourceDef) {
        return ServiceDefUtil.isAncestorOf(this.serviceDef, this.leafResourceDef, resourceDef);
    }

    @Override
    public boolean hasAllow() {
        return this.policy != null && CollectionUtils.isNotEmpty(this.policy.getPolicyItems());
    }

    protected boolean hasMatchablePolicyItem(RangerAccessRequest request) {
        return this.hasAllow() || this.hasDeny();
    }

    @Override
    public boolean hasDeny() {
        return this.policy != null && (this.policy.getIsDenyAllElse() != false || CollectionUtils.isNotEmpty(this.policy.getDenyPolicyItems()));
    }

    private RangerPolicy getPrunedPolicy(RangerPolicy policy) {
        RangerPolicy ret;
        boolean isPruningNeeded;
        List<RangerPolicy.RangerPolicyItem> prunedDenyExceptions;
        List<RangerPolicy.RangerPolicyItem> prunedAllowExceptions;
        List<RangerPolicy.RangerPolicyItem> prunedDenyItems;
        List<RangerPolicy.RangerPolicyItem> prunedAllowItems;
        RangerPluginContext pluginContext;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAbstractPolicyEvaluator.getPrunedPolicy(" + policy + ")"));
        }
        if ((pluginContext = this.getPluginContext()) != null && pluginContext.getConfig().getPolicyEngineOptions().evaluateDelegateAdminOnly) {
            prunedAllowItems = policy.getPolicyItems().stream().filter(RangerPolicy.RangerPolicyItem::getDelegateAdmin).collect(Collectors.toList());
            prunedDenyItems = policy.getDenyPolicyItems().stream().filter(RangerPolicy.RangerPolicyItem::getDelegateAdmin).collect(Collectors.toList());
            prunedAllowExceptions = policy.getAllowExceptions().stream().filter(RangerPolicy.RangerPolicyItem::getDelegateAdmin).collect(Collectors.toList());
            prunedDenyExceptions = policy.getDenyExceptions().stream().filter(RangerPolicy.RangerPolicyItem::getDelegateAdmin).collect(Collectors.toList());
            isPruningNeeded = prunedAllowItems.size() != policy.getPolicyItems().size() || prunedDenyItems.size() != policy.getDenyPolicyItems().size() || prunedAllowExceptions.size() != policy.getAllowExceptions().size() || prunedDenyExceptions.size() != policy.getDenyExceptions().size();
        } else {
            prunedAllowItems = null;
            prunedDenyItems = null;
            prunedAllowExceptions = null;
            prunedDenyExceptions = null;
            isPruningNeeded = false;
        }
        if (!isPruningNeeded) {
            ret = policy;
        } else {
            ret = new RangerPolicy();
            ret.updateFrom(policy);
            ret.setId(policy.getId());
            ret.setGuid(policy.getGuid());
            ret.setVersion(policy.getVersion());
            ret.setServiceType(policy.getServiceType());
            ret.setPolicyItems(prunedAllowItems);
            ret.setDenyPolicyItems(prunedDenyItems);
            ret.setAllowExceptions(prunedAllowExceptions);
            ret.setDenyExceptions(prunedDenyExceptions);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAbstractPolicyEvaluator.getPrunedPolicy(isPruningNeeded=" + isPruningNeeded + ") : " + ret));
        }
        return ret;
    }

    @Override
    public int getEvalOrder() {
        return this.evalOrder;
    }

    @Override
    public boolean isAuditEnabled() {
        return this.policy != null && this.policy.getIsAuditEnabled() != false;
    }

    public void setEvalOrder(int evalOrder) {
        this.evalOrder = evalOrder;
    }

    @Override
    public RangerPolicyEvaluator.PolicyACLSummary getPolicyACLSummary() {
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerAbstractPolicyEvaluator={");
        sb.append("policy={");
        if (this.policy != null) {
            this.policy.toString(sb);
        }
        sb.append("} ");
        sb.append("}");
        return sb;
    }
}

