/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.ranger.plugin.model.RangerMetrics;

public class RangerMetricsUtil {
    private static final Logger LOG = Logger.getLogger(RangerMetricsUtil.class);
    private static final OperatingSystemMXBean OS;
    private static final MemoryMXBean MEM_BEAN;
    public static final String NL;
    private static final RuntimeMXBean RUNTIME;
    private static final String JVM_MACHINE_ACTUAL_NAME;
    private static final String VERSION;
    private static final String JVM_MACHINE_REPRESENTATION_NAME;
    private static final long UP_TIME_OF_JVM;
    private static final String JVM_VENDOR_NAME;

    public Map<String, Object> getValues() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerMetricsUtil.getValues()");
        }
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("os.spec", StringUtils.join(Arrays.asList(this.addSystemInfo()), (String)", "));
        values.put("os.vcpus", String.valueOf(OS.getAvailableProcessors()));
        values.put("memory", this.addMemoryDetails());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerMetricsUtil.getValues()" + values));
        }
        return values;
    }

    protected Map<String, Object> getPoolDivision() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerMetricsUtil.getPoolDivision()");
        }
        LinkedHashMap<String, Object> poolDivisionValues = new LinkedHashMap<String, Object>();
        for (MemoryPoolMXBean mpBean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (mpBean.getType() != MemoryType.HEAP) continue;
            poolDivisionValues.put(mpBean.getName(), mpBean.getUsage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerMetricsUtil.getPoolDivision()" + poolDivisionValues));
        }
        return poolDivisionValues;
    }

    protected Map<String, Object> addMemoryDetails() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerMetricsUtil.addMemoryDetails()");
        }
        LinkedHashMap<String, Object> memory = new LinkedHashMap<String, Object>();
        MemoryUsage memHeapUsage = MEM_BEAN.getHeapMemoryUsage();
        MemoryUsage nonHeapUsage = MEM_BEAN.getNonHeapMemoryUsage();
        memory.put("heapInit", String.valueOf(memHeapUsage.getInit()));
        memory.put("heapMax", String.valueOf(memHeapUsage.getMax()));
        memory.put("heapCommitted", String.valueOf(memHeapUsage.getCommitted()));
        memory.put("heapUsed", String.valueOf(memHeapUsage.getUsed()));
        memory.put("nonHeapInit", String.valueOf(nonHeapUsage.getInit()));
        memory.put("nonHeapMax", String.valueOf(nonHeapUsage.getMax()));
        memory.put("nonHeapCommitted", String.valueOf(nonHeapUsage.getCommitted()));
        memory.put("nonHeapUsed", String.valueOf(nonHeapUsage.getUsed()));
        memory.put("memory_pool_usages", this.getPoolDivision());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerMetricsUtil.addMemoryDetails()" + memory));
        }
        return memory;
    }

    protected String[] addSystemInfo() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerMetricsUtil.addSystemInfo()");
        }
        String[] osInfo = new String[]{OS.getName(), OS.getArch(), OS.getVersion()};
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerMetricsUtil.addSystemInfo()" + osInfo));
        }
        return osInfo;
    }

    public RangerMetrics getVMStatus() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerMetricsUtil.getVMStatus()");
        }
        LinkedHashMap<String, Object> jvm = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> vmDetails = new LinkedHashMap<String, Object>();
        vmDetails.put("JVM Machine Actual Name", JVM_MACHINE_ACTUAL_NAME);
        vmDetails.put("version", VERSION);
        vmDetails.put("JVM Machine Representation Name", JVM_MACHINE_REPRESENTATION_NAME);
        vmDetails.put("Up time of JVM", UP_TIME_OF_JVM);
        vmDetails.put("JVM Vendor Name", JVM_VENDOR_NAME);
        vmDetails.putAll(this.getValues());
        jvm.put("jvm", vmDetails);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerMetricsUtil.getVMStatus() " + jvm));
        }
        return new RangerMetrics(jvm);
    }

    public void writeMetricsToFile(File filePath) throws Throwable {
        RangerMetrics rangerMetrics = null;
        rangerMetrics = this.getVMStatus();
        if (null == rangerMetrics || null == filePath) {
            LOG.debug((Object)"RangerMetrics or filePath can not be null)");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerMetricsUtil.writeMetricsToFIle() for path: " + filePath));
        }
        Gson gson = new Gson();
        try (FileWriter file = new FileWriter(filePath);){
            gson.toJson((Object)rangerMetrics, (Appendable)file);
            file.flush();
        }
        catch (Exception e) {
            LOG.error((Object)"RangerMetricsUtil.writeMetricsToFile() got an error", (Throwable)e);
            throw e;
        }
    }

    static {
        NL = System.getProperty("line.separator");
        RUNTIME = ManagementFactory.getRuntimeMXBean();
        JVM_MACHINE_ACTUAL_NAME = RUNTIME.getVmName();
        VERSION = RUNTIME.getVmVersion();
        JVM_MACHINE_REPRESENTATION_NAME = RUNTIME.getName();
        UP_TIME_OF_JVM = RUNTIME.getUptime();
        JVM_VENDOR_NAME = RUNTIME.getVmVendor();
        OS = ManagementFactory.getOperatingSystemMXBean();
        MEM_BEAN = ManagementFactory.getMemoryMXBean();
    }
}

