/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.model.RangerBaseModelObject;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.plugin.model.RangerTag;
import org.apache.ranger.plugin.model.RangerTagDef;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.ServiceTags;

public class RangerServiceTagsDeltaUtil {
    private static final Log LOG = LogFactory.getLog(RangerServiceTagsDeltaUtil.class);
    private static final Log PERF_TAGS_DELTA_LOG = RangerPerfTracer.getPerfLogger("tags.delta");

    public static ServiceTags applyDelta(ServiceTags serviceTags, ServiceTags delta) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerServiceTagsDeltaUtil.applyDelta()");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TAGS_DELTA_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TAGS_DELTA_LOG, "RangerServiceTagsDeltaUtil.applyDelta()");
        }
        if (serviceTags != null && !serviceTags.getIsDelta().booleanValue() && delta != null && delta.getIsDelta().booleanValue()) {
            serviceTags.setServiceName(delta.getServiceName());
            serviceTags.setTagVersion(delta.getTagVersion());
            Map<Long, RangerTag> tags = serviceTags.getTags();
            List<RangerServiceResource> serviceResources = serviceTags.getServiceResources();
            Map<Long, List<Long>> resourceToTagIds = serviceTags.getResourceToTagIds();
            boolean isAnyMaterialChange = false;
            for (Map.Entry<Long, RangerTag> tagEntry : delta.getTags().entrySet()) {
                if (StringUtils.isEmpty((String)tagEntry.getValue().getType())) {
                    if (null == tags.remove(tagEntry.getKey())) continue;
                    isAnyMaterialChange = true;
                    continue;
                }
                tags.put(tagEntry.getKey(), tagEntry.getValue());
            }
            HashMap<Long, Long> deletedServiceResources = new HashMap<Long, Long>();
            ArrayList<RangerServiceResource> addedServiceResources = new ArrayList<RangerServiceResource>();
            for (RangerServiceResource serviceResource : delta.getServiceResources()) {
                boolean found = false;
                Iterator<RangerServiceResource> iter = serviceResources.iterator();
                while (iter.hasNext()) {
                    RangerServiceResource existingResource = iter.next();
                    if (!serviceResource.getId().equals(existingResource.getId())) continue;
                    if (!StringUtils.isEmpty((String)serviceResource.getResourceSignature())) {
                        if (!serviceResource.getResourceSignature().equals(existingResource.getResourceSignature())) {
                            iter.remove();
                            existingResource.setResourceSignature(null);
                            addedServiceResources.add(existingResource);
                            break;
                        }
                    } else {
                        iter.remove();
                        deletedServiceResources.put(serviceResource.getId(), serviceResource.getId());
                    }
                    found = true;
                    break;
                }
                if (found || !StringUtils.isNotEmpty((String)serviceResource.getResourceSignature())) continue;
                serviceResources.add(serviceResource);
                isAnyMaterialChange = true;
            }
            for (Long deletedServiceResourceId : deletedServiceResources.keySet()) {
                resourceToTagIds.remove(deletedServiceResourceId);
            }
            resourceToTagIds.putAll(delta.getResourceToTagIds());
            addedServiceResources.addAll(delta.getServiceResources());
            delta.setServiceResources(addedServiceResources);
            if (!isAnyMaterialChange && LOG.isDebugEnabled()) {
                LOG.debug((Object)"No material change may have occurred because of applying this delta");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Cannot apply deltas to service-tags as one of preconditions is violated. Returning received serviceTags without applying delta!!");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerServiceTagsDeltaUtil.applyDelta()");
        }
        RangerPerfTracer.log(perf);
        return serviceTags;
    }

    public static void pruneUnusedAttributes(ServiceTags serviceTags) {
        if (serviceTags != null) {
            serviceTags.setTagUpdateTime(null);
            for (Map.Entry<Long, RangerTagDef> entry : serviceTags.getTagDefinitions().entrySet()) {
                RangerTagDef tagDef = entry.getValue();
                tagDef.setCreatedBy(null);
                tagDef.setCreateTime(null);
                tagDef.setUpdatedBy(null);
                tagDef.setUpdateTime(null);
                tagDef.setGuid(null);
            }
            for (Map.Entry<Long, RangerBaseModelObject> entry : serviceTags.getTags().entrySet()) {
                RangerTag tag = (RangerTag)entry.getValue();
                tag.setCreatedBy(null);
                tag.setCreateTime(null);
                tag.setUpdatedBy(null);
                tag.setUpdateTime(null);
                tag.setGuid(null);
            }
            for (RangerServiceResource rangerServiceResource : serviceTags.getServiceResources()) {
                rangerServiceResource.setCreatedBy(null);
                rangerServiceResource.setCreateTime(null);
                rangerServiceResource.setUpdatedBy(null);
                rangerServiceResource.setUpdateTime(null);
                rangerServiceResource.setGuid(null);
                rangerServiceResource.setServiceName(null);
            }
        }
    }
}

