/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyevaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.policyengine.PolicyEngine;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.policyresourcematcher.RangerDefaultPolicyResourceMatcher;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.RangerResourceMatcher;
import org.apache.ranger.plugin.util.RangerRequestExprResolver;
import org.apache.ranger.plugin.util.ServiceDefUtil;
import org.apache.ranger.plugin.util.StringTokenReplacer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RangerAbstractPolicyEvaluator
implements RangerPolicyEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAbstractPolicyEvaluator.class);
    private static final AtomicLong NEXT_RESOURCE_EVALUATOR_ID = new AtomicLong(1L);
    private static final Map<String, Object> WILDCARD_EVAL_CONTEXT = new HashMap<String, Object>(){

        @Override
        public boolean containsKey(Object key) {
            return true;
        }

        @Override
        public Object get(Object key) {
            return "*";
        }
    };
    private RangerPolicy policy;
    private RangerServiceDef serviceDef;
    private boolean needsDynamicEval = false;
    private int evalOrder;
    private List<RangerPolicyEvaluator.RangerPolicyResourceEvaluator> resourceEvaluators = Collections.emptyList();
    protected RangerPluginContext pluginContext = null;

    public void setPluginContext(RangerPluginContext pluginContext) {
        this.pluginContext = pluginContext;
    }

    public RangerPluginContext getPluginContext() {
        return this.pluginContext;
    }

    @Override
    public void init(RangerPolicy policy, RangerServiceDef serviceDef, RangerPolicyEngineOptions options) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAbstractPolicyEvaluator.init(" + policy + ", " + serviceDef + ")");
        }
        this.policy = this.getPrunedPolicy(policy);
        this.serviceDef = serviceDef;
        this.needsDynamicEval = false;
        ArrayList<RangerPolicyEvaluator.RangerPolicyResourceEvaluator> resourceEvaluators = new ArrayList<RangerPolicyEvaluator.RangerPolicyResourceEvaluator>();
        RangerDefaultPolicyResourceEvaluator resourceEvaluator = new RangerDefaultPolicyResourceEvaluator(NEXT_RESOURCE_EVALUATOR_ID.getAndIncrement(), policy.getResources(), this.getPolicyType(), serviceDef, options.getServiceDefHelper());
        resourceEvaluators.add(resourceEvaluator);
        boolean bl = this.needsDynamicEval = this.needsDynamicEval || resourceEvaluator.getPolicyResourceMatcher().getNeedsDynamicEval();
        if (CollectionUtils.isNotEmpty(policy.getAdditionalResources())) {
            for (Map<String, RangerPolicy.RangerPolicyResource> additionalResource : policy.getAdditionalResources()) {
                resourceEvaluator = new RangerDefaultPolicyResourceEvaluator(NEXT_RESOURCE_EVALUATOR_ID.getAndIncrement(), additionalResource, this.getPolicyType(), serviceDef, options.getServiceDefHelper());
                resourceEvaluators.add(resourceEvaluator);
                this.needsDynamicEval = this.needsDynamicEval || resourceEvaluator.getPolicyResourceMatcher().getNeedsDynamicEval();
            }
        }
        this.resourceEvaluators = resourceEvaluators;
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAbstractPolicyEvaluator.init(" + this.policy + ", " + serviceDef + ")");
        }
    }

    public int getPolicyType() {
        Integer ret = this.policy != null ? this.policy.getPolicyType() : null;
        return ret != null ? ret : 0;
    }

    @Override
    public RangerPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public long getPolicyId() {
        Long ret = this.policy != null ? this.policy.getId() : null;
        return ret != null ? ret : -1L;
    }

    @Override
    public int getPolicyPriority() {
        return this.policy != null && this.policy.getPolicyPriority() != null ? this.policy.getPolicyPriority() : 0;
    }

    @Override
    public List<RangerPolicyEvaluator.RangerPolicyResourceEvaluator> getResourceEvaluators() {
        return this.resourceEvaluators;
    }

    @Override
    public RangerServiceDef getServiceDef() {
        return this.serviceDef;
    }

    @Override
    public boolean hasAllow() {
        return this.policy != null && CollectionUtils.isNotEmpty(this.policy.getPolicyItems());
    }

    protected boolean hasMatchablePolicyItem(RangerAccessRequest request) {
        return this.hasAllow() || this.hasDeny();
    }

    @Override
    public boolean hasDeny() {
        return this.policy != null && (this.policy.getIsDenyAllElse() != false || CollectionUtils.isNotEmpty(this.policy.getDenyPolicyItems()));
    }

    protected boolean needsDynamicEval() {
        return this.needsDynamicEval;
    }

    private RangerPolicy getPrunedPolicy(RangerPolicy policy) {
        RangerPolicy ret;
        boolean isPruningNeeded;
        List<RangerPolicy.RangerPolicyItem> prunedDenyExceptions;
        List<RangerPolicy.RangerPolicyItem> prunedAllowExceptions;
        List<RangerPolicy.RangerPolicyItem> prunedDenyItems;
        List<RangerPolicy.RangerPolicyItem> prunedAllowItems;
        RangerPluginContext pluginContext;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAbstractPolicyEvaluator.getPrunedPolicy(" + policy + ")");
        }
        if ((pluginContext = this.getPluginContext()) != null && pluginContext.getConfig().getPolicyEngineOptions().evaluateDelegateAdminOnly) {
            prunedAllowItems = policy.getPolicyItems().stream().filter(RangerPolicy.RangerPolicyItem::getDelegateAdmin).collect(Collectors.toList());
            prunedDenyItems = policy.getDenyPolicyItems().stream().filter(RangerPolicy.RangerPolicyItem::getDelegateAdmin).collect(Collectors.toList());
            prunedAllowExceptions = policy.getAllowExceptions().stream().filter(RangerPolicy.RangerPolicyItem::getDelegateAdmin).collect(Collectors.toList());
            prunedDenyExceptions = policy.getDenyExceptions().stream().filter(RangerPolicy.RangerPolicyItem::getDelegateAdmin).collect(Collectors.toList());
            isPruningNeeded = prunedAllowItems.size() != policy.getPolicyItems().size() || prunedDenyItems.size() != policy.getDenyPolicyItems().size() || prunedAllowExceptions.size() != policy.getAllowExceptions().size() || prunedDenyExceptions.size() != policy.getDenyExceptions().size();
        } else {
            prunedAllowItems = null;
            prunedDenyItems = null;
            prunedAllowExceptions = null;
            prunedDenyExceptions = null;
            isPruningNeeded = false;
        }
        if (!isPruningNeeded) {
            ret = policy;
        } else {
            ret = new RangerPolicy();
            ret.updateFrom(policy);
            ret.setId(policy.getId());
            ret.setGuid(policy.getGuid());
            ret.setVersion(policy.getVersion());
            ret.setServiceType(policy.getServiceType());
            ret.setPolicyItems(prunedAllowItems);
            ret.setDenyPolicyItems(prunedDenyItems);
            ret.setAllowExceptions(prunedAllowExceptions);
            ret.setDenyExceptions(prunedDenyExceptions);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAbstractPolicyEvaluator.getPrunedPolicy(isPruningNeeded=" + isPruningNeeded + ") : " + ret);
        }
        return ret;
    }

    @Override
    public int getEvalOrder() {
        return this.evalOrder;
    }

    @Override
    public boolean isAuditEnabled() {
        return this.policy != null && this.policy.getIsAuditEnabled() != false;
    }

    public void setEvalOrder(int evalOrder) {
        this.evalOrder = evalOrder;
    }

    @Override
    public RangerPolicyEvaluator.PolicyACLSummary getPolicyACLSummary() {
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerAbstractPolicyEvaluator={");
        sb.append("policy={");
        if (this.policy != null) {
            this.policy.toString(sb);
        }
        sb.append("} ");
        sb.append("}");
        return sb;
    }

    private Map<String, RangerPolicy.RangerPolicyResource> getPolicyResourcesWithMacrosReplaced(Map<String, RangerPolicy.RangerPolicyResource> resources, PolicyEngine policyEngine) {
        Map<String, RangerPolicy.RangerPolicyResource> ret;
        Set<String> resourceKeys;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAbstractPolicyEvaluator.getPolicyResourcesWithMacrosReplaced(" + resources + ")");
        }
        Set<String> set = resourceKeys = resources == null ? null : resources.keySet();
        if (CollectionUtils.isNotEmpty(resourceKeys)) {
            ret = new HashMap<String, RangerPolicy.RangerPolicyResource>();
            for (String resourceName : resourceKeys) {
                List<String> values;
                RangerPolicy.RangerPolicyResource resourceValues = resources.get(resourceName);
                List<String> list = values = resourceValues == null ? null : resourceValues.getValues();
                if (CollectionUtils.isNotEmpty(values)) {
                    StringTokenReplacer tokenReplacer = policyEngine.getStringTokenReplacer(resourceName);
                    ArrayList<String> modifiedValues = new ArrayList<String>();
                    for (String value : values) {
                        RangerRequestExprResolver exprResolver = new RangerRequestExprResolver(value, this.serviceDef.getName());
                        String modifiedValue = exprResolver.resolveExpressions(WILDCARD_EVAL_CONTEXT);
                        if (tokenReplacer != null) {
                            modifiedValue = tokenReplacer.replaceTokens(modifiedValue, WILDCARD_EVAL_CONTEXT);
                        }
                        modifiedValues.add(modifiedValue);
                    }
                    RangerPolicy.RangerPolicyResource modifiedPolicyResource = new RangerPolicy.RangerPolicyResource(modifiedValues, resourceValues.getIsExcludes(), resourceValues.getIsRecursive());
                    ret.put(resourceName, modifiedPolicyResource);
                    continue;
                }
                ret.put(resourceName, resourceValues);
            }
        } else {
            ret = resources;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAbstractPolicyEvaluator.getPolicyResourcesWithMacrosReplaced(" + resources + "): " + ret);
        }
        return ret;
    }

    static {
        WILDCARD_EVAL_CONTEXT.put("*", "*");
    }

    public class RangerDefaultPolicyResourceEvaluator
    implements RangerPolicyEvaluator.RangerPolicyResourceEvaluator {
        private final long id;
        private final Map<String, RangerPolicy.RangerPolicyResource> resource;
        private final RangerDefaultPolicyResourceMatcher resourceMatcher;
        private final RangerServiceDef.RangerResourceDef leafResourceDef;
        private volatile RangerDefaultPolicyResourceMatcher macrosReplacedWithWildcardMatcher;

        public RangerDefaultPolicyResourceEvaluator(long id, Map<String, RangerPolicy.RangerPolicyResource> resource, int policyType, RangerServiceDef serviceDef, RangerServiceDefHelper serviceDefHelper) {
            this.id = id;
            this.resource = resource;
            this.leafResourceDef = ServiceDefUtil.getLeafResourceDef(serviceDef, resource);
            this.resourceMatcher = new RangerDefaultPolicyResourceMatcher();
            this.resourceMatcher.setPolicyResources(resource, policyType);
            this.resourceMatcher.setServiceDef(serviceDef);
            this.resourceMatcher.setServiceDefHelper(serviceDefHelper);
            this.resourceMatcher.init();
        }

        @Override
        public RangerPolicyEvaluator getPolicyEvaluator() {
            return RangerAbstractPolicyEvaluator.this;
        }

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        public RangerPolicyResourceMatcher getPolicyResourceMatcher() {
            return this.resourceMatcher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RangerPolicyResourceMatcher getMacrosReplaceWithWildcardMatcher(PolicyEngine policyEngine) {
            RangerDefaultPolicyResourceMatcher ret = this.macrosReplacedWithWildcardMatcher;
            if (ret == null) {
                RangerDefaultPolicyResourceEvaluator rangerDefaultPolicyResourceEvaluator = this;
                synchronized (rangerDefaultPolicyResourceEvaluator) {
                    ret = this.macrosReplacedWithWildcardMatcher;
                    if (ret == null) {
                        if (this.resourceMatcher.getNeedsDynamicEval()) {
                            Map updatedResource = RangerAbstractPolicyEvaluator.this.getPolicyResourcesWithMacrosReplaced(this.resource, policyEngine);
                            ret = new RangerDefaultPolicyResourceMatcher();
                            ret.setPolicyResources(updatedResource, this.resourceMatcher.getPolicyType());
                            ret.setServiceDef(RangerAbstractPolicyEvaluator.this.serviceDef);
                            ret.setServiceDefHelper(this.resourceMatcher.getServiceDefHelper());
                            ret.init();
                        } else {
                            ret = this.resourceMatcher;
                        }
                        this.macrosReplacedWithWildcardMatcher = ret;
                    }
                }
            }
            return ret;
        }

        @Override
        public Map<String, RangerPolicy.RangerPolicyResource> getPolicyResource() {
            return this.resource;
        }

        @Override
        public RangerResourceMatcher getResourceMatcher(String resourceName) {
            return this.resourceMatcher.getResourceMatcher(resourceName);
        }

        @Override
        public boolean isAncestorOf(RangerServiceDef.RangerResourceDef resourceDef) {
            if (this.resourceMatcher.getPolicyType() == 3 && (this.resource == null || this.resource.isEmpty())) {
                return true;
            }
            return ServiceDefUtil.isAncestorOf(RangerAbstractPolicyEvaluator.this.serviceDef, this.leafResourceDef, resourceDef);
        }
    }
}

