/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import javax.script.ScriptEngine;
import jdk.nashorn.api.scripting.ClassFilter;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;
import org.apache.ranger.plugin.conditionevaluator.RangerScriptConditionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEngineUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RangerScriptConditionEvaluator.class);
    private static final String[] SCRIPT_ENGINE_ARGS = new String[0];

    public static ScriptEngine createScriptEngine(String engineName, String serviceType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ScriptEngineUtil.createScriptEngine(engineName=" + engineName + ", serviceType=" + serviceType + "): engineName ignored");
        }
        return ScriptEngineUtil.createScriptEngine(serviceType);
    }

    public static ScriptEngine createScriptEngine(String serviceType) {
        ScriptEngine ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> ScriptEngineUtil.createScriptEngine(serviceType=" + serviceType + ")");
        }
        if ((ret = ScriptEngineUtil.getScriptEngine(null)) != null) {
            LOG.debug("Created script-engine in current class-loader");
        } else {
            LOG.warn("Failed to create script-engine in current class-loader. Will try plugin-class-loader for service-type:[" + serviceType + "]");
            ClassLoader prevActiveClassLoader = null;
            try {
                RangerPluginClassLoader pluginClassLoader = RangerPluginClassLoader.getInstance((String)serviceType, null);
                if (pluginClassLoader != null) {
                    prevActiveClassLoader = pluginClassLoader.getPrevActiveClassLoader();
                } else {
                    LOG.error("Cannot get script-engine from null plugin-class-loader");
                }
            }
            catch (Throwable exp) {
                LOG.error("RangerScriptConditionEvaluator.init() failed", exp);
            }
            if (prevActiveClassLoader != null) {
                ret = ScriptEngineUtil.getScriptEngine(prevActiveClassLoader);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== ScriptEngineUtil.createScriptEngine(serviceType=" + serviceType + ") : ret=" + ret);
        }
        return ret;
    }

    private static ScriptEngine getScriptEngine(ClassLoader clsLoader) {
        ScriptEngine ret;
        try {
            NashornScriptEngineFactory factory = new NashornScriptEngineFactory();
            ret = clsLoader != null ? factory.getScriptEngine(SCRIPT_ENGINE_ARGS, clsLoader, (ClassFilter)RangerClassFilter.INSTANCE) : factory.getScriptEngine((ClassFilter)RangerClassFilter.INSTANCE);
        }
        catch (Throwable t) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ScriptEngineUtil.getScriptEngine(clsLoader={}): failed", (Object)clsLoader, (Object)t);
            }
            ret = null;
        }
        return ret;
    }

    private static class RangerClassFilter
    implements ClassFilter {
        static final RangerClassFilter INSTANCE = new RangerClassFilter();

        private RangerClassFilter() {
        }

        public boolean exposeToScripts(String className) {
            LOG.warn("script blocked: attempt to use Java class {}", (Object)className);
            return false;
        }
    }
}

