/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.mp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.rat.Defaults;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.config.AddLicenseHeaders;
import org.apache.rat.config.ReportFormat;
import org.apache.rat.mp.AbstractRatMojo;
import org.apache.rat.mp.RatCheckException;
import org.apache.rat.report.claim.ClaimStatistic;

@Mojo(name="check", defaultPhase=LifecyclePhase.VALIDATE)
public class RatCheckMojo
extends AbstractRatMojo {
    @Parameter(property="rat.outputFile", defaultValue="${project.build.directory}/rat.txt")
    private File reportFile;
    @Parameter(property="rat.outputStyle", defaultValue="plain")
    private String reportStyle;
    @Parameter(property="rat.numUnapprovedLicenses", defaultValue="0")
    private int numUnapprovedLicenses;
    @Parameter(property="rat.addLicenseHeaders", defaultValue="false")
    private String addLicenseHeaders;
    @Parameter(property="rat.copyrightMessage")
    private String copyrightMessage;
    @Parameter(property="rat.ignoreErrors", defaultValue="false")
    private boolean ignoreErrors;
    @Parameter(property="rat.consoleOutput", defaultValue="false")
    private boolean consoleOutput;

    private ClaimStatistic getRawReport() throws MojoExecutionException, MojoFailureException {
        ClaimStatistic claimStatistic;
        OutputStreamWriter fw = null;
        try {
            fw = new OutputStreamWriter((OutputStream)new FileOutputStream(this.reportFile), Charset.forName("UTF-8"));
            ClaimStatistic statistic = this.createReport(fw, this.getStyleSheet());
            ((Writer)fw).close();
            fw = null;
            claimStatistic = statistic;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fw);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)fw);
        return claimStatistic;
    }

    private InputStream getStyleSheet() throws MojoExecutionException {
        if (this.reportStyle == null || ReportFormat.PLAIN.is(this.reportStyle)) {
            return Defaults.getPlainStyleSheet();
        }
        if (ReportFormat.XML.is(this.reportStyle)) {
            return null;
        }
        try {
            return new FileInputStream(this.reportStyle);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Unable to find report stylesheet: " + this.reportStyle, (Exception)e);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"RAT will not execute since it is configured to be skipped via system property 'rat.skip'.");
            return;
        }
        File parent = this.reportFile.getParentFile();
        if (!parent.mkdirs() && !parent.isDirectory()) {
            throw new MojoExecutionException("Could not create report parent directory " + parent);
        }
        ClaimStatistic report = this.getRawReport();
        this.check(report);
    }

    protected void check(ClaimStatistic statistics) throws MojoFailureException {
        if (this.numUnapprovedLicenses > 0) {
            this.getLog().info((CharSequence)("You requested to accept " + this.numUnapprovedLicenses + " files with unapproved licenses."));
        }
        int numApproved = statistics.getNumApproved();
        this.getLog().info((CharSequence)("Rat check: Summary over all files. Unapproved: " + statistics.getNumUnApproved() + ", unknown: " + statistics.getNumUnknown() + ", generated: " + statistics.getNumGenerated() + ", approved: " + numApproved + (numApproved > 0 ? " licenses." : " license.")));
        if (this.numUnapprovedLicenses < statistics.getNumUnApproved()) {
            if (this.consoleOutput) {
                try {
                    this.getLog().warn((CharSequence)this.createReport(Defaults.getUnapprovedLicensesStyleSheet()).trim());
                }
                catch (MojoExecutionException e) {
                    this.getLog().warn((CharSequence)"Unable to print the files with unapproved licenses to the console.");
                }
            }
            String seeReport = " See RAT report in: " + this.reportFile;
            if (!this.ignoreErrors) {
                throw new RatCheckException("Too many files with unapproved license: " + statistics.getNumUnApproved() + seeReport);
            }
            this.getLog().warn((CharSequence)("Rat check: " + statistics.getNumUnApproved() + " files with unapproved licenses." + seeReport));
        }
    }

    protected ReportConfiguration getConfiguration() throws MojoFailureException, MojoExecutionException {
        ReportConfiguration configuration = super.getConfiguration();
        if (AddLicenseHeaders.FORCED.name().equalsIgnoreCase(this.addLicenseHeaders)) {
            configuration.setAddingLicenses(true);
            configuration.setAddingLicensesForced(true);
            configuration.setCopyrightMessage(this.copyrightMessage);
        } else if (AddLicenseHeaders.TRUE.name().equalsIgnoreCase(this.addLicenseHeaders)) {
            configuration.setAddingLicenses(true);
            configuration.setCopyrightMessage(this.copyrightMessage);
        } else if (!AddLicenseHeaders.FALSE.name().equalsIgnoreCase(this.addLicenseHeaders)) {
            throw new MojoFailureException("Invalid value for addLicenseHeaders: Expected " + AddLicenseHeaders.getValuesForHelp() + ", got " + this.addLicenseHeaders);
        }
        return configuration;
    }
}

