/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.sentry.core.common.utils.KeyValue;
import org.apache.sentry.core.common.utils.SentryConstants;
import org.apache.sentry.provider.db.service.thrift.TSentryGrantOption;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilege;
import org.apache.sentry.service.thrift.ServiceConstants;

public final class SentryServiceUtil {
    public static TSentryPrivilege convertToTSentryPrivilege(String privilegeStr) {
        TSentryPrivilege tSentryPrivilege = new TSentryPrivilege();
        for (String authorizable : SentryConstants.AUTHORIZABLE_SPLITTER.split((CharSequence)privilegeStr)) {
            KeyValue tempKV = new KeyValue(authorizable);
            String key = tempKV.getKey();
            String value = tempKV.getValue();
            if ("server".equalsIgnoreCase(key)) {
                tSentryPrivilege.setServerName(value);
                continue;
            }
            if ("db".equalsIgnoreCase(key)) {
                tSentryPrivilege.setDbName(value);
                continue;
            }
            if ("table".equalsIgnoreCase(key)) {
                tSentryPrivilege.setTableName(value);
                continue;
            }
            if ("column".equalsIgnoreCase(key)) {
                tSentryPrivilege.setColumnName(value);
                continue;
            }
            if ("uri".equalsIgnoreCase(key)) {
                tSentryPrivilege.setURI(value);
                continue;
            }
            if ("action".equalsIgnoreCase(key)) {
                tSentryPrivilege.setAction(value);
                continue;
            }
            if (!"grantoption".equalsIgnoreCase(key)) continue;
            TSentryGrantOption grantOption = "true".equalsIgnoreCase(value) ? TSentryGrantOption.TRUE : TSentryGrantOption.FALSE;
            tSentryPrivilege.setGrantOption(grantOption);
        }
        tSentryPrivilege.setPrivilegeScope(SentryServiceUtil.getPrivilegeScope(tSentryPrivilege));
        return tSentryPrivilege;
    }

    public static Map<String, String> parseObjectPath(String objectPath) {
        HashMap<String, String> objectMap = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)objectPath)) {
            return objectMap;
        }
        for (String kvStr : SentryConstants.AUTHORIZABLE_SPLITTER.split((CharSequence)objectPath)) {
            KeyValue kv = new KeyValue(kvStr);
            String key = kv.getKey();
            String value = kv.getValue();
            if ("db".equalsIgnoreCase(key)) {
                objectMap.put("db", value);
                continue;
            }
            if (!"table".equalsIgnoreCase(key)) continue;
            objectMap.put("table", value);
        }
        return objectMap;
    }

    public static String getPrivilegeScope(TSentryPrivilege tSentryPrivilege) {
        ServiceConstants.PrivilegeScope privilegeScope = ServiceConstants.PrivilegeScope.SERVER;
        if (!StringUtils.isEmpty((String)tSentryPrivilege.getURI())) {
            privilegeScope = ServiceConstants.PrivilegeScope.URI;
        } else if (!StringUtils.isEmpty((String)tSentryPrivilege.getColumnName())) {
            privilegeScope = ServiceConstants.PrivilegeScope.COLUMN;
        } else if (!StringUtils.isEmpty((String)tSentryPrivilege.getTableName())) {
            privilegeScope = ServiceConstants.PrivilegeScope.TABLE;
        } else if (!StringUtils.isEmpty((String)tSentryPrivilege.getDbName())) {
            privilegeScope = ServiceConstants.PrivilegeScope.DATABASE;
        }
        return privilegeScope.toString();
    }

    public static String convertTSentryPrivilegeToStr(TSentryPrivilege tSentryPrivilege) {
        ArrayList privileges = Lists.newArrayList();
        if (tSentryPrivilege != null) {
            String grantOption;
            String serverName = tSentryPrivilege.getServerName();
            String dbName = tSentryPrivilege.getDbName();
            String tableName = tSentryPrivilege.getTableName();
            String columnName = tSentryPrivilege.getColumnName();
            String uri = tSentryPrivilege.getURI();
            String action = tSentryPrivilege.getAction();
            String string = grantOption = tSentryPrivilege.getGrantOption() == TSentryGrantOption.TRUE ? "true" : "false";
            if (!StringUtils.isEmpty((String)serverName)) {
                privileges.add(SentryConstants.KV_JOINER.join((Object)"server", (Object)serverName, new Object[0]));
                if (!StringUtils.isEmpty((String)uri)) {
                    privileges.add(SentryConstants.KV_JOINER.join((Object)"uri", (Object)uri, new Object[0]));
                } else if (!StringUtils.isEmpty((String)dbName)) {
                    privileges.add(SentryConstants.KV_JOINER.join((Object)"db", (Object)dbName, new Object[0]));
                    if (!StringUtils.isEmpty((String)tableName)) {
                        privileges.add(SentryConstants.KV_JOINER.join((Object)"table", (Object)tableName, new Object[0]));
                        if (!StringUtils.isEmpty((String)columnName)) {
                            privileges.add(SentryConstants.KV_JOINER.join((Object)"column", (Object)columnName, new Object[0]));
                        }
                    }
                }
                if (!StringUtils.isEmpty((String)action)) {
                    privileges.add(SentryConstants.KV_JOINER.join((Object)"action", (Object)action, new Object[0]));
                }
            }
            if ("true".equals(grantOption)) {
                privileges.add(SentryConstants.KV_JOINER.join((Object)"grantoption", (Object)grantOption, new Object[0]));
            }
        }
        return SentryConstants.AUTHORIZABLE_JOINER.join((Iterable)privileges);
    }

    private SentryServiceUtil() {
    }
}

