/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.javascript.helper;

import java.lang.reflect.Field;
import org.apache.sling.scripting.javascript.helper.SlingContext;
import org.apache.sling.scripting.javascript.helper.SlingRhinoDebugger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.tools.debugger.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingContextFactory
extends ContextFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private SlingRhinoDebugger debugger;
    private ScopeProvider scopeProvider;
    private boolean debuggerActive;

    public static void setup(ScopeProvider sp) {
        if (!SlingContextFactory.hasExplicitGlobal()) {
            SlingContextFactory.initGlobal(new SlingContextFactory(sp));
        }
    }

    public static void teardown() {
        ContextFactory factory = SlingContextFactory.getGlobal();
        if (factory instanceof SlingContextFactory) {
            ((SlingContextFactory)factory).dispose();
        }
    }

    private SlingContextFactory(ScopeProvider sp) {
        this.scopeProvider = sp;
    }

    private void dispose() {
        this.exitDebugger();
        ContextFactory newGlobal = new ContextFactory();
        this.setField(newGlobal, "hasCustomGlobal", Boolean.FALSE);
        this.setField(newGlobal, "global", newGlobal);
        this.setField(newGlobal, "sealed", Boolean.FALSE);
        this.setField(newGlobal, "listeners", null);
        this.setField(newGlobal, "disabledListening", Boolean.FALSE);
        this.setField(newGlobal, "applicationClassLoader", null);
    }

    @Override
    protected Context makeContext() {
        return new SlingContext();
    }

    @Override
    protected boolean hasFeature(Context cx, int featureIndex) {
        if (featureIndex == 7) {
            return true;
        }
        return super.hasFeature(cx, featureIndex);
    }

    @Override
    protected void onContextCreated(Context cx) {
        super.onContextCreated(cx);
        this.initDebugger(cx);
    }

    private void initDebugger(Context cx) {
        if (this.isDebugging()) {
            try {
                if (this.debugger == null) {
                    this.debugger = new SlingRhinoDebugger(this.getClass().getSimpleName());
                    this.debugger.setScopeProvider(this.scopeProvider);
                    this.debugger.attachTo(this);
                }
            }
            catch (Exception e) {
                this.log.warn("initDebugger: Failed setting up the Rhino debugger", (Throwable)e);
            }
        }
    }

    public void exitDebugger() {
        if (this.debugger != null) {
            this.debugger.setScopeProvider(null);
            this.debugger.detach();
            this.debugger.dispose();
            this.debugger = null;
        }
    }

    void debuggerStopped() {
        this.debugger = null;
    }

    public void setDebugging(boolean enable) {
        this.debuggerActive = enable;
    }

    public boolean isDebugging() {
        return this.debuggerActive;
    }

    private void setField(Object instance, String fieldName, Object value) {
        try {
            Field field = instance.getClass().getDeclaredField(fieldName);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(instance, value);
        }
        catch (IllegalArgumentException iae) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (NoSuchFieldException nsfe) {
            // empty catch block
        }
    }
}

