/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.javascript.helper;

import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrapFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingWrapFactory
extends WrapFactory {
    private static final Class<?>[] EXCLUDED_CLASSES = new Class[0];
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<Class<?>, String> wrappers = new HashMap();

    public Scriptable wrapAsJavaObject(Context cx, Scriptable scope, Object javaObject, Class staticType) {
        Scriptable result = null;
        try {
            String hostObjectName = this.getHostObjectName(staticType);
            if (hostObjectName == null) {
                hostObjectName = this.getHostObjectName(javaObject.getClass());
            }
            if (hostObjectName != null) {
                result = cx.newObject(scope, hostObjectName, new Object[]{javaObject});
            }
        }
        catch (Exception e) {
            this.log.warn("Cannot Wrap " + javaObject, (Throwable)e);
        }
        if (result == null) {
            result = super.wrapAsJavaObject(cx, scope, javaObject, staticType);
        }
        return result;
    }

    private String getHostObjectName(Class<?> javaClass) {
        if (javaClass == null || this.isExcluded(javaClass)) {
            return null;
        }
        String hostObjectName = this.wrappers.get(javaClass);
        if (hostObjectName == null) {
            Class<?>[] javaInterfaces = javaClass.getInterfaces();
            for (int i = 0; i < javaInterfaces.length && hostObjectName == null; ++i) {
                hostObjectName = this.getHostObjectName(javaInterfaces[i]);
            }
            if (hostObjectName == null) {
                hostObjectName = this.getHostObjectName(javaClass.getSuperclass());
            }
        }
        return hostObjectName;
    }

    private boolean isExcluded(Class<?> javaClass) {
        for (Class<?> type : EXCLUDED_CLASSES) {
            if (!type.isAssignableFrom(javaClass)) continue;
            return true;
        }
        return false;
    }

    public void registerWrapper(Class<?> javaClass, String hostObjectName) {
        this.wrappers.put(javaClass, hostObjectName);
    }

    public void unregisterWrapper(Class<?> javaClass) {
        this.wrappers.remove(javaClass);
    }
}

