/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.javascript.internal;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.scripting.api.AbstractScriptEngineFactory;
import org.apache.sling.scripting.api.ScriptCache;
import org.apache.sling.scripting.javascript.RhinoHostObjectProvider;
import org.apache.sling.scripting.javascript.SlingWrapper;
import org.apache.sling.scripting.javascript.helper.SlingContextFactory;
import org.apache.sling.scripting.javascript.helper.SlingWrapFactory;
import org.apache.sling.scripting.javascript.internal.RhinoJavaScriptEngine;
import org.apache.sling.scripting.javascript.wrapper.ScriptableCalendar;
import org.apache.sling.scripting.javascript.wrapper.ScriptableItemMap;
import org.apache.sling.scripting.javascript.wrapper.ScriptableMap;
import org.apache.sling.scripting.javascript.wrapper.ScriptableNode;
import org.apache.sling.scripting.javascript.wrapper.ScriptablePrintWriter;
import org.apache.sling.scripting.javascript.wrapper.ScriptableProperty;
import org.apache.sling.scripting.javascript.wrapper.ScriptableResource;
import org.apache.sling.scripting.javascript.wrapper.ScriptableVersion;
import org.apache.sling.scripting.javascript.wrapper.ScriptableVersionHistory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeJavaPackage;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.debugger.ScopeProvider;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="Apache Sling Rhino Javascript Engine Factory", description="Javascript engine based on Rhino")
@Service(value={ScriptEngineFactory.class})
@Reference(name="HostObjectProvider", referenceInterface=RhinoHostObjectProvider.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="addHostObjectProvider", unbind="removeHostObjectProvider")
@Property(name="org.apache.sling.scripting.javascript.rhino.optLevel", label="Rhino optimization level", intValue={9}, description="The level of optimization for the bytecode generated by Rhino. Provide values between 0-9, 9 being the most aggressive level of optimization. A value of -1 will run scripts in interpreted mode.")
public class RhinoJavaScriptEngineFactory
extends AbstractScriptEngineFactory
implements ScopeProvider {
    public static final String OPTIMIZATION_CONFIG = "org.apache.sling.scripting.javascript.rhino.optLevel";
    public static final int DEFAULT_OPTIMIZATION_LEVEL = 9;
    public static final String ECMA_SCRIPT_EXTENSION = "ecma";
    public static final String ESP_SCRIPT_EXTENSION = "esp";
    private static final Class<?>[] HOSTOBJECT_CLASSES = new Class[]{ScriptableResource.class, ScriptableNode.class, ScriptableProperty.class, ScriptableItemMap.class, ScriptablePrintWriter.class, ScriptableVersionHistory.class, ScriptableVersion.class, ScriptableCalendar.class, ScriptableMap.class};
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private int optimizationLevel;
    private String languageVersion;
    private SlingWrapFactory wrapFactory;
    private Scriptable rootScope;
    private final Set<RhinoHostObjectProvider> hostObjectProvider = new HashSet<RhinoHostObjectProvider>();
    @Reference
    private DynamicClassLoaderManager dynamicClassLoaderManager = null;
    @Reference
    private ScriptCache scriptCache = null;

    public ScriptEngine getScriptEngine() {
        return new RhinoJavaScriptEngine((ScriptEngineFactory)((Object)this), this.getRootScope(), this.scriptCache);
    }

    public String getLanguageName() {
        return "ECMAScript";
    }

    public String getLanguageVersion() {
        return this.languageVersion;
    }

    public int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public Object getParameter(String name) {
        if ("THREADING".equals(name)) {
            return "MULTITHREADED";
        }
        return super.getParameter(name);
    }

    @Override
    public Scriptable getScope() {
        return this.getRootScope();
    }

    SlingWrapFactory getWrapFactory() {
        return this.wrapFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Scriptable getRootScope() {
        if (this.rootScope == null) {
            Context rhinoContext = Context.enter();
            try {
                rhinoContext.setOptimizationLevel(this.optimizationLevel);
                ScriptableObject tmpScope = rhinoContext.initStandardObjects(new ImporterTopLevel(rhinoContext), false);
                this.addHostObjects(tmpScope, HOSTOBJECT_CLASSES);
                for (RhinoHostObjectProvider provider : this.hostObjectProvider) {
                    this.addHostObjects(tmpScope, provider.getHostObjectClasses());
                    this.addImportedClasses(rhinoContext, tmpScope, provider.getImportedClasses());
                    this.addImportedPackages(rhinoContext, tmpScope, provider.getImportedPackages());
                }
                this.rootScope = tmpScope;
            }
            finally {
                Context.exit();
            }
        }
        return this.rootScope;
    }

    private void dropRootScope() {
        ContextFactory contextFactory = ContextFactory.getGlobal();
        if (contextFactory instanceof SlingContextFactory) {
            ((SlingContextFactory)contextFactory).exitDebugger();
        }
        this.rootScope = null;
    }

    @Activate
    protected void activate(ComponentContext context) {
        DynamicClassLoaderManager dclm;
        Dictionary props = context.getProperties();
        boolean debugging = this.getProperty("org.apache.sling.scripting.javascript.debug", props, context.getBundleContext(), false);
        this.optimizationLevel = this.readOptimizationLevel(props);
        this.wrapFactory = new SlingWrapFactory();
        SlingContextFactory.setup(this);
        Context cx = Context.enter();
        this.setEngineName(this.getEngineName() + " (" + cx.getImplementationVersion() + ")");
        this.languageVersion = String.valueOf(cx.getLanguageVersion());
        Context.exit();
        this.setExtensions(new String[]{ECMA_SCRIPT_EXTENSION, ESP_SCRIPT_EXTENSION});
        this.setMimeTypes(new String[]{"text/javascript", "application/ecmascript", "application/javascript"});
        this.setNames(new String[]{"javascript", ECMA_SCRIPT_EXTENSION, ESP_SCRIPT_EXTENSION});
        ContextFactory contextFactory = ContextFactory.getGlobal();
        if (contextFactory instanceof SlingContextFactory) {
            ((SlingContextFactory)contextFactory).setDebugging(debugging);
        }
        if ((dclm = this.dynamicClassLoaderManager) != null) {
            contextFactory.initApplicationClassLoader(this.dynamicClassLoaderManager.getDynamicClassLoader());
        }
        this.log.info("Activated with optimization level {}", (Object)this.optimizationLevel);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.dropRootScope();
        SlingContextFactory.teardown();
        this.wrapFactory = null;
        this.hostObjectProvider.clear();
    }

    protected void addHostObjectProvider(RhinoHostObjectProvider provider) {
        this.hostObjectProvider.add(provider);
        if (this.rootScope != null) {
            this.addHostObjects(this.rootScope, provider.getHostObjectClasses());
        }
    }

    protected void removeHostObjectProvider(RhinoHostObjectProvider provider) {
        if (this.hostObjectProvider.remove(provider)) {
            this.dropRootScope();
        }
    }

    private void addHostObjects(Scriptable scope, Class<? extends Scriptable>[] classes) {
        if (classes != null) {
            for (Class<? extends Scriptable> clazz : classes) {
                try {
                    ScriptableObject.defineClass(scope, clazz);
                    if (SlingWrapper.class.isAssignableFrom(clazz)) {
                        SlingWrapper hostWrapper = (SlingWrapper)((Object)clazz.newInstance());
                        for (Class<?> c : hostWrapper.getWrappedClasses()) {
                            this.getWrapFactory().registerWrapper(c, hostWrapper.getClassName());
                        }
                        continue;
                    }
                    Scriptable host = clazz.newInstance();
                    this.getWrapFactory().registerWrapper(host.getClass(), host.getClassName());
                }
                catch (Throwable t) {
                    this.log.warn("addHostObjects: Cannot prepare host object " + clazz, t);
                }
            }
        }
    }

    private void addImportedClasses(Context cx, Scriptable scope, Class<?>[] classes) {
        if (classes != null && classes.length > 0) {
            Object[] np = new NativeJavaClass[classes.length];
            for (int i = 0; i < classes.length; ++i) {
                np[i] = new NativeJavaClass(scope, classes[i]);
            }
            ScriptableObject.callMethod(cx, scope, "importClass", np);
        }
    }

    private void addImportedPackages(Context cx, Scriptable scope, String[] packages) {
        if (packages != null && packages.length > 0) {
            Object[] np = new NativeJavaPackage[packages.length];
            for (int i = 0; i < packages.length; ++i) {
                np[i] = new NativeJavaPackage(packages[i]);
            }
            ScriptableObject.callMethod(cx, scope, "importPackage", np);
        }
    }

    private boolean getProperty(String name, Dictionary<?, ?> props, BundleContext bundleContext, boolean defaultValue) {
        Object value = props.get(name);
        if (value == null) {
            value = bundleContext.getProperty(name);
        }
        return value != null ? Boolean.parseBoolean(String.valueOf(value)) : defaultValue;
    }

    private int readOptimizationLevel(Dictionary<?, ?> dictionary) {
        int optLevel = PropertiesUtil.toInteger(dictionary.get(OPTIMIZATION_CONFIG), 9);
        if (!Context.isValidOptimizationLevel(optLevel)) {
            this.log.warn("Invalid optimization level {}, using default value", (Object)optLevel);
            optLevel = 9;
        }
        return optLevel;
    }

    protected void bindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        this.dynamicClassLoaderManager = dynamicClassLoaderManager;
    }

    protected void unbindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        if (this.dynamicClassLoaderManager == dynamicClassLoaderManager) {
            this.dynamicClassLoaderManager = null;
        }
    }

    protected void bindScriptCache(ScriptCache scriptCache) {
        this.scriptCache = scriptCache;
    }

    protected void unbindScriptCache(ScriptCache scriptCache) {
        if (this.scriptCache == scriptCache) {
            this.scriptCache = null;
        }
    }
}

