/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.Collection;
import java.util.Collections;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Hash;

public abstract class HashBasedRouter
extends DocRouter {
    @Override
    public Slice getTargetSlice(String id, SolrInputDocument sdoc, SolrParams params, DocCollection collection) {
        if (id == null) {
            id = this.getId(sdoc, params);
        }
        int hash = this.sliceHash(id, sdoc, params, collection);
        return this.hashToSlice(hash, collection);
    }

    @Override
    public boolean isTargetSlice(String id, SolrInputDocument sdoc, SolrParams params, String shardId, DocCollection collection) {
        if (id == null) {
            id = this.getId(sdoc, params);
        }
        int hash = this.sliceHash(id, sdoc, params, collection);
        DocRouter.Range range = collection.getSlice(shardId).getRange();
        return range != null && range.includes(hash);
    }

    public int sliceHash(String id, SolrInputDocument sdoc, SolrParams params, DocCollection collection) {
        return Hash.murmurhash3_x86_32(id, 0, id.length(), 0);
    }

    protected String getId(SolrInputDocument sdoc, SolrParams params) {
        Object idObj = sdoc.getFieldValue("id");
        String id = idObj != null ? idObj.toString() : "null";
        return id;
    }

    protected Slice hashToSlice(int hash, DocCollection collection) {
        for (Slice slice : collection.getActiveSlices()) {
            DocRouter.Range range = slice.getRange();
            if (range == null || !range.includes(hash)) continue;
            return slice;
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No active slice servicing hash code " + Integer.toHexString(hash) + " in " + collection);
    }

    @Override
    public Collection<Slice> getSearchSlicesSingle(String shardKey, SolrParams params, DocCollection collection) {
        if (shardKey == null) {
            return collection.getActiveSlices();
        }
        Slice slice = this.getTargetSlice(shardKey, null, params, collection);
        return slice == null ? Collections.emptyList() : Collections.singletonList(slice);
    }
}

