/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.response;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.common.luke.FieldFlag;
import org.apache.solr.common.util.NamedList;

public class LukeResponse
extends SolrResponseBase {
    private NamedList<Object> indexInfo;
    private Map<String, FieldInfo> fieldInfo;
    private Map<String, FieldInfo> dynamicFieldInfo;
    private Map<String, FieldTypeInfo> fieldTypeInfo;

    @Override
    public void setResponse(NamedList<Object> res) {
        NamedList fldTypes;
        FieldInfo f;
        super.setResponse(res);
        this.indexInfo = (NamedList)res.get("index");
        NamedList schema = (NamedList)res.get("schema");
        NamedList flds = (NamedList)res.get("fields");
        NamedList dynamicFlds = (NamedList)res.get("dynamicFields");
        if (flds == null && schema != null) {
            flds = (NamedList)schema.get("fields");
        }
        if (flds != null) {
            this.fieldInfo = new HashMap<String, FieldInfo>();
            for (Map.Entry field : flds) {
                f = new FieldInfo(field.getKey());
                f.read((NamedList)field.getValue());
                this.fieldInfo.put(field.getKey(), f);
            }
        }
        if (dynamicFlds == null && schema != null) {
            dynamicFlds = (NamedList)schema.get("dynamicFields");
        }
        if (dynamicFlds != null) {
            this.dynamicFieldInfo = new HashMap<String, FieldInfo>();
            for (Map.Entry dynamicField : dynamicFlds) {
                f = new FieldInfo(dynamicField.getKey());
                f.read((NamedList)dynamicField.getValue());
                this.dynamicFieldInfo.put(dynamicField.getKey(), f);
            }
        }
        if (schema != null && (fldTypes = (NamedList)schema.get("types")) != null) {
            this.fieldTypeInfo = new HashMap<String, FieldTypeInfo>();
            for (Map.Entry fieldType : fldTypes) {
                FieldTypeInfo ft = new FieldTypeInfo(fieldType.getKey());
                ft.read((NamedList)fieldType.getValue());
                this.fieldTypeInfo.put(fieldType.getKey(), ft);
            }
        }
    }

    public String getIndexDirectory() {
        if (this.indexInfo == null) {
            return null;
        }
        return (String)this.indexInfo.get("directory");
    }

    public Integer getNumDocs() {
        if (this.indexInfo == null) {
            return null;
        }
        return (Integer)this.indexInfo.get("numDocs");
    }

    public Integer getMaxDoc() {
        if (this.indexInfo == null) {
            return null;
        }
        return (Integer)this.indexInfo.get("maxDoc");
    }

    public Integer getNumTerms() {
        if (this.indexInfo == null) {
            return null;
        }
        return (Integer)this.indexInfo.get("numTerms");
    }

    public Map<String, FieldTypeInfo> getFieldTypeInfo() {
        return this.fieldTypeInfo;
    }

    public FieldTypeInfo getFieldTypeInfo(String name) {
        return this.fieldTypeInfo.get(name);
    }

    public NamedList<Object> getIndexInfo() {
        return this.indexInfo;
    }

    public Map<String, FieldInfo> getFieldInfo() {
        return this.fieldInfo;
    }

    public FieldInfo getFieldInfo(String f) {
        return this.fieldInfo.get(f);
    }

    public Map<String, FieldInfo> getDynamicFieldInfo() {
        return this.dynamicFieldInfo;
    }

    public FieldInfo getDynamicFieldInfo(String f) {
        return this.dynamicFieldInfo.get(f);
    }

    public static class FieldInfo
    implements Serializable {
        String name;
        String type;
        String schema;
        int docs;
        int distinct;
        EnumSet<FieldFlag> flags;
        boolean cacheableFaceting;
        NamedList<Integer> topTerms;

        public FieldInfo(String n) {
            this.name = n;
        }

        public void read(NamedList<Object> nl) {
            for (Map.Entry<String, Object> entry : nl) {
                if ("type".equals(entry.getKey())) {
                    this.type = (String)entry.getValue();
                }
                if ("flags".equals(entry.getKey())) {
                    this.flags = FieldInfo.parseFlags((String)entry.getValue());
                    continue;
                }
                if ("schema".equals(entry.getKey())) {
                    this.schema = (String)entry.getValue();
                    continue;
                }
                if ("docs".equals(entry.getKey())) {
                    this.docs = (Integer)entry.getValue();
                    continue;
                }
                if ("distinct".equals(entry.getKey())) {
                    this.distinct = (Integer)entry.getValue();
                    continue;
                }
                if ("cacheableFaceting".equals(entry.getKey())) {
                    this.cacheableFaceting = (Boolean)entry.getValue();
                    continue;
                }
                if (!"topTerms".equals(entry.getKey())) continue;
                this.topTerms = (NamedList)entry.getValue();
            }
        }

        public static EnumSet<FieldFlag> parseFlags(String flagStr) {
            EnumSet<FieldFlag> result = EnumSet.noneOf(FieldFlag.class);
            char[] chars = flagStr.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] == '-') continue;
                FieldFlag flag = FieldFlag.getFlag(chars[i]);
                result.add(flag);
            }
            return result;
        }

        public EnumSet<FieldFlag> getFlags() {
            return this.flags;
        }

        public boolean isCacheableFaceting() {
            return this.cacheableFaceting;
        }

        public String getType() {
            return this.type;
        }

        public int getDistinct() {
            return this.distinct;
        }

        public int getDocs() {
            return this.docs;
        }

        public String getName() {
            return this.name;
        }

        public String getSchema() {
            return this.schema;
        }

        public EnumSet<FieldFlag> getSchemaFlags() {
            return this.flags;
        }

        public NamedList<Integer> getTopTerms() {
            return this.topTerms;
        }
    }

    public static class FieldTypeInfo
    implements Serializable {
        String name;
        String className;
        boolean tokenized;
        String analyzer;
        List<String> fields;
        List<String> dynamicFields;

        public FieldTypeInfo(String name) {
            this.name = name;
            this.fields = Collections.emptyList();
        }

        public String getAnalyzer() {
            return this.analyzer;
        }

        public String getClassName() {
            return this.className;
        }

        public List<String> getFields() {
            return this.fields;
        }

        public List<String> getDynamicFields() {
            return this.dynamicFields;
        }

        public String getName() {
            return this.name;
        }

        public boolean isTokenized() {
            return this.tokenized;
        }

        public void read(NamedList<Object> nl) {
            for (Map.Entry<String, Object> entry : nl) {
                String key = entry.getKey();
                if ("fields".equals(key) && entry.getValue() != null) {
                    List theFields = (List)entry.getValue();
                    this.fields = new ArrayList<String>(theFields);
                    continue;
                }
                if ("dynamicFields".equals(key) && entry.getValue() != null) {
                    List theDynamicFields = (List)entry.getValue();
                    this.dynamicFields = new ArrayList<String>(theDynamicFields);
                    continue;
                }
                if ("tokenized".equals(key)) {
                    this.tokenized = Boolean.parseBoolean(entry.getValue().toString());
                    continue;
                }
                if ("analyzer".equals(key)) {
                    this.analyzer = entry.getValue().toString();
                    continue;
                }
                if (!"className".equals(key)) continue;
                this.className = entry.getValue().toString();
            }
        }
    }
}

