/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.util.LuceneTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RandomMergePolicy
extends MergePolicy {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final MergePolicy inner;

    public RandomMergePolicy() {
        this(LuceneTestCase.newMergePolicy());
    }

    private RandomMergePolicy(MergePolicy inner) {
        super(inner.getNoCFSRatio(), (long)(inner.getMaxCFSSegmentSizeMB() * 1024.0 * 1024.0));
        this.inner = inner;
        log.info("RandomMergePolicy wrapping {}: {}", inner.getClass(), (Object)inner);
    }

    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos segmentInfos, IndexWriter writer) throws IOException {
        return this.inner.findForcedDeletesMerges(segmentInfos, writer);
    }

    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos segmentInfos, int maxSegmentCount, Map<SegmentCommitInfo, Boolean> segmentsToMerge, IndexWriter writer) throws IOException {
        return this.inner.findForcedMerges(segmentInfos, maxSegmentCount, segmentsToMerge, writer);
    }

    public MergePolicy.MergeSpecification findMerges(MergeTrigger mergeTrigger, SegmentInfos segmentInfos, IndexWriter writer) throws IOException {
        return this.inner.findMerges(mergeTrigger, segmentInfos, writer);
    }

    public boolean useCompoundFile(SegmentInfos infos, SegmentCommitInfo mergedInfo, IndexWriter writer) throws IOException {
        return this.inner.useCompoundFile(infos, mergedInfo, writer);
    }
}

