/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.linalg;

import breeze.linalg.SparseVector;
import breeze.storage.Zero;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vector$class;
import org.apache.spark.ml.linalg.Vectors$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.mutable.IndexedSeq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\u0001\u0003\u00015\u0011Ab\u00159beN,g+Z2u_JT!a\u0001\u0003\u0002\r1Lg.\u00197h\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+Yi\u0011AA\u0005\u0003/\t\u0011aAV3di>\u0014\b\u0002C\r\u0001\u0005\u000b\u0007I\u0011\t\u000e\u0002\tML'0Z\u000b\u00027A\u0011q\u0002H\u0005\u0003;A\u00111!\u00138u\u0011!y\u0002A!A!\u0002\u0013Y\u0012!B:ju\u0016\u0004\u0003\u0002C\u0011\u0001\u0005\u000b\u0007I\u0011\u0001\u0012\u0002\u000f%tG-[2fgV\t1\u0005E\u0002\u0010ImI!!\n\t\u0003\u000b\u0005\u0013(/Y=)\u0007\u0001:S\u0006\u0005\u0002)W5\t\u0011F\u0003\u0002+\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u00051J#!B*j]\u000e,\u0017%\u0001\u0018\u0002\u000bIr\u0003G\f\u0019\t\u0011A\u0002!\u0011!Q\u0001\n\r\n\u0001\"\u001b8eS\u000e,7\u000f\t\u0015\u0004_\u001dj\u0003\u0002C\u001a\u0001\u0005\u000b\u0007I\u0011\u0001\u001b\u0002\rY\fG.^3t+\u0005)\u0004cA\b%mA\u0011qbN\u0005\u0003qA\u0011a\u0001R8vE2,\u0007f\u0001\u001a([!A1\b\u0001B\u0001B\u0003%Q'A\u0004wC2,Xm\u001d\u0011)\u0007i:S\u0006C\u0003?\u0001\u0011\u0005q(\u0001\u0004=S:LGO\u0010\u000b\u0005\u0001\u0006\u0013E\t\u0005\u0002\u0016\u0001!)\u0011$\u0010a\u00017!)\u0011%\u0010a\u0001G!\u001a!iJ\u0017\t\u000bMj\u0004\u0019A\u001b)\u0007\u0011;S\u0006K\u0002>O5BQ\u0001\u0013\u0001\u0005B%\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0002\u0015B\u00111J\u0014\b\u0003\u001f1K!!\u0014\t\u0002\rA\u0013X\rZ3g\u0013\ty\u0005K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001bBAQA\u0015\u0001\u0005BQ\nq\u0001^8BeJ\f\u0017\u0010C\u0003U\u0001\u0011\u0005S+\u0001\u0003d_BLX#\u0001!\t\r]\u0003A\u0011\t\u0004Y\u0003!\t7O\u0011:fKj,W#A-\u0011\u0007isf'D\u0001\\\u0015\t\u0019ALC\u0001^\u0003\u0019\u0011'/Z3{K&\u0011qc\u0017\u0005\u0006A\u0002!\t%Y\u0001\u000eM>\u0014X-Y2i\u0003\u000e$\u0018N^3\u0015\u0005\t,\u0007CA\bd\u0013\t!\u0007C\u0001\u0003V]&$\b\"\u00024`\u0001\u00049\u0017!\u00014\u0011\u000b=A7D\u000e2\n\u0005%\u0004\"!\u0003$v]\u000e$\u0018n\u001c83\u0011\u0015Y\u0007\u0001\"\u0011m\u0003\u0019)\u0017/^1mgR\u0011Q\u000e\u001d\t\u0003\u001f9L!a\u001c\t\u0003\u000f\t{w\u000e\\3b]\")\u0011O\u001ba\u0001e\u0006)q\u000e\u001e5feB\u0011qb]\u0005\u0003iB\u00111!\u00118z\u0011\u00151\b\u0001\"\u0011x\u0003!A\u0017m\u001d5D_\u0012,G#A\u000e\t\u000be\u0004A\u0011\t\u000e\u0002\u00159,X.Q2uSZ,7\u000fC\u0003|\u0001\u0011\u0005#$A\u0006ok6tuN\u001c>fe>\u001c\b\"B?\u0001\t\u0003*\u0016\u0001\u0003;p'B\f'o]3\t\u000b}\u0004A\u0011\t\u000e\u0002\r\u0005\u0014x-\\1y\u0011!\t\u0019\u0001\u0001C\u0001\r\u0005\u0015\u0011!B:mS\u000e,Gc\u0001!\u0002\b!9\u0011\u0011BA\u0001\u0001\u0004\u0019\u0013aD:fY\u0016\u001cG/\u001a3J]\u0012L7-Z:)\u0007\u00019SfB\u0004\u0002\u0010\tA\t!!\u0005\u0002\u0019M\u0003\u0018M]:f-\u0016\u001cGo\u001c:\u0011\u0007U\t\u0019B\u0002\u0004\u0002\u0005!\u0005\u0011QC\n\u0006\u0003'q\u0011q\u0003\t\u0004\u001f\u0005e\u0011bAA\u000e!\ta1+\u001a:jC2L'0\u00192mK\"9a(a\u0005\u0005\u0002\u0005}ACAA\t\u0011!\t\u0019#a\u0005\u0005\u0002\u0005\u0015\u0012aB;oCB\u0004H.\u001f\u000b\u0005\u0003O\t\u0019\u0004E\u0003\u0010\u0003S\ti#C\u0002\u0002,A\u0011aa\u00149uS>t\u0007CB\b\u00020m\u0019S'C\u0002\u00022A\u0011a\u0001V;qY\u0016\u001c\u0004bBA\u001b\u0003C\u0001\r\u0001Q\u0001\u0003gZDC!!\t([!Q\u00111HA\n\u0003\u0003%I!!\u0010\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u007f\u0001B!!\u0011\u0002L5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%\u0001\u0003mC:<'BAA%\u0003\u0011Q\u0017M^1\n\t\u00055\u00131\t\u0002\u0007\u001f\nTWm\u0019;)\t\u0005Mq%\f\u0015\u0005\u0003\u001b9S\u0006")
public class SparseVector
implements Vector {
    private final int size;
    private final int[] indices;
    private final double[] values;

    public static Option<Tuple3<Object, int[], double[]>> unapply(SparseVector sparseVector) {
        return SparseVector$.MODULE$.unapply(sparseVector);
    }

    @Override
    public double apply(int i) {
        return Vector$class.apply(this, i);
    }

    @Override
    public DenseVector toDense() {
        return Vector$class.toDense(this);
    }

    @Override
    public Vector compressed() {
        return Vector$class.compressed(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    public int[] indices() {
        return this.indices;
    }

    public double[] values() {
        return this.values;
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ",", ",", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.size()), Predef$.MODULE$.intArrayOps(this.indices()).mkString("[", ",", "]"), Predef$.MODULE$.doubleArrayOps(this.values()).mkString("[", ",", "]")}));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] toArray() {
        void var1_1;
        double[] data = new double[this.size()];
        int nnz = this.indices().length;
        for (int i = 0; i < nnz; ++i) {
            data[this.indices()[i]] = this.values()[i];
        }
        return var1_1;
    }

    @Override
    public SparseVector copy() {
        return new SparseVector(this.size(), (int[])this.indices().clone(), (double[])this.values().clone());
    }

    @Override
    public breeze.linalg.Vector<Object> asBreeze() {
        return new SparseVector.mcD.sp(this.indices(), this.values(), this.size(), (Zero)Zero.DoubleZero$.MODULE$);
    }

    @Override
    public void foreachActive(Function2<Object, Object, BoxedUnit> f) {
        int localValuesSize = this.values().length;
        int[] localIndices = this.indices();
        double[] localValues = this.values();
        for (int i = 0; i < localValuesSize; ++i) {
            f.apply$mcVID$sp(localIndices[i], localValues[i]);
        }
    }

    @Override
    public boolean equals(Object other) {
        return Vector$class.equals(this, other);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int result = 31 + this.size();
        int end = this.values().length;
        int nnz = 0;
        for (int k = 0; k < end && nnz < Vectors$.MODULE$.MAX_HASH_NNZ(); ++k) {
            double v = this.values()[k];
            if (v == 0.0) continue;
            int i = this.indices()[k];
            result = 31 * result + i;
            long bits = Double.doubleToLongBits(v);
            result = 31 * result + (int)(bits ^ bits >>> 32);
            ++nnz;
        }
        return (int)var1_1;
    }

    @Override
    public int numActives() {
        return this.values().length;
    }

    @Override
    public int numNonzeros() {
        IntRef nnz = new IntRef(0);
        Predef$.MODULE$.doubleArrayOps(this.values()).foreach((Function1)new Serializable(this, nnz){
            public static final long serialVersionUID = 0L;
            private final IntRef nnz$3;

            public final void apply(double v) {
                this.apply$mcVD$sp(v);
            }

            public void apply$mcVD$sp(double v) {
                if (v != 0.0) {
                    ++this.nnz$3.elem;
                }
            }
            {
                this.nnz$3 = nnz$3;
            }
        });
        return nnz.elem;
    }

    @Override
    public SparseVector toSparse() {
        SparseVector sparseVector;
        int nnz = this.numNonzeros();
        if (nnz == this.numActives()) {
            sparseVector = this;
        } else {
            int[] ii = new int[nnz];
            double[] vv = new double[nnz];
            IntRef k = new IntRef(0);
            this.foreachActive((Function2<Object, Object, BoxedUnit>)new Serializable(this, ii, vv, k){
                public static final long serialVersionUID = 0L;
                private final int[] ii$2;
                private final double[] vv$2;
                private final IntRef k$2;

                public final void apply(int i, double v) {
                    this.apply$mcVID$sp(i, v);
                }

                public void apply$mcVID$sp(int i, double v) {
                    if (v != 0.0) {
                        this.ii$2[this.k$2.elem] = i;
                        this.vv$2[this.k$2.elem] = v;
                        ++this.k$2.elem;
                    }
                }
                {
                    this.ii$2 = ii$2;
                    this.vv$2 = vv$2;
                    this.k$2 = k$2;
                }
            });
            sparseVector = new SparseVector(this.size(), ii, vv);
        }
        return sparseVector;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int argmax() {
        int n;
        if (this.size() == 0) {
            n = -1;
        } else {
            void var1_1;
            int maxIdx = this.indices()[0];
            double maxValue = this.values()[0];
            int maxJ = 0;
            int na = this.numActives();
            for (int j = 1; j < na; ++j) {
                double v = this.values()[j];
                if (!(v > maxValue)) continue;
                maxValue = v;
                maxIdx = this.indices()[j];
                maxJ = j;
            }
            if (maxValue <= 0.0 && na < this.size()) {
                if (maxValue == 0.0) {
                    if (maxJ < maxIdx) {
                        int k;
                        for (k = 0; k < maxJ && this.indices()[k] == k; ++k) {
                        }
                        maxIdx = k;
                    }
                } else {
                    int k;
                    for (k = 0; k < na && this.indices()[k] == k; ++k) {
                    }
                    maxIdx = k;
                }
            }
            n = var1_1;
        }
        return n;
    }

    public SparseVector slice(int[] selectedIndices) {
        IntRef currentIdx = new IntRef(0);
        Tuple2 tuple2 = Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.intArrayOps(selectedIndices).flatMap((Function1)new $anonfun$4(this, currentIdx), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).unzip((Function1)Predef$.MODULE$.conforms());
        if (tuple2 != null) {
            Tuple2 tuple22;
            IndexedSeq sliceInds = (IndexedSeq)tuple2._1();
            IndexedSeq sliceVals = (IndexedSeq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)sliceInds, (Object)sliceVals);
            IndexedSeq sliceInds2 = (IndexedSeq)tuple23._1();
            IndexedSeq sliceVals2 = (IndexedSeq)tuple23._2();
            return new SparseVector(selectedIndices.length, (int[])sliceInds2.toArray(ClassTag$.MODULE$.Int()), (double[])sliceVals2.toArray(ClassTag$.MODULE$.Double()));
        }
        throw new MatchError((Object)tuple2);
    }

    public SparseVector(int size, int[] indices, double[] values) {
        this.size = size;
        this.indices = indices;
        this.values = values;
        Vector$class.$init$(this);
        Predef$.MODULE$.require(indices.length == values.length, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparseVector $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Sparse vectors require that the dimension of the").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" indices match the dimension of the values. You provided ", " indices and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.indices().length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " values."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.values().length)}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(indices.length <= size, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparseVector $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You provided ", " indices and values, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.indices().length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"which exceeds the specified vector size ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.size())}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

