/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.attribute;

import java.util.NoSuchElementException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.Attribute$;
import org.apache.spark.ml.attribute.AttributeType;
import org.apache.spark.ml.attribute.AttributeType$;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.BinaryAttribute$;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NominalAttribute$;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.attribute.NumericAttribute$;
import org.apache.spark.ml.attribute.UnresolvedAttribute$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]1A!\u0001\u0002\u0001\u001b\tq\u0011\t\u001e;sS\n,H/Z*vSR,'BA\u0002\u0005\u0003%\tG\u000f\u001e:jEV$XM\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011C\u0001\u0001\u000f!\ty\u0001#D\u0001\u0007\u0013\t\tbAA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\t\u0001")
public class AttributeSuite
extends SparkFunSuite {
    public AttributeSuite() {
        this.test("default numeric attribute", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AttributeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NumericAttribute attr = NumericAttribute$.MODULE$.defaultAttr();
                Metadata metadata = Metadata$.MODULE$.fromJson("{}");
                Metadata metadataWithType = Metadata$.MODULE$.fromJson("{\"type\":\"numeric\"}");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(attr.attrType());
                AttributeType $org_scalatest_assert_macro_right = AttributeType$.MODULE$.Numeric();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(attr.isNumeric(), "attr.isNumeric");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(attr.isNominal(), "attr.isNominal"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Option $org_scalatest_assert_macro_left2 = attr.name();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Option $org_scalatest_assert_macro_left3 = attr.index();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Option $org_scalatest_assert_macro_left4 = attr.min();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Option $org_scalatest_assert_macro_left5 = attr.max();
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Option $org_scalatest_assert_macro_left6 = attr.std();
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                Option $org_scalatest_assert_macro_left7 = attr.sparsity();
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left7, "isEmpty", $org_scalatest_assert_macro_left7.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(attr.toMetadataImpl());
                Metadata $org_scalatest_assert_macro_right2 = metadata;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(attr.toMetadataImpl(false));
                Metadata $org_scalatest_assert_macro_right3 = metadata;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(attr.toMetadataImpl(true));
                Metadata $org_scalatest_assert_macro_right4 = metadataWithType;
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(attr);
                Attribute $org_scalatest_assert_macro_right5 = Attribute$.MODULE$.fromMetadata(metadata);
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.$outer.convertToEqualizer(attr);
                Attribute $org_scalatest_assert_macro_right6 = Attribute$.MODULE$.fromMetadata(metadataWithType);
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, attr){
                    public static final long serialVersionUID = 0L;
                    private final NumericAttribute attr$1;

                    public final StructField apply() {
                        return this.attr$1.toStructField();
                    }
                    {
                        this.attr$1 = attr$1;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchElementException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("customized numeric attribute", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AttributeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String name = "age";
                int index = 0;
                Metadata metadata = Metadata$.MODULE$.fromJson("{\"name\":\"age\",\"idx\":0}");
                Metadata metadataWithType = Metadata$.MODULE$.fromJson("{\"type\":\"numeric\",\"name\":\"age\",\"idx\":0}");
                NumericAttribute attr = NumericAttribute$.MODULE$.defaultAttr().withName(name).withIndex(index);
                AttributeType $org_scalatest_assert_macro_left = attr.attrType();
                AttributeType $org_scalatest_assert_macro_right = AttributeType$.MODULE$.Numeric();
                AttributeType attributeType = $org_scalatest_assert_macro_left;
                AttributeType attributeType2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(attributeType != null ? !attributeType.equals(attributeType2) : attributeType2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(attr.isNumeric(), "attr.isNumeric");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(attr.isNominal(), "attr.isNominal"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(attr.name());
                Some $org_scalatest_assert_macro_right2 = new Some((Object)name);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(attr.index());
                Some $org_scalatest_assert_macro_right3 = new Some((Object)BoxesRunTime.boxToInteger((int)index));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(attr.toMetadataImpl());
                Metadata $org_scalatest_assert_macro_right4 = metadata;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(attr.toMetadataImpl(false));
                Metadata $org_scalatest_assert_macro_right5 = metadata;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(attr.toMetadataImpl(true));
                Metadata $org_scalatest_assert_macro_right6 = metadataWithType;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(attr);
                Attribute $org_scalatest_assert_macro_right7 = Attribute$.MODULE$.fromMetadata(metadata);
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(attr);
                Attribute $org_scalatest_assert_macro_right8 = Attribute$.MODULE$.fromMetadata(metadataWithType);
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                StructField field = attr.toStructField();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(field.dataType());
                DoubleType$ $org_scalatest_assert_macro_right9 = DoubleType$.MODULE$;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(field.nullable(), "field.nullable"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(attr.withoutIndex());
                Attribute $org_scalatest_assert_macro_right10 = Attribute$.MODULE$.fromStructField(field);
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
                Metadata existingMetadata = new MetadataBuilder().putString("name", "test").build();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(attr.toStructField(existingMetadata).metadata().getString("name"));
                String $org_scalatest_assert_macro_right11 = "test";
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"");
                NumericAttribute attr2 = attr.withoutName().withoutIndex().withMin(0.0).withMax(1.0).withStd(0.5).withSparsity(0.3);
                Option $org_scalatest_assert_macro_left12 = attr2.name();
                Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left12, "isEmpty", $org_scalatest_assert_macro_left12.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"");
                Option $org_scalatest_assert_macro_left13 = attr2.index();
                Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left13, "isEmpty", $org_scalatest_assert_macro_left13.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.$outer.convertToEqualizer(attr2.min());
                Some $org_scalatest_assert_macro_right12 = new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
                Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left15 = this.$outer.convertToEqualizer(attr2.max());
                Some $org_scalatest_assert_macro_right13 = new Some((Object)BoxesRunTime.boxToDouble((double)1.0));
                Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "===", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left15.$eq$eq$eq((Object)$org_scalatest_assert_macro_right13, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left16 = this.$outer.convertToEqualizer(attr2.std());
                Some $org_scalatest_assert_macro_right14 = new Some((Object)BoxesRunTime.boxToDouble((double)0.5));
                Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "===", (Object)$org_scalatest_assert_macro_right14, $org_scalatest_assert_macro_left16.$eq$eq$eq((Object)$org_scalatest_assert_macro_right14, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left17 = this.$outer.convertToEqualizer(attr2.sparsity());
                Some $org_scalatest_assert_macro_right15 = new Some((Object)BoxesRunTime.boxToDouble((double)0.3));
                Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "===", (Object)$org_scalatest_assert_macro_right15, $org_scalatest_assert_macro_left17.$eq$eq$eq((Object)$org_scalatest_assert_macro_right15, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left18 = this.$outer.convertToEqualizer(attr2);
                Attribute $org_scalatest_assert_macro_right16 = Attribute$.MODULE$.fromMetadata(attr2.toMetadataImpl());
                Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left18, "===", (Object)$org_scalatest_assert_macro_right16, $org_scalatest_assert_macro_left18.$eq$eq$eq((Object)$org_scalatest_assert_macro_right16, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("bad numeric attributes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AttributeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NumericAttribute attr = NumericAttribute$.MODULE$.defaultAttr();
                this.$outer.intercept((Function0)new Serializable(this, attr){
                    public static final long serialVersionUID = 0L;
                    private final NumericAttribute attr$2;

                    public final NumericAttribute apply() {
                        return this.attr$2.withName("");
                    }
                    {
                        this.attr$2 = attr$2;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, attr){
                    public static final long serialVersionUID = 0L;
                    private final NumericAttribute attr$2;

                    public final NumericAttribute apply() {
                        return this.attr$2.withIndex(-1);
                    }
                    {
                        this.attr$2 = attr$2;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, attr){
                    public static final long serialVersionUID = 0L;
                    private final NumericAttribute attr$2;

                    public final NumericAttribute apply() {
                        return this.attr$2.withStd(-0.1);
                    }
                    {
                        this.attr$2 = attr$2;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, attr){
                    public static final long serialVersionUID = 0L;
                    private final NumericAttribute attr$2;

                    public final NumericAttribute apply() {
                        return this.attr$2.withSparsity(-0.5);
                    }
                    {
                        this.attr$2 = attr$2;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, attr){
                    public static final long serialVersionUID = 0L;
                    private final NumericAttribute attr$2;

                    public final NumericAttribute apply() {
                        return this.attr$2.withSparsity(1.5);
                    }
                    {
                        this.attr$2 = attr$2;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("default nominal attribute", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AttributeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NominalAttribute attr = NominalAttribute$.MODULE$.defaultAttr();
                Metadata metadata = Metadata$.MODULE$.fromJson("{\"type\":\"nominal\"}");
                Metadata metadataWithoutType = Metadata$.MODULE$.fromJson("{}");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(attr.attrType());
                AttributeType $org_scalatest_assert_macro_right = AttributeType$.MODULE$.Nominal();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(attr.isNumeric(), "attr.isNumeric"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(attr.isNominal(), "attr.isNominal");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Option $org_scalatest_assert_macro_left2 = attr.name();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Option $org_scalatest_assert_macro_left3 = attr.index();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Option $org_scalatest_assert_macro_left4 = attr.values();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Option $org_scalatest_assert_macro_left5 = attr.numValues();
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Option $org_scalatest_assert_macro_left6 = attr.isOrdinal();
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(attr.toMetadataImpl());
                Metadata $org_scalatest_assert_macro_right2 = metadata;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(attr.toMetadataImpl(true));
                Metadata $org_scalatest_assert_macro_right3 = metadata;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(attr.toMetadataImpl(false));
                Metadata $org_scalatest_assert_macro_right4 = metadataWithoutType;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(attr);
                Attribute $org_scalatest_assert_macro_right5 = Attribute$.MODULE$.fromMetadata(metadata);
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(attr);
                NominalAttribute $org_scalatest_assert_macro_right6 = NominalAttribute$.MODULE$.fromMetadata(metadataWithoutType);
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, attr){
                    public static final long serialVersionUID = 0L;
                    private final NominalAttribute attr$3;

                    public final StructField apply() {
                        return this.attr$3.toStructField();
                    }
                    {
                        this.attr$3 = attr$3;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchElementException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("customized nominal attribute", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AttributeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String name = "size";
                int index = 1;
                String[] values = (String[])((Object[])new String[]{"small", "medium", "large"});
                Metadata metadata = Metadata$.MODULE$.fromJson("{\"type\":\"nominal\",\"name\":\"size\",\"idx\":1,\"vals\":[\"small\",\"medium\",\"large\"]}");
                Metadata metadataWithoutType = Metadata$.MODULE$.fromJson("{\"name\":\"size\",\"idx\":1,\"vals\":[\"small\",\"medium\",\"large\"]}");
                NominalAttribute attr = NominalAttribute$.MODULE$.defaultAttr().withName(name).withIndex(index).withValues(values);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(attr.attrType());
                AttributeType $org_scalatest_assert_macro_right = AttributeType$.MODULE$.Nominal();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(attr.isNumeric(), "attr.isNumeric"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(attr.isNominal(), "attr.isNominal");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(attr.name());
                Some $org_scalatest_assert_macro_right2 = new Some((Object)name);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(attr.index());
                Some $org_scalatest_assert_macro_right3 = new Some((Object)BoxesRunTime.boxToInteger((int)index));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(attr.values());
                Some $org_scalatest_assert_macro_right4 = new Some((Object)values);
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)attr.indexOf("medium")));
                int $org_scalatest_assert_macro_right5 = 1;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(attr.getValue(1));
                String $org_scalatest_assert_macro_right6 = "medium";
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(attr.toMetadataImpl());
                Metadata $org_scalatest_assert_macro_right7 = metadata;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(attr.toMetadataImpl(true));
                Metadata $org_scalatest_assert_macro_right8 = metadata;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(attr.toMetadataImpl(false));
                Metadata $org_scalatest_assert_macro_right9 = metadataWithoutType;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(attr);
                Attribute $org_scalatest_assert_macro_right10 = Attribute$.MODULE$.fromMetadata(metadata);
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(attr);
                NominalAttribute $org_scalatest_assert_macro_right11 = NominalAttribute$.MODULE$.fromMetadata(metadataWithoutType);
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.$outer.convertToEqualizer(attr.withoutIndex());
                Attribute $org_scalatest_assert_macro_right12 = Attribute$.MODULE$.fromStructField(attr.toStructField());
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"");
                NominalAttribute attr2 = attr.withoutName().withoutIndex().withValues((String[])Predef$.MODULE$.refArrayOps((Object[])attr.values().get()).$colon$plus((Object)"x-large", Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
                Option $org_scalatest_assert_macro_left13 = attr2.name();
                Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left13, "isEmpty", $org_scalatest_assert_macro_left13.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"");
                Option $org_scalatest_assert_macro_left14 = attr2.index();
                Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left14, "isEmpty", $org_scalatest_assert_macro_left14.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left15 = this.$outer.convertToEqualizer(attr2.values().get());
                String[] $org_scalatest_assert_macro_right13 = (String[])((Object[])new String[]{"small", "medium", "large", "x-large"});
                Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "===", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left15.$eq$eq$eq((Object)$org_scalatest_assert_macro_right13, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left16 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)attr2.indexOf("x-large")));
                int $org_scalatest_assert_macro_right14 = 3;
                Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left16.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left17 = this.$outer.convertToEqualizer(attr2);
                Attribute $org_scalatest_assert_macro_right15 = Attribute$.MODULE$.fromMetadata(attr2.toMetadataImpl());
                Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "===", (Object)$org_scalatest_assert_macro_right15, $org_scalatest_assert_macro_left17.$eq$eq$eq((Object)$org_scalatest_assert_macro_right15, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left18 = this.$outer.convertToEqualizer(attr2);
                NominalAttribute $org_scalatest_assert_macro_right16 = NominalAttribute$.MODULE$.fromMetadata(attr2.toMetadataImpl(false));
                Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left18, "===", (Object)$org_scalatest_assert_macro_right16, $org_scalatest_assert_macro_left18.$eq$eq$eq((Object)$org_scalatest_assert_macro_right16, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("bad nominal attributes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AttributeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NominalAttribute attr = NominalAttribute$.MODULE$.defaultAttr();
                this.$outer.intercept((Function0)new Serializable(this, attr){
                    public static final long serialVersionUID = 0L;
                    private final NominalAttribute attr$4;

                    public final NominalAttribute apply() {
                        return this.attr$4.withName("");
                    }
                    {
                        this.attr$4 = attr$4;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, attr){
                    public static final long serialVersionUID = 0L;
                    private final NominalAttribute attr$4;

                    public final NominalAttribute apply() {
                        return this.attr$4.withIndex(-1);
                    }
                    {
                        this.attr$4 = attr$4;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, attr){
                    public static final long serialVersionUID = 0L;
                    private final NominalAttribute attr$4;

                    public final NominalAttribute apply() {
                        return this.attr$4.withNumValues(-1);
                    }
                    {
                        this.attr$4 = attr$4;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("default binary attribute", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AttributeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                BinaryAttribute attr = BinaryAttribute$.MODULE$.defaultAttr();
                Metadata metadata = Metadata$.MODULE$.fromJson("{\"type\":\"binary\"}");
                Metadata metadataWithoutType = Metadata$.MODULE$.fromJson("{}");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(attr.attrType());
                AttributeType $org_scalatest_assert_macro_right = AttributeType$.MODULE$.Binary();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(attr.isNumeric(), "attr.isNumeric");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(attr.isNominal(), "attr.isNominal");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Option $org_scalatest_assert_macro_left2 = attr.name();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Option $org_scalatest_assert_macro_left3 = attr.index();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Option $org_scalatest_assert_macro_left4 = attr.values();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(attr.toMetadataImpl());
                Metadata $org_scalatest_assert_macro_right2 = metadata;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(attr.toMetadataImpl(true));
                Metadata $org_scalatest_assert_macro_right3 = metadata;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(attr.toMetadataImpl(false));
                Metadata $org_scalatest_assert_macro_right4 = metadataWithoutType;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(attr);
                Attribute $org_scalatest_assert_macro_right5 = Attribute$.MODULE$.fromMetadata(metadata);
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(attr);
                BinaryAttribute $org_scalatest_assert_macro_right6 = BinaryAttribute$.MODULE$.fromMetadata(metadataWithoutType);
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, attr){
                    public static final long serialVersionUID = 0L;
                    private final BinaryAttribute attr$5;

                    public final StructField apply() {
                        return this.attr$5.toStructField();
                    }
                    {
                        this.attr$5 = attr$5;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchElementException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("customized binary attribute", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AttributeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String name = "clicked";
                int index = 2;
                String[] values = (String[])((Object[])new String[]{"no", "yes"});
                Metadata metadata = Metadata$.MODULE$.fromJson("{\"type\":\"binary\",\"name\":\"clicked\",\"idx\":2,\"vals\":[\"no\",\"yes\"]}");
                Metadata metadataWithoutType = Metadata$.MODULE$.fromJson("{\"name\":\"clicked\",\"idx\":2,\"vals\":[\"no\",\"yes\"]}");
                BinaryAttribute attr = BinaryAttribute$.MODULE$.defaultAttr().withName(name).withIndex(index).withValues(values[0], values[1]);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(attr.attrType());
                AttributeType $org_scalatest_assert_macro_right = AttributeType$.MODULE$.Binary();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(attr.isNumeric(), "attr.isNumeric");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(attr.isNominal(), "attr.isNominal");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(attr.name());
                Some $org_scalatest_assert_macro_right2 = new Some((Object)name);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(attr.index());
                Some $org_scalatest_assert_macro_right3 = new Some((Object)BoxesRunTime.boxToInteger((int)index));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(attr.values().get());
                String[] $org_scalatest_assert_macro_right4 = values;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(attr.toMetadataImpl());
                Metadata $org_scalatest_assert_macro_right5 = metadata;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(attr.toMetadataImpl(true));
                Metadata $org_scalatest_assert_macro_right6 = metadata;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(attr.toMetadataImpl(false));
                Metadata $org_scalatest_assert_macro_right7 = metadataWithoutType;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(attr);
                Attribute $org_scalatest_assert_macro_right8 = Attribute$.MODULE$.fromMetadata(metadata);
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(attr);
                BinaryAttribute $org_scalatest_assert_macro_right9 = BinaryAttribute$.MODULE$.fromMetadata(metadataWithoutType);
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(attr.withoutIndex());
                Attribute $org_scalatest_assert_macro_right10 = Attribute$.MODULE$.fromStructField(attr.toStructField());
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("bad binary attributes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AttributeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                BinaryAttribute attr = BinaryAttribute$.MODULE$.defaultAttr();
                this.$outer.intercept((Function0)new Serializable(this, attr){
                    public static final long serialVersionUID = 0L;
                    private final BinaryAttribute attr$6;

                    public final BinaryAttribute apply() {
                        return this.attr$6.withName("");
                    }
                    {
                        this.attr$6 = attr$6;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, attr){
                    public static final long serialVersionUID = 0L;
                    private final BinaryAttribute attr$6;

                    public final BinaryAttribute apply() {
                        return this.attr$6.withIndex(-1);
                    }
                    {
                        this.attr$6 = attr$6;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("attribute from struct field", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AttributeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Metadata metadata = NumericAttribute$.MODULE$.defaultAttr().withName("label").toMetadata();
                StructField fldWithoutMeta = new StructField("x", (DataType)DoubleType$.MODULE$, false, Metadata$.MODULE$.empty());
                Attribute $org_scalatest_assert_macro_left = Attribute$.MODULE$.fromStructField(fldWithoutMeta);
                UnresolvedAttribute$ $org_scalatest_assert_macro_right = UnresolvedAttribute$.MODULE$;
                Attribute attribute = $org_scalatest_assert_macro_left;
                UnresolvedAttribute$ unresolvedAttribute$ = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(attribute != null ? !attribute.equals(unresolvedAttribute$) : unresolvedAttribute$ != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                StructField fldWithMeta = new StructField("x", (DataType)DoubleType$.MODULE$, false, metadata);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Attribute$.MODULE$.fromStructField(fldWithMeta).isNumeric(), "Attribute.fromStructField(fldWithMeta).isNumeric");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                StructField longFldWithMeta = new StructField("x", (DataType)LongType$.MODULE$, false, metadata);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Attribute$.MODULE$.fromStructField(longFldWithMeta).isNumeric(), "Attribute.fromStructField(longFldWithMeta).isNumeric");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                StructField decimalFldWithMeta = new StructField("x", (DataType)new DecimalType(38, 18), false, metadata);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Attribute$.MODULE$.fromStructField(decimalFldWithMeta).isNumeric(), "Attribute.fromStructField(decimalFldWithMeta).isNumeric");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

