/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel$;
import org.apache.spark.ml.classification.DecisionTreeClassifier;
import org.apache.spark.ml.impl.TreeTests$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.DecisionTree$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public final class DecisionTreeClassifierSuite$
extends SparkFunSuite {
    public static final DecisionTreeClassifierSuite$ MODULE$;

    static {
        new DecisionTreeClassifierSuite$();
    }

    public void compareAPIs(RDD<LabeledPoint> data, DecisionTreeClassifier dt, Map<Object, Object> categoricalFeatures, int numClasses) {
        int numFeatures = ((LabeledPoint)data.first()).features().size();
        Strategy oldStrategy = dt.getOldStrategy(categoricalFeatures, numClasses);
        DecisionTreeModel oldTree = DecisionTree$.MODULE$.train(data, oldStrategy);
        DataFrame newData = TreeTests$.MODULE$.setMetadata(data, categoricalFeatures, numClasses);
        DecisionTreeClassificationModel newTree = (DecisionTreeClassificationModel)dt.fit(newData);
        DecisionTreeClassificationModel oldTreeAsNew = DecisionTreeClassificationModel$.MODULE$.fromOld(oldTree, (DecisionTreeClassifier)newTree.parent(), categoricalFeatures, DecisionTreeClassificationModel$.MODULE$.fromOld$default$4());
        TreeTests$.MODULE$.checkEqual((org.apache.spark.ml.tree.DecisionTreeModel)oldTreeAsNew, (org.apache.spark.ml.tree.DecisionTreeModel)newTree);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)newTree.numFeatures()));
        int $org_scalatest_assert_macro_right = numFeatures;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DecisionTreeClassifierSuite$() {
        MODULE$ = this;
    }
}

