/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.classification.DecisionTreeClassifier;
import org.apache.spark.ml.classification.DecisionTreeClassifier$;
import org.apache.spark.ml.classification.DecisionTreeClassifierSuite$;
import org.apache.spark.ml.classification.DecisionTreeClassifierSuite$$anonfun$3$;
import org.apache.spark.ml.impl.TreeTests$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.ml.tree.LeafNode;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.DecisionTreeSuite$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0001\u0003\u00015\u00111\u0004R3dSNLwN\u001c+sK\u0016\u001cE.Y:tS\u001aLWM]*vSR,'BA\u0002\u0005\u00039\u0019G.Y:tS\u001aL7-\u0019;j_:T!!\u0002\u0004\u0002\u00055d'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\n\u0011\u0005=\u0001R\"\u0001\u0004\n\u0005E1!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u0005!Q\u000f^5m\u0015\t9b!A\u0003nY2L'-\u0003\u0002\u001a)\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\b\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011%\u0001\u0003\u00011AA\u0002\u0013%\u0011%\u0001\rdCR,wm\u001c:jG\u0006dG)\u0019;b!>Lg\u000e^:S\t\u0012+\u0012A\t\t\u0004G\u0019BS\"\u0001\u0013\u000b\u0005\u00152\u0011a\u0001:eI&\u0011q\u0005\n\u0002\u0004%\u0012#\u0005CA\u0015-\u001b\u0005Q#BA\u0016\u0017\u0003)\u0011Xm\u001a:fgNLwN\\\u0005\u0003[)\u0012A\u0002T1cK2,G\rU8j]RD\u0011b\f\u0001A\u0002\u0003\u0007I\u0011\u0002\u0019\u00029\r\fG/Z4pe&\u001c\u0017\r\u001c#bi\u0006\u0004v.\u001b8ugJ#Ei\u0018\u0013fcR\u0011\u0011g\u000e\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0005+:LG\u000fC\u00049]\u0005\u0005\t\u0019\u0001\u0012\u0002\u0007a$\u0013\u0007\u0003\u0004;\u0001\u0001\u0006KAI\u0001\u001aG\u0006$XmZ8sS\u000e\fG\u000eR1uCB{\u0017N\u001c;t%\u0012#\u0005\u0005C\u0005=\u0001\u0001\u0007\t\u0019!C\u0005C\u0005\tsN\u001d3fe\u0016$G*\u00192fY\u0016$\u0007k\\5oiN<\u0016\u000e\u001e5MC\n,G\u000e\r*E\t\"Ia\b\u0001a\u0001\u0002\u0004%IaP\u0001&_J$WM]3e\u0019\u0006\u0014W\r\\3e!>Lg\u000e^:XSRDG*\u00192fYB\u0012F\tR0%KF$\"!\r!\t\u000faj\u0014\u0011!a\u0001E!1!\t\u0001Q!\n\t\n!e\u001c:eKJ,G\rT1cK2,G\rU8j]R\u001cx+\u001b;i\u0019\u0006\u0014W\r\u001c\u0019S\t\u0012\u0003\u0003\"\u0003#\u0001\u0001\u0004\u0005\r\u0011\"\u0003\"\u0003\u0005z'\u000fZ3sK\u0012d\u0015MY3mK\u0012\u0004v.\u001b8ug^KG\u000f\u001b'bE\u0016d\u0017G\u0015#E\u0011%1\u0005\u00011AA\u0002\u0013%q)A\u0013pe\u0012,'/\u001a3MC\n,G.\u001a3Q_&tGo],ji\"d\u0015MY3mcI#Ei\u0018\u0013fcR\u0011\u0011\u0007\u0013\u0005\bq\u0015\u000b\t\u00111\u0001#\u0011\u0019Q\u0005\u0001)Q\u0005E\u0005\u0011sN\u001d3fe\u0016$G*\u00192fY\u0016$\u0007k\\5oiN<\u0016\u000e\u001e5MC\n,G.\r*E\t\u0002B\u0011\u0002\u0014\u0001A\u0002\u0003\u0007I\u0011B\u0011\u0002K\r\fG/Z4pe&\u001c\u0017\r\u001c#bi\u0006\u0004v.\u001b8ug\u001a{'/T;mi&\u001cG.Y:t%\u0012#\u0005\"\u0003(\u0001\u0001\u0004\u0005\r\u0011\"\u0003P\u0003%\u001a\u0017\r^3h_JL7-\u00197ECR\f\u0007k\\5oiN4uN]'vYRL7\r\\1tgJ#Ei\u0018\u0013fcR\u0011\u0011\u0007\u0015\u0005\bq5\u000b\t\u00111\u0001#\u0011\u0019\u0011\u0006\u0001)Q\u0005E\u000513-\u0019;fO>\u0014\u0018nY1m\t\u0006$\u0018\rU8j]R\u001chi\u001c:Nk2$\u0018n\u00197bgN\u0014F\t\u0012\u0011\t\u0013Q\u0003\u0001\u0019!a\u0001\n\u0013\t\u0013\u0001J2p]RLg.^8vg\u0012\u000bG/\u0019)pS:$8OR8s\u001bVdG/[2mCN\u001c(\u000b\u0012#\t\u0013Y\u0003\u0001\u0019!a\u0001\n\u00139\u0016\u0001K2p]RLg.^8vg\u0012\u000bG/\u0019)pS:$8OR8s\u001bVdG/[2mCN\u001c(\u000b\u0012#`I\u0015\fHCA\u0019Y\u0011\u001dAT+!AA\u0002\tBaA\u0017\u0001!B\u0013\u0011\u0013!J2p]RLg.^8vg\u0012\u000bG/\u0019)pS:$8OR8s\u001bVdG/[2mCN\u001c(\u000b\u0012#!\u0011%a\u0006\u00011AA\u0002\u0013%\u0011%A\u001cdCR,wm\u001c:jG\u0006dG)\u0019;b!>Lg\u000e^:G_JlU\u000f\u001c;jG2\f7o\u001d$pe>\u0013H-\u001a:fI\u001a+\u0017\r^;sKN\u0014F\t\u0012\u0005\n=\u0002\u0001\r\u00111A\u0005\n}\u000b1hY1uK\u001e|'/[2bY\u0012\u000bG/\u0019)pS:$8OR8s\u001bVdG/[2mCN\u001chi\u001c:Pe\u0012,'/\u001a3GK\u0006$XO]3t%\u0012#u\fJ3r)\t\t\u0004\rC\u00049;\u0006\u0005\t\u0019\u0001\u0012\t\r\t\u0004\u0001\u0015)\u0003#\u0003a\u001a\u0017\r^3h_JL7-\u00197ECR\f\u0007k\\5oiN4uN]'vYRL7\r\\1tg\u001a{'o\u0014:eKJ,GMR3biV\u0014Xm\u001d*E\t\u0002BQ\u0001\u001a\u0001\u0005B\u0015\f\u0011BY3g_J,\u0017\t\u001c7\u0015\u0003E:aa\u001a\u0002\t\u0002\u0011A\u0017a\u0007#fG&\u001c\u0018n\u001c8Ue\u0016,7\t\\1tg&4\u0017.\u001a:Tk&$X\r\u0005\u0002\u001fS\u001a1\u0011A\u0001E\u0001\t)\u001c\"!\u001b\b\t\u000bmIG\u0011\u00017\u0015\u0003!DQA\\5\u0005\u0002=\f1bY8na\u0006\u0014X-\u0011)JgR1\u0011\u0007\u001d:x\u0003\u000fAQ!]7A\u0002\t\nA\u0001Z1uC\")1/\u001ca\u0001i\u0006\u0011A\r\u001e\t\u0003=UL!A\u001e\u0002\u0003-\u0011+7-[:j_:$&/Z3DY\u0006\u001c8/\u001b4jKJDQ\u0001_7A\u0002e\f1cY1uK\u001e|'/[2bY\u001a+\u0017\r^;sKN\u0004bA_?\u0002\u0002\u0005\u0005aB\u0001\u001a|\u0013\ta8'\u0001\u0004Qe\u0016$WMZ\u0005\u0003}~\u00141!T1q\u0015\ta8\u0007E\u00023\u0003\u0007I1!!\u00024\u0005\rIe\u000e\u001e\u0005\b\u0003\u0013i\u0007\u0019AA\u0001\u0003)qW/\\\"mCN\u001cXm\u001d\u0005\n\u0003\u001bI\u0017\u0011!C\u0005\u0003\u001f\t1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u0003\t\u0005\u0003'\ti\"\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003\u0011a\u0017M\\4\u000b\u0005\u0005m\u0011\u0001\u00026bm\u0006LA!a\b\u0002\u0016\t1qJ\u00196fGR\u0004")
public class DecisionTreeClassifierSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private RDD<LabeledPoint> org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$categoricalDataPointsRDD;
    private RDD<LabeledPoint> org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$orderedLabeledPointsWithLabel0RDD;
    private RDD<LabeledPoint> org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$orderedLabeledPointsWithLabel1RDD;
    private RDD<LabeledPoint> org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$categoricalDataPointsForMulticlassRDD;
    private RDD<LabeledPoint> org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$continuousDataPointsForMulticlassRDD;
    private RDD<LabeledPoint> org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$categoricalDataPointsForMulticlassForOrderedFeaturesRDD;
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public static void compareAPIs(RDD<LabeledPoint> rDD, DecisionTreeClassifier decisionTreeClassifier, Map<Object, Object> map, int n) {
        DecisionTreeClassifierSuite$.MODULE$.compareAPIs(rDD, decisionTreeClassifier, map, n);
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public RDD<LabeledPoint> org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$categoricalDataPointsRDD() {
        return this.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$categoricalDataPointsRDD;
    }

    private void org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$categoricalDataPointsRDD_$eq(RDD<LabeledPoint> x$1) {
        this.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$categoricalDataPointsRDD = x$1;
    }

    public RDD<LabeledPoint> org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$orderedLabeledPointsWithLabel0RDD() {
        return this.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$orderedLabeledPointsWithLabel0RDD;
    }

    private void org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$orderedLabeledPointsWithLabel0RDD_$eq(RDD<LabeledPoint> x$1) {
        this.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$orderedLabeledPointsWithLabel0RDD = x$1;
    }

    public RDD<LabeledPoint> org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$orderedLabeledPointsWithLabel1RDD() {
        return this.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$orderedLabeledPointsWithLabel1RDD;
    }

    private void org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$orderedLabeledPointsWithLabel1RDD_$eq(RDD<LabeledPoint> x$1) {
        this.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$orderedLabeledPointsWithLabel1RDD = x$1;
    }

    public RDD<LabeledPoint> org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$categoricalDataPointsForMulticlassRDD() {
        return this.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$categoricalDataPointsForMulticlassRDD;
    }

    private void org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$categoricalDataPointsForMulticlassRDD_$eq(RDD<LabeledPoint> x$1) {
        this.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$categoricalDataPointsForMulticlassRDD = x$1;
    }

    public RDD<LabeledPoint> org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$continuousDataPointsForMulticlassRDD() {
        return this.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$continuousDataPointsForMulticlassRDD;
    }

    private void org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$continuousDataPointsForMulticlassRDD_$eq(RDD<LabeledPoint> x$1) {
        this.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$continuousDataPointsForMulticlassRDD = x$1;
    }

    public RDD<LabeledPoint> org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$categoricalDataPointsForMulticlassForOrderedFeaturesRDD() {
        return this.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$categoricalDataPointsForMulticlassForOrderedFeaturesRDD;
    }

    private void org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$categoricalDataPointsForMulticlassForOrderedFeaturesRDD_$eq(RDD<LabeledPoint> x$1) {
        this.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$categoricalDataPointsForMulticlassForOrderedFeaturesRDD = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        SparkContext qual$1 = this.sc();
        WrappedArray x$2 = Predef$.MODULE$.wrapRefArray((Object[])DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints());
        int x$3 = qual$1.parallelize$default$2();
        this.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$categoricalDataPointsRDD_$eq((RDD<LabeledPoint>)qual$1.parallelize((Seq)x$2, x$3, ClassTag$.MODULE$.apply(LabeledPoint.class)));
        SparkContext qual$2 = this.sc();
        WrappedArray x$4 = Predef$.MODULE$.wrapRefArray((Object[])DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel0());
        int x$5 = qual$2.parallelize$default$2();
        this.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$orderedLabeledPointsWithLabel0RDD_$eq((RDD<LabeledPoint>)qual$2.parallelize((Seq)x$4, x$5, ClassTag$.MODULE$.apply(LabeledPoint.class)));
        SparkContext qual$3 = this.sc();
        WrappedArray x$6 = Predef$.MODULE$.wrapRefArray((Object[])DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel1());
        int x$7 = qual$3.parallelize$default$2();
        this.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$orderedLabeledPointsWithLabel1RDD_$eq((RDD<LabeledPoint>)qual$3.parallelize((Seq)x$6, x$7, ClassTag$.MODULE$.apply(LabeledPoint.class)));
        SparkContext qual$4 = this.sc();
        WrappedArray x$8 = Predef$.MODULE$.wrapRefArray((Object[])DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlass());
        int x$9 = qual$4.parallelize$default$2();
        this.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$categoricalDataPointsForMulticlassRDD_$eq((RDD<LabeledPoint>)qual$4.parallelize((Seq)x$8, x$9, ClassTag$.MODULE$.apply(LabeledPoint.class)));
        SparkContext qual$5 = this.sc();
        WrappedArray x$10 = Predef$.MODULE$.wrapRefArray((Object[])DecisionTreeSuite$.MODULE$.generateContinuousDataPointsForMulticlass());
        int x$11 = qual$5.parallelize$default$2();
        this.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$continuousDataPointsForMulticlassRDD_$eq((RDD<LabeledPoint>)qual$5.parallelize((Seq)x$10, x$11, ClassTag$.MODULE$.apply(LabeledPoint.class)));
        SparkContext qual$6 = this.sc();
        WrappedArray x$12 = Predef$.MODULE$.wrapRefArray((Object[])DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlassForOrderedFeatures());
        int x$13 = qual$6.parallelize$default$2();
        this.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$categoricalDataPointsForMulticlassForOrderedFeaturesRDD_$eq((RDD<LabeledPoint>)qual$6.parallelize((Seq)x$12, x$13, ClassTag$.MODULE$.apply(LabeledPoint.class)));
    }

    public DecisionTreeClassifierSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParamsSuite$.MODULE$.checkParams((Params)new DecisionTreeClassifier());
                DecisionTreeClassificationModel model = new DecisionTreeClassificationModel("dtc", (Node)new LeafNode(0.0, 0.0, null), 1, 2);
                ParamsSuite$.MODULE$.checkParams((Params)model);
            }
        });
        this.test("Binary classification stump with ordered categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DecisionTreeClassifier dt = new DecisionTreeClassifier().setImpurity("gini").setMaxDepth(2).setMaxBins(100).setSeed(1L);
                Map categoricalFeatures = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
                int numClasses = 2;
                DecisionTreeClassifierSuite$.MODULE$.compareAPIs(this.$outer.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$categoricalDataPointsRDD(), dt, (Map<Object, Object>)categoricalFeatures, numClasses);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification stump with fixed labels 0,1 for Entropy,Gini", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DecisionTreeClassifier dt = new DecisionTreeClassifier().setMaxDepth(3).setMaxBins(100);
                int numClasses = 2;
                Predef$.MODULE$.refArrayOps((Object[])new RDD[]{this.$outer.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$orderedLabeledPointsWithLabel0RDD(), this.$outer.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$orderedLabeledPointsWithLabel1RDD()}).foreach((Function1)new Serializable(this, dt, numClasses){
                    public static final long serialVersionUID = 0L;
                    public final DecisionTreeClassifier dt$1;
                    public final int numClasses$1;

                    public final void apply(RDD<LabeledPoint> rdd) {
                        Predef$.MODULE$.refArrayOps((Object[])DecisionTreeClassifier$.MODULE$.supportedImpurities()).foreach((Function1)new Serializable(this, rdd){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$1 $outer;
                            private final RDD rdd$1;

                            public final void apply(String impurity) {
                                this.$outer.dt$1.setImpurity(impurity);
                                DecisionTreeClassifierSuite$.MODULE$.compareAPIs((RDD<LabeledPoint>)this.rdd$1, this.$outer.dt$1, (Map<Object, Object>)Predef$.MODULE$.Map().empty(), this.$outer.numClasses$1);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.rdd$1 = rdd$1;
                            }
                        });
                    }
                    {
                        this.dt$1 = dt$1;
                        this.numClasses$1 = numClasses$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Multiclass classification stump with 3-ary (unordered) categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD<LabeledPoint> rdd = this.$outer.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$categoricalDataPointsForMulticlassRDD();
                DecisionTreeClassifier dt = new DecisionTreeClassifier().setImpurity("Gini").setMaxDepth(4);
                int numClasses = 3;
                Map categoricalFeatures = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
                DecisionTreeClassifierSuite$.MODULE$.compareAPIs(rdd, dt, (Map<Object, Object>)categoricalFeatures, numClasses);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification stump with 1 continuous feature, to check off-by-1 error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))});
                SparkContext qual$7 = this.$outer.sc();
                WrappedArray x$14 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$15 = qual$7.parallelize$default$2();
                RDD rdd = qual$7.parallelize((Seq)x$14, x$15, ClassTag$.MODULE$.apply(LabeledPoint.class));
                DecisionTreeClassifier dt = new DecisionTreeClassifier().setImpurity("Gini").setMaxDepth(4);
                int numClasses = 2;
                DecisionTreeClassifierSuite$.MODULE$.compareAPIs((RDD<LabeledPoint>)rdd, dt, (Map<Object, Object>)Predef$.MODULE$.Map().empty(), numClasses);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification stump with 2 continuous features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.0)})))), new LabeledPoint(1.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 1.0)})))), new LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.0)})))), new LabeledPoint(1.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 2.0)}))))});
                SparkContext qual$8 = this.$outer.sc();
                WrappedArray x$16 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$17 = qual$8.parallelize$default$2();
                RDD rdd = qual$8.parallelize((Seq)x$16, x$17, ClassTag$.MODULE$.apply(LabeledPoint.class));
                DecisionTreeClassifier dt = new DecisionTreeClassifier().setImpurity("Gini").setMaxDepth(4);
                int numClasses = 2;
                DecisionTreeClassifierSuite$.MODULE$.compareAPIs((RDD<LabeledPoint>)rdd, dt, (Map<Object, Object>)Predef$.MODULE$.Map().empty(), numClasses);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Multiclass classification stump with unordered categorical features, with just enough bins", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int maxBins = 2 * ((int)package$.MODULE$.pow(2.0, 2.0) - 1);
                RDD<LabeledPoint> rdd = this.$outer.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$categoricalDataPointsForMulticlassRDD();
                DecisionTreeClassifier dt = new DecisionTreeClassifier().setImpurity("Gini").setMaxDepth(4).setMaxBins(maxBins);
                Map categoricalFeatures = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
                int numClasses = 3;
                DecisionTreeClassifierSuite$.MODULE$.compareAPIs(rdd, dt, (Map<Object, Object>)categoricalFeatures, numClasses);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Multiclass classification stump with continuous features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD<LabeledPoint> rdd = this.$outer.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$continuousDataPointsForMulticlassRDD();
                DecisionTreeClassifier dt = new DecisionTreeClassifier().setImpurity("Gini").setMaxDepth(4).setMaxBins(100);
                int numClasses = 3;
                DecisionTreeClassifierSuite$.MODULE$.compareAPIs(rdd, dt, (Map<Object, Object>)Predef$.MODULE$.Map().empty(), numClasses);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Multiclass classification stump with continuous + unordered categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD<LabeledPoint> rdd = this.$outer.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$continuousDataPointsForMulticlassRDD();
                DecisionTreeClassifier dt = new DecisionTreeClassifier().setImpurity("Gini").setMaxDepth(4).setMaxBins(100);
                Map categoricalFeatures = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3))}));
                int numClasses = 3;
                DecisionTreeClassifierSuite$.MODULE$.compareAPIs(rdd, dt, (Map<Object, Object>)categoricalFeatures, numClasses);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Multiclass classification stump with 10-ary (ordered) categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD<LabeledPoint> rdd = this.$outer.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$categoricalDataPointsForMulticlassForOrderedFeaturesRDD();
                DecisionTreeClassifier dt = new DecisionTreeClassifier().setImpurity("Gini").setMaxDepth(4).setMaxBins(100);
                Map categoricalFeatures = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)10))}));
                int numClasses = 3;
                DecisionTreeClassifierSuite$.MODULE$.compareAPIs(rdd, dt, (Map<Object, Object>)categoricalFeatures, numClasses);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Multiclass classification tree with 10-ary (ordered) categorical features, with just enough bins", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD<LabeledPoint> rdd = this.$outer.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$categoricalDataPointsForMulticlassForOrderedFeaturesRDD();
                DecisionTreeClassifier dt = new DecisionTreeClassifier().setImpurity("Gini").setMaxDepth(4).setMaxBins(10);
                Map categoricalFeatures = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)10))}));
                int numClasses = 3;
                DecisionTreeClassifierSuite$.MODULE$.compareAPIs(rdd, dt, (Map<Object, Object>)categoricalFeatures, numClasses);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("split must satisfy min instances per node requirements", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.0)})))), new LabeledPoint(1.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 1.0)})))), new LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0)}))))});
                SparkContext qual$9 = this.$outer.sc();
                WrappedArray x$18 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$19 = qual$9.parallelize$default$2();
                RDD rdd = qual$9.parallelize((Seq)x$18, x$19, ClassTag$.MODULE$.apply(LabeledPoint.class));
                DecisionTreeClassifier dt = new DecisionTreeClassifier().setImpurity("Gini").setMaxDepth(2).setMinInstancesPerNode(2);
                int numClasses = 2;
                DecisionTreeClassifierSuite$.MODULE$.compareAPIs((RDD<LabeledPoint>)rdd, dt, (Map<Object, Object>)Predef$.MODULE$.Map().empty(), numClasses);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("do not choose split that does not satisfy min instance per node requirements", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})))});
                SparkContext qual$10 = this.$outer.sc();
                WrappedArray x$20 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$21 = qual$10.parallelize$default$2();
                RDD rdd = qual$10.parallelize((Seq)x$20, x$21, ClassTag$.MODULE$.apply(LabeledPoint.class));
                DecisionTreeClassifier dt = new DecisionTreeClassifier().setImpurity("Gini").setMaxBins(2).setMaxDepth(2).setMinInstancesPerNode(2);
                Map categoricalFeatures = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2))}));
                int numClasses = 2;
                DecisionTreeClassifierSuite$.MODULE$.compareAPIs((RDD<LabeledPoint>)rdd, dt, (Map<Object, Object>)categoricalFeatures, numClasses);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("split must satisfy min info gain requirements", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.0)})))), new LabeledPoint(1.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 1.0)})))), new LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0)}))))});
                SparkContext qual$11 = this.$outer.sc();
                WrappedArray x$22 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$23 = qual$11.parallelize$default$2();
                RDD rdd = qual$11.parallelize((Seq)x$22, x$23, ClassTag$.MODULE$.apply(LabeledPoint.class));
                DecisionTreeClassifier dt = new DecisionTreeClassifier().setImpurity("Gini").setMaxDepth(2).setMinInfoGain(1.0);
                int numClasses = 2;
                DecisionTreeClassifierSuite$.MODULE$.compareAPIs((RDD<LabeledPoint>)rdd, dt, (Map<Object, Object>)Predef$.MODULE$.Map().empty(), numClasses);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("predictRaw and predictProbability", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD<LabeledPoint> rdd = this.$outer.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$continuousDataPointsForMulticlassRDD();
                DecisionTreeClassifier dt = new DecisionTreeClassifier().setImpurity("Gini").setMaxDepth(4).setMaxBins(100);
                Map categoricalFeatures = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3))}));
                int numClasses = 3;
                DataFrame newData = TreeTests$.MODULE$.setMetadata(rdd, (Map<Object, Object>)categoricalFeatures, numClasses);
                DecisionTreeClassificationModel newTree = (DecisionTreeClassificationModel)dt.fit(newData);
                MLTestingUtils$.MODULE$.checkCopy((Model<?>)newTree);
                Row[] predictions = newTree.transform(newData).select(newTree.getPredictionCol(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{newTree.getRawPredictionCol(), newTree.getProbabilityCol()})).collect();
                Predef$.MODULE$.refArrayOps((Object[])predictions).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$15 $outer;

                    public final void apply(Row x0$1) {
                        Row row = x0$1;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                            Object pred = ((SeqLike)some.get()).apply(0);
                            Object rawPred = ((SeqLike)some.get()).apply(1);
                            Object probPred = ((SeqLike)some.get()).apply(2);
                            if (pred instanceof Double) {
                                double d = BoxesRunTime.unboxToDouble((Object)pred);
                                if (rawPred instanceof Vector) {
                                    Vector vector = (Vector)rawPred;
                                    if (probPred instanceof Vector) {
                                        Vector vector2 = (Vector)probPred;
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)d));
                                        int $org_scalatest_assert_macro_right = vector.argmax();
                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                        this.$outer.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected prediction ", " but calculated ", " from rawPrediction."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)d), BoxesRunTime.boxToInteger((int)vector.argmax())})));
                                        double sum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(vector.toArray()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$anonfun$$$outer().convertToEqualizer(Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(vector.toArray()).map((Function1)new Serializable(this, sum){
                                            public static final long serialVersionUID = 0L;
                                            private final double sum$1;

                                            public final double apply(double x$1) {
                                                return this.apply$mcDD$sp(x$1);
                                            }

                                            public double apply$mcDD$sp(double x$1) {
                                                return x$1 / this.sum$1;
                                            }
                                            {
                                                this.sum$1 = sum$1;
                                            }
                                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))));
                                        Vector $org_scalatest_assert_macro_right2 = vector2;
                                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                                        this.$outer.org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"probability prediction mismatch");
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return;
                                    }
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ DecisionTreeClassifierSuite org$apache$spark$ml$classification$DecisionTreeClassifierSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("training with 1-category categorical feature", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkContext qual$12 = this.$outer.sc();
                Seq x$24 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 1.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 2.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 9.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 6.0})))}));
                int x$25 = qual$12.parallelize$default$2();
                RDD data = qual$12.parallelize(x$24, x$25, ClassTag$.MODULE$.apply(LabeledPoint.class));
                DataFrame df = TreeTests$.MODULE$.setMetadata((RDD<LabeledPoint>)data, (Map<Object, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)1))}))), 2);
                DecisionTreeClassifier dt = new DecisionTreeClassifier().setMaxDepth(3);
                DecisionTreeClassificationModel model = (DecisionTreeClassificationModel)dt.fit(df);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

