/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.File;
import java.util.NoSuchElementException;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.BinaryLogisticRegressionSummary;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.LogisticRegressionSuite$;
import org.apache.spark.ml.classification.LogisticRegressionSuite$$anonfun$3$;
import org.apache.spark.ml.classification.MultiClassSummarizer;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001q4A!\u0001\u0002\u0001\u001b\t9Bj\\4jgRL7MU3he\u0016\u001c8/[8o'VLG/\u001a\u0006\u0003\u0007\u0011\tab\u00197bgNLg-[2bi&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f%i\u0001\"a\u0004\t\u000e\u0003\u0019I!!\u0005\u0004\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t\u0019\u0002$D\u0001\u0015\u0015\t)b#\u0001\u0003vi&d'BA\f\u0007\u0003\u0015iG\u000e\\5c\u0013\tIBCA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\u0011\u0005miR\"\u0001\u000f\u000b\u0005U!\u0011B\u0001\u0010\u001d\u0005Q!UMZ1vYR\u0014V-\u00193Xe&$X\rV3ti\")\u0001\u0005\u0001C\u0001C\u00051A(\u001b8jiz\"\u0012A\t\t\u0003G\u0001i\u0011A\u0001\u0005\nK\u0001\u0001\r\u00111A\u0005\u0002\u0019\nq\u0001Z1uCN,G/F\u0001(!\tA3&D\u0001*\u0015\tQc!A\u0002tc2L!\u0001L\u0015\u0003\u0013\u0011\u000bG/\u0019$sC6,\u0007\"\u0003\u0018\u0001\u0001\u0004\u0005\r\u0011\"\u00010\u0003-!\u0017\r^1tKR|F%Z9\u0015\u0005A2\u0004CA\u00195\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$\u0001B+oSRDqaN\u0017\u0002\u0002\u0003\u0007q%A\u0002yIEBa!\u000f\u0001!B\u00139\u0013\u0001\u00033bi\u0006\u001cX\r\u001e\u0011)\u0005aZ\u0004CA\u0019=\u0013\ti$GA\u0005ue\u0006t7/[3oi\"Iq\b\u0001a\u0001\u0002\u0004%\tAJ\u0001\u000eE&t\u0017M]=ECR\f7/\u001a;\t\u0013\u0005\u0003\u0001\u0019!a\u0001\n\u0003\u0011\u0015!\u00052j]\u0006\u0014\u0018\u0010R1uCN,Go\u0018\u0013fcR\u0011\u0001g\u0011\u0005\bo\u0001\u000b\t\u00111\u0001(\u0011\u0019)\u0005\u0001)Q\u0005O\u0005q!-\u001b8bef$\u0015\r^1tKR\u0004\u0003F\u0001#<\u0011\u001dA\u0005A1A\u0005\n%\u000b1!\u001a9t+\u0005Q\u0005CA\u0019L\u0013\ta%G\u0001\u0004E_V\u0014G.\u001a\u0005\u0007\u001d\u0002\u0001\u000b\u0011\u0002&\u0002\t\u0015\u00048\u000f\t\u0005\u0006!\u0002!\t%U\u0001\nE\u00164wN]3BY2$\u0012\u0001M\u0004\u0006'\nA\t\u0001V\u0001\u0018\u0019><\u0017n\u001d;jGJ+wM]3tg&|gnU;ji\u0016\u0004\"aI+\u0007\u000b\u0005\u0011\u0001\u0012\u0001,\u0014\u0007U;&\f\u0005\u000221&\u0011\u0011L\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005EZ\u0016B\u0001/3\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0015\u0001S\u000b\"\u0001_)\u0005!\u0006b\u00021V\u0005\u0004%\t!Y\u0001\u0011C2d\u0007+\u0019:b[N+G\u000f^5oON,\u0012A\u0019\t\u0005G\u001aLGN\u0004\u00022I&\u0011QMM\u0001\u0007!J,G-\u001a4\n\u0005\u001dD'aA'ba*\u0011QM\r\t\u0003G*L!a\u001b5\u0003\rM#(/\u001b8h!\t\tT.\u0003\u0002oe\t\u0019\u0011I\\=\t\rA,\u0006\u0015!\u0003c\u0003E\tG\u000e\u001c)be\u0006l7+\u001a;uS:<7\u000f\t\u0005\beV\u000b\t\u0011\"\u0003t\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003Q\u0004\"!\u001e>\u000e\u0003YT!a\u001e=\u0002\t1\fgn\u001a\u0006\u0002s\u0006!!.\u0019<b\u0013\tYhO\u0001\u0004PE*,7\r\u001e")
public class LogisticRegressionSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient DataFrame dataset;
    private transient DataFrame binaryDataset;
    private final double org$apache$spark$ml$classification$LogisticRegressionSuite$$eps;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public static Map<String, Object> allParamSettings() {
        return LogisticRegressionSuite$.MODULE$.allParamSettings();
    }

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, DataFrame dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    @Override
    public void afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public DataFrame dataset() {
        return this.dataset;
    }

    public void dataset_$eq(DataFrame x$1) {
        this.dataset = x$1;
    }

    public DataFrame binaryDataset() {
        return this.binaryDataset;
    }

    public void binaryDataset_$eq(DataFrame x$1) {
        this.binaryDataset = x$1;
    }

    public double org$apache$spark$ml$classification$LogisticRegressionSuite$$eps() {
        return this.org$apache$spark$ml$classification$LogisticRegressionSuite$$eps;
    }

    @Override
    public void beforeAll() {
        TempDirectory$class.beforeAll(this);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LogisticRegressionSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_classification_LogisticRegressionSuite$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.regression.LabeledPoint")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_classification_LogisticRegressionSuite$$typecreator1$1(LogisticRegressionSuite $outer) {
            }
        }
        this.dataset_$eq(this.sqlContext().createDataFrame(org.apache.spark.mllib.classification.LogisticRegressionSuite$.MODULE$.generateLogisticInput(1.0, 1.0, 100, 42), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_LogisticRegressionSuite$$typecreator1$1(this))));
        int nPoints = 10000;
        double[] coefficients = new double[]{-0.57997, 0.912083, -0.371077, -0.819866, 2.688191};
        double[] xMean = new double[]{5.843, 3.057, 3.758, 1.199};
        double[] xVariance = new double[]{0.6856, 0.1899, 3.116, 0.581};
        Seq<LabeledPoint> testData = org.apache.spark.mllib.classification.LogisticRegressionSuite$.MODULE$.generateMultinomialLogisticInput(coefficients, xMean, xVariance, true, nPoints, 42);
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(LogisticRegressionSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_classification_LogisticRegressionSuite$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.regression.LabeledPoint")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_classification_LogisticRegressionSuite$$typecreator2$1(LogisticRegressionSuite $outer) {
            }
        }
        this.binaryDataset_$eq(this.sqlContext().createDataFrame(this.sc().parallelize(testData, 4, ClassTag$.MODULE$.apply(LabeledPoint.class)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_classification_LogisticRegressionSuite$$typecreator2$1(this))));
    }

    public LogisticRegressionSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        TempDirectory$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.org$apache$spark$ml$classification$LogisticRegressionSuite$$eps = 1.0E-5;
        this.test("params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParamsSuite$.MODULE$.checkParams((Params)new LogisticRegression());
                LogisticRegressionModel model = new LogisticRegressionModel("logReg", Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), 0.0);
                ParamsSuite$.MODULE$.checkParams((Params)model);
            }
        });
        this.test("logistic regression: default params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression lr = new LogisticRegression();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(lr.getLabelCol());
                String $org_scalatest_assert_macro_right = "label";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(lr.getFeaturesCol());
                String $org_scalatest_assert_macro_right2 = "features";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(lr.getPredictionCol());
                String $org_scalatest_assert_macro_right3 = "prediction";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(lr.getRawPredictionCol());
                String $org_scalatest_assert_macro_right4 = "rawPrediction";
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(lr.getProbabilityCol());
                String $org_scalatest_assert_macro_right5 = "probability";
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(lr.getWeightCol());
                String $org_scalatest_assert_macro_right6 = "";
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(lr.getFitIntercept(), "lr.getFitIntercept");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(lr.getStandardization(), "lr.getStandardization");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                LogisticRegressionModel model = (LogisticRegressionModel)lr.fit(this.$outer.dataset());
                model.transform(this.$outer.dataset()).select("label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"probability", "prediction", "rawPrediction"})).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)model.getThreshold()));
                double $org_scalatest_assert_macro_right7 = 0.5;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(model.getFeaturesCol());
                String $org_scalatest_assert_macro_right8 = "features";
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(model.getPredictionCol());
                String $org_scalatest_assert_macro_right9 = "prediction";
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(model.getRawPredictionCol());
                String $org_scalatest_assert_macro_right10 = "rawPrediction";
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(model.getProbabilityCol());
                String $org_scalatest_assert_macro_right11 = "probability";
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)model.intercept()));
                double $org_scalatest_assert_macro_right12 = 0.0;
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "!==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12.$bang$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"");
                Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(model.hasParent(), "model.hasParent");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("setThreshold, getThreshold", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression lr = new LogisticRegression();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)lr.getThreshold()));
                double $org_scalatest_assert_macro_right = 0.5;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"LogisticRegression.threshold should default to 0.5");
                this.$outer.withClue("LogisticRegression should not have thresholds set by default.", (Function0)new Serializable(this, lr){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    public final LogisticRegression lr$1;

                    public final NoSuchElementException apply() {
                        return (NoSuchElementException)this.$outer.org$apache$spark$ml$classification$LogisticRegressionSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$2 $outer;

                            public final double[] apply() {
                                return this.$outer.lr$1.getThresholds();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(NoSuchElementException.class));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.lr$1 = lr$1;
                    }
                });
                lr.setThreshold(1.0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(lr.getThresholds());
                double[] $org_scalatest_assert_macro_right2 = new double[]{0.0, 1.0};
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                lr.setThreshold(0.0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(lr.getThresholds());
                double[] $org_scalatest_assert_macro_right3 = new double[]{1.0, 0.0};
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                lr.setThreshold(0.5);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(lr.getThresholds());
                double[] $org_scalatest_assert_macro_right4 = new double[]{0.5, 0.5};
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                LogisticRegression lr2 = new LogisticRegression();
                lr2.setThresholds(new double[]{0.3, 0.7});
                double expectedThreshold = 0.7;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(lr2.getThreshold()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(expectedThreshold).relTol(1.0E-7)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(lr2.getThreshold).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(expectedThreshold).relTol(1.0E-7))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                lr2.setThresholds(new double[]{0.1, 0.2, 0.3});
                this.$outer.withClue("getThreshold should throw error if thresholds has length != 2.", (Function0)new Serializable(this, lr2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    public final LogisticRegression lr2$1;

                    public final IllegalArgumentException apply() {
                        return (IllegalArgumentException)this.$outer.org$apache$spark$ml$classification$LogisticRegressionSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$3 $outer;

                            public final double apply() {
                                return this.apply$mcD$sp();
                            }

                            public double apply$mcD$sp() {
                                return this.$outer.lr2$1.getThreshold();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.lr2$1 = lr2$1;
                    }
                });
                this.$outer.withClue("fit with ParamMap should throw error if threshold, thresholds do not match.", (Function0)new Serializable(this, lr2, expectedThreshold){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    public final LogisticRegression lr2$1;
                    public final double expectedThreshold$1;

                    public final IllegalArgumentException apply() {
                        return (IllegalArgumentException)this.$outer.org$apache$spark$ml$classification$LogisticRegressionSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$4 $outer;

                            public final double apply() {
                                return this.apply$mcD$sp();
                            }

                            public double apply$mcD$sp() {
                                LogisticRegressionModel lr2model = (LogisticRegressionModel)this.$outer.lr2$1.fit(this.$outer.org$apache$spark$ml$classification$LogisticRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$classification$LogisticRegressionSuite$$anonfun$$$outer().dataset(), this.$outer.lr2$1.thresholds().$minus$greater((Object)new double[]{0.3, 0.7}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.$outer.lr2$1.threshold().$minus$greater((Object)BoxesRunTime.boxToDouble((double)(this.$outer.expectedThreshold$1 / 2.0)))}));
                                return lr2model.getThreshold();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                    }

                    public /* synthetic */ $anonfun$3 org$apache$spark$ml$classification$LogisticRegressionSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.lr2$1 = lr2$1;
                        this.expectedThreshold$1 = expectedThreshold$1;
                    }
                });
            }

            public /* synthetic */ LogisticRegressionSuite org$apache$spark$ml$classification$LogisticRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("logistic regression doesn't fit intercept when fitIntercept is off", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression lr = new LogisticRegression();
                lr.setFitIntercept(false);
                LogisticRegressionModel model = (LogisticRegressionModel)lr.fit(this.$outer.dataset());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)model.intercept()));
                double $org_scalatest_assert_macro_right = 0.0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                MLTestingUtils$.MODULE$.checkCopy((Model<?>)model);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("logistic regression with setters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression lr = (LogisticRegression)new LogisticRegression().setMaxIter(10).setRegParam(1.0).setThreshold(0.6).setProbabilityCol("myProbability");
                LogisticRegressionModel model = (LogisticRegressionModel)lr.fit(this.$outer.dataset());
                LogisticRegression parent = (LogisticRegression)model.parent();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parent.getMaxIter()));
                int $org_scalatest_assert_macro_right = 10;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)parent.getRegParam()));
                double $org_scalatest_assert_macro_right2 = 1.0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)parent.getThreshold()));
                double $org_scalatest_assert_macro_right3 = 0.6;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)model.getThreshold()));
                double $org_scalatest_assert_macro_right4 = 0.6;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                model.setThreshold(1.0);
                double[] predAllZero = (double[])Predef$.MODULE$.refArrayOps((Object[])model.transform(this.$outer.dataset()).select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"myProbability"})).collect()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Row x0$1) {
                        Row row = x0$1;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object pred = ((SeqLike)some.get()).apply(0);
                            Object prob = ((SeqLike)some.get()).apply(1);
                            if (pred instanceof Double) {
                                double d = BoxesRunTime.unboxToDouble((Object)pred);
                                if (prob instanceof Vector) {
                                    double d2 = d;
                                    return d2;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.doubleArrayOps(predAllZero).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final boolean apply(double x$1) {
                        return this.apply$mcZD$sp(x$1);
                    }

                    public boolean apply$mcZD$sp(double x$1) {
                        return this.$outer.org$apache$spark$ml$classification$LogisticRegressionSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)x$1)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0), Equality$.MODULE$.default());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }), "scala.this.Predef.doubleArrayOps(predAllZero).forall(((x$1: Double) => LogisticRegressionSuite.this.convertToEqualizer[Double](x$1).===(0)(scalactic.this.Equality.default[Double])))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"With threshold=1.0, expected predictions to be all 0, but only"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " of ", " were 0."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Predef$.MODULE$.doubleArrayOps(predAllZero).count((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final boolean apply(double x$2) {
                        return this.apply$mcZD$sp(x$2);
                    }

                    public boolean apply$mcZD$sp(double x$2) {
                        return this.$outer.org$apache$spark$ml$classification$LogisticRegressionSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)x$2)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0), Equality$.MODULE$.default());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })), BoxesRunTime.boxToLong((long)this.$outer.dataset().count())}))).toString());
                double[] predNotAllZero = (double[])Predef$.MODULE$.refArrayOps((Object[])model.transform(this.$outer.dataset(), model.threshold().$minus$greater((Object)BoxesRunTime.boxToDouble((double)0.0)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{model.probabilityCol().$minus$greater((Object)"myProb")})).select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"myProb"})).collect()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Row x0$2) {
                        Row row = x0$2;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object pred = ((SeqLike)some.get()).apply(0);
                            Object prob = ((SeqLike)some.get()).apply(1);
                            if (pred instanceof Double) {
                                double d = BoxesRunTime.unboxToDouble((Object)pred);
                                if (prob instanceof Vector) {
                                    double d2 = d;
                                    return d2;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.doubleArrayOps(predNotAllZero).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final boolean apply(double x$3) {
                        return this.apply$mcZD$sp(x$3);
                    }

                    public boolean apply$mcZD$sp(double x$3) {
                        return this.$outer.org$apache$spark$ml$classification$LogisticRegressionSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)x$3)).$bang$eq$eq((Object)BoxesRunTime.boxToDouble((double)0.0), Equality$.MODULE$.default());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }), "scala.this.Predef.doubleArrayOps(predNotAllZero).exists(((x$3: Double) => LogisticRegressionSuite.this.convertToEqualizer[Double](x$3).!==(0.0)(scalactic.this.Equality.default[Double])))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                lr.setThresholds(new double[]{0.6, 0.4});
                LogisticRegressionModel model2 = (LogisticRegressionModel)lr.fit(this.$outer.dataset(), lr.maxIter().$minus$greater((Object)BoxesRunTime.boxToInteger((int)5)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{lr.regParam().$minus$greater((Object)BoxesRunTime.boxToDouble((double)0.1)), lr.probabilityCol().$minus$greater((Object)"theProb")}));
                LogisticRegression parent2 = (LogisticRegression)model2.parent();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parent2.getMaxIter()));
                int $org_scalatest_assert_macro_right5 = 5;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)parent2.getRegParam()));
                double $org_scalatest_assert_macro_right6 = 0.1;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)parent2.getThreshold()));
                double $org_scalatest_assert_macro_right7 = 0.4;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)model2.getThreshold()));
                double $org_scalatest_assert_macro_right8 = 0.4;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(model2.getProbabilityCol());
                String $org_scalatest_assert_macro_right9 = "theProb";
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
            }

            public /* synthetic */ LogisticRegressionSuite org$apache$spark$ml$classification$LogisticRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("logistic regression: Predictor, Classifier methods", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SQLContext sqlContext = this.$outer.sqlContext();
                LogisticRegression lr = new LogisticRegression();
                LogisticRegressionModel model = (LogisticRegressionModel)lr.fit(this.$outer.dataset());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numClasses()));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                int numFeatures = ((Vector)this.$outer.dataset().select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).first().getAs(0)).size();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numFeatures()));
                int $org_scalatest_assert_macro_right2 = numFeatures;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                double threshold = model.getThreshold();
                DataFrame results = model.transform(this.$outer.dataset());
                Predef$.MODULE$.refArrayOps((Object[])results.select("rawPrediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"probability"})).collect()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final void apply(Row x0$3) {
                        Row row = x0$3;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object raw = ((SeqLike)some.get()).apply(0);
                            Object prob = ((SeqLike)some.get()).apply(1);
                            if (raw instanceof Vector) {
                                Vector vector = (Vector)raw;
                                if (prob instanceof Vector) {
                                    Vector vector2 = (Vector)prob;
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$classification$LogisticRegressionSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)vector.size()));
                                    int $org_scalatest_assert_macro_right = 2;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                    this.$outer.org$apache$spark$ml$classification$LogisticRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$ml$classification$LogisticRegressionSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)vector2.size()));
                                    int $org_scalatest_assert_macro_right2 = 2;
                                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                                    this.$outer.org$apache$spark$ml$classification$LogisticRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                                    double probFromRaw1 = 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-vector.apply(1)));
                                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(vector2.apply(1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(probFromRaw1).relTol(this.$outer.org$apache$spark$ml$classification$LogisticRegressionSuite$$anonfun$$$outer().org$apache$spark$ml$classification$LogisticRegressionSuite$$eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(prob.apply(1)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(probFromRaw1).relTol(LogisticRegressionSuite.this.eps))");
                                    this.$outer.org$apache$spark$ml$classification$LogisticRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(vector2.apply(0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0 - probFromRaw1).relTol(this.$outer.org$apache$spark$ml$classification$LogisticRegressionSuite$$anonfun$$$outer().org$apache$spark$ml$classification$LogisticRegressionSuite$$eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(prob.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0.-(probFromRaw1)).relTol(LogisticRegressionSuite.this.eps))");
                                    this.$outer.org$apache$spark$ml$classification$LogisticRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Predef$.MODULE$.refArrayOps((Object[])results.select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"probability"})).collect()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final void apply(Row x0$4) {
                        Row row = x0$4;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object pred = ((SeqLike)some.get()).apply(0);
                            Object prob = ((SeqLike)some.get()).apply(1);
                            if (pred instanceof Double) {
                                double d = BoxesRunTime.unboxToDouble((Object)pred);
                                if (prob instanceof Vector) {
                                    Vector vector = (Vector)prob;
                                    int predFromProb = ((Tuple2)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(vector.toArray()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).maxBy((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final double apply(Tuple2<Object, Object> x$4) {
                                            return x$4._1$mcD$sp();
                                        }
                                    }, (Ordering)Ordering.Double$.MODULE$))._2$mcI$sp();
                                    Double $org_scalatest_assert_macro_left = BoxesRunTime.boxToDouble((double)d);
                                    int $org_scalatest_assert_macro_right = predFromProb;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), BoxesRunTime.unboxToDouble((Object)$org_scalatest_assert_macro_left) == (double)$org_scalatest_assert_macro_right);
                                    this.$outer.org$apache$spark$ml$classification$LogisticRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LogisticRegressionSuite org$apache$spark$ml$classification$LogisticRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("MultiClassSummarizer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MultiClassSummarizer qual$1 = new MultiClassSummarizer();
                double x$6 = 0.0;
                double x$7 = qual$1.add$default$2();
                MultiClassSummarizer qual$2 = qual$1.add(x$6, x$7);
                double x$8 = 3.0;
                double x$9 = qual$2.add$default$2();
                MultiClassSummarizer qual$3 = qual$2.add(x$8, x$9);
                double x$10 = 4.0;
                double x$11 = qual$3.add$default$2();
                MultiClassSummarizer qual$4 = qual$3.add(x$10, x$11);
                double x$12 = 3.0;
                double x$13 = qual$4.add$default$2();
                MultiClassSummarizer qual$5 = qual$4.add(x$12, x$13);
                double x$14 = 6.0;
                double x$15 = qual$5.add$default$2();
                MultiClassSummarizer summarizer1 = qual$5.add(x$14, x$15);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(summarizer1.histogram());
                double[] $org_scalatest_assert_macro_right = (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 0.0, 0.0, 2.0, 1.0, 0.0, 1.0}), ClassTag$.MODULE$.Double());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)summarizer1.countInvalid()));
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)summarizer1.numClasses()));
                int $org_scalatest_assert_macro_right3 = 7;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                MultiClassSummarizer qual$6 = new MultiClassSummarizer();
                double x$16 = 1.0;
                double x$17 = qual$6.add$default$2();
                MultiClassSummarizer qual$7 = qual$6.add(x$16, x$17);
                double x$18 = 5.0;
                double x$19 = qual$7.add$default$2();
                MultiClassSummarizer qual$8 = qual$7.add(x$18, x$19);
                double x$20 = 3.0;
                double x$21 = qual$8.add$default$2();
                MultiClassSummarizer qual$9 = qual$8.add(x$20, x$21);
                double x$22 = 0.0;
                double x$23 = qual$9.add$default$2();
                MultiClassSummarizer qual$10 = qual$9.add(x$22, x$23);
                double x$24 = 4.0;
                double x$25 = qual$10.add$default$2();
                MultiClassSummarizer qual$11 = qual$10.add(x$24, x$25);
                double x$26 = 1.0;
                double x$27 = qual$11.add$default$2();
                MultiClassSummarizer summarizer2 = qual$11.add(x$26, x$27);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(summarizer2.histogram());
                double[] $org_scalatest_assert_macro_right4 = (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 0.0, 1.0, 1.0, 1.0}), ClassTag$.MODULE$.Double());
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)summarizer2.countInvalid()));
                int $org_scalatest_assert_macro_right5 = 0;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)summarizer2.numClasses()));
                int $org_scalatest_assert_macro_right6 = 6;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                MultiClassSummarizer qual$12 = new MultiClassSummarizer();
                double x$28 = 0.0;
                double x$29 = qual$12.add$default$2();
                MultiClassSummarizer qual$13 = qual$12.add(x$28, x$29);
                double x$30 = 1.3;
                double x$31 = qual$13.add$default$2();
                MultiClassSummarizer qual$14 = qual$13.add(x$30, x$31);
                double x$32 = 5.2;
                double x$33 = qual$14.add$default$2();
                MultiClassSummarizer qual$15 = qual$14.add(x$32, x$33);
                double x$34 = 2.5;
                double x$35 = qual$15.add$default$2();
                MultiClassSummarizer qual$16 = qual$15.add(x$34, x$35);
                double x$36 = 2.0;
                double x$37 = qual$16.add$default$2();
                MultiClassSummarizer qual$17 = qual$16.add(x$36, x$37);
                double x$38 = 4.0;
                double x$39 = qual$17.add$default$2();
                MultiClassSummarizer qual$18 = qual$17.add(x$38, x$39);
                double x$40 = 4.0;
                double x$41 = qual$18.add$default$2();
                MultiClassSummarizer qual$19 = qual$18.add(x$40, x$41);
                double x$42 = 4.0;
                double x$43 = qual$19.add$default$2();
                MultiClassSummarizer qual$20 = qual$19.add(x$42, x$43);
                double x$44 = 1.0;
                double x$45 = qual$20.add$default$2();
                MultiClassSummarizer summarizer3 = qual$20.add(x$44, x$45);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(summarizer3.histogram());
                double[] $org_scalatest_assert_macro_right7 = (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0, 1.0, 0.0, 3.0}), ClassTag$.MODULE$.Double());
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)summarizer3.countInvalid()));
                int $org_scalatest_assert_macro_right8 = 3;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)summarizer3.numClasses()));
                int $org_scalatest_assert_macro_right9 = 5;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                MultiClassSummarizer qual$21 = new MultiClassSummarizer();
                double x$46 = 3.1;
                double x$47 = qual$21.add$default$2();
                MultiClassSummarizer qual$22 = qual$21.add(x$46, x$47);
                double x$48 = 4.3;
                double x$49 = qual$22.add$default$2();
                MultiClassSummarizer qual$23 = qual$22.add(x$48, x$49);
                double x$50 = 2.0;
                double x$51 = qual$23.add$default$2();
                MultiClassSummarizer qual$24 = qual$23.add(x$50, x$51);
                double x$52 = 1.0;
                double x$53 = qual$24.add$default$2();
                MultiClassSummarizer qual$25 = qual$24.add(x$52, x$53);
                double x$54 = 3.0;
                double x$55 = qual$25.add$default$2();
                MultiClassSummarizer summarizer4 = qual$25.add(x$54, x$55);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(summarizer4.histogram());
                double[] $org_scalatest_assert_macro_right10 = (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0, 1.0, 1.0}), ClassTag$.MODULE$.Double());
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)summarizer4.countInvalid()));
                int $org_scalatest_assert_macro_right11 = 2;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)summarizer4.numClasses()));
                int $org_scalatest_assert_macro_right12 = 4;
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                MultiClassSummarizer summarizerA = summarizer1.merge(summarizer2);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)summarizerA.hashCode()));
                int $org_scalatest_assert_macro_right13 = summarizer2.hashCode();
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right13), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.$outer.convertToEqualizer(summarizerA.histogram());
                double[] $org_scalatest_assert_macro_right14 = (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 2.0, 0.0, 3.0, 2.0, 1.0, 1.0}), ClassTag$.MODULE$.Double());
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)$org_scalatest_assert_macro_right14, $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)$org_scalatest_assert_macro_right14, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left15 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)summarizerA.countInvalid()));
                int $org_scalatest_assert_macro_right15 = 0;
                Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right15), $org_scalatest_assert_macro_left15.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right15), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left16 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)summarizerA.numClasses()));
                int $org_scalatest_assert_macro_right16 = 7;
                Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right16), $org_scalatest_assert_macro_left16.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right16), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"");
                MultiClassSummarizer summarizerB = summarizer3.merge(summarizer4);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left17 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)summarizerB.hashCode()));
                int $org_scalatest_assert_macro_right17 = summarizer3.hashCode();
                Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right17), $org_scalatest_assert_macro_left17.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right17), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left18 = this.$outer.convertToEqualizer(summarizerB.histogram());
                double[] $org_scalatest_assert_macro_right18 = (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 2.0, 1.0, 3.0}), ClassTag$.MODULE$.Double());
                Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left18, "===", (Object)$org_scalatest_assert_macro_right18, $org_scalatest_assert_macro_left18.$eq$eq$eq((Object)$org_scalatest_assert_macro_right18, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left19 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)summarizerB.countInvalid()));
                int $org_scalatest_assert_macro_right19 = 5;
                Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left19, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right19), $org_scalatest_assert_macro_left19.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right19), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left20 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)summarizerB.numClasses()));
                int $org_scalatest_assert_macro_right20 = 5;
                Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left20, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right20), $org_scalatest_assert_macro_left20.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right20), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("MultiClassSummarizer with weighted samples", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MultiClassSummarizer summarizer1 = new MultiClassSummarizer().add(0.0, 0.2).add(3.0, 0.8).add(4.0, 3.2).add(3.0, 1.3).add(6.0, 3.1);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(summarizer1.histogram())).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(new double[]{0.2, 0.0, 0.0, 2.1, 3.2, 0.0, 3.1})).absTol(1.0E-10)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(summarizer1.histogram)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(scala.Array.apply(0.2, 0.0, 0.0, 2.1, 3.2, 0.0, 3.1))).absTol(1.0E-10))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)summarizer1.countInvalid()));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)summarizer1.numClasses()));
                int $org_scalatest_assert_macro_right2 = 7;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                MultiClassSummarizer qual$26 = new MultiClassSummarizer().add(1.0, 1.1).add(5.0, 2.3);
                double x$56 = 3.0;
                double x$57 = qual$26.add$default$2();
                MultiClassSummarizer qual$27 = qual$26.add(x$56, x$57);
                double x$58 = 0.0;
                double x$59 = qual$27.add$default$2();
                MultiClassSummarizer qual$28 = qual$27.add(x$58, x$59);
                double x$60 = 4.0;
                double x$61 = qual$28.add$default$2();
                MultiClassSummarizer qual$29 = qual$28.add(x$60, x$61);
                double x$62 = 1.0;
                double x$63 = qual$29.add$default$2();
                MultiClassSummarizer summarizer2 = qual$29.add(x$62, x$63).add(2.0, 0.0);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(summarizer2.histogram())).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense((double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.1, 0.0, 1.0, 1.0, 2.3}), ClassTag$.MODULE$.Double()))).absTol(1.0E-10)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(summarizer2.histogram)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(scala.Array.apply[Double](1.0, 2.1, 0.0, 1.0, 1.0, 2.3)(ClassTag.Double))).absTol(1.0E-10))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)summarizer2.countInvalid()));
                int $org_scalatest_assert_macro_right3 = 0;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)summarizer2.numClasses()));
                int $org_scalatest_assert_macro_right4 = 6;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                MultiClassSummarizer summarizer = summarizer1.merge(summarizer2);
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(summarizer.histogram())).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(new double[]{1.2, 2.1, 0.0, 3.1, 4.2, 2.3, 3.1})).absTol(1.0E-10)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(summarizer.histogram)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(scala.Array.apply(1.2, 2.1, 0.0, 3.1, 4.2, 2.3, 3.1))).absTol(1.0E-10))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)summarizer.countInvalid()));
                int $org_scalatest_assert_macro_right5 = 0;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)summarizer.numClasses()));
                int $org_scalatest_assert_macro_right6 = 7;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("binary logistic regression with intercept without regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression trainer1 = new LogisticRegression().setFitIntercept(true).setStandardization(true);
                LogisticRegression trainer2 = new LogisticRegression().setFitIntercept(true).setStandardization(false);
                LogisticRegressionModel model1 = (LogisticRegressionModel)trainer1.fit(this.$outer.binaryDataset());
                LogisticRegressionModel model2 = (LogisticRegressionModel)trainer2.fit(this.$outer.binaryDataset());
                double interceptR = 2.8366423;
                Vector coefficientsR = Vectors$.MODULE$.dense(-0.5895848, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.8931147, -0.3925051, -0.7996864}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("binary logistic regression without intercept without regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression trainer1 = new LogisticRegression().setFitIntercept(false).setStandardization(true);
                LogisticRegression trainer2 = new LogisticRegression().setFitIntercept(false).setStandardization(false);
                LogisticRegressionModel model1 = (LogisticRegressionModel)trainer1.fit(this.$outer.binaryDataset());
                LogisticRegressionModel model2 = (LogisticRegressionModel)trainer2.fit(this.$outer.binaryDataset());
                double interceptR = 0.0;
                Vector coefficientsR = Vectors$.MODULE$.dense(-0.3534996, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.2964482, -0.3571741, -0.7407946}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).relTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).relTol(0.01))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).relTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).relTol(0.01))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("binary logistic regression with intercept with L1 regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression trainer1 = new LogisticRegression().setFitIntercept(true).setElasticNetParam(1.0).setRegParam(0.12).setStandardization(true);
                LogisticRegression trainer2 = new LogisticRegression().setFitIntercept(true).setElasticNetParam(1.0).setRegParam(0.12).setStandardization(false);
                LogisticRegressionModel model1 = (LogisticRegressionModel)trainer1.fit(this.$outer.binaryDataset());
                LogisticRegressionModel model2 = (LogisticRegressionModel)trainer2.fit(this.$outer.binaryDataset());
                double interceptR1 = -0.05627428;
                Vector coefficientsR1 = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, -0.04325749, -0.02481551}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR1).relTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR1).relTol(0.01))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR1).absTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR1).absTol(0.02))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                double interceptR2 = 0.3722152;
                Vector coefficientsR2 = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, -0.1665453, 0.0}));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR2).relTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR2).relTol(0.01))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR2).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR2).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("binary logistic regression without intercept with L1 regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression trainer1 = new LogisticRegression().setFitIntercept(false).setElasticNetParam(1.0).setRegParam(0.12).setStandardization(true);
                LogisticRegression trainer2 = new LogisticRegression().setFitIntercept(false).setElasticNetParam(1.0).setRegParam(0.12).setStandardization(false);
                LogisticRegressionModel model1 = (LogisticRegressionModel)trainer1.fit(this.$outer.binaryDataset());
                LogisticRegressionModel model2 = (LogisticRegressionModel)trainer2.fit(this.$outer.binaryDataset());
                double interceptR1 = 0.0;
                Vector coefficientsR1 = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, -0.05189203, -0.03891782}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR1).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR1).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR1).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR1).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                double interceptR2 = 0.0;
                Vector coefficientsR2 = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, -0.08420782, 0.0}));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR2).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR2).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR2).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR2).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("binary logistic regression with intercept with L2 regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression trainer1 = new LogisticRegression().setFitIntercept(true).setElasticNetParam(0.0).setRegParam(1.37).setStandardization(true);
                LogisticRegression trainer2 = new LogisticRegression().setFitIntercept(true).setElasticNetParam(0.0).setRegParam(1.37).setStandardization(false);
                LogisticRegressionModel model1 = (LogisticRegressionModel)trainer1.fit(this.$outer.binaryDataset());
                LogisticRegressionModel model2 = (LogisticRegressionModel)trainer2.fit(this.$outer.binaryDataset());
                double interceptR1 = 0.15021751;
                Vector coefficientsR1 = Vectors$.MODULE$.dense(-0.07251837, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.10724191, -0.04865309, -0.10062872}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR1).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR1).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR1).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR1).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                double interceptR2 = 0.48657516;
                Vector coefficientsR2 = Vectors$.MODULE$.dense(-0.05155371, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.02301057, -0.11482896, -0.06266838}));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR2).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR2).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR2).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR2).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("binary logistic regression without intercept with L2 regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression trainer1 = new LogisticRegression().setFitIntercept(false).setElasticNetParam(0.0).setRegParam(1.37).setStandardization(true);
                LogisticRegression trainer2 = new LogisticRegression().setFitIntercept(false).setElasticNetParam(0.0).setRegParam(1.37).setStandardization(false);
                LogisticRegressionModel model1 = (LogisticRegressionModel)trainer1.fit(this.$outer.binaryDataset());
                LogisticRegressionModel model2 = (LogisticRegressionModel)trainer2.fit(this.$outer.binaryDataset());
                double interceptR1 = 0.0;
                Vector coefficientsR1 = Vectors$.MODULE$.dense(-0.06099165, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.12857058, -0.0470877, -0.09799775}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR1).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR1).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR1).relTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR1).relTol(0.01))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                double interceptR2 = 0.0;
                Vector coefficientsR2 = Vectors$.MODULE$.dense(-0.005679651, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.048967094, -0.093714016, -0.053314311}));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR2).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR2).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR2).relTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR2).relTol(0.01))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("binary logistic regression with intercept with ElasticNet regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression trainer1 = new LogisticRegression().setFitIntercept(true).setElasticNetParam(0.38).setRegParam(0.21).setStandardization(true);
                LogisticRegression trainer2 = new LogisticRegression().setFitIntercept(true).setElasticNetParam(0.38).setRegParam(0.21).setStandardization(false);
                LogisticRegressionModel model1 = (LogisticRegressionModel)trainer1.fit(this.$outer.binaryDataset());
                LogisticRegressionModel model2 = (LogisticRegressionModel)trainer2.fit(this.$outer.binaryDataset());
                double interceptR1 = 0.57734851;
                Vector coefficientsR1 = Vectors$.MODULE$.dense(-0.05310287, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, -0.0884925, -0.15458796}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR1).relTol(0.006)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR1).relTol(0.006))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR1).absTol(0.005)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR1).absTol(0.005))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                double interceptR2 = 0.51555993;
                Vector coefficientsR2 = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, -0.18807395, -0.05350074}));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR2).relTol(0.006)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR2).relTol(0.006))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR2).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR2).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("binary logistic regression without intercept with ElasticNet regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression trainer1 = new LogisticRegression().setFitIntercept(false).setElasticNetParam(0.38).setRegParam(0.21).setStandardization(true);
                LogisticRegression trainer2 = new LogisticRegression().setFitIntercept(false).setElasticNetParam(0.38).setRegParam(0.21).setStandardization(false);
                LogisticRegressionModel model1 = (LogisticRegressionModel)trainer1.fit(this.$outer.binaryDataset());
                LogisticRegressionModel model2 = (LogisticRegressionModel)trainer2.fit(this.$outer.binaryDataset());
                double interceptR1 = 0.0;
                Vector coefficientsR1 = Vectors$.MODULE$.dense(-0.001005743, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.072577857, -0.081203769, -0.142534158}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR1).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR1).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR1).absTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR1).absTol(0.01))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                double interceptR2 = 0.0;
                Vector coefficientsR2 = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.03345223, -0.11304532, 0.0}));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR2).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR2).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR2).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR2).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("binary logistic regression with intercept with strong L1 regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression trainer1 = new LogisticRegression().setFitIntercept(true).setElasticNetParam(1.0).setRegParam(6.0).setStandardization(true);
                LogisticRegression trainer2 = new LogisticRegression().setFitIntercept(true).setElasticNetParam(1.0).setRegParam(6.0).setStandardization(false);
                LogisticRegressionModel model1 = (LogisticRegressionModel)trainer1.fit(this.$outer.binaryDataset());
                LogisticRegressionModel model2 = (LogisticRegressionModel)trainer2.fit(this.$outer.binaryDataset());
                RDD qual$30 = this.$outer.binaryDataset().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Row x0$5) {
                        Row row = x0$5;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object label = ((SeqLike)some.get()).apply(0);
                            Object features = ((SeqLike)some.get()).apply(1);
                            if (label instanceof Double) {
                                double d = BoxesRunTime.unboxToDouble((Object)label);
                                if (features instanceof Vector) {
                                    double d2 = d;
                                    return d2;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                }, ClassTag$.MODULE$.Double());
                MultiClassSummarizer x$64 = new MultiClassSummarizer();
                Serializable x$65 = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MultiClassSummarizer apply(MultiClassSummarizer c, double v) {
                        Tuple2 tuple2 = new Tuple2((Object)c, (Object)BoxesRunTime.boxToDouble((double)v));
                        if (tuple2 != null) {
                            MultiClassSummarizer classSummarizer = (MultiClassSummarizer)tuple2._1();
                            double label = tuple2._2$mcD$sp();
                            if (classSummarizer != null) {
                                MultiClassSummarizer multiClassSummarizer = classSummarizer;
                                double d = label;
                                MultiClassSummarizer multiClassSummarizer2 = multiClassSummarizer.add(d, multiClassSummarizer.add$default$2());
                                return multiClassSummarizer2;
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                };
                Serializable x$66 = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MultiClassSummarizer apply(MultiClassSummarizer c1, MultiClassSummarizer c2) {
                        Tuple2 tuple2 = new Tuple2((Object)c1, (Object)c2);
                        if (tuple2 != null) {
                            MultiClassSummarizer classSummarizer1 = (MultiClassSummarizer)tuple2._1();
                            MultiClassSummarizer classSummarizer2 = (MultiClassSummarizer)tuple2._2();
                            if (classSummarizer1 != null) {
                                MultiClassSummarizer multiClassSummarizer = classSummarizer1;
                                if (classSummarizer2 != null) {
                                    MultiClassSummarizer multiClassSummarizer2 = classSummarizer2;
                                    MultiClassSummarizer multiClassSummarizer3 = multiClassSummarizer.merge(multiClassSummarizer2);
                                    return multiClassSummarizer3;
                                }
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                };
                int x$67 = qual$30.treeAggregate$default$4((Object)x$64);
                double[] histogram = ((MultiClassSummarizer)qual$30.treeAggregate((Object)x$64, (Function2)x$65, (Function2)x$66, x$67, ClassTag$.MODULE$.apply(MultiClassSummarizer.class))).histogram();
                double interceptTheory = scala.math.package$.MODULE$.log(histogram[1] / histogram[0]);
                Vector coefficientsTheory = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 0.0}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptTheory).relTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptTheory).relTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsTheory).absTol(1.0E-6)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsTheory).absTol(1.0E-6))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptTheory).relTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptTheory).relTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsTheory).absTol(1.0E-6)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsTheory).absTol(1.0E-6))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                double interceptR = -0.248065;
                Vector coefficientsR = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 0.0}));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR).relTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR).relTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).absTol(1.0E-6)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).absTol(1.0E-6))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("evaluate on test set", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression lr = new LogisticRegression().setMaxIter(10).setRegParam(1.0).setThreshold(0.6);
                LogisticRegressionModel model = (LogisticRegressionModel)lr.fit(this.$outer.dataset());
                BinaryLogisticRegressionSummary summary = (BinaryLogisticRegressionSummary)model.summary();
                BinaryLogisticRegressionSummary sameSummary = (BinaryLogisticRegressionSummary)model.evaluate(this.$outer.dataset());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)summary.areaUnderROC()));
                double $org_scalatest_assert_macro_right = sameSummary.areaUnderROC();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(summary.roc().collect());
                Row[] $org_scalatest_assert_macro_right2 = sameSummary.roc().collect();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(summary.pr().collect());
                Row[] $org_scalatest_assert_macro_right3 = sameSummary.pr().collect();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(summary.fMeasureByThreshold().collect());
                Row[] $org_scalatest_assert_macro_right4 = sameSummary.fMeasureByThreshold().collect();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(summary.recallByThreshold().collect());
                Row[] $org_scalatest_assert_macro_right5 = sameSummary.recallByThreshold().collect();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(summary.precisionByThreshold().collect());
                Row[] $org_scalatest_assert_macro_right6 = sameSummary.precisionByThreshold().collect();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("statistics on training data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression lr = new LogisticRegression().setMaxIter(10).setRegParam(1.0).setThreshold(0.6);
                LogisticRegressionModel model = (LogisticRegressionModel)lr.fit(this.$outer.dataset());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.doubleArrayOps(model.summary().objectiveHistory()).sliding(2).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double[] x) {
                        return x[0] >= x[1];
                    }
                }), "scala.this.Predef.doubleArrayOps(model.summary.objectiveHistory).sliding(2).forall(((x: Array[Double]) => x.apply(0).>=(x.apply(1))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("binary logistic regression with weighted samples", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int nPoints = 1000;
                double[] coefficients = new double[]{-0.57997, 0.912083, -0.371077, -0.819866, 2.688191};
                double[] xMean = new double[]{5.843, 3.057, 3.758, 1.199};
                double[] xVariance = new double[]{0.6856, 0.1899, 3.116, 0.581};
                Seq<LabeledPoint> testData = org.apache.spark.mllib.classification.LogisticRegressionSuite$.MODULE$.generateMultinomialLogisticInput(coefficients, xMean, xVariance, true, nPoints, 42);
                Seq data1 = (Seq)testData.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterator<LabeledPoint> apply(LabeledPoint x0$6) {
                        LabeledPoint labeledPoint = x0$6;
                        if (labeledPoint != null) {
                            LabeledPoint labeledPoint2 = labeledPoint;
                            Iterator iterator = labeledPoint2.label() == 1.0 ? scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{labeledPoint2, labeledPoint2})) : scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{labeledPoint2}));
                            return iterator;
                        }
                        throw new MatchError((Object)labeledPoint);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Random rnd = new Random(8392);
                Seq data2 = (Seq)testData.flatMap((Function1)new Serializable(this, rnd){
                    public static final long serialVersionUID = 0L;
                    private final Random rnd$1;

                    public final Iterator<Instance> apply(LabeledPoint x0$7) {
                        LabeledPoint labeledPoint = x0$7;
                        if (labeledPoint != null) {
                            double label = labeledPoint.label();
                            Vector features = labeledPoint.features();
                            double d = label;
                            if (features != null) {
                                Vector vector = features;
                                Iterator iterator = this.rnd$1.nextGaussian() > 0.0 ? (d == 1.0 ? scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Instance[]{new Instance(d, 1.2, vector), new Instance(d, 0.8, vector), new Instance(0.0, 0.0, vector)})) : scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Instance[]{new Instance(d, 0.3, vector), new Instance(1.0, 0.0, vector), new Instance(d, 0.1, vector), new Instance(d, 0.6, vector)}))) : (d == 1.0 ? scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Instance[]{new Instance(d, 2.0, vector)})) : scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Instance[]{new Instance(d, 1.0, vector)})));
                                return iterator;
                            }
                        }
                        throw new MatchError((Object)labeledPoint);
                    }
                    {
                        this.rnd$1 = rnd$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LogisticRegressionSuite.class.getClassLoader());
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(LogisticRegressionSuite.class.getClassLoader());
                Tuple2 tuple2 = new Tuple2((Object)this.$outer.sqlContext().createDataFrame(this.$outer.sc().parallelize(data1, 4, ClassTag$.MODULE$.apply(LabeledPoint.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.regression.LabeledPoint")).asType()).toTypeConstructor();
                    }
                })), (Object)this.$outer.sqlContext().createDataFrame(this.$outer.sc().parallelize(data2, 4, ClassTag$.MODULE$.apply(Instance.class)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.Instance")).asType()).toTypeConstructor();
                    }
                })));
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    DataFrame dataset = (DataFrame)tuple2._1();
                    DataFrame weightedDataset = (DataFrame)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)dataset, (Object)weightedDataset);
                    DataFrame dataset2 = (DataFrame)tuple23._1();
                    DataFrame weightedDataset2 = (DataFrame)tuple23._2();
                    LogisticRegression trainer1a = new LogisticRegression().setFitIntercept(true).setRegParam(0.0).setStandardization(true);
                    LogisticRegression trainer1b = new LogisticRegression().setFitIntercept(true).setWeightCol("weight").setRegParam(0.0).setStandardization(true);
                    LogisticRegressionModel model1a0 = (LogisticRegressionModel)trainer1a.fit(dataset2);
                    LogisticRegressionModel model1a1 = (LogisticRegressionModel)trainer1a.fit(weightedDataset2);
                    LogisticRegressionModel model1b = (LogisticRegressionModel)trainer1b.fit(weightedDataset2);
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1a0.coefficients()).$bang$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1a1.coefficients()).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1a0.coefficients).!~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1a1.coefficients).absTol(0.001))");
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1a0.intercept()).$bang$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1a1.intercept()).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1a0.intercept).!~=(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1a1.intercept).absTol(0.001))");
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1a0.coefficients()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1b.coefficients()).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1a0.coefficients).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1b.coefficients).absTol(0.001))");
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1a0.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1b.intercept()).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1a0.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1b.intercept).absTol(0.001))");
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression lr = new LogisticRegression();
                this.$outer.testEstimatorAndModelReadWrite(lr, this.$outer.dataset(), LogisticRegressionSuite$.MODULE$.allParamSettings(), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$23 $outer;

                    public final void apply(LogisticRegressionModel model, LogisticRegressionModel model2) {
                        this.$outer.org$apache$spark$ml$classification$LogisticRegressionSuite$$anonfun$$checkModelData$1(model, model2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public final void org$apache$spark$ml$classification$LogisticRegressionSuite$$anonfun$$checkModelData$1(LogisticRegressionModel model, LogisticRegressionModel model2) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)model.intercept()));
                double $org_scalatest_assert_macro_right = model2.intercept();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(model.coefficients().toArray());
                double[] $org_scalatest_assert_macro_right2 = model2.coefficients().toArray();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numClasses()));
                int $org_scalatest_assert_macro_right3 = model2.numClasses();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numFeatures()));
                int $org_scalatest_assert_macro_right4 = model2.numFeatures();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

