/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.classification.MultilayerPerceptronClassificationModel;
import org.apache.spark.ml.classification.MultilayerPerceptronClassifier;
import org.apache.spark.ml.classification.MultilayerPerceptronClassifierSuite$;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionSuite$;
import org.apache.spark.mllib.classification.LogisticRegressionWithLBFGS;
import org.apache.spark.mllib.evaluation.MulticlassMetrics;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001}1A!\u0001\u0002\u0001\u001b\t\u0019S*\u001e7uS2\f\u00170\u001a:QKJ\u001cW\r\u001d;s_:\u001cE.Y:tS\u001aLWM]*vSR,'BA\u0002\u0005\u00039\u0019G.Y:tS\u001aL7-\u0019;j_:T!!\u0002\u0004\u0002\u00055d'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\n\u0011\u0005=\u0001R\"\u0001\u0004\n\u0005E1!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u0005!Q\u000f^5m\u0015\t9b!A\u0003nY2L'-\u0003\u0002\u001a)\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\b\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0001")
public class MultilayerPerceptronClassifierSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public MultilayerPerceptronClassifierSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("XOR function learning as binary classification problem with two outputs.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultilayerPerceptronClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MultilayerPerceptronClassifierSuite.class.getClassLoader());
                DataFrame dataFrame = this.$outer.sqlContext().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple2((Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0})), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple2((Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple2((Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0})), (Object)BoxesRunTime.boxToDouble((double)0.0))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.linalg.Vector")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"features", "label"}));
                int[] layers = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 5, 2}), ClassTag$.MODULE$.Int());
                MultilayerPerceptronClassifier trainer = new MultilayerPerceptronClassifier().setLayers(layers).setBlockSize(1).setSeed(11L).setMaxIter(100);
                MultilayerPerceptronClassificationModel model = (MultilayerPerceptronClassificationModel)trainer.fit(dataFrame);
                DataFrame result = model.transform(dataFrame);
                Row[] predictionAndLabels = result.select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"})).collect();
                Predef$.MODULE$.refArrayOps((Object[])predictionAndLabels).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final void apply(Row x0$1) {
                        Row row = x0$1;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object p = ((SeqLike)some.get()).apply(0);
                            Object l = ((SeqLike)some.get()).apply(1);
                            if (p instanceof Double) {
                                double d = BoxesRunTime.unboxToDouble((Object)p);
                                if (l instanceof Double) {
                                    double d2 = BoxesRunTime.unboxToDouble((Object)l);
                                    Double $org_scalatest_assert_macro_left = BoxesRunTime.boxToDouble((double)d);
                                    double $org_scalatest_assert_macro_right = d2;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), BoxesRunTime.unboxToDouble((Object)$org_scalatest_assert_macro_left) == $org_scalatest_assert_macro_right);
                                    this.$outer.org$apache$spark$ml$classification$MultilayerPerceptronClassifierSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ MultilayerPerceptronClassifierSuite org$apache$spark$ml$classification$MultilayerPerceptronClassifierSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("3 class classification with 2 hidden layers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultilayerPerceptronClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int nPoints = 1000;
                double[] coefficients = new double[]{-0.57997, 0.912083, -0.371077, -0.819866, 2.688191, -0.16624, -0.84355, -0.048509, -0.301789, 4.170682};
                double[] xMean = new double[]{5.843, 3.057, 3.758, 1.199};
                double[] xVariance = new double[]{0.6856, 0.1899, 3.116, 0.581};
                RDD rdd = this.$outer.sc().parallelize(LogisticRegressionSuite$.MODULE$.generateMultinomialLogisticInput(coefficients, xMean, xVariance, true, nPoints, 1), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MultilayerPerceptronClassifierSuite.class.getClassLoader());
                DataFrame dataFrame = this.$outer.sqlContext().createDataFrame(rdd, ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.regression.LabeledPoint")).asType()).toTypeConstructor();
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label", "features"}));
                int numClasses = 3;
                int numIterations = 100;
                int[] layers = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 4, numClasses}), ClassTag$.MODULE$.Int());
                MultilayerPerceptronClassifier trainer = new MultilayerPerceptronClassifier().setLayers(layers).setBlockSize(1).setSeed(11L).setMaxIter(numIterations);
                MultilayerPerceptronClassificationModel model = (MultilayerPerceptronClassificationModel)trainer.fit(dataFrame);
                int numFeatures = ((Vector)dataFrame.select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).first().getAs(0)).size();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numFeatures()));
                int $org_scalatest_assert_macro_right = numFeatures;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                RDD mlpPredictionAndLabels = model.transform(dataFrame).select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"})).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(Row x0$2) {
                        Row row = x0$2;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object p = ((SeqLike)some.get()).apply(0);
                            Object l = ((SeqLike)some.get()).apply(1);
                            if (p instanceof Double) {
                                double d = BoxesRunTime.unboxToDouble((Object)p);
                                if (l instanceof Double) {
                                    double d2 = BoxesRunTime.unboxToDouble((Object)l);
                                    Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(d, d2);
                                    return sp2;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class));
                LogisticRegressionWithLBFGS lr = ((LogisticRegressionWithLBFGS)new LogisticRegressionWithLBFGS().setIntercept(true)).setNumClasses(numClasses);
                lr.optimizer().setRegParam(0.0).setNumIterations(numIterations);
                LogisticRegressionModel lrModel = (LogisticRegressionModel)lr.run(rdd);
                RDD lrPredictionAndLabels = lrModel.predict(rdd.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(LabeledPoint x$1) {
                        return x$1.features();
                    }
                }, ClassTag$.MODULE$.apply(Vector.class))).zip(rdd.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(LabeledPoint x$2) {
                        return x$2.label();
                    }
                }, ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.Double());
                MulticlassMetrics lrMetrics = new MulticlassMetrics(lrPredictionAndLabels);
                MulticlassMetrics mlpMetrics = new MulticlassMetrics(mlpPredictionAndLabels);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(mlpMetrics.confusionMatrix()).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(lrMetrics.confusionMatrix()).absTol(100.0)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(mlpMetrics.confusionMatrix).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(lrMetrics.confusionMatrix).absTol(100.0))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

