/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import breeze.generic.UFunc;
import breeze.linalg.Vector$;
import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.NaiveBayes;
import org.apache.spark.ml.classification.NaiveBayesModel;
import org.apache.spark.ml.classification.NaiveBayesSuite$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.classification.NaiveBayes$;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001B\u0001\u0003\u00015\u0011qBT1jm\u0016\u0014\u0015-_3t'VLG/\u001a\u0006\u0003\u0007\u0011\tab\u00197bgNLg-[2bi&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f%i\u0001\"a\u0004\t\u000e\u0003\u0019I!!\u0005\u0004\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t\u0019\u0002$D\u0001\u0015\u0015\t)b#\u0001\u0003vi&d'BA\f\u0007\u0003\u0015iG\u000e\\5c\u0013\tIBCA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\u0011\u0005miR\"\u0001\u000f\u000b\u0005U!\u0011B\u0001\u0010\u001d\u0005Q!UMZ1vYR\u0014V-\u00193Xe&$X\rV3ti\")\u0001\u0005\u0001C\u0001C\u00051A(\u001b8jiz\"\u0012A\t\t\u0003G\u0001i\u0011A\u0001\u0005\nK\u0001\u0001\r\u00111A\u0005\u0002\u0019\nq\u0001Z1uCN,G/F\u0001(!\tA3&D\u0001*\u0015\tQc!A\u0002tc2L!\u0001L\u0015\u0003\u0013\u0011\u000bG/\u0019$sC6,\u0007\"\u0003\u0018\u0001\u0001\u0004\u0005\r\u0011\"\u00010\u0003-!\u0017\r^1tKR|F%Z9\u0015\u0005A2\u0004CA\u00195\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$\u0001B+oSRDqaN\u0017\u0002\u0002\u0003\u0007q%A\u0002yIEBa!\u000f\u0001!B\u00139\u0013\u0001\u00033bi\u0006\u001cX\r\u001e\u0011)\u0005aZ\u0004CA\u0019=\u0013\ti$GA\u0005ue\u0006t7/[3oi\")q\b\u0001C!\u0001\u0006I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002a!)!\t\u0001C\u0001\u0007\u0006\u0011b/\u00197jI\u0006$X\r\u0015:fI&\u001cG/[8o)\t\u0001D\tC\u0003F\u0003\u0002\u0007q%A\nqe\u0016$\u0017n\u0019;j_:\fe\u000e\u001a'bE\u0016d7\u000fC\u0003H\u0001\u0011\u0005\u0001*\u0001\twC2LG-\u0019;f\u001b>$W\r\u001c$jiR!\u0001'S)W\u0011\u0015Qe\t1\u0001L\u0003\u0019\u0001\u0018\u000eR1uCB\u0011AjT\u0007\u0002\u001b*\u0011aJF\u0001\u0007Y&t\u0017\r\\4\n\u0005Ak%A\u0002,fGR|'\u000fC\u0003S\r\u0002\u00071+A\u0005uQ\u0016$\u0018\rR1uCB\u0011A\nV\u0005\u0003+6\u0013a!T1ue&D\b\"B,G\u0001\u0004A\u0016!B7pI\u0016d\u0007CA\u0012Z\u0013\tQ&AA\bOC&4XMQ1zKNlu\u000eZ3m\u0011\u0015a\u0006\u0001\"\u0001^\u0003\u0001*\u0007\u0010]3di\u0016$W*\u001e7uS:|W.[1m!J|'-\u00192jY&$\u0018.Z:\u0015\u0007-sv\fC\u0003X7\u0002\u0007\u0001\fC\u0003a7\u0002\u00071*A\u0004gK\u0006$XO]3\t\u000b\t\u0004A\u0011A2\u0002=\u0015D\b/Z2uK\u0012\u0014UM\u001d8pk2d\u0017\u000e\u0015:pE\u0006\u0014\u0017\u000e\\5uS\u0016\u001cHcA&eK\")q+\u0019a\u00011\")\u0001-\u0019a\u0001\u0017\")q\r\u0001C\u0001Q\u0006)b/\u00197jI\u0006$X\r\u0015:pE\u0006\u0014\u0017\u000e\\5uS\u0016\u001cH\u0003\u0002\u0019jW2DQA\u001b4A\u0002\u001d\nqCZ3biV\u0014X-\u00118e!J|'-\u00192jY&$\u0018.Z:\t\u000b]3\u0007\u0019\u0001-\t\u000b54\u0007\u0019\u00018\u0002\u00135|G-\u001a7UsB,\u0007CA8s\u001d\t\t\u0004/\u0003\u0002re\u00051\u0001K]3eK\u001aL!a\u001d;\u0003\rM#(/\u001b8h\u0015\t\t(gB\u0003w\u0005!\u0005q/A\bOC&4XMQ1zKN\u001cV/\u001b;f!\t\u0019\u0003PB\u0003\u0002\u0005!\u0005\u0011pE\u0002yuv\u0004\"!M>\n\u0005q\u0014$AB!osJ+g\r\u0005\u00022}&\u0011qP\r\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0007Aa$\t!a\u0001\u0015\u0003]D\u0011\"a\u0002y\u0005\u0004%\t!!\u0003\u0002!\u0005dG\u000eU1sC6\u001cV\r\u001e;j]\u001e\u001cXCAA\u0006!\u0019y\u0017Q\u00028\u0002\u0012%\u0019\u0011q\u0002;\u0003\u00075\u000b\u0007\u000fE\u00022\u0003'I1!!\u00063\u0005\r\te.\u001f\u0005\t\u00033A\b\u0015!\u0003\u0002\f\u0005\t\u0012\r\u001c7QCJ\fWnU3ui&twm\u001d\u0011\t\u0013\u0005u\u00010!A\u0005\n\u0005}\u0011a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!\t\u0011\t\u0005\r\u0012QF\u0007\u0003\u0003KQA!a\n\u0002*\u0005!A.\u00198h\u0015\t\tY#\u0001\u0003kCZ\f\u0017\u0002BA\u0018\u0003K\u0011aa\u00142kK\u000e$\b")
public class NaiveBayesSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient DataFrame dataset;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public static Map<String, Object> allParamSettings() {
        return NaiveBayesSuite$.MODULE$.allParamSettings();
    }

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, DataFrame dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    @Override
    public void afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public DataFrame dataset() {
        return this.dataset;
    }

    public void dataset_$eq(DataFrame x$1) {
        this.dataset = x$1;
    }

    @Override
    public void beforeAll() {
        TempDirectory$class.beforeAll(this);
        double[] pi = (double[])Predef$.MODULE$.doubleArrayOps(new double[]{0.5, 0.1, 0.4}).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return scala.math.package$.MODULE$.log(x);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double[][] theta = (double[][])Predef$.MODULE$.refArrayOps((Object[])new double[][]{{0.7, 0.1, 0.1, 0.1}, {0.1, 0.7, 0.1, 0.1}, {0.1, 0.1, 0.7, 0.1}}).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double[] apply(double[] x$1) {
                return (double[])Predef$.MODULE$.doubleArrayOps(x$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return scala.math.package$.MODULE$.log(x);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(NaiveBayesSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_classification_NaiveBayesSuite$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.regression.LabeledPoint")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_classification_NaiveBayesSuite$$typecreator1$1(NaiveBayesSuite $outer) {
            }
        }
        this.dataset_$eq(this.sqlContext().createDataFrame(org.apache.spark.mllib.classification.NaiveBayesSuite$.MODULE$.generateNaiveBayesInput(pi, theta, 100, 42, org.apache.spark.mllib.classification.NaiveBayesSuite$.MODULE$.generateNaiveBayesInput$default$5(), org.apache.spark.mllib.classification.NaiveBayesSuite$.MODULE$.generateNaiveBayesInput$default$6()), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_NaiveBayesSuite$$typecreator1$1(this))));
    }

    public void validatePrediction(DataFrame predictionAndLabels) {
        int numOfErrorPredictions;
        int $org_scalatest_assert_macro_left = numOfErrorPredictions = Predef$.MODULE$.refArrayOps((Object[])predictionAndLabels.collect()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Row x0$1) {
                Row row = x0$1;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Object prediction = ((SeqLike)some.get()).apply(0);
                    Object label = ((SeqLike)some.get()).apply(1);
                    if (prediction instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)prediction);
                        if (label instanceof Double) {
                            double d2 = BoxesRunTime.unboxToDouble((Object)label);
                            boolean bl = d != d2;
                            return bl;
                        }
                    }
                }
                throw new MatchError((Object)row);
            }
        });
        long $org_scalatest_assert_macro_right = predictionAndLabels.count() / 5L;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), (long)$org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public void validateModelFit(Vector piData, Matrix thetaData, NaiveBayesModel model) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(model.pi().toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return scala.math.package$.MODULE$.exp(x);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(piData.toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return scala.math.package$.MODULE$.exp(x);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).absTol(0.05)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(scala.this.Predef.doubleArrayOps(model.pi.toArray).map[Double, Array[Double]]({\n  ((x: Double) => scala.math.`package`.exp(x))\n})(scala.this.Array.canBuildFrom[Double](ClassTag.Double)))).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(scala.this.Predef.doubleArrayOps(piData.toArray).map[Double, Array[Double]]({\n  ((x: Double) => scala.math.`package`.exp(x))\n})(scala.this.Array.canBuildFrom[Double](ClassTag.Double)))).absTol(0.05))");
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"pi mismatch");
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(model.theta().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return scala.math.package$.MODULE$.exp(x);
            }
        })).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(thetaData.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return scala.math.package$.MODULE$.exp(x);
            }
        })).absTol(0.05)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(model.theta.map({\n  ((x: Double) => scala.math.`package`.exp(x))\n})).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(thetaData.map({\n  ((x: Double) => scala.math.`package`.exp(x))\n})).absTol(0.05))");
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"theta mismatch");
    }

    public Vector expectedMultinomialProbabilities(NaiveBayesModel model, Vector feature) {
        breeze.linalg.Vector logClassProbs = (breeze.linalg.Vector)model.pi().toBreeze().$plus((Object)model.theta().multiply(feature).toBreeze(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpAdd());
        double[] classProbs = (double[])Predef$.MODULE$.doubleArrayOps(logClassProbs.toArray$mcD$sp(ClassTag$.MODULE$.Double())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return scala.math.package$.MODULE$.exp(x);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double classProbsSum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(classProbs).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(classProbs).map((Function1)new Serializable(this, classProbsSum){
            public static final long serialVersionUID = 0L;
            private final double classProbsSum$1;

            public final double apply(double x$2) {
                return this.apply$mcDD$sp(x$2);
            }

            public double apply$mcDD$sp(double x$2) {
                return x$2 / this.classProbsSum$1;
            }
            {
                this.classProbsSum$1 = classProbsSum$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
    }

    public Vector expectedBernoulliProbabilities(NaiveBayesModel model, Vector feature) {
        Matrix negThetaMatrix = model.theta().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double v) {
                return this.apply$mcDD$sp(v);
            }

            public double apply$mcDD$sp(double v) {
                return scala.math.package$.MODULE$.log(1.0 - scala.math.package$.MODULE$.exp(v));
            }
        });
        Vector negFeature = Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(feature.toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double v) {
                return this.apply$mcDD$sp(v);
            }

            public double apply$mcDD$sp(double v) {
                return 1.0 - v;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
        breeze.linalg.Vector piTheta = (breeze.linalg.Vector)model.pi().toBreeze().$plus((Object)model.theta().multiply(feature).toBreeze(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpAdd());
        breeze.linalg.Vector logClassProbs = (breeze.linalg.Vector)piTheta.$plus((Object)negThetaMatrix.multiply(negFeature).toBreeze(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpAdd());
        double[] classProbs = (double[])Predef$.MODULE$.doubleArrayOps(logClassProbs.toArray$mcD$sp(ClassTag$.MODULE$.Double())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return scala.math.package$.MODULE$.exp(x);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double classProbsSum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(classProbs).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(classProbs).map((Function1)new Serializable(this, classProbsSum){
            public static final long serialVersionUID = 0L;
            private final double classProbsSum$2;

            public final double apply(double x$3) {
                return this.apply$mcDD$sp(x$3);
            }

            public double apply$mcDD$sp(double x$3) {
                return x$3 / this.classProbsSum$2;
            }
            {
                this.classProbsSum$2 = classProbsSum$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
    }

    public void validateProbabilities(DataFrame featureAndProbabilities, NaiveBayesModel model, String modelType) {
        Predef$.MODULE$.refArrayOps((Object[])featureAndProbabilities.collect()).foreach((Function1)new Serializable(this, model, modelType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NaiveBayesSuite $outer;
            private final NaiveBayesModel model$1;
            private final String modelType$1;

            public final void apply(Row x0$2) {
                Row row;
                block2: {
                    block5: {
                        Vector vector;
                        Vector vector2;
                        block4: {
                            String string;
                            Vector vector3;
                            block3: {
                                row = x0$2;
                                Some some = Row$.MODULE$.unapplySeq(row);
                                if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block2;
                                Object features = ((SeqLike)some.get()).apply(0);
                                Object probability = ((SeqLike)some.get()).apply(1);
                                if (!(features instanceof Vector)) break block2;
                                vector3 = (Vector)features;
                                if (!(probability instanceof Vector)) break block2;
                                vector2 = (Vector)probability;
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(vector2.toArray()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).relTol(1.0E-10)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.this.Predef.doubleArrayOps(probability.toArray).sum[Double](math.this.Numeric.DoubleIsFractional)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).relTol(1.0E-10))");
                                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                string = this.modelType$1;
                                String string2 = NaiveBayes$.MODULE$.Multinomial();
                                String string3 = string;
                                if (string2 != null ? !string2.equals(string3) : string3 != null) break block3;
                                vector = this.$outer.expectedMultinomialProbabilities(this.model$1, vector3);
                                break block4;
                            }
                            String string4 = NaiveBayes$.MODULE$.Bernoulli();
                            String string5 = string;
                            if (string4 != null ? !string4.equals(string5) : string5 != null) break block5;
                            vector = this.$outer.expectedBernoulliProbabilities(this.model$1, vector3);
                        }
                        Vector expected = vector;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector2).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(expected).relTol(1.0E-10)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(probability).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(expected).relTol(1.0E-10))");
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new UnknownError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid modelType: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.modelType$1})));
                }
                throw new MatchError((Object)row);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.model$1 = model$1;
                this.modelType$1 = modelType$1;
            }
        });
    }

    public NaiveBayesSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        TempDirectory$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.test("params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParamsSuite$.MODULE$.checkParams((Params)new NaiveBayes());
                NaiveBayesModel model = new NaiveBayesModel("nb", Vectors$.MODULE$.dense(new double[]{0.2, 0.8}), (Matrix)new DenseMatrix(2, 3, new double[]{0.1, 0.2, 0.3, 0.4, 0.6, 0.4}));
                ParamsSuite$.MODULE$.checkParams((Params)model);
            }
        });
        this.test("naive bayes: default params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NaiveBayesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NaiveBayes nb = new NaiveBayes();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(nb.getLabelCol());
                String $org_scalatest_assert_macro_right = "label";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(nb.getFeaturesCol());
                String $org_scalatest_assert_macro_right2 = "features";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(nb.getPredictionCol());
                String $org_scalatest_assert_macro_right3 = "prediction";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)nb.getSmoothing()));
                double $org_scalatest_assert_macro_right4 = 1.0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(nb.getModelType());
                String $org_scalatest_assert_macro_right5 = "multinomial";
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Naive Bayes Multinomial", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NaiveBayesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int nPoints = 1000;
                double[] piArray = (double[])Predef$.MODULE$.doubleArrayOps(new double[]{0.5, 0.1, 0.4}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return scala.math.package$.MODULE$.log(x);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                double[][] thetaArray = (double[][])Predef$.MODULE$.refArrayOps((Object[])new double[][]{{0.7, 0.1, 0.1, 0.1}, {0.1, 0.7, 0.1, 0.1}, {0.1, 0.1, 0.7, 0.1}}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double[] apply(double[] x$4) {
                        return (double[])Predef$.MODULE$.doubleArrayOps(x$4).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(double x) {
                                return this.apply$mcDD$sp(x);
                            }

                            public double apply$mcDD$sp(double x) {
                                return scala.math.package$.MODULE$.log(x);
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
                Vector pi = Vectors$.MODULE$.dense(piArray);
                DenseMatrix theta = new DenseMatrix(3, 4, (double[])Predef$.MODULE$.refArrayOps((Object[])thetaArray).flatten((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final WrappedArray<Object> apply(double[] xs) {
                        return Predef$.MODULE$.wrapDoubleArray(xs);
                    }
                }, ClassTag$.MODULE$.Double()), true);
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(NaiveBayesSuite.class.getClassLoader());
                DataFrame testDataset = this.$outer.sqlContext().createDataFrame(org.apache.spark.mllib.classification.NaiveBayesSuite$.MODULE$.generateNaiveBayesInput(piArray, thetaArray, nPoints, 42, "multinomial", org.apache.spark.mllib.classification.NaiveBayesSuite$.MODULE$.generateNaiveBayesInput$default$6()), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.regression.LabeledPoint")).asType()).toTypeConstructor();
                    }
                }));
                NaiveBayes nb = new NaiveBayes().setSmoothing(1.0).setModelType("multinomial");
                NaiveBayesModel model = (NaiveBayesModel)nb.fit(testDataset);
                this.$outer.validateModelFit(pi, (Matrix)theta, model);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(model.hasParent(), "model.hasParent");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(NaiveBayesSuite.class.getClassLoader());
                DataFrame validationDataset = this.$outer.sqlContext().createDataFrame(org.apache.spark.mllib.classification.NaiveBayesSuite$.MODULE$.generateNaiveBayesInput(piArray, thetaArray, nPoints, 17, "multinomial", org.apache.spark.mllib.classification.NaiveBayesSuite$.MODULE$.generateNaiveBayesInput$default$6()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.regression.LabeledPoint")).asType()).toTypeConstructor();
                    }
                }));
                DataFrame predictionAndLabels = model.transform(validationDataset).select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"}));
                this.$outer.validatePrediction(predictionAndLabels);
                DataFrame featureAndProbabilities = model.transform(validationDataset).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"probability"}));
                this.$outer.validateProbabilities(featureAndProbabilities, model, "multinomial");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Naive Bayes Bernoulli", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NaiveBayesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int nPoints = 10000;
                double[] piArray = (double[])Predef$.MODULE$.doubleArrayOps(new double[]{0.5, 0.3, 0.2}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return scala.math.package$.MODULE$.log(x);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                double[][] thetaArray = (double[][])Predef$.MODULE$.refArrayOps((Object[])new double[][]{{0.5, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.4}, {0.02, 0.7, 0.1, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02}, {0.02, 0.02, 0.6, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.3}}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double[] apply(double[] x$5) {
                        return (double[])Predef$.MODULE$.doubleArrayOps(x$5).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(double x) {
                                return this.apply$mcDD$sp(x);
                            }

                            public double apply$mcDD$sp(double x) {
                                return scala.math.package$.MODULE$.log(x);
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
                Vector pi = Vectors$.MODULE$.dense(piArray);
                DenseMatrix theta = new DenseMatrix(3, 12, (double[])Predef$.MODULE$.refArrayOps((Object[])thetaArray).flatten((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final WrappedArray<Object> apply(double[] xs) {
                        return Predef$.MODULE$.wrapDoubleArray(xs);
                    }
                }, ClassTag$.MODULE$.Double()), true);
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(NaiveBayesSuite.class.getClassLoader());
                DataFrame testDataset = this.$outer.sqlContext().createDataFrame(org.apache.spark.mllib.classification.NaiveBayesSuite$.MODULE$.generateNaiveBayesInput(piArray, thetaArray, nPoints, 45, "bernoulli", org.apache.spark.mllib.classification.NaiveBayesSuite$.MODULE$.generateNaiveBayesInput$default$6()), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.regression.LabeledPoint")).asType()).toTypeConstructor();
                    }
                }));
                NaiveBayes nb = new NaiveBayes().setSmoothing(1.0).setModelType("bernoulli");
                NaiveBayesModel model = (NaiveBayesModel)nb.fit(testDataset);
                this.$outer.validateModelFit(pi, (Matrix)theta, model);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(model.hasParent(), "model.hasParent");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(NaiveBayesSuite.class.getClassLoader());
                DataFrame validationDataset = this.$outer.sqlContext().createDataFrame(org.apache.spark.mllib.classification.NaiveBayesSuite$.MODULE$.generateNaiveBayesInput(piArray, thetaArray, nPoints, 20, "bernoulli", org.apache.spark.mllib.classification.NaiveBayesSuite$.MODULE$.generateNaiveBayesInput$default$6()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.regression.LabeledPoint")).asType()).toTypeConstructor();
                    }
                }));
                DataFrame predictionAndLabels = model.transform(validationDataset).select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"}));
                this.$outer.validatePrediction(predictionAndLabels);
                DataFrame featureAndProbabilities = model.transform(validationDataset).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"probability"}));
                this.$outer.validateProbabilities(featureAndProbabilities, model, "bernoulli");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NaiveBayesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NaiveBayes nb = new NaiveBayes();
                this.$outer.testEstimatorAndModelReadWrite(nb, this.$outer.dataset(), NaiveBayesSuite$.MODULE$.allParamSettings(), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$16 $outer;

                    public final void apply(NaiveBayesModel model, NaiveBayesModel model2) {
                        this.$outer.org$apache$spark$ml$classification$NaiveBayesSuite$$anonfun$$checkModelData$1(model, model2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public final void org$apache$spark$ml$classification$NaiveBayesSuite$$anonfun$$checkModelData$1(NaiveBayesModel model, NaiveBayesModel model2) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(model.pi());
                Vector $org_scalatest_assert_macro_right = model2.pi();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(model.theta());
                Matrix $org_scalatest_assert_macro_right2 = model2.theta();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

