/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NominalAttribute$;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.Classifier;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.MockLogisticRegression;
import org.apache.spark.ml.classification.OneVsRest;
import org.apache.spark.ml.classification.OneVsRestModel;
import org.apache.spark.ml.classification.OneVsRestSuite$;
import org.apache.spark.ml.feature.StringIndexer;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.classification.LogisticRegressionSuite$;
import org.apache.spark.mllib.classification.LogisticRegressionWithLBFGS;
import org.apache.spark.mllib.evaluation.MulticlassMetrics;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E3A!\u0001\u0002\u0001\u001b\tqqJ\\3WgJ+7\u000f^*vSR,'BA\u0002\u0005\u00039\u0019G.Y:tS\u001aL7-\u0019;j_:T!!\u0002\u0004\u0002\u00055d'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\n\u0011\u0005=\u0001R\"\u0001\u0004\n\u0005E1!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u0005!Q\u000f^5m\u0015\t9b!A\u0003nY2L'-\u0003\u0002\u001a)\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\b\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011%\u0001\u0003\u00011AA\u0002\u0013\u0005\u0011%A\u0004eCR\f7/\u001a;\u0016\u0003\t\u0002\"a\t\u0014\u000e\u0003\u0011R!!\n\u0004\u0002\u0007M\fH.\u0003\u0002(I\tIA)\u0019;b\rJ\fW.\u001a\u0005\nS\u0001\u0001\r\u00111A\u0005\u0002)\n1\u0002Z1uCN,Go\u0018\u0013fcR\u00111&\r\t\u0003Y=j\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'\f\u0002\u0005+:LG\u000fC\u00043Q\u0005\u0005\t\u0019\u0001\u0012\u0002\u0007a$\u0013\u0007\u0003\u00045\u0001\u0001\u0006KAI\u0001\tI\u0006$\u0018m]3uA!\u00121G\u000e\t\u0003Y]J!\u0001O\u0017\u0003\u0013Q\u0014\u0018M\\:jK:$\b\"\u0003\u001e\u0001\u0001\u0004\u0005\r\u0011\"\u0001<\u0003\r\u0011H\rZ\u000b\u0002yA\u0019QhP!\u000e\u0003yR!A\u000f\u0004\n\u0005\u0001s$a\u0001*E\tB\u0011!)R\u0007\u0002\u0007*\u0011AIF\u0001\u000be\u0016<'/Z:tS>t\u0017B\u0001$D\u00051a\u0015MY3mK\u0012\u0004v.\u001b8u\u0011%A\u0005\u00011AA\u0002\u0013\u0005\u0011*A\u0004sI\u0012|F%Z9\u0015\u0005-R\u0005b\u0002\u001aH\u0003\u0003\u0005\r\u0001\u0010\u0005\u0007\u0019\u0002\u0001\u000b\u0015\u0002\u001f\u0002\tI$G\r\t\u0015\u0003\u0017ZBQa\u0014\u0001\u0005BA\u000b\u0011BY3g_J,\u0017\t\u001c7\u0015\u0003-\u0002")
public class OneVsRestSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient DataFrame dataset;
    private transient RDD<LabeledPoint> rdd;
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public DataFrame dataset() {
        return this.dataset;
    }

    public void dataset_$eq(DataFrame x$1) {
        this.dataset = x$1;
    }

    public RDD<LabeledPoint> rdd() {
        return this.rdd;
    }

    public void rdd_$eq(RDD<LabeledPoint> x$1) {
        this.rdd = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        int nPoints = 1000;
        double[] coefficients = new double[]{-0.57997, 0.912083, -0.371077, -0.819866, 2.688191, -0.16624, -0.84355, -0.048509, -0.301789, 4.170682};
        double[] xMean = new double[]{5.843, 3.057, 3.758, 1.199};
        double[] xVariance = new double[]{0.6856, 0.1899, 3.116, 0.581};
        this.rdd_$eq((RDD<LabeledPoint>)this.sc().parallelize(LogisticRegressionSuite$.MODULE$.generateMultinomialLogisticInput(coefficients, xMean, xVariance, true, nPoints, 42), 2, ClassTag$.MODULE$.apply(LabeledPoint.class)));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OneVsRestSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_classification_OneVsRestSuite$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.regression.LabeledPoint")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_classification_OneVsRestSuite$$typecreator1$1(OneVsRestSuite $outer) {
            }
        }
        this.dataset_$eq(this.sqlContext().createDataFrame(this.rdd(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_OneVsRestSuite$$typecreator1$1(this))));
    }

    public OneVsRestSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParamsSuite$.MODULE$.checkParams((Params)new OneVsRest());
                LogisticRegressionModel lrModel = new LogisticRegressionModel("lr", Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), 0.0);
                OneVsRestModel model = new OneVsRestModel("ovr", Metadata$.MODULE$.empty(), (ClassificationModel[])new LogisticRegressionModel[]{lrModel});
                ParamsSuite$.MODULE$.checkParams((Params)model);
            }
        });
        this.test("one-vs-rest: default params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OneVsRestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int numClasses = 3;
                OneVsRest ova = new OneVsRest().setClassifier((Classifier)new LogisticRegression());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(ova.getLabelCol());
                String $org_scalatest_assert_macro_right = "label";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(ova.getPredictionCol());
                String $org_scalatest_assert_macro_right2 = "prediction";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                OneVsRestModel ovaModel = ova.fit(this.$outer.dataset());
                MLTestingUtils$.MODULE$.checkCopy((Model<?>)ovaModel);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])ovaModel.models()).size()));
                int $org_scalatest_assert_macro_right3 = numClasses;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                DataFrame transformedDataset = ovaModel.transform(this.$outer.dataset());
                StructField predictionColSchema = transformedDataset.schema().apply(ovaModel.getPredictionCol());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(MetadataUtils$.MODULE$.getNumClasses(predictionColSchema));
                Some $org_scalatest_assert_macro_right4 = new Some((Object)BoxesRunTime.boxToInteger((int)3));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                RDD ovaResults = transformedDataset.select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"})).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(Row row) {
                        return new Tuple2.mcDD.sp(row.getDouble(0), row.getDouble(1));
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class));
                LogisticRegressionWithLBFGS lr = ((LogisticRegressionWithLBFGS)new LogisticRegressionWithLBFGS().setIntercept(true)).setNumClasses(numClasses);
                lr.optimizer().setRegParam(0.1).setNumIterations(100);
                org.apache.spark.mllib.classification.LogisticRegressionModel model = (org.apache.spark.mllib.classification.LogisticRegressionModel)lr.run(this.$outer.rdd());
                RDD results = model.predict(this.$outer.rdd().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(LabeledPoint x$1) {
                        return x$1.features();
                    }
                }, ClassTag$.MODULE$.apply(Vector.class))).zip(this.$outer.rdd().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(LabeledPoint x$2) {
                        return x$2.label();
                    }
                }, ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.Double());
                MulticlassMetrics expectedMetrics = new MulticlassMetrics(results);
                MulticlassMetrics ovaMetrics = new MulticlassMetrics(ovaResults);
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(expectedMetrics.confusionMatrix()).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(ovaMetrics.confusionMatrix()).absTol(400.0)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(expectedMetrics.confusionMatrix).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(ovaMetrics.confusionMatrix).absTol(400.0))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("one-vs-rest: pass label metadata correctly during train", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OneVsRestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int numClasses = 3;
                OneVsRest ova = new OneVsRest();
                ova.setClassifier((Classifier)new MockLogisticRegression());
                NominalAttribute labelMetadata = NominalAttribute$.MODULE$.defaultAttr().withName("label").withNumValues(numClasses);
                Column labelWithMetadata = this.$outer.dataset().apply("label").as("label", labelMetadata.toMetadata());
                Column features = this.$outer.dataset().apply("features").as("features");
                DataFrame datasetWithLabelMetadata = this.$outer.dataset().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{labelWithMetadata, features}));
                ova.fit(datasetWithLabelMetadata);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SPARK-8092: ensure label features and prediction cols are configurable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OneVsRestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set outputFields;
                StringIndexer labelIndexer = new StringIndexer().setInputCol("label").setOutputCol("indexed");
                DataFrame indexedDataset = labelIndexer.fit(this.$outer.dataset()).transform(this.$outer.dataset()).drop("label").withColumnRenamed("features", "f");
                OneVsRest ova = new OneVsRest();
                ova.setClassifier((Classifier)new LogisticRegression()).setLabelCol(labelIndexer.getOutputCol()).setFeaturesCol("f").setPredictionCol("p");
                OneVsRestModel ovaModel = ova.fit(indexedDataset);
                DataFrame transformedDataset = ovaModel.transform(indexedDataset);
                Set $org_scalatest_assert_macro_left = outputFields = Predef$.MODULE$.refArrayOps((Object[])transformedDataset.schema().fieldNames()).toSet();
                String $org_scalatest_assert_macro_right = "p";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SPARK-8049: OneVsRest shouldn't output temp columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OneVsRestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression logReg = new LogisticRegression().setMaxIter(1);
                OneVsRest ovr = new OneVsRest().setClassifier((Classifier)logReg);
                DataFrame output = ovr.fit(this.$outer.dataset()).transform(this.$outer.dataset());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(Predef$.MODULE$.refArrayOps((Object[])output.schema().fieldNames()).toSet());
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label", "features", "prediction"}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("OneVsRest.copy and OneVsRestModel.copy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OneVsRestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression lr = new LogisticRegression().setMaxIter(1);
                OneVsRest ovr = new OneVsRest();
                this.$outer.withClue("copy with classifier unset should work", (Function0)new Serializable(this, lr, ovr){
                    public static final long serialVersionUID = 0L;
                    private final LogisticRegression lr$1;
                    private final OneVsRest ovr$1;

                    public final OneVsRest apply() {
                        return this.ovr$1.copy(ParamMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.lr$1.maxIter().$minus$greater((Object)BoxesRunTime.boxToInteger((int)10))})));
                    }
                    {
                        this.lr$1 = lr$1;
                        this.ovr$1 = ovr$1;
                    }
                });
                ovr.setClassifier((Classifier)lr);
                OneVsRest ovr1 = ovr.copy(ParamMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{lr.maxIter().$minus$greater((Object)BoxesRunTime.boxToInteger((int)10))})));
                Predef$.MODULE$.require(this.$outer.convertToEqualizer(ovr.getClassifier().getOrDefault((Param)lr.maxIter())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "copy should have no side-effects";
                    }
                });
                Predef$.MODULE$.require(this.$outer.convertToEqualizer(ovr1.getClassifier().getOrDefault((Param)lr.maxIter())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10), Equality$.MODULE$.default()), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "copy should handle extra classifier params";
                    }
                });
                OneVsRestModel ovrModel = ovr1.fit(this.$outer.dataset()).copy(ParamMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{lr.thresholds().$minus$greater((Object)new double[]{0.9, 0.1})})));
                Predef$.MODULE$.refArrayOps((Object[])ovrModel.models()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final void apply(ClassificationModel x0$1) {
                        ClassificationModel classificationModel = x0$1;
                        if (classificationModel instanceof LogisticRegressionModel) {
                            LogisticRegressionModel logisticRegressionModel = (LogisticRegressionModel)classificationModel;
                            Predef$.MODULE$.require(this.$outer.org$apache$spark$ml$classification$OneVsRestSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)logisticRegressionModel.getThreshold())).$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)0.1), Equality$.MODULE$.default()), (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "copy should handle extra model params";
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError((Object)classificationModel);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ OneVsRestSuite org$apache$spark$ml$classification$OneVsRestSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

