/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.classification.RandomForestClassificationModel;
import org.apache.spark.ml.classification.RandomForestClassificationModel$;
import org.apache.spark.ml.classification.RandomForestClassifier;
import org.apache.spark.ml.impl.TreeTests$;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.RandomForest$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public final class RandomForestClassifierSuite$
extends SparkFunSuite {
    public static final RandomForestClassifierSuite$ MODULE$;

    static {
        new RandomForestClassifierSuite$();
    }

    public void compareAPIs(RDD<LabeledPoint> data, RandomForestClassifier rf, Map<Object, Object> categoricalFeatures, int numClasses) {
        int numFeatures = ((LabeledPoint)data.first()).features().size();
        Strategy oldStrategy = rf.getOldStrategy(categoricalFeatures, numClasses, Algo$.MODULE$.Classification(), rf.getOldImpurity());
        RandomForestModel oldModel = RandomForest$.MODULE$.trainClassifier(data, oldStrategy, rf.getNumTrees(), rf.getFeatureSubsetStrategy(), (int)rf.getSeed());
        DataFrame newData = TreeTests$.MODULE$.setMetadata(data, categoricalFeatures, numClasses);
        RandomForestClassificationModel newModel = (RandomForestClassificationModel)rf.fit(newData);
        RandomForestClassificationModel oldModelAsNew = RandomForestClassificationModel$.MODULE$.fromOld(oldModel, (RandomForestClassifier)newModel.parent(), categoricalFeatures, numClasses, RandomForestClassificationModel$.MODULE$.fromOld$default$5());
        TreeTests$.MODULE$.checkEqual((TreeEnsembleModel)oldModelAsNew, (TreeEnsembleModel)newModel);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(newModel.hasParent(), "newModel.hasParent");
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((DecisionTreeClassificationModel)Predef$.MODULE$.refArrayOps((Object[])newModel.trees()).head()).hasParent(), "scala.this.Predef.refArrayOps[org.apache.spark.ml.tree.DecisionTreeModel](newModel.trees).head.asInstanceOf[org.apache.spark.ml.classification.DecisionTreeClassificationModel].hasParent"));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)newModel.numClasses()));
        int $org_scalatest_assert_macro_right = numClasses;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)newModel.numFeatures()));
        int $org_scalatest_assert_macro_right2 = numFeatures;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
    }

    private Object readResolve() {
        return MODULE$;
    }

    private RandomForestClassifierSuite$() {
        MODULE$ = this;
    }
}

