/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.classification.RandomForestClassificationModel;
import org.apache.spark.ml.classification.RandomForestClassifier;
import org.apache.spark.ml.classification.RandomForestClassifierSuite$;
import org.apache.spark.ml.impl.TreeTests$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.ml.tree.LeafNode;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.EnsembleTestHelper$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0001\u0002\u0001\u001b\tY\"+\u00198e_64uN]3ti\u000ec\u0017m]:jM&,'oU;ji\u0016T!a\u0001\u0003\u0002\u001d\rd\u0017m]:jM&\u001c\u0017\r^5p]*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001aB\u0005\t\u0003\u001fAi\u0011AB\u0005\u0003#\u0019\u0011Qb\u00159be.4UO\\*vSR,\u0007CA\n\u0019\u001b\u0005!\"BA\u000b\u0017\u0003\u0011)H/\u001b7\u000b\u0005]1\u0011!B7mY&\u0014\u0017BA\r\u0015\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqRDQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u0013\u0001\u0002\u0001\u0019!a\u0001\n\u0013\t\u0013aG8sI\u0016\u0014X\r\u001a'bE\u0016dW\r\u001a)pS:$8/\u000e\u0019`cA\u0002\u0004'F\u0001#!\r\u0019c\u0005K\u0007\u0002I)\u0011QEB\u0001\u0004e\u0012$\u0017BA\u0014%\u0005\r\u0011F\t\u0012\t\u0003S1j\u0011A\u000b\u0006\u0003WY\t!B]3he\u0016\u001c8/[8o\u0013\ti#F\u0001\u0007MC\n,G.\u001a3Q_&tG\u000fC\u00050\u0001\u0001\u0007\t\u0019!C\u0005a\u0005yrN\u001d3fe\u0016$G*\u00192fY\u0016$\u0007k\\5oiN,\u0004gX\u00191aAzF%Z9\u0015\u0005E:\u0004C\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$\u0001B+oSRDq\u0001\u000f\u0018\u0002\u0002\u0003\u0007!%A\u0002yIEBaA\u000f\u0001!B\u0013\u0011\u0013\u0001H8sI\u0016\u0014X\r\u001a'bE\u0016dW\r\u001a)pS:$8/\u000e\u0019`cA\u0002\u0004\u0007\t\u0005\ny\u0001\u0001\r\u00111A\u0005\n\u0005\n\u0001d\u001c:eKJ,G\rT1cK2,G\rU8j]R\u001cXg\u0018\u001a1\u0011%q\u0004\u00011AA\u0002\u0013%q(\u0001\u000fpe\u0012,'/\u001a3MC\n,G.\u001a3Q_&tGo]\u001b`eAzF%Z9\u0015\u0005E\u0002\u0005b\u0002\u001d>\u0003\u0003\u0005\rA\t\u0005\u0007\u0005\u0002\u0001\u000b\u0015\u0002\u0012\u00023=\u0014H-\u001a:fI2\u000b'-\u001a7fIB{\u0017N\u001c;tk}\u0013\u0004\u0007\t\u0005\u0006\t\u0002!\t%R\u0001\nE\u00164wN]3BY2$\u0012!\r\u0005\u0006\u000f\u0002!\t\u0001S\u0001/E&t\u0017M]=DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8UKN$x+\u001b;i\u0007>tG/\u001b8v_V\u001ch)Z1ukJ,7\u000f\u0006\u00022\u0013\")!J\u0012a\u0001\u0017\u0006\u0011!O\u001a\t\u0003=1K!!\u0014\u0002\u0003-I\u000bg\u000eZ8n\r>\u0014Xm\u001d;DY\u0006\u001c8/\u001b4jKJ<Qa\u0014\u0002\t\nA\u000b1DU1oI>lgi\u001c:fgR\u001cE.Y:tS\u001aLWM]*vSR,\u0007C\u0001\u0010R\r\u0015\t!\u0001#\u0003S'\t\tf\u0002C\u0003\u001c#\u0012\u0005A\u000bF\u0001Q\u0011\u00151\u0016\u000b\"\u0001X\u0003-\u0019w.\u001c9be\u0016\f\u0005+S:\u0015\u000bEB&lW4\t\u000be+\u0006\u0019\u0001\u0012\u0002\t\u0011\fG/\u0019\u0005\u0006\u0015V\u0003\ra\u0013\u0005\u00069V\u0003\r!X\u0001\u0014G\u0006$XmZ8sS\u000e\fGNR3biV\u0014Xm\u001d\t\u0005=\u0006$GM\u0004\u00023?&\u0011\u0001mM\u0001\u0007!J,G-\u001a4\n\u0005\t\u001c'aA'ba*\u0011\u0001m\r\t\u0003e\u0015L!AZ\u001a\u0003\u0007%sG\u000fC\u0003i+\u0002\u0007A-\u0001\u0006ok6\u001cE.Y:tKNDqA[)\u0002\u0002\u0013%1.A\u0006sK\u0006$'+Z:pYZ,G#\u00017\u0011\u00055\u0014X\"\u00018\u000b\u0005=\u0004\u0018\u0001\u00027b]\u001eT\u0011!]\u0001\u0005U\u00064\u0018-\u0003\u0002t]\n1qJ\u00196fGR\u0004")
public class RandomForestClassifierSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private RDD<LabeledPoint> orderedLabeledPoints50_1000;
    private RDD<LabeledPoint> org$apache$spark$ml$classification$RandomForestClassifierSuite$$orderedLabeledPoints5_20;
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public static void compareAPIs(RDD<LabeledPoint> rDD, RandomForestClassifier randomForestClassifier, Map<Object, Object> map, int n) {
        RandomForestClassifierSuite$.MODULE$.compareAPIs(rDD, randomForestClassifier, map, n);
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    private RDD<LabeledPoint> orderedLabeledPoints50_1000() {
        return this.orderedLabeledPoints50_1000;
    }

    private void orderedLabeledPoints50_1000_$eq(RDD<LabeledPoint> x$1) {
        this.orderedLabeledPoints50_1000 = x$1;
    }

    public RDD<LabeledPoint> org$apache$spark$ml$classification$RandomForestClassifierSuite$$orderedLabeledPoints5_20() {
        return this.org$apache$spark$ml$classification$RandomForestClassifierSuite$$orderedLabeledPoints5_20;
    }

    private void org$apache$spark$ml$classification$RandomForestClassifierSuite$$orderedLabeledPoints5_20_$eq(RDD<LabeledPoint> x$1) {
        this.org$apache$spark$ml$classification$RandomForestClassifierSuite$$orderedLabeledPoints5_20 = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        SparkContext qual$1 = this.sc();
        WrappedArray x$2 = Predef$.MODULE$.wrapRefArray((Object[])EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(50, 1000));
        int x$3 = qual$1.parallelize$default$2();
        this.orderedLabeledPoints50_1000_$eq((RDD<LabeledPoint>)qual$1.parallelize((Seq)x$2, x$3, ClassTag$.MODULE$.apply(LabeledPoint.class)));
        SparkContext qual$2 = this.sc();
        WrappedArray x$4 = Predef$.MODULE$.wrapRefArray((Object[])EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(5, 20));
        int x$5 = qual$2.parallelize$default$2();
        this.org$apache$spark$ml$classification$RandomForestClassifierSuite$$orderedLabeledPoints5_20_$eq((RDD<LabeledPoint>)qual$2.parallelize((Seq)x$4, x$5, ClassTag$.MODULE$.apply(LabeledPoint.class)));
    }

    public void binaryClassificationTestWithContinuousFeatures(RandomForestClassifier rf) {
        Map categoricalFeatures = Predef$.MODULE$.Map().empty();
        int numClasses = 2;
        RandomForestClassifier newRF = rf.setImpurity("Gini").setMaxDepth(2).setNumTrees(1).setFeatureSubsetStrategy("auto").setSeed(123L);
        RandomForestClassifierSuite$.MODULE$.compareAPIs(this.orderedLabeledPoints50_1000(), newRF, (Map<Object, Object>)categoricalFeatures, numClasses);
    }

    public RandomForestClassifierSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParamsSuite$.MODULE$.checkParams((Params)new RandomForestClassifier());
                DecisionTreeClassificationModel[] decisionTreeClassificationModelArray = new DecisionTreeClassificationModel[1];
                decisionTreeClassificationModelArray[0] = new DecisionTreeClassificationModel("dtc", (Node)new LeafNode(0.0, 0.0, null), 1, 2);
                RandomForestClassificationModel model = new RandomForestClassificationModel("rfc", (DecisionTreeClassificationModel[])((Object[])decisionTreeClassificationModelArray), 2, 2);
                ParamsSuite$.MODULE$.checkParams((Params)model);
            }
        });
        this.test("Binary classification with continuous features: comparing DecisionTree vs. RandomForest(numTrees = 1)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RandomForestClassifier rf = new RandomForestClassifier();
                this.$outer.binaryClassificationTestWithContinuousFeatures(rf);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification with continuous features and node Id cache: comparing DecisionTree vs. RandomForest(numTrees = 1)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RandomForestClassifier rf = new RandomForestClassifier().setCacheNodeIds(true);
                this.$outer.binaryClassificationTestWithContinuousFeatures(rf);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("alternating categorical and continuous features with multiclass labels to test indexing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 3.0, 1.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0, 1.0, 2.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 6.0, 3.0}))), new LabeledPoint(2.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 1.0, 3.0, 2.0})))});
                SparkContext qual$3 = this.$outer.sc();
                WrappedArray x$6 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$7 = qual$3.parallelize$default$2();
                RDD rdd = qual$3.parallelize((Seq)x$6, x$7, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Map categoricalFeatures = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)BoxesRunTime.boxToInteger((int)4))}));
                int numClasses = 3;
                RandomForestClassifier rf = new RandomForestClassifier().setImpurity("Gini").setMaxDepth(5).setNumTrees(2).setFeatureSubsetStrategy("sqrt").setSeed(12345L);
                RandomForestClassifierSuite$.MODULE$.compareAPIs((RDD<LabeledPoint>)rdd, rf, (Map<Object, Object>)categoricalFeatures, numClasses);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("subsampling rate in RandomForest", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD<LabeledPoint> rdd = this.$outer.org$apache$spark$ml$classification$RandomForestClassifierSuite$$orderedLabeledPoints5_20();
                Map categoricalFeatures = Predef$.MODULE$.Map().empty();
                int numClasses = 2;
                RandomForestClassifier rf1 = new RandomForestClassifier().setImpurity("Gini").setMaxDepth(2).setCacheNodeIds(true).setNumTrees(3).setFeatureSubsetStrategy("auto").setSeed(123L);
                RandomForestClassifierSuite$.MODULE$.compareAPIs(rdd, rf1, (Map<Object, Object>)categoricalFeatures, numClasses);
                RandomForestClassifier rf2 = rf1.setSubsamplingRate(0.5);
                RandomForestClassifierSuite$.MODULE$.compareAPIs(rdd, rf2, (Map<Object, Object>)categoricalFeatures, numClasses);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("predictRaw and predictProbability", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD<LabeledPoint> rdd = this.$outer.org$apache$spark$ml$classification$RandomForestClassifierSuite$$orderedLabeledPoints5_20();
                RandomForestClassifier rf = new RandomForestClassifier().setImpurity("Gini").setMaxDepth(3).setNumTrees(3).setSeed(123L);
                Map categoricalFeatures = Predef$.MODULE$.Map().empty();
                int numClasses = 2;
                DataFrame df = TreeTests$.MODULE$.setMetadata(rdd, (Map<Object, Object>)categoricalFeatures, numClasses);
                RandomForestClassificationModel model = (RandomForestClassificationModel)rf.fit(df);
                MLTestingUtils$.MODULE$.checkCopy((Model<?>)model);
                Row[] predictions = model.transform(df).select(rf.getPredictionCol(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{rf.getRawPredictionCol(), rf.getProbabilityCol()})).collect();
                Predef$.MODULE$.refArrayOps((Object[])predictions).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final void apply(Row x0$1) {
                        Row row = x0$1;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                            Object pred = ((SeqLike)some.get()).apply(0);
                            Object rawPred = ((SeqLike)some.get()).apply(1);
                            Object probPred = ((SeqLike)some.get()).apply(2);
                            if (pred instanceof Double) {
                                double d = BoxesRunTime.unboxToDouble((Object)pred);
                                if (rawPred instanceof Vector) {
                                    Vector vector = (Vector)rawPred;
                                    if (probPred instanceof Vector) {
                                        Vector vector2 = (Vector)probPred;
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$classification$RandomForestClassifierSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)d));
                                        int $org_scalatest_assert_macro_right = vector.argmax();
                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                        this.$outer.org$apache$spark$ml$classification$RandomForestClassifierSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected prediction ", " but calculated ", " from rawPrediction."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)d), BoxesRunTime.boxToInteger((int)vector.argmax())})));
                                        double sum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(vector.toArray()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$ml$classification$RandomForestClassifierSuite$$anonfun$$$outer().convertToEqualizer(Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(vector.toArray()).map((Function1)new Serializable(this, sum){
                                            public static final long serialVersionUID = 0L;
                                            private final double sum$1;

                                            public final double apply(double x$1) {
                                                return this.apply$mcDD$sp(x$1);
                                            }

                                            public double apply$mcDD$sp(double x$1) {
                                                return x$1 / this.sum$1;
                                            }
                                            {
                                                this.sum$1 = sum$1;
                                            }
                                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))));
                                        Vector $org_scalatest_assert_macro_right2 = vector2;
                                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                                        this.$outer.org$apache$spark$ml$classification$RandomForestClassifierSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"probability prediction mismatch");
                                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(vector2.toArray()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).relTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.this.Predef.doubleArrayOps(probPred.toArray).sum[Double](math.this.Numeric.DoubleIsFractional)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).relTol(1.0E-5))");
                                        this.$outer.org$apache$spark$ml$classification$RandomForestClassifierSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return;
                                    }
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ RandomForestClassifierSuite org$apache$spark$ml$classification$RandomForestClassifierSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Feature importance with toy data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int numClasses = 2;
                RandomForestClassifier rf = new RandomForestClassifier().setImpurity("Gini").setMaxDepth(3).setNumTrees(3).setFeatureSubsetStrategy("all").setSubsamplingRate(1.0).setSeed(123L);
                SparkContext qual$4 = this.$outer.sc();
                Seq x$8 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 0.0, 1.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 0.0, 1.0, 0.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 0.0, 0.0, 0.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 0.0, 0.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 0.0, 0.0, 0.0})))}));
                int x$9 = qual$4.parallelize$default$2();
                RDD data = qual$4.parallelize(x$8, x$9, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Map categoricalFeatures = Predef$.MODULE$.Map().empty();
                DataFrame df = TreeTests$.MODULE$.setMetadata((RDD<LabeledPoint>)data, (Map<Object, Object>)categoricalFeatures, numClasses);
                Vector importances = ((RandomForestClassificationModel)rf.fit(df)).featureImportances();
                int mostImportantFeature = importances.argmax();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mostImportantFeature));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

