/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.clustering.KMeans;
import org.apache.spark.ml.clustering.KMeansModel;
import org.apache.spark.ml.clustering.KMeansSuite;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaKMeansSuite
implements Serializable {
    private transient int k = 5;
    private transient JavaSparkContext sc;
    private transient DataFrame dataset;
    private transient SQLContext sql;

    @Before
    public void setUp() {
        this.sc = new JavaSparkContext("local", "JavaKMeansSuite");
        this.sql = new SQLContext(this.sc);
        this.dataset = KMeansSuite.generateKMeansData(this.sql, 50, 3, this.k);
    }

    @After
    public void tearDown() {
        this.sc.stop();
        this.sc = null;
    }

    @Test
    public void fitAndTransform() {
        KMeans kmeans = new KMeans().setK(this.k).setSeed(1L);
        KMeansModel model = kmeans.fit(this.dataset);
        Vector[] centers = model.clusterCenters();
        Assert.assertEquals((long)this.k, (long)centers.length);
        DataFrame transformed = model.transform(this.dataset);
        List<String> columns = Arrays.asList(transformed.columns());
        List<String> expectedColumns = Arrays.asList("features", "prediction");
        for (String column : expectedColumns) {
            Assert.assertTrue((boolean)columns.contains(column));
        }
    }
}

