/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.util.Arrays;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.feature.Normalizer;
import org.apache.spark.ml.feature.VectorIndexerSuite;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JavaNormalizerSuite {
    private transient JavaSparkContext jsc;
    private transient SQLContext jsql;

    @Before
    public void setUp() {
        this.jsc = new JavaSparkContext("local", "JavaNormalizerSuite");
        this.jsql = new SQLContext(this.jsc);
    }

    @After
    public void tearDown() {
        this.jsc.stop();
        this.jsc = null;
    }

    @Test
    public void normalizer() {
        JavaRDD points = this.jsc.parallelize(Arrays.asList(new VectorIndexerSuite.FeatureData(Vectors.dense((double)0.0, (double[])new double[]{-2.0})), new VectorIndexerSuite.FeatureData(Vectors.dense((double)1.0, (double[])new double[]{3.0})), new VectorIndexerSuite.FeatureData(Vectors.dense((double)1.0, (double[])new double[]{4.0}))));
        DataFrame dataFrame = this.jsql.createDataFrame(points, VectorIndexerSuite.FeatureData.class);
        Normalizer normalizer = (Normalizer)((Normalizer)new Normalizer().setInputCol("features")).setOutputCol("normFeatures");
        DataFrame l2NormData = normalizer.transform(dataFrame, normalizer.p().w(2.0), new ParamPair[0]);
        l2NormData.count();
        DataFrame lInfNormData = normalizer.transform(dataFrame, normalizer.p().w(Double.POSITIVE_INFINITY), new ParamPair[0]);
        lInfNormData.count();
    }
}

