/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.feature.PolynomialExpansion;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaPolynomialExpansionSuite {
    private transient JavaSparkContext jsc;
    private transient SQLContext jsql;

    @Before
    public void setUp() {
        this.jsc = new JavaSparkContext("local", "JavaPolynomialExpansionSuite");
        this.jsql = new SQLContext(this.jsc);
    }

    @After
    public void tearDown() {
        this.jsc.stop();
        this.jsc = null;
    }

    @Test
    public void polynomialExpansionTest() {
        Row[] pairs;
        PolynomialExpansion polyExpansion = ((PolynomialExpansion)((PolynomialExpansion)new PolynomialExpansion().setInputCol("features")).setOutputCol("polyFeatures")).setDegree(3);
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{Vectors.dense((double)-2.0, (double[])new double[]{2.3}), Vectors.dense((double)-2.0, (double[])new double[]{4.0, -8.0, 2.3, -4.6, 9.2, 5.29, -10.58, 12.17})}), RowFactory.create((Object[])new Object[]{Vectors.dense((double)0.0, (double[])new double[]{0.0}), Vectors.dense((double[])new double[9])}), RowFactory.create((Object[])new Object[]{Vectors.dense((double)0.6, (double[])new double[]{-1.1}), Vectors.dense((double)0.6, (double[])new double[]{0.36, 0.216, -1.1, -0.66, -0.396, 1.21, 0.726, -1.331})}));
        StructType schema = new StructType(new StructField[]{new StructField("features", (DataType)new VectorUDT(), false, Metadata.empty()), new StructField("expected", (DataType)new VectorUDT(), false, Metadata.empty())});
        DataFrame dataset = this.jsql.createDataFrame(data, schema);
        for (Row r : pairs = polyExpansion.transform(dataset).select("polyFeatures", new String[]{"expected"}).collect()) {
            double[] polyFeatures = ((Vector)r.get(0)).toArray();
            double[] expected = ((Vector)r.get(1)).toArray();
            Assert.assertArrayEquals((double[])polyFeatures, (double[])expected, (double)0.1);
        }
    }
}

