/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.feature.StandardScaler;
import org.apache.spark.ml.feature.StandardScalerModel;
import org.apache.spark.ml.feature.VectorIndexerSuite;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JavaStandardScalerSuite {
    private transient JavaSparkContext jsc;
    private transient SQLContext jsql;

    @Before
    public void setUp() {
        this.jsc = new JavaSparkContext("local", "JavaStandardScalerSuite");
        this.jsql = new SQLContext(this.jsc);
    }

    @After
    public void tearDown() {
        this.jsc.stop();
        this.jsc = null;
    }

    @Test
    public void standardScaler() {
        List<VectorIndexerSuite.FeatureData> points = Arrays.asList(new VectorIndexerSuite.FeatureData(Vectors.dense((double)0.0, (double[])new double[]{-2.0})), new VectorIndexerSuite.FeatureData(Vectors.dense((double)1.0, (double[])new double[]{3.0})), new VectorIndexerSuite.FeatureData(Vectors.dense((double)1.0, (double[])new double[]{4.0})));
        DataFrame dataFrame = this.jsql.createDataFrame(this.jsc.parallelize(points, 2), VectorIndexerSuite.FeatureData.class);
        StandardScaler scaler = new StandardScaler().setInputCol("features").setOutputCol("scaledFeatures").setWithStd(true).setWithMean(false);
        StandardScalerModel scalerModel = scaler.fit(dataFrame);
        DataFrame scaledData = scalerModel.transform(dataFrame);
        scaledData.count();
    }
}

