/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.feature.StopWordsRemover;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JavaStopWordsRemoverSuite {
    private transient JavaSparkContext jsc;
    private transient SQLContext jsql;

    @Before
    public void setUp() {
        this.jsc = new JavaSparkContext("local", "JavaStopWordsRemoverSuite");
        this.jsql = new SQLContext(this.jsc);
    }

    @After
    public void tearDown() {
        this.jsc.stop();
        this.jsc = null;
    }

    @Test
    public void javaCompatibilityTest() {
        StopWordsRemover remover = new StopWordsRemover().setInputCol("raw").setOutputCol("filtered");
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{Arrays.asList("I", "saw", "the", "red", "baloon")}), RowFactory.create((Object[])new Object[]{Arrays.asList("Mary", "had", "a", "little", "lamb")}));
        StructType schema = new StructType(new StructField[]{new StructField("raw", (DataType)DataTypes.createArrayType((DataType)DataTypes.StringType), false, Metadata.empty())});
        DataFrame dataset = this.jsql.createDataFrame(data, schema);
        remover.transform(dataset).collect();
    }
}

