/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.feature.StringIndexer;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaStringIndexerSuite {
    private transient JavaSparkContext jsc;
    private transient SQLContext sqlContext;

    @Before
    public void setUp() {
        this.jsc = new JavaSparkContext("local", "JavaStringIndexerSuite");
        this.sqlContext = new SQLContext(this.jsc);
    }

    @After
    public void tearDown() {
        this.jsc.stop();
        this.sqlContext = null;
    }

    @Test
    public void testStringIndexer() {
        StructType schema = DataTypes.createStructType((StructField[])new StructField[]{DataTypes.createStructField((String)"id", (DataType)DataTypes.IntegerType, (boolean)false), DataTypes.createStructField((String)"label", (DataType)DataTypes.StringType, (boolean)false)});
        List<Row> data = Arrays.asList(this.c(0, "a"), this.c(1, "b"), this.c(2, "c"), this.c(3, "a"), this.c(4, "a"), this.c(5, "c"));
        DataFrame dataset = this.sqlContext.createDataFrame(data, schema);
        StringIndexer indexer = new StringIndexer().setInputCol("label").setOutputCol("labelIndex");
        DataFrame output = indexer.fit(dataset).transform(dataset);
        Assert.assertArrayEquals((Object[])new Row[]{this.c(0, 0.0), this.c(1, 2.0), this.c(2, 1.0), this.c(3, 0.0), this.c(4, 0.0), this.c(5, 1.0)}, (Object[])output.orderBy("id", new String[0]).select("id", new String[]{"labelIndex"}).collect());
    }

    private Row c(Object ... values) {
        return RowFactory.create((Object[])values);
    }
}

