/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.feature.VectorIndexer;
import org.apache.spark.ml.feature.VectorIndexerModel;
import org.apache.spark.ml.feature.VectorIndexerSuite;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaVectorIndexerSuite
implements Serializable {
    private transient JavaSparkContext sc;

    @Before
    public void setUp() {
        this.sc = new JavaSparkContext("local", "JavaVectorIndexerSuite");
    }

    @After
    public void tearDown() {
        this.sc.stop();
        this.sc = null;
    }

    @Test
    public void vectorIndexerAPI() {
        List<VectorIndexerSuite.FeatureData> points = Arrays.asList(new VectorIndexerSuite.FeatureData(Vectors.dense((double)0.0, (double[])new double[]{-2.0})), new VectorIndexerSuite.FeatureData(Vectors.dense((double)1.0, (double[])new double[]{3.0})), new VectorIndexerSuite.FeatureData(Vectors.dense((double)1.0, (double[])new double[]{4.0})));
        SQLContext sqlContext = new SQLContext(this.sc);
        DataFrame data = sqlContext.createDataFrame(this.sc.parallelize(points, 2), VectorIndexerSuite.FeatureData.class);
        VectorIndexer indexer = new VectorIndexer().setInputCol("features").setOutputCol("indexed").setMaxCategories(2);
        VectorIndexerModel model = indexer.fit(data);
        Assert.assertEquals((long)model.numFeatures(), (long)2L);
        Map categoryMaps = model.javaCategoryMaps();
        Assert.assertEquals((long)categoryMaps.size(), (long)1L);
        DataFrame indexedData = model.transform(data);
    }
}

